/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;

public class SealedObject
implements Serializable {
    protected byte[] encodedParams;
    private byte[] encryptedContent;
    private String sealAlg;
    private String paramsAlg;
    private transient Cipher sealCipher;
    private static final long serialVersionUID = 4482838265551344752L;

    public SealedObject(Serializable serializable, Cipher cipher) throws IOException, IllegalBlockSizeException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(serializable);
        objectOutputStream.flush();
        try {
            this.encryptedContent = cipher.doFinal(byteArrayOutputStream.toByteArray());
        }
        catch (IllegalStateException illegalStateException) {
            throw new IOException("cipher not in proper state");
        }
        catch (BadPaddingException badPaddingException) {
            throw new IOException("encrypting but got javax.crypto.BadPaddingException");
        }
        this.sealAlg = cipher.getAlgorithm();
        this.encodedParams = cipher.getParameters().getEncoded();
        this.paramsAlg = cipher.getParameters().getAlgorithm();
    }

    protected SealedObject(SealedObject sealedObject) {
        this.encodedParams = (byte[])sealedObject.encodedParams.clone();
        this.encryptedContent = (byte[])sealedObject.encryptedContent.clone();
        this.sealAlg = sealedObject.sealAlg;
        this.paramsAlg = sealedObject.paramsAlg;
    }

    public final String getAlgorithm() {
        return this.sealAlg;
    }

    public final Object getObject(Cipher cipher) throws IOException, ClassNotFoundException, IllegalBlockSizeException, BadPaddingException {
        this.sealCipher = cipher;
        return this.unseal();
    }

    public final Object getObject(Key key) throws IOException, ClassNotFoundException, InvalidKeyException, NoSuchAlgorithmException {
        try {
            if (this.sealCipher == null) {
                this.sealCipher = Cipher.getInstance(this.sealAlg);
            }
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new NoSuchAlgorithmException(noSuchPaddingException.getMessage());
        }
        AlgorithmParameters algorithmParameters = null;
        if (this.encodedParams != null) {
            algorithmParameters = AlgorithmParameters.getInstance(this.paramsAlg);
            algorithmParameters.init(this.encodedParams);
        }
        try {
            this.sealCipher.init(2, key, algorithmParameters);
            return this.unseal();
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new IOException("bad parameters");
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new IOException("illegal block size");
        }
        catch (BadPaddingException badPaddingException) {
            throw new IOException("bad padding");
        }
    }

    public final Object getObject(Key key, String string) throws IOException, ClassNotFoundException, InvalidKeyException, NoSuchAlgorithmException, NoSuchProviderException {
        try {
            this.sealCipher = Cipher.getInstance(this.sealAlg, string);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new NoSuchAlgorithmException(noSuchPaddingException.getMessage());
        }
        AlgorithmParameters algorithmParameters = null;
        if (this.encodedParams != null) {
            algorithmParameters = AlgorithmParameters.getInstance(this.paramsAlg, string);
            algorithmParameters.init(this.encodedParams);
        }
        try {
            this.sealCipher.init(2, key, algorithmParameters);
            return this.unseal();
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new IOException("bad parameters");
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new IOException("illegal block size");
        }
        catch (BadPaddingException badPaddingException) {
            throw new IOException("bad padding");
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.encodedParams = (byte[])objectInputStream.readObject();
        this.encryptedContent = (byte[])objectInputStream.readObject();
        this.sealAlg = (String)objectInputStream.readObject();
        this.paramsAlg = (String)objectInputStream.readObject();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.encodedParams);
        objectOutputStream.writeObject(this.encryptedContent);
        objectOutputStream.writeObject(this.sealAlg);
        objectOutputStream.writeObject(this.paramsAlg);
    }

    private Object unseal() throws IOException, ClassNotFoundException, IllegalBlockSizeException, BadPaddingException {
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            byteArrayInputStream = new ByteArrayInputStream(this.sealCipher.doFinal(this.encryptedContent));
        }
        catch (IllegalStateException illegalStateException) {
            throw new IOException("cipher not initialized");
        }
        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
        return objectInputStream.readObject();
    }
}

