/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.CellEditorListener;
import javax.swing.table.TableCellEditor;
import javax.swing.tree.TreeCellEditor;

public class DefaultCellEditor
extends AbstractCellEditor
implements TableCellEditor,
TreeCellEditor {
    private static final long serialVersionUID = 3564035141373880027L;
    protected JComponent editorComponent;
    protected EditorDelegate delegate;
    protected int clickCountToStart;

    public DefaultCellEditor(JTextField jTextField) {
        this.editorComponent = jTextField;
        this.clickCountToStart = 2;
        this.delegate = new JTextFieldDelegate(this);
        jTextField.addActionListener(this.delegate);
    }

    public DefaultCellEditor(JCheckBox jCheckBox) {
        this.editorComponent = jCheckBox;
        this.clickCountToStart = 1;
        this.delegate = new JCheckBoxDelegate(this);
        jCheckBox.addActionListener(this.delegate);
    }

    public DefaultCellEditor(JComboBox jComboBox) {
        this.editorComponent = jComboBox;
        this.clickCountToStart = 1;
        this.delegate = new JComboBoxDelegate(this);
        jComboBox.addActionListener(this.delegate);
    }

    public Component getComponent() {
        return this.editorComponent;
    }

    public int getClickCountToStart() {
        return this.clickCountToStart;
    }

    public void setClickCountToStart(int n) {
        this.clickCountToStart = n;
    }

    public Object getCellEditorValue() {
        return this.delegate.getCellEditorValue();
    }

    public boolean isCellEditable(EventObject eventObject) {
        return this.delegate.isCellEditable(eventObject);
    }

    public boolean shouldSelectCell(EventObject eventObject) {
        return this.delegate.shouldSelectCell(eventObject);
    }

    public boolean stopCellEditing() {
        return this.delegate.stopCellEditing();
    }

    public void cancelCellEditing() {
        this.delegate.cancelCellEditing();
    }

    public Component getTreeCellEditorComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n) {
        this.delegate.setValue(object);
        return this.editorComponent;
    }

    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        this.delegate.setValue(object);
        return this.editorComponent;
    }

    private class JCheckBoxDelegate
    extends EditorDelegate {
        private /* synthetic */ DefaultCellEditor this$0;
        private static final long serialVersionUID = 1L;

        public void setValue(Object object) {
            JCheckBox jCheckBox = (JCheckBox)this.this$0.editorComponent;
            if (object == null) {
                jCheckBox.setSelected(false);
            } else {
                jCheckBox.setSelected((Boolean)object);
            }
        }

        public Object getCellEditorValue() {
            JCheckBox jCheckBox = (JCheckBox)this.this$0.editorComponent;
            this.value = jCheckBox.isSelected() ? Boolean.TRUE : Boolean.FALSE;
            return this.value;
        }

        JCheckBoxDelegate(DefaultCellEditor defaultCellEditor) {
            this.this$0 = defaultCellEditor;
            super(defaultCellEditor);
        }
    }

    private class JComboBoxDelegate
    extends EditorDelegate {
        private /* synthetic */ DefaultCellEditor this$0;
        private static final long serialVersionUID = 1L;

        public void setValue(Object object) {
            this.value = object;
            JComboBox jComboBox = (JComboBox)this.this$0.editorComponent;
            if (this.value != null) {
                jComboBox.setSelectedItem(this.value);
            }
        }

        public Object getCellEditorValue() {
            JComboBox jComboBox = (JComboBox)this.this$0.editorComponent;
            this.value = jComboBox.getSelectedItem();
            return this.value;
        }

        public boolean shouldSelectCell(EventObject eventObject) {
            JComboBox jComboBox = (JComboBox)this.this$0.editorComponent;
            if (!jComboBox.isEditable) {
                jComboBox.showPopup();
            }
            return true;
        }

        JComboBoxDelegate(DefaultCellEditor defaultCellEditor) {
            this.this$0 = defaultCellEditor;
            super(defaultCellEditor);
        }
    }

    private class JTextFieldDelegate
    extends EditorDelegate {
        private /* synthetic */ DefaultCellEditor this$0;
        private static final long serialVersionUID = 1L;

        public void setValue(Object object) {
            this.value = object;
            JTextField jTextField = (JTextField)this.this$0.editorComponent;
            if (this.value == null) {
                jTextField.setText("");
            } else {
                jTextField.setText(this.value.toString());
            }
        }

        public Object getCellEditorValue() {
            JTextField jTextField = (JTextField)this.this$0.editorComponent;
            this.value = jTextField.getText();
            return this.value;
        }

        JTextFieldDelegate(DefaultCellEditor defaultCellEditor) {
            this.this$0 = defaultCellEditor;
            super(defaultCellEditor);
        }
    }

    protected class EditorDelegate
    implements ActionListener,
    ItemListener,
    Serializable {
        private /* synthetic */ DefaultCellEditor this$0;
        private static final long serialVersionUID = -1420007406015481933L;
        protected Object value;

        protected EditorDelegate(DefaultCellEditor defaultCellEditor) {
            this.this$0 = defaultCellEditor;
        }

        public void setValue(Object object) {
            this.value = object;
        }

        public Object getCellEditorValue() {
            return this.value;
        }

        public boolean isCellEditable(EventObject eventObject) {
            return eventObject == null || !(eventObject instanceof MouseEvent) || ((MouseEvent)eventObject).getClickCount() >= this.this$0.getClickCountToStart();
        }

        public boolean shouldSelectCell(EventObject eventObject) {
            return true;
        }

        public boolean stopCellEditing() {
            this.fireEditingStopped();
            return true;
        }

        public void cancelCellEditing() {
            this.fireEditingCanceled();
        }

        public boolean startCellEditing(EventObject eventObject) {
            return true;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.stopCellEditing();
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            this.stopCellEditing();
        }

        void fireEditingStopped() {
            CellEditorListener[] cellEditorListenerArray = this.this$0.getCellEditorListeners();
            for (int i = 0; i < cellEditorListenerArray.length; ++i) {
                cellEditorListenerArray[i].editingStopped(this.this$0.changeEvent);
            }
        }

        void fireEditingCanceled() {
            CellEditorListener[] cellEditorListenerArray = this.this$0.getCellEditorListeners();
            for (int i = 0; i < cellEditorListenerArray.length; ++i) {
                cellEditorListenerArray[i].editingCanceled(this.this$0.changeEvent);
            }
        }
    }
}

