/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleStateSet;
import javax.swing.Action;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JViewport;
import javax.swing.SwingConstants;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;
import javax.swing.text.TextAction;

public class JTextField
extends JTextComponent
implements SwingConstants {
    private static final long serialVersionUID = 353853209832607592L;
    private static final Action[] actions;
    public static final String notifyAction = "notify-field-accept";
    private int columns;
    private int align;
    private Action action;
    private String actionCommand;
    private PropertyChangeListener actionPropertyChangeListener;
    private BoundedRangeModel horizontalVisibility;

    public JTextField() {
        this(null, null, 0);
    }

    public JTextField(String string) {
        this(null, string, 0);
    }

    public JTextField(int n) {
        this(null, null, n);
    }

    public JTextField(String string, int n) {
        this(null, string, n);
    }

    public JTextField(Document document, String string, int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        this.columns = n;
        this.horizontalVisibility = new DefaultBoundedRangeModel();
        this.setDocument(document == null ? this.createDefaultModel() : document);
        if (string != null) {
            this.setText(string);
        }
        this.align = 10;
    }

    protected Document createDefaultModel() {
        return new PlainDocument();
    }

    public void setDocument(Document document) {
        document.putProperty("filterNewlines", Boolean.TRUE);
        super.setDocument(document);
    }

    public String getUIClassID() {
        return "TextFieldUI";
    }

    public void addActionListener(ActionListener actionListener) {
        this.listenerList.add(JTextField.class$("java.awt.event.ActionListener"), actionListener);
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void removeActionListener(ActionListener actionListener) {
        this.listenerList.remove(JTextField.class$("java.awt.event.ActionListener"), actionListener);
    }

    public ActionListener[] getActionListeners() {
        return (ActionListener[])this.getListeners(JTextField.class$("java.awt.event.ActionListener"));
    }

    protected void fireActionPerformed() {
        ActionEvent actionEvent = new ActionEvent(this, 0, this.getText());
        ActionListener[] actionListenerArray = this.getActionListeners();
        for (int i = 0; i < actionListenerArray.length; ++i) {
            actionListenerArray[i].actionPerformed(actionEvent);
        }
    }

    public int getColumns() {
        return this.columns;
    }

    public void setColumns(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        this.columns = n;
        this.invalidate();
        this.repaint();
    }

    public int getHorizontalAlignment() {
        return this.align;
    }

    public void setHorizontalAlignment(int n) {
        if (this.align == n) {
            return;
        }
        int n2 = this.align;
        this.align = n;
        this.firePropertyChange("horizontalAlignment", n2, n);
        this.invalidate();
        this.repaint();
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.revalidate();
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (this.columns != 0) {
            Insets insets = this.getInsets();
            dimension.width = this.columns * this.getColumnWidth() + insets.left + insets.right;
        }
        return dimension;
    }

    public int getScrollOffset() {
        return this.horizontalVisibility.getValue();
    }

    public void setScrollOffset(int n) {
        this.horizontalVisibility.setValue(Math.min(this.horizontalVisibility.getMaximum() - this.horizontalVisibility.getExtent(), n));
    }

    public Action[] getActions() {
        return TextAction.augmentList(super.getActions(), actions);
    }

    public void postActionEvent() {
        String string = this.actionCommand != null ? this.actionCommand : this.getText();
        ActionEvent actionEvent = new ActionEvent(this, 0, string);
        ActionListener[] actionListenerArray = this.getActionListeners();
        for (int i = 0; i < actionListenerArray.length; ++i) {
            actionListenerArray[i].actionPerformed(actionEvent);
        }
    }

    public Action getAction() {
        return this.action;
    }

    public void setAction(Action action) {
        if (this.action == action) {
            return;
        }
        if (this.action != null) {
            this.removeActionListener(this.action);
            this.action.removePropertyChangeListener(this.actionPropertyChangeListener);
            this.actionPropertyChangeListener = null;
        }
        Action action2 = this.action;
        this.action = action;
        if (this.action != null) {
            this.addActionListener(this.action);
            this.actionPropertyChangeListener = this.createActionPropertyChangeListener(this.action);
            this.action.addPropertyChangeListener(this.actionPropertyChangeListener);
        }
        this.firePropertyChange("horizontalAlignment", action2, action);
    }

    public void setActionCommand(String string) {
        this.actionCommand = string;
    }

    protected PropertyChangeListener createActionPropertyChangeListener(Action action) {
        return new PropertyChangeListener(this){
            private /* synthetic */ JTextField this$0;
            {
                this.this$0 = jTextField;
            }

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if (string.equals("enabled")) {
                    boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                    this.this$0.setEnabled(bl);
                } else if (string.equals("ShortDescription")) {
                    this.this$0.setToolTipText((String)propertyChangeEvent.getNewValue());
                }
            }
        };
    }

    protected void configurePropertiesFromAction(Action action) {
        if (action != null) {
            this.setEnabled(action.isEnabled());
            this.setToolTipText((String)action.getValue("ShortDescription"));
        } else {
            this.setEnabled(true);
            this.setToolTipText(null);
        }
    }

    protected int getColumnWidth() {
        FontMetrics fontMetrics = this.getToolkit().getFontMetrics(this.getFont());
        return fontMetrics.charWidth('m');
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJTextField(this);
        }
        return this.accessibleContext;
    }

    public BoundedRangeModel getHorizontalVisibility() {
        return this.horizontalVisibility;
    }

    public boolean isValidateRoot() {
        return this.getParent() instanceof JViewport ^ true;
    }

    public void scrollRectToVisible(Rectangle rectangle) {
        int n = this.horizontalVisibility.getValue();
        int n2 = this.horizontalVisibility.getExtent();
        Insets insets = this.getInsets();
        if (rectangle.x < insets.left) {
            this.setScrollOffset(n + rectangle.x - insets.left);
        } else if (rectangle.x > n2 + insets.left) {
            this.setScrollOffset(rectangle.x + n - n2 - insets.left);
        }
    }

    static {
        notifyAction = notifyAction;
        actions = new Action[1];
        JTextField.actions[0] = new TextAction(null, notifyAction){
            private /* synthetic */ JTextField this$0;
            {
                this.this$0 = jTextField;
                super(string);
            }

            public void actionPerformed(ActionEvent actionEvent) {
                JTextField jTextField = (JTextField)actionEvent.getSource();
                jTextField.fireActionPerformed();
            }
        };
    }

    protected class AccessibleJTextField
    extends JTextComponent.AccessibleJTextComponent {
        private /* synthetic */ JTextField this$0;
        private static final long serialVersionUID = 8255147276740453036L;

        protected AccessibleJTextField(JTextField jTextField) {
            this.this$0 = jTextField;
            super(jTextField);
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            return accessibleStateSet;
        }
    }
}

