/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.colorchooser;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.image.MemoryImageSource;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class DefaultHSBChooserPanel
extends AbstractColorChooserPanel {
    transient Image gradientImage;
    private transient JPanel gradientPanel;
    transient Image trackImage;
    private transient JPanel trackPanel;
    transient JSlider slider;
    transient JRadioButton hRadio;
    transient JRadioButton sRadio;
    transient JRadioButton bRadio;
    transient JSpinner hSpinner;
    transient JSpinner sSpinner;
    transient JSpinner bSpinner;
    private static final int imgWidth = 200;
    private static final int imgHeight = 200;
    private static final int trackWidth = 30;
    private static final JLabel R = new JLabel("R");
    private static final JLabel G = new JLabel("G");
    private static final JLabel B = new JLabel("B");
    private transient JLabel rFull;
    private transient JLabel gFull;
    private transient JLabel bFull;
    transient Point gradientPoint;
    transient boolean internalChange;
    transient boolean spinnerTrigger;
    transient int locked;
    static final int HLOCKED = 0;
    static final int SLOCKED = 1;
    static final int BLOCKED = 2;
    transient boolean handlingMouse;

    private /* synthetic */ void finit$() {
        this.gradientPoint = new Point();
        this.internalChange = false;
        this.spinnerTrigger = false;
        this.locked = -1;
    }

    DefaultHSBChooserPanel() {
        this.finit$();
    }

    public String getDisplayName() {
        return "HSB";
    }

    public void updateChooser() {
        Color color = this.getColorSelectionModel().getSelectedColor();
        float[] fArray = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        this.internalChange = true;
        if (!this.spinnerTrigger) {
            this.hSpinner.setValue(new Integer((int)(fArray[0] * 360.0f)));
            this.sSpinner.setValue(new Integer((int)(fArray[1] * 100.0f)));
            this.bSpinner.setValue(new Integer((int)(fArray[2] * 100.0f)));
        }
        switch (this.locked) {
            case 0: {
                if (this.slider != null) {
                    this.slider.setValue(((Number)this.hSpinner.getValue()).intValue());
                }
                if (this.handlingMouse) break;
                this.gradientPoint.x = (int)((1.0f - (float)((Number)this.sSpinner.getValue()).intValue() / 100.0f) * 200.0f);
                this.gradientPoint.y = (int)((1.0f - (float)((Number)this.bSpinner.getValue()).intValue() / 100.0f) * 200.0f);
                break;
            }
            case 1: {
                if (this.slider != null) {
                    this.slider.setValue(((Number)this.sSpinner.getValue()).intValue());
                }
                if (this.handlingMouse) break;
                this.gradientPoint.x = (int)((float)((Number)this.hSpinner.getValue()).intValue() / 360.0f * 200.0f);
                this.gradientPoint.y = (int)((1.0f - (float)((Number)this.bSpinner.getValue()).intValue() / 100.0f) * 200.0f);
                break;
            }
            case 2: {
                if (this.slider != null) {
                    this.slider.setValue(((Number)this.bSpinner.getValue()).intValue());
                }
                if (this.handlingMouse) break;
                this.gradientPoint.x = (int)((float)((Number)this.hSpinner.getValue()).intValue() / 360.0f * 200.0f);
                this.gradientPoint.y = (int)((1.0f - (float)((Number)this.sSpinner.getValue()).intValue() / 100.0f) * 200.0f);
            }
        }
        this.internalChange = false;
        if (!this.handlingMouse && this.slider != null && !this.slider.getValueIsAdjusting()) {
            this.updateImage();
        }
        if (!this.handlingMouse || this.locked != 0) {
            this.updateTrack();
        }
        this.updateTextFields();
    }

    protected void buildChooser() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.buildRightPanel(), "East");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this.gradientPanel = new JPanel(this){
            private /* synthetic */ DefaultHSBChooserPanel this$0;
            {
                this.this$0 = defaultHSBChooserPanel;
            }

            public Dimension getPreferredSize() {
                return new Dimension(200, 200);
            }

            public void paint(Graphics graphics) {
                if (this.this$0.gradientImage != null) {
                    graphics.drawImage(this.this$0.gradientImage, 0, 0, this);
                }
                Color color = graphics.getColor();
                graphics.setColor(Color.WHITE);
                graphics.drawOval(this.this$0.gradientPoint.x - 3, this.this$0.gradientPoint.y - 3, 6, 6);
                graphics.setColor(color);
            }
        };
        MainGradientMouseListener mainGradientMouseListener = new MainGradientMouseListener(this);
        this.gradientPanel.addMouseListener(mainGradientMouseListener);
        this.gradientPanel.addMouseMotionListener(mainGradientMouseListener);
        this.trackPanel = new JPanel(this){
            private /* synthetic */ DefaultHSBChooserPanel this$0;
            {
                this.this$0 = defaultHSBChooserPanel;
            }

            public Dimension getPreferredSize() {
                return new Dimension(30, 200);
            }

            public void paint(Graphics graphics) {
                if (this.this$0.trackImage != null) {
                    graphics.drawImage(this.this$0.trackImage, 0, 0, this);
                }
            }
        };
        this.slider = new JSlider();
        this.slider.setPaintTrack(false);
        this.slider.setPaintTicks(false);
        this.slider.setOrientation(1);
        this.updateSlider();
        jPanel.add((Component)this.gradientPanel, "West");
        jPanel.add((Component)this.slider, "Center");
        jPanel.add((Component)this.trackPanel, "East");
        this.add((Component)jPanel, "West");
        this.slider.addChangeListener(new SliderChangeListener(this));
        this.repaint();
    }

    public void uninstallChooserPanel(JColorChooser jColorChooser) {
        this.trackImage = null;
        this.gradientImage = null;
        this.gradientPanel = null;
        this.slider = null;
        this.hSpinner = null;
        this.sSpinner = null;
        this.bSpinner = null;
        this.hRadio = null;
        this.sRadio = null;
        this.bRadio = null;
        this.removeAll();
        super.uninstallChooserPanel(jColorChooser);
    }

    private Container buildRightPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(6, 2));
        this.hRadio = new JRadioButton("H");
        this.sRadio = new JRadioButton("S");
        this.bRadio = new JRadioButton("B");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.hRadio);
        buttonGroup.add(this.sRadio);
        buttonGroup.add(this.bRadio);
        this.hSpinner = new JSpinner(new SpinnerNumberModel(0, 0, 359, 1));
        this.sSpinner = new JSpinner(new SpinnerNumberModel(0, 0, 100, 1));
        this.bSpinner = new JSpinner(new SpinnerNumberModel(100, 0, 100, 1));
        this.hSpinner.setEnabled(false);
        this.sSpinner.setEnabled(false);
        this.bSpinner.setEnabled(false);
        RadioStateListener radioStateListener = new RadioStateListener(this);
        ImageScrollListener imageScrollListener = new ImageScrollListener(this);
        this.hRadio.addChangeListener(radioStateListener);
        this.sRadio.addChangeListener(radioStateListener);
        this.bRadio.addChangeListener(radioStateListener);
        this.hSpinner.addChangeListener(imageScrollListener);
        this.sSpinner.addChangeListener(imageScrollListener);
        this.bSpinner.addChangeListener(imageScrollListener);
        this.hRadio.setSelected(true);
        jPanel.add(this.hRadio);
        jPanel.add(this.hSpinner);
        jPanel.add(this.sRadio);
        jPanel.add(this.sSpinner);
        jPanel.add(this.bRadio);
        jPanel.add(this.bSpinner);
        this.rFull = new JLabel("red full");
        this.gFull = new JLabel("green full");
        this.bFull = new JLabel("blue full");
        jPanel.add(R);
        jPanel.add(this.rFull);
        jPanel.add(G);
        jPanel.add(this.gFull);
        jPanel.add(B);
        jPanel.add(this.bFull);
        return jPanel;
    }

    public Icon getSmallDisplayIcon() {
        return null;
    }

    public Icon getLargeDisplayIcon() {
        return null;
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
    }

    private void updateHLockImage() {
        int n = 0;
        int[] nArray = new int[40000];
        float f = (float)((Number)this.hSpinner.getValue()).intValue() / 360.0f;
        for (int i = 0; i < 200; ++i) {
            for (int j = 0; j < 200; ++j) {
                nArray[n++] = Color.HSBtoRGB(f, (200.0f - (float)j * 1.0f) / 200.0f, (200.0f - (float)i * 1.0f) / 200.0f) | 0xFF000000;
            }
        }
        this.gradientImage = this.createImage(new MemoryImageSource(200, 200, nArray, 0, 200));
    }

    private void updateBLockImage() {
        int[] nArray = new int[40000];
        float f = (float)((Number)this.bSpinner.getValue()).intValue() / 100.0f;
        int n = 0;
        for (int i = 0; i < 200; ++i) {
            for (int j = 0; j < 200; ++j) {
                nArray[n++] = Color.HSBtoRGB((float)j * 1.0f / 200.0f, (200.0f - (float)i * 1.0f) / 200.0f, f) | 0xFF000000;
            }
        }
        this.gradientImage = this.createImage(new MemoryImageSource(200, 200, nArray, 0, 200));
    }

    private void updateSLockImage() {
        int[] nArray = new int[40000];
        float f = (float)((Number)this.sSpinner.getValue()).intValue() / 100.0f;
        int n = 0;
        for (int i = 0; i < 200; ++i) {
            for (int j = 0; j < 200; ++j) {
                nArray[n++] = Color.HSBtoRGB((float)j * 1.0f / 200.0f, f, (200.0f - (float)i * 1.0f) / 200.0f) | 0xFF000000;
            }
        }
        this.gradientImage = this.createImage(new MemoryImageSource(200, 200, nArray, 0, 200));
    }

    void updateImage() {
        switch (this.locked) {
            case 0: {
                this.updateHLockImage();
                break;
            }
            case 1: {
                this.updateSLockImage();
                break;
            }
            case 2: {
                this.updateBLockImage();
            }
        }
    }

    private void updateTextFields() {
        int n = this.getColorSelectionModel().getSelectedColor().getRGB();
        this.rFull.setText("" + (n >> 16 & 0xFF));
        this.gFull.setText("" + (n >> 8 & 0xFF));
        this.bFull.setText("" + (n & 0xFF));
        this.repaint();
    }

    void updateSlider() {
        if (this.slider == null) {
            return;
        }
        this.slider.setMinimum(0);
        if (this.locked == 0) {
            this.slider.setMaximum(359);
            this.slider.setValue(((Number)this.hSpinner.getValue()).intValue());
            this.slider.setInverted(true);
        } else {
            this.slider.setMaximum(100);
            this.slider.setInverted(false);
            if (this.sRadio.isSelected()) {
                this.slider.setValue(((Number)this.sSpinner.getValue()).intValue());
            } else {
                this.slider.setValue(((Number)this.bSpinner.getValue()).intValue());
            }
        }
        this.repaint();
    }

    void updateTrack() {
        switch (this.locked) {
            case 0: {
                this.updateHTrack();
                break;
            }
            case 1: {
                this.updateSTrack();
                break;
            }
            case 2: {
                this.updateBTrack();
            }
        }
    }

    private void updateHTrack() {
        int n = 0;
        int[] nArray = new int[6000];
        for (int i = 0; i < 200; ++i) {
            for (int j = 0; j < 30; ++j) {
                nArray[n++] = Color.HSBtoRGB((float)i * 1.0f / 200.0f, 1.0f, 1.0f) | 0xFF000000;
            }
        }
        this.trackImage = this.createImage(new MemoryImageSource(30, 200, nArray, 0, 30));
    }

    private void updateSTrack() {
        int[] nArray = new int[6000];
        float f = (float)((Number)this.hSpinner.getValue()).intValue() / 360.0f;
        float f2 = (float)((Number)this.bSpinner.getValue()).intValue() / 100.0f;
        int n = 0;
        for (int i = 0; i < 200; ++i) {
            for (int j = 0; j < 30; ++j) {
                nArray[n++] = Color.HSBtoRGB(f, (200.0f - (float)i * 1.0f) / 200.0f, f2) | 0xFF000000;
            }
        }
        this.trackImage = this.createImage(new MemoryImageSource(30, 200, nArray, 0, 30));
    }

    private void updateBTrack() {
        int[] nArray = new int[6000];
        float f = (float)((Number)this.hSpinner.getValue()).intValue() / 360.0f;
        float f2 = (float)((Number)this.sSpinner.getValue()).intValue() / 100.0f;
        int n = 0;
        for (int i = 0; i < 200; ++i) {
            for (int j = 0; j < 30; ++j) {
                nArray[n++] = Color.HSBtoRGB(f, f2, (200.0f - (float)i * 1.0f) / 200.0f) | 0xFF000000;
            }
        }
        this.trackImage = this.createImage(new MemoryImageSource(30, 200, nArray, 0, 30));
    }

    private float[] getHSBValues() {
        Color color = this.getColorFromModel();
        float[] fArray = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        return fArray;
    }

    class ImageScrollListener
    implements ChangeListener {
        private /* synthetic */ DefaultHSBChooserPanel this$0;

        public void stateChanged(ChangeEvent changeEvent) {
            if (this.this$0.internalChange) {
                return;
            }
            float f = (float)((Number)this.this$0.hSpinner.getValue()).intValue() / 360.0f;
            float f2 = (float)((Number)this.this$0.sSpinner.getValue()).intValue() / 100.0f;
            float f3 = (float)((Number)this.this$0.bSpinner.getValue()).intValue() / 100.0f;
            this.this$0.spinnerTrigger = true;
            this.this$0.getColorSelectionModel().setSelectedColor(new Color(Color.HSBtoRGB(f, f2, f3)));
            this.this$0.spinnerTrigger = false;
            if (!this.this$0.handlingMouse && this.this$0.slider != null && !this.this$0.slider.getValueIsAdjusting()) {
                this.this$0.updateImage();
                this.this$0.updateTrack();
            }
            this.this$0.repaint();
        }

        ImageScrollListener(DefaultHSBChooserPanel defaultHSBChooserPanel) {
            this.this$0 = defaultHSBChooserPanel;
        }
    }

    class RadioStateListener
    implements ChangeListener {
        private /* synthetic */ DefaultHSBChooserPanel this$0;

        public void stateChanged(ChangeEvent changeEvent) {
            JSpinner jSpinner;
            if (changeEvent.getSource() == this.this$0.hRadio) {
                this.this$0.locked = 0;
                jSpinner = this.this$0.hSpinner;
            } else if (changeEvent.getSource() == this.this$0.sRadio) {
                this.this$0.locked = 1;
                jSpinner = this.this$0.sSpinner;
            } else {
                this.this$0.locked = 2;
                jSpinner = this.this$0.bSpinner;
            }
            jSpinner.setEnabled(((AbstractButton)changeEvent.getSource()).isSelected());
            this.this$0.updateSlider();
            this.this$0.updateTrack();
            this.this$0.updateImage();
            this.this$0.repaint();
        }

        RadioStateListener(DefaultHSBChooserPanel defaultHSBChooserPanel) {
            this.this$0 = defaultHSBChooserPanel;
        }
    }

    class SliderChangeListener
    implements ChangeListener {
        private /* synthetic */ DefaultHSBChooserPanel this$0;

        public void stateChanged(ChangeEvent changeEvent) {
            if (this.this$0.internalChange) {
                return;
            }
            Integer n = new Integer(this.this$0.slider.getValue());
            switch (this.this$0.locked) {
                case 0: {
                    this.this$0.hSpinner.setValue(n);
                    break;
                }
                case 1: {
                    this.this$0.sSpinner.setValue(n);
                    break;
                }
                case 2: {
                    this.this$0.bSpinner.setValue(n);
                }
            }
        }

        SliderChangeListener(DefaultHSBChooserPanel defaultHSBChooserPanel) {
            this.this$0 = defaultHSBChooserPanel;
        }
    }

    class MainGradientMouseListener
    extends MouseAdapter
    implements MouseMotionListener {
        private /* synthetic */ DefaultHSBChooserPanel this$0;

        public void mousePressed(MouseEvent mouseEvent) {
            this.this$0.gradientPoint = mouseEvent.getPoint();
            this.update(mouseEvent.getPoint());
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            Point point = mouseEvent.getPoint();
            if (point.x < 0 || point.y < 0 || point.y > 200 || point.x > 200) {
                return;
            }
            this.this$0.gradientPoint = point;
            this.update(point);
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        private void update(Point point) {
            this.this$0.handlingMouse = true;
            if (this.this$0.hSpinner.isEnabled()) {
                this.updateH(point);
            } else if (this.this$0.sSpinner.isEnabled()) {
                this.updateS(point);
            } else {
                this.updateB(point);
            }
            this.this$0.handlingMouse = false;
        }

        private void updateH(Point point) {
            float f = (200.0f - (float)point.x * 1.0f) / 200.0f;
            float f2 = (200.0f - (float)point.y * 1.0f) / 200.0f;
            this.this$0.internalChange = true;
            this.this$0.sSpinner.setValue(new Integer((int)(f * 100.0f)));
            this.this$0.internalChange = false;
            this.this$0.bSpinner.setValue(new Integer((int)(f2 * 100.0f)));
            this.this$0.revalidate();
        }

        private void updateS(Point point) {
            float f = (float)point.x * 1.0f / 200.0f;
            float f2 = (200.0f - (float)point.y * 1.0f) / 200.0f;
            this.this$0.internalChange = true;
            this.this$0.hSpinner.setValue(new Integer((int)(f * 365.0f)));
            this.this$0.internalChange = false;
            this.this$0.bSpinner.setValue(new Integer((int)(f2 * 100.0f)));
            this.this$0.revalidate();
        }

        private void updateB(Point point) {
            float f = (float)point.x * 1.0f / 200.0f;
            float f2 = (200.0f - (float)point.y * 1.0f) / 200.0f;
            this.this$0.internalChange = true;
            this.this$0.hSpinner.setValue(new Integer((int)(f * 365.0f)));
            this.this$0.internalChange = false;
            this.this$0.sSpinner.setValue(new Integer((int)(f2 * 100.0f)));
            this.this$0.revalidate();
        }

        MainGradientMouseListener(DefaultHSBChooserPanel defaultHSBChooserPanel) {
            this.this$0 = defaultHSBChooserPanel;
        }
    }
}

