/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.CellRendererPane;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListSelectionModel;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.TableUI;
import javax.swing.plaf.basic.SharedUIDefaults;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class BasicTableUI
extends TableUI {
    protected FocusListener focusListener;
    protected KeyListener keyListener;
    protected MouseInputListener mouseInputListener;
    protected CellRendererPane rendererPane;
    protected JTable table;
    Border cellBorder;
    TableAction action;
    private PropertyChangeListener propertyChangeListener;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicTableUI();
    }

    protected FocusListener createFocusListener() {
        return new FocusHandler(this);
    }

    protected MouseInputListener createMouseInputListener() {
        return new MouseInputHandler(this);
    }

    protected KeyListener createKeyListener() {
        return new KeyHandler(this);
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        int n = 0;
        for (int i = 0; i < this.table.getColumnCount(); ++i) {
            n += this.table.getColumnModel().getColumn(i).getMaxWidth();
        }
        return new Dimension(n, this.getHeight());
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        int n = 0;
        for (int i = 0; i < this.table.getColumnCount(); ++i) {
            n += this.table.getColumnModel().getColumn(i).getMinWidth();
        }
        return new Dimension(n, this.getHeight());
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        int n = 0;
        for (int i = 0; i < this.table.getColumnCount(); ++i) {
            TableColumn tableColumn = this.table.getColumnModel().getColumn(i);
            n += tableColumn.getPreferredWidth();
        }
        return new Dimension(n, this.getHeight());
    }

    private int getHeight() {
        int n = 0;
        int n2 = this.table.getRowCount();
        if (n2 > 0 && this.table.getColumnCount() > 0) {
            Rectangle rectangle = this.table.getCellRect(n2 - 1, 0, true);
            n = rectangle.y + rectangle.height;
        }
        return n;
    }

    protected void installDefaults() {
        LookAndFeel.installColorsAndFont(this.table, "Table.background", "Table.foreground", "Table.font");
        this.table.setGridColor(UIManager.getColor("Table.gridColor"));
        this.table.setSelectionForeground(UIManager.getColor("Table.selectionForeground"));
        this.table.setSelectionBackground(UIManager.getColor("Table.selectionBackground"));
        this.table.setOpaque(true);
    }

    protected void installKeyboardActions() {
        InputMap inputMap = (InputMap)SharedUIDefaults.get("Table.ancestorInputMap");
        SwingUtilities.replaceUIInputMap(this.table, 1, inputMap);
        SwingUtilities.replaceUIActionMap(this.table, this.getActionMap());
    }

    private ActionMap getActionMap() {
        ActionMap actionMap = (ActionMap)UIManager.get("Table.actionMap");
        if (actionMap == null) {
            actionMap = this.createDefaultActions();
            UIManager.getLookAndFeelDefaults().put("Table.actionMap", actionMap);
        }
        return actionMap;
    }

    private ActionMap createDefaultActions() {
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        TableAction tableAction = new TableAction();
        actionMapUIResource.put("cut", TransferHandler.getCutAction());
        actionMapUIResource.put("copy", TransferHandler.getCopyAction());
        actionMapUIResource.put("paste", TransferHandler.getPasteAction());
        actionMapUIResource.put("cancel", tableAction);
        actionMapUIResource.put("selectAll", tableAction);
        actionMapUIResource.put("clearSelection", tableAction);
        actionMapUIResource.put("startEditing", tableAction);
        actionMapUIResource.put("selectNextRow", tableAction);
        actionMapUIResource.put("selectNextRowCell", tableAction);
        actionMapUIResource.put("selectNextRowExtendSelection", tableAction);
        actionMapUIResource.put("selectNextRowChangeLead", tableAction);
        actionMapUIResource.put("selectPreviousRow", tableAction);
        actionMapUIResource.put("selectPreviousRowCell", tableAction);
        actionMapUIResource.put("selectPreviousRowExtendSelection", tableAction);
        actionMapUIResource.put("selectPreviousRowChangeLead", tableAction);
        actionMapUIResource.put("selectNextColumn", tableAction);
        actionMapUIResource.put("selectNextColumnCell", tableAction);
        actionMapUIResource.put("selectNextColumnExtendSelection", tableAction);
        actionMapUIResource.put("selectNextColumnChangeLead", tableAction);
        actionMapUIResource.put("selectPreviousColumn", tableAction);
        actionMapUIResource.put("selectPreviousColumnCell", tableAction);
        actionMapUIResource.put("selectPreviousColumnExtendSelection", tableAction);
        actionMapUIResource.put("selectPreviousColumnChangeLead", tableAction);
        actionMapUIResource.put("scrollLeftChangeSelection", tableAction);
        actionMapUIResource.put("scrollLeftExtendSelection", tableAction);
        actionMapUIResource.put("scrollRightChangeSelection", tableAction);
        actionMapUIResource.put("scrollRightExtendSelection", tableAction);
        actionMapUIResource.put("scrollUpChangeSelection", tableAction);
        actionMapUIResource.put("scrollUpExtendSelection", tableAction);
        actionMapUIResource.put("scrollDownChangeSelection", tableAction);
        actionMapUIResource.put("scrolldownExtendSelection", tableAction);
        actionMapUIResource.put("selectFirstColumn", tableAction);
        actionMapUIResource.put("selectFirstColumnExtendSelection", tableAction);
        actionMapUIResource.put("selectLastColumn", tableAction);
        actionMapUIResource.put("selectLastColumnExtendSelection", tableAction);
        actionMapUIResource.put("selectFirstRow", tableAction);
        actionMapUIResource.put("selectFirstRowExtendSelection", tableAction);
        actionMapUIResource.put("selectLastRow", tableAction);
        actionMapUIResource.put("selectLastRowExtendSelection", tableAction);
        actionMapUIResource.put("addToSelection", tableAction);
        actionMapUIResource.put("toggleAndAnchor", tableAction);
        actionMapUIResource.put("extendTo", tableAction);
        actionMapUIResource.put("moveSelectionTo", tableAction);
        return actionMapUIResource;
    }

    protected void installListeners() {
        if (this.focusListener == null) {
            this.focusListener = this.createFocusListener();
        }
        this.table.addFocusListener(this.focusListener);
        if (this.keyListener == null) {
            this.keyListener = this.createKeyListener();
        }
        this.table.addKeyListener(this.keyListener);
        if (this.mouseInputListener == null) {
            this.mouseInputListener = this.createMouseInputListener();
        }
        this.table.addMouseListener(this.mouseInputListener);
        this.table.addMouseMotionListener(this.mouseInputListener);
        if (this.propertyChangeListener == null) {
            this.propertyChangeListener = new PropertyChangeHandler(this);
        }
        this.table.addPropertyChangeListener(this.propertyChangeListener);
    }

    protected void uninstallDefaults() {
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIInputMap(this.table, 1, null);
        SwingUtilities.replaceUIActionMap(this.table, null);
    }

    protected void uninstallListeners() {
        this.table.removeFocusListener(this.focusListener);
        this.table.removeKeyListener(this.keyListener);
        this.table.removeMouseListener(this.mouseInputListener);
        this.table.removeMouseMotionListener(this.mouseInputListener);
        this.table.removePropertyChangeListener(this.propertyChangeListener);
        this.propertyChangeListener = null;
    }

    public void installUI(JComponent jComponent) {
        this.table = (JTable)jComponent;
        this.rendererPane = new CellRendererPane();
        this.table.add(this.rendererPane);
        this.installDefaults();
        this.installKeyboardActions();
        this.installListeners();
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallListeners();
        this.uninstallKeyboardActions();
        this.uninstallDefaults();
        this.table.remove(this.rendererPane);
        this.rendererPane = null;
        this.table = null;
    }

    void paintCell(Graphics graphics, int n, int n2, Rectangle rectangle, TableCellRenderer tableCellRenderer) {
        Component component = this.table.prepareRenderer(tableCellRenderer, n, n2);
        this.rendererPane.paintComponent(graphics, component, this.table, rectangle);
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        int n;
        int n2;
        int n3;
        Point point;
        int n4;
        int n5;
        int n6 = this.table.getColumnCount();
        int n7 = this.table.getRowCount();
        if (n7 == 0 || n6 == 0) {
            return;
        }
        Rectangle rectangle = graphics.getClipBounds();
        Point point2 = new Point(rectangle.x, rectangle.y);
        int n8 = this.table.columnAtPoint(point2);
        if (n8 == -1) {
            n8 = 0;
        }
        if ((n5 = this.table.rowAtPoint(point2)) == -1) {
            n5 = 0;
        }
        if ((n4 = this.table.columnAtPoint(point = new Point(rectangle.x + rectangle.width, rectangle.y + rectangle.height))) == -1) {
            n4 = this.table.getColumnCount() - 1;
        }
        if ((n3 = this.table.rowAtPoint(point)) == -1) {
            n3 = this.table.getRowCount() - 1;
        }
        int n9 = this.table.getColumnModel().getColumnMargin();
        int n10 = this.table.getRowMargin();
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        int[] nArray = new int[n4 + 1];
        for (int i = n8; i <= n4; ++i) {
            nArray[i] = tableColumnModel.getColumn(i).getWidth() - n9;
        }
        Rectangle rectangle2 = this.table.getCellRect(n5, n8, false);
        int n11 = rectangle2.x;
        int n12 = rectangle2.y;
        Color color = this.table.getGridColor();
        for (int i = n5; i <= n3; ++i) {
            for (n2 = n8; n2 <= n4; ++n2) {
                rectangle2.width = nArray[n2];
                this.paintCell(graphics, i, n2, rectangle2, this.table.getCellRenderer(i, n2));
                rectangle2.x += nArray[n2] + n9;
            }
            rectangle2.x = n11;
            rectangle2.y += this.table.getRowHeight(i);
            rectangle2.height = this.table.getRowHeight(i + 1) - n10;
        }
        int n13 = rectangle2.y - n10;
        if (color != null && this.table.getShowVerticalLines()) {
            Color color2 = graphics.getColor();
            graphics.setColor(color);
            n2 = n11 - n9;
            for (n = n8; n <= n4; ++n) {
                graphics.drawLine(n2 += nArray[n] + n9, n12, n2, n13);
            }
            graphics.setColor(color2);
        }
        if (color != null && this.table.getShowHorizontalLines()) {
            Color color3 = graphics.getColor();
            graphics.setColor(color);
            n2 = n12 - n10;
            for (n = n5; n <= n3; ++n) {
                graphics.drawLine(n11, n2 += this.table.getRowHeight(n), point.x, n2);
            }
            graphics.setColor(color3);
        }
    }

    private static class TableAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            JTable jTable = (JTable)actionEvent.getSource();
            DefaultListSelectionModel defaultListSelectionModel = (DefaultListSelectionModel)jTable.getSelectionModel();
            DefaultListSelectionModel defaultListSelectionModel2 = (DefaultListSelectionModel)jTable.getColumnModel().getSelectionModel();
            int n = defaultListSelectionModel.getLeadSelectionIndex();
            int n2 = jTable.getModel().getRowCount() - 1;
            int n3 = defaultListSelectionModel2.getLeadSelectionIndex();
            int n4 = jTable.getModel().getColumnCount() - 1;
            String string = (String)this.getValue("__command__");
            if (string.equals("selectPreviousRowExtendSelection")) {
                defaultListSelectionModel.setLeadSelectionIndex(Math.max(n - 1, 0));
            } else if (string.equals("selectLastColumn")) {
                defaultListSelectionModel2.setSelectionInterval(n4, n4);
            } else if (string.equals("startEditing")) {
                if (jTable.isCellEditable(n, n3)) {
                    jTable.editCellAt(n, n3);
                }
            } else if (string.equals("selectFirstRowExtendSelection")) {
                defaultListSelectionModel.setLeadSelectionIndex(0);
            } else if (string.equals("selectFirstColumn")) {
                defaultListSelectionModel2.setSelectionInterval(0, 0);
            } else if (string.equals("selectFirstColumnExtendSelection")) {
                defaultListSelectionModel2.setLeadSelectionIndex(0);
            } else if (string.equals("selectLastRow")) {
                defaultListSelectionModel.setSelectionInterval(n2, n2);
            } else if (string.equals("selectNextRowExtendSelection")) {
                defaultListSelectionModel.setLeadSelectionIndex(Math.min(n + 1, n2));
            } else if (string.equals("selectFirstRow")) {
                defaultListSelectionModel.setSelectionInterval(0, 0);
            } else if (string.equals("selectNextColumnExtendSelection")) {
                defaultListSelectionModel2.setLeadSelectionIndex(Math.min(n3 + 1, n4));
            } else if (string.equals("selectLastColumnExtendSelection")) {
                defaultListSelectionModel2.setLeadSelectionIndex(n4);
            } else if (string.equals("selectPreviousColumnExtendSelection")) {
                defaultListSelectionModel2.setLeadSelectionIndex(Math.max(n3 - 1, 0));
            } else if (string.equals("selectNextRow")) {
                defaultListSelectionModel.setSelectionInterval(Math.min(n + 1, n2), Math.min(n + 1, n2));
            } else if (string.equals("scrollUpExtendSelection")) {
                int n5 = n == this.getFirstVisibleRowIndex(jTable) ? Math.max(0, n - (this.getLastVisibleRowIndex(jTable) - this.getFirstVisibleRowIndex(jTable) + 1)) : this.getFirstVisibleRowIndex(jTable);
                defaultListSelectionModel.setLeadSelectionIndex(n5);
                defaultListSelectionModel2.setLeadSelectionIndex(n3);
            } else if (string.equals("selectPreviousRow")) {
                defaultListSelectionModel.setSelectionInterval(Math.max(n - 1, 0), Math.max(n - 1, 0));
            } else if (string.equals("scrollRightChangeSelection")) {
                int n6 = n3 == this.getLastVisibleColumnIndex(jTable) ? Math.min(n4, n3 + (this.getLastVisibleColumnIndex(jTable) - this.getFirstVisibleColumnIndex(jTable) + 1)) : this.getLastVisibleColumnIndex(jTable);
                defaultListSelectionModel2.setSelectionInterval(n6, n6);
                defaultListSelectionModel.setSelectionInterval(n, n);
            } else if (string.equals("selectPreviousColumn")) {
                defaultListSelectionModel2.setSelectionInterval(Math.max(n3 - 1, 0), Math.max(n3 - 1, 0));
            } else if (string.equals("scrollLeftChangeSelection")) {
                int n7 = n3 == this.getFirstVisibleColumnIndex(jTable) ? Math.max(0, n3 - (this.getLastVisibleColumnIndex(jTable) - this.getFirstVisibleColumnIndex(jTable) + 1)) : this.getFirstVisibleColumnIndex(jTable);
                defaultListSelectionModel2.setSelectionInterval(n7, n7);
                defaultListSelectionModel.setSelectionInterval(n, n);
            } else if (string.equals("clearSelection")) {
                jTable.clearSelection();
            } else if (string.equals("cancel")) {
                if (jTable.isEditing()) {
                    jTable.editingCanceled(new ChangeEvent("cancel"));
                }
            } else if (string.equals("selectNextRowCell") || string.equals("selectPreviousRowCell") || string.equals("selectNextColumnCell") || string.equals("selectPreviousColumnCell")) {
                int n8;
                boolean bl;
                if (jTable.getSelectedRowCount() == 0 && jTable.getSelectedColumnCount() == 0) {
                    defaultListSelectionModel.setSelectionInterval(0, 0);
                    defaultListSelectionModel2.setSelectionInterval(0, 0);
                    return;
                }
                if (!jTable.isCellSelected(n, n3)) {
                    defaultListSelectionModel.addSelectionInterval(defaultListSelectionModel.getMinSelectionIndex(), defaultListSelectionModel.getMinSelectionIndex());
                    defaultListSelectionModel2.addSelectionInterval(defaultListSelectionModel2.getMinSelectionIndex(), defaultListSelectionModel2.getMinSelectionIndex());
                    return;
                }
                boolean bl2 = jTable.getSelectedRowCount() > 1 && jTable.getRowSelectionAllowed();
                boolean bl3 = bl = jTable.getSelectedColumnCount() > 1 && jTable.getColumnSelectionAllowed();
                if (!bl && !bl2) {
                    if (string.indexOf("Column") != -1) {
                        this.advanceSingleSelection(defaultListSelectionModel2, n4, defaultListSelectionModel, n2, string.equals("selectPreviousColumnCell"));
                    } else {
                        this.advanceSingleSelection(defaultListSelectionModel, n2, defaultListSelectionModel2, n4, string.equals("selectPreviousRowCell"));
                    }
                    return;
                }
                int n9 = jTable.getRowSelectionAllowed() ? defaultListSelectionModel.getMaxSelectionIndex() : jTable.getModel().getRowCount() - 1;
                int n10 = jTable.getRowSelectionAllowed() ? defaultListSelectionModel.getMinSelectionIndex() : 0;
                int n11 = jTable.getColumnSelectionAllowed() ? defaultListSelectionModel2.getMaxSelectionIndex() : jTable.getModel().getColumnCount() - 1;
                int n12 = n8 = jTable.getColumnSelectionAllowed() ? defaultListSelectionModel2.getMinSelectionIndex() : 0;
                if (string.indexOf("Column") != -1) {
                    this.advanceMultipleSelection(jTable, defaultListSelectionModel2, n8, n11, defaultListSelectionModel, n10, n9, string.equals("selectPreviousColumnCell"), true);
                } else {
                    this.advanceMultipleSelection(jTable, defaultListSelectionModel, n10, n9, defaultListSelectionModel2, n8, n11, string.equals("selectPreviousRowCell"), false);
                }
            } else if (string.equals("selectNextColumn")) {
                defaultListSelectionModel2.setSelectionInterval(Math.min(n3 + 1, n4), Math.min(n3 + 1, n4));
            } else if (string.equals("scrollLeftExtendSelection")) {
                int n13 = n3 == this.getFirstVisibleColumnIndex(jTable) ? Math.max(0, n3 - (this.getLastVisibleColumnIndex(jTable) - this.getFirstVisibleColumnIndex(jTable) + 1)) : this.getFirstVisibleColumnIndex(jTable);
                defaultListSelectionModel2.setLeadSelectionIndex(n13);
                defaultListSelectionModel.setLeadSelectionIndex(n);
            } else if (string.equals("scrollDownChangeSelection")) {
                int n14 = n == this.getLastVisibleRowIndex(jTable) ? Math.min(n2, n + (this.getLastVisibleRowIndex(jTable) - this.getFirstVisibleRowIndex(jTable) + 1)) : this.getLastVisibleRowIndex(jTable);
                defaultListSelectionModel.setSelectionInterval(n14, n14);
                defaultListSelectionModel2.setSelectionInterval(n3, n3);
            } else if (string.equals("scrollRightExtendSelection")) {
                int n15 = n3 == this.getLastVisibleColumnIndex(jTable) ? Math.min(n4, n3 + (this.getLastVisibleColumnIndex(jTable) - this.getFirstVisibleColumnIndex(jTable) + 1)) : this.getLastVisibleColumnIndex(jTable);
                defaultListSelectionModel2.setLeadSelectionIndex(n15);
                defaultListSelectionModel.setLeadSelectionIndex(n);
            } else if (string.equals("selectAll")) {
                jTable.selectAll();
            } else if (string.equals("selectLastRowExtendSelection")) {
                defaultListSelectionModel.setLeadSelectionIndex(n2);
                defaultListSelectionModel2.setLeadSelectionIndex(n3);
            } else if (string.equals("scrollDownExtendSelection")) {
                int n16 = n == this.getLastVisibleRowIndex(jTable) ? Math.min(n2, n + (this.getLastVisibleRowIndex(jTable) - this.getFirstVisibleRowIndex(jTable) + 1)) : this.getLastVisibleRowIndex(jTable);
                defaultListSelectionModel.setLeadSelectionIndex(n16);
                defaultListSelectionModel2.setLeadSelectionIndex(n3);
            } else if (string.equals("scrollUpChangeSelection")) {
                int n17 = n == this.getFirstVisibleRowIndex(jTable) ? Math.max(0, n - (this.getLastVisibleRowIndex(jTable) - this.getFirstVisibleRowIndex(jTable) + 1)) : this.getFirstVisibleRowIndex(jTable);
                defaultListSelectionModel.setSelectionInterval(n17, n17);
                defaultListSelectionModel2.setSelectionInterval(n3, n3);
            } else if (string.equals("selectNextRowChangeLead")) {
                if (defaultListSelectionModel.getSelectionMode() != 2) {
                    defaultListSelectionModel.setSelectionInterval(Math.min(n + 1, n2), Math.min(n + 1, n2));
                    defaultListSelectionModel2.setSelectionInterval(n3, n3);
                } else {
                    defaultListSelectionModel.moveLeadSelectionIndex(Math.min(n + 1, n2));
                }
            } else if (string.equals("selectPreviousRowChangeLead")) {
                if (defaultListSelectionModel.getSelectionMode() != 2) {
                    defaultListSelectionModel.setSelectionInterval(Math.max(n - 1, 0), Math.min(n - 1, 0));
                    defaultListSelectionModel2.setSelectionInterval(n3, n3);
                } else {
                    defaultListSelectionModel.moveLeadSelectionIndex(Math.max(n - 1, 0));
                }
            } else if (string.equals("selectNextColumnChangeLead")) {
                if (defaultListSelectionModel2.getSelectionMode() != 2) {
                    defaultListSelectionModel.setSelectionInterval(n, n);
                    defaultListSelectionModel2.setSelectionInterval(Math.min(n3 + 1, n4), Math.min(n3 + 1, n4));
                } else {
                    defaultListSelectionModel2.moveLeadSelectionIndex(Math.min(n3 + 1, n4));
                }
            } else if (string.equals("selectPreviousColumnChangeLead")) {
                if (defaultListSelectionModel2.getSelectionMode() != 2) {
                    defaultListSelectionModel.setSelectionInterval(n, n);
                    defaultListSelectionModel2.setSelectionInterval(Math.max(n3 - 1, 0), Math.max(n3 - 1, 0));
                } else {
                    defaultListSelectionModel2.moveLeadSelectionIndex(Math.max(n3 - 1, 0));
                }
            } else if (string.equals("addToSelection")) {
                if (!jTable.isEditing()) {
                    int n18 = defaultListSelectionModel.getAnchorSelectionIndex();
                    int n19 = defaultListSelectionModel2.getAnchorSelectionIndex();
                    defaultListSelectionModel.addSelectionInterval(n, n);
                    defaultListSelectionModel2.addSelectionInterval(n3, n3);
                    defaultListSelectionModel.setAnchorSelectionIndex(n18);
                    defaultListSelectionModel2.setAnchorSelectionIndex(n19);
                }
            } else if (string.equals("extendTo")) {
                defaultListSelectionModel.setSelectionInterval(defaultListSelectionModel.getAnchorSelectionIndex(), n);
                defaultListSelectionModel2.setSelectionInterval(defaultListSelectionModel2.getAnchorSelectionIndex(), n3);
            } else if (string.equals("toggleAndAnchor")) {
                if (defaultListSelectionModel.isSelectedIndex(n)) {
                    defaultListSelectionModel.removeSelectionInterval(n, n);
                } else {
                    defaultListSelectionModel.addSelectionInterval(n, n);
                }
                if (defaultListSelectionModel2.isSelectedIndex(n3)) {
                    defaultListSelectionModel2.removeSelectionInterval(n3, n3);
                } else {
                    defaultListSelectionModel2.addSelectionInterval(n3, n3);
                }
                defaultListSelectionModel.setAnchorSelectionIndex(n);
                defaultListSelectionModel2.setAnchorSelectionIndex(n3);
            } else if (string.equals("stopEditing")) {
                jTable.editingStopped(new ChangeEvent(string));
            }
            if (jTable.isEditing() && string != "startEditing" && string != "addToSelection") {
                jTable.editingStopped(new ChangeEvent("update"));
            }
            jTable.scrollRectToVisible(jTable.getCellRect(defaultListSelectionModel.getLeadSelectionIndex(), defaultListSelectionModel2.getLeadSelectionIndex(), false));
        }

        int getFirstVisibleColumnIndex(JTable jTable) {
            ComponentOrientation componentOrientation = jTable.getComponentOrientation();
            Rectangle rectangle = jTable.getVisibleRect();
            if (!componentOrientation.isLeftToRight()) {
                rectangle.translate((int)rectangle.getWidth() - 1, 0);
            }
            return jTable.columnAtPoint(rectangle.getLocation());
        }

        int getLastVisibleColumnIndex(JTable jTable) {
            ComponentOrientation componentOrientation = jTable.getComponentOrientation();
            Rectangle rectangle = jTable.getVisibleRect();
            if (componentOrientation.isLeftToRight()) {
                rectangle.translate((int)rectangle.getWidth() - 1, 0);
            }
            return jTable.columnAtPoint(rectangle.getLocation());
        }

        int getFirstVisibleRowIndex(JTable jTable) {
            ComponentOrientation componentOrientation = jTable.getComponentOrientation();
            Rectangle rectangle = jTable.getVisibleRect();
            if (!componentOrientation.isLeftToRight()) {
                rectangle.translate((int)rectangle.getWidth() - 1, 0);
            }
            return jTable.rowAtPoint(rectangle.getLocation());
        }

        int getLastVisibleRowIndex(JTable jTable) {
            ComponentOrientation componentOrientation = jTable.getComponentOrientation();
            Rectangle rectangle = jTable.getVisibleRect();
            rectangle.translate(0, (int)rectangle.getHeight() - 1);
            if (componentOrientation.isLeftToRight()) {
                rectangle.translate((int)rectangle.getWidth() - 1, 0);
            }
            if (jTable.rowAtPoint(rectangle.getLocation()) == -1) {
                if (this.getFirstVisibleRowIndex(jTable) == -1) {
                    return -1;
                }
                return jTable.getModel().getRowCount() - 1;
            }
            return jTable.rowAtPoint(rectangle.getLocation());
        }

        void advanceMultipleSelection(JTable jTable, ListSelectionModel listSelectionModel, int n, int n2, ListSelectionModel listSelectionModel2, int n3, int n4, boolean bl, boolean bl2) {
            int n5;
            int n6 = listSelectionModel.getLeadSelectionIndex();
            int n7 = listSelectionModel2.getLeadSelectionIndex();
            int n8 = bl2 ? jTable.getModel().getColumnCount() : jTable.getModel().getRowCount();
            int n9 = n5 = bl2 ? jTable.getModel().getRowCount() : jTable.getModel().getColumnCount();
            if (n6 == n2 && !bl || bl && n6 == n) {
                listSelectionModel.addSelectionInterval(bl ? n2 : n, bl ? n2 : n);
                if (n7 == n4 && !bl || bl && n7 == n3) {
                    listSelectionModel2.addSelectionInterval(bl ? n4 : n3, bl ? n4 : n3);
                } else {
                    int n10;
                    int[] nArray;
                    if (bl2 && jTable.getRowSelectionAllowed() || !bl2 && jTable.getColumnSelectionAllowed()) {
                        nArray = bl2 ? jTable.getSelectedRows() : jTable.getSelectedColumns();
                    } else {
                        nArray = new int[n5];
                        for (n10 = 0; n10 < n5; ++n10) {
                            nArray[n10] = n10;
                        }
                    }
                    int n11 = n10 = bl ? nArray.length - 1 : 0;
                    if (!bl) {
                        while (nArray[n10] <= n7) {
                            ++n10;
                        }
                    } else {
                        while (nArray[n10] >= n7) {
                            --n10;
                        }
                    }
                    listSelectionModel2.addSelectionInterval(nArray[n10], nArray[n10]);
                }
            } else {
                int n12;
                int[] nArray;
                if (bl2 && jTable.getColumnSelectionAllowed() || !bl2 && jTable.getRowSelectionAllowed()) {
                    nArray = bl2 ? jTable.getSelectedColumns() : jTable.getSelectedRows();
                } else {
                    nArray = new int[n8];
                    for (n12 = 0; n12 < n8; ++n12) {
                        nArray[n12] = n12;
                    }
                }
                int n13 = n12 = bl ? nArray.length - 1 : 0;
                if (!bl) {
                    while (nArray[n12] <= n6) {
                        ++n12;
                    }
                } else {
                    while (nArray[n12] >= n6) {
                        --n12;
                    }
                }
                listSelectionModel.addSelectionInterval(nArray[n12], nArray[n12]);
                listSelectionModel2.addSelectionInterval(n7, n7);
            }
        }

        void advanceSingleSelection(ListSelectionModel listSelectionModel, int n, ListSelectionModel listSelectionModel2, int n2, boolean bl) {
            int n3 = listSelectionModel.getLeadSelectionIndex();
            int n4 = listSelectionModel2.getLeadSelectionIndex();
            if (bl && n3 == 0) {
                if (n4 == 0) {
                    n4 += n2 + 1;
                }
                n4 -= 2;
            }
            if (bl && n3 == 0 || !bl && n3 == n) {
                listSelectionModel2.setSelectionInterval((n4 + 1) % (n2 + 1), (n4 + 1) % (n2 + 1));
            } else {
                listSelectionModel2.setSelectionInterval(n4, n4);
            }
            if (bl) {
                if (n3 == 0) {
                    n3 += n + 1;
                }
                n3 -= 2;
            }
            listSelectionModel.setSelectionInterval((n3 + 1) % (n + 1), (n3 + 1) % (n + 1));
        }

        TableAction() {
        }
    }

    private class PropertyChangeHandler
    implements PropertyChangeListener {
        private /* synthetic */ BasicTableUI this$0;

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("model")) {
                ListSelectionModel listSelectionModel = this.this$0.table.getSelectionModel();
                listSelectionModel.clearSelection();
                ListSelectionModel listSelectionModel2 = this.this$0.table.getColumnModel().getSelectionModel();
                listSelectionModel2.clearSelection();
                TableModel tableModel = this.this$0.table.getModel();
                if (tableModel.getRowCount() > 0) {
                    listSelectionModel.setAnchorSelectionIndex(0);
                    listSelectionModel.setLeadSelectionIndex(0);
                } else {
                    listSelectionModel.setAnchorSelectionIndex(-1);
                    listSelectionModel.setLeadSelectionIndex(-1);
                }
                if (tableModel.getColumnCount() > 0) {
                    listSelectionModel2.setAnchorSelectionIndex(0);
                    listSelectionModel2.setLeadSelectionIndex(0);
                } else {
                    listSelectionModel2.setAnchorSelectionIndex(-1);
                    listSelectionModel2.setLeadSelectionIndex(-1);
                }
            }
        }

        PropertyChangeHandler(BasicTableUI basicTableUI) {
            this.this$0 = basicTableUI;
        }
    }

    public class MouseInputHandler
    implements MouseInputListener {
        private /* synthetic */ BasicTableUI this$0;
        Point begin;
        Point curr;

        private void updateSelection(boolean bl) {
            int n = this.this$0.table.rowAtPoint(this.begin);
            int n2 = this.this$0.table.rowAtPoint(this.curr);
            ListSelectionModel listSelectionModel = this.this$0.table.getSelectionModel();
            if (n != -1 && n2 != -1) {
                if (bl && listSelectionModel.getSelectionMode() != 0) {
                    listSelectionModel.addSelectionInterval(n, n2);
                } else {
                    listSelectionModel.setSelectionInterval(n, n2);
                }
            }
            int n3 = this.this$0.table.columnAtPoint(this.begin);
            int n4 = this.this$0.table.columnAtPoint(this.curr);
            ListSelectionModel listSelectionModel2 = this.this$0.table.getColumnModel().getSelectionModel();
            if (n3 != -1 && n4 != -1) {
                if (bl && listSelectionModel2.getSelectionMode() != 0) {
                    listSelectionModel2.addSelectionInterval(n3, n4);
                } else {
                    listSelectionModel2.setSelectionInterval(n3, n4);
                }
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            int n;
            Point point = mouseEvent.getPoint();
            int n2 = this.this$0.table.rowAtPoint(point);
            if (this.this$0.table.isCellEditable(n2, n = this.this$0.table.columnAtPoint(point))) {
                TableCellEditor tableCellEditor = this.this$0.table.getCellEditor(n2, n);
                if (tableCellEditor instanceof DefaultCellEditor) {
                    DefaultCellEditor defaultCellEditor = (DefaultCellEditor)tableCellEditor;
                    if (mouseEvent.getClickCount() < defaultCellEditor.getClickCountToStart()) {
                        return;
                    }
                }
                this.this$0.table.editCellAt(n2, n);
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (this.this$0.table.isEnabled()) {
                this.curr = new Point(mouseEvent.getX(), mouseEvent.getY());
                this.updateSelection(mouseEvent.isControlDown());
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (this.this$0.table.isEnabled()) {
                ListSelectionModel listSelectionModel = this.this$0.table.getSelectionModel();
                ListSelectionModel listSelectionModel2 = this.this$0.table.getColumnModel().getSelectionModel();
                int n = listSelectionModel.getLeadSelectionIndex();
                int n2 = listSelectionModel2.getLeadSelectionIndex();
                this.begin = new Point(mouseEvent.getX(), mouseEvent.getY());
                this.curr = new Point(mouseEvent.getX(), mouseEvent.getY());
                if (mouseEvent.isControlDown() && this.this$0.table.isCellSelected(this.this$0.table.rowAtPoint(this.begin), this.this$0.table.columnAtPoint(this.begin))) {
                    this.this$0.table.getSelectionModel().removeSelectionInterval(this.this$0.table.rowAtPoint(this.begin), this.this$0.table.rowAtPoint(this.begin));
                    this.this$0.table.getColumnModel().getSelectionModel().removeSelectionInterval(this.this$0.table.columnAtPoint(this.begin), this.this$0.table.columnAtPoint(this.begin));
                } else {
                    this.updateSelection(mouseEvent.isControlDown());
                }
                if ((n != listSelectionModel.getLeadSelectionIndex() || n2 != listSelectionModel2.getLeadSelectionIndex()) && this.this$0.table.isEditing()) {
                    this.this$0.table.editingStopped(new ChangeEvent(mouseEvent));
                }
                this.this$0.table.requestFocusInWindow();
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.this$0.table.isEnabled()) {
                this.begin = null;
                this.curr = null;
            }
        }

        public MouseInputHandler(BasicTableUI basicTableUI) {
            this.this$0 = basicTableUI;
        }
    }

    public class FocusHandler
    implements FocusListener {
        private /* synthetic */ BasicTableUI this$0;

        public void focusGained(FocusEvent focusEvent) {
            this.repaintLeadCell();
        }

        public void focusLost(FocusEvent focusEvent) {
            this.repaintLeadCell();
        }

        private void repaintLeadCell() {
            int n = this.this$0.table.getRowCount();
            int n2 = this.this$0.table.getColumnCount();
            int n3 = this.this$0.table.getSelectionModel().getLeadSelectionIndex();
            int n4 = this.this$0.table.getColumnModel().getSelectionModel().getLeadSelectionIndex();
            if (n3 >= 0 && n3 < n && n4 >= 0 && n4 < n2) {
                Rectangle rectangle = this.this$0.table.getCellRect(n3, n4, false);
                this.this$0.table.repaint(rectangle);
            }
        }

        public FocusHandler(BasicTableUI basicTableUI) {
            this.this$0 = basicTableUI;
        }
    }

    public class KeyHandler
    implements KeyListener {
        private /* synthetic */ BasicTableUI this$0;

        public void keyTyped(KeyEvent keyEvent) {
            int n;
            int n2;
            if (!this.this$0.table.isEditing() && this.this$0.table.isEnabled() && this.this$0.table.isCellEditable(n2 = this.this$0.table.getSelectedRow(), n = this.this$0.table.getSelectedColumn())) {
                this.this$0.table.editCellAt(n2, n);
            }
        }

        public void keyPressed(KeyEvent keyEvent) {
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public KeyHandler(BasicTableUI basicTableUI) {
            this.this$0 = basicTableUI;
        }
    }
}

