/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import gnu.classpath.SystemProperties;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.TexturePaint;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.List;
import javax.swing.UIManager;

class MetalUtils {
    static BufferedImage pattern2D;
    static Color lightColor;
    static Color darkColor;

    static void fillMetalPattern(Component component, Graphics graphics, int n, int n2, int n3, int n4, Color color, Color color2) {
        if (graphics instanceof Graphics2D && SystemProperties.getProperty("gnu.javax.swing.noGraphics2D") == null) {
            MetalUtils.fillMetalPattern2D((Graphics2D)graphics, n, n2, n3, n4, color, color2);
        } else {
            int n5 = 0;
            for (int i = n2; i < n2 + n4; ++i) {
                if ((i - n2) % 2 == 0) {
                    graphics.setColor(color);
                } else {
                    graphics.setColor(color2);
                }
                for (int j = n + n5; j < n + n3; j += 4) {
                    graphics.fillRect(j, i, 1, 1);
                }
                if (++n5 <= 3) continue;
                n5 = 0;
            }
        }
    }

    static void fillMetalPattern2D(Graphics2D graphics2D, int n, int n2, int n3, int n4, Color color, Color color2) {
        if (pattern2D == null || !darkColor.equals(color2) || !lightColor.equals(color)) {
            MetalUtils.initializePattern(color, color2);
        }
        TexturePaint texturePaint = new TexturePaint(pattern2D, new Rectangle2D.Double(0.0, 0.0, 4.0, 4.0));
        graphics2D.setPaint(texturePaint);
        graphics2D.fillRect(n, n2, n3, n4);
    }

    static void initializePattern(Color color, Color color2) {
        pattern2D = new BufferedImage(4, 4, 2);
        lightColor = color;
        darkColor = color2;
        Graphics graphics = pattern2D.getGraphics();
        graphics.setColor(color);
        graphics.fillRect(0, 0, 1, 1);
        graphics.fillRect(2, 2, 1, 1);
        graphics.setColor(color2);
        graphics.fillRect(1, 1, 1, 1);
        graphics.fillRect(3, 3, 1, 1);
        graphics.dispose();
    }

    static void paintGradient(Graphics graphics, int n, int n2, int n3, int n4, int n5, String string) {
        MetalUtils.paintGradient(graphics, n, n2, n3, n4, n5, string, null);
    }

    static void paintGradient(Graphics graphics, int n, int n2, int n3, int n4, int n5, String string, int[][] nArray) {
        List list2 = (List)UIManager.get(string);
        float f = ((Float)list2.get(0)).floatValue();
        float f2 = ((Float)list2.get(1)).floatValue();
        Color color = (Color)list2.get(2);
        Color color2 = (Color)list2.get(3);
        Color color3 = (Color)list2.get(4);
        MetalUtils.paintGradient(graphics, n, n2, n3, n4, f, f2, color, color2, color3, n5, nArray);
    }

    static void paintGradient(Graphics graphics, int n, int n2, int n3, int n4, float f, float f2, Color color, Color color2, Color color3, int n5, int[][] nArray) {
        if (n5 == 0) {
            MetalUtils.paintHorizontalGradient(graphics, n, n2, n3, n4, f, f2, color, color2, color3, nArray);
        } else {
            MetalUtils.paintVerticalGradient(graphics, n, n2, n3, n4, f, f2, color, color2, color3, nArray);
        }
    }

    static void paintHorizontalGradient(Graphics graphics, int n, int n2, int n3, int n4, float f, float f2, Color color, Color color2, Color color3, int[][] nArray) {
        Color color4;
        int n5;
        int n6;
        int n7;
        double d;
        int n8;
        if (graphics instanceof Graphics2D && SystemProperties.getProperty("gnu.javax.swing.noGraphics2D") == null) {
            MetalUtils.paintHorizontalGradient2D((Graphics2D)graphics, n, n2, n3, n4, f, f2, color, color2, color3, nArray);
            return;
        }
        int n9 = n2;
        int n10 = n2 + n4;
        int n11 = (int)((float)n3 * f);
        int n12 = (int)((float)n3 * f2);
        int n13 = n;
        int n14 = n13 + n11;
        int n15 = n14 + n12;
        int n16 = n15 + n11;
        int n17 = n + n3;
        for (n8 = n13; n8 < n14 && n8 <= n + n3; ++n8) {
            d = (double)(n8 - n13) / (double)n11;
            n7 = (int)((double)(color2.getRed() - color.getRed()) * d + (double)color.getRed());
            n6 = (int)((double)(color2.getGreen() - color.getGreen()) * d + (double)color.getGreen());
            n5 = (int)((double)(color2.getBlue() - color.getBlue()) * d + (double)color.getBlue());
            color4 = new Color(n7, n6, n5);
            graphics.setColor(color4);
            if (nArray != null) {
                n9 = nArray[n8 - n13][0] + n2;
                n10 = nArray[n8 - n13][1] + n2;
            }
            graphics.fillRect(n8, n9, 1, n10 - n9);
        }
        graphics.setColor(color2);
        if (nArray == null) {
            graphics.fillRect(n14, n2, n15 - n14, n4);
        } else {
            for (n8 = n14; n8 < n15; ++n8) {
                n9 = nArray[n8 - n13][0] + n2;
                n10 = nArray[n8 - n13][1] + n2;
                graphics.fillRect(n8, n9, 1, n10 - n9);
            }
        }
        for (n8 = n15; n8 < n16 && n8 <= n + n3; ++n8) {
            d = (double)(n8 - n15) / (double)n11;
            n7 = (int)((double)(color.getRed() - color2.getRed()) * d + (double)color2.getRed());
            n6 = (int)((double)(color.getGreen() - color2.getGreen()) * d + (double)color2.getGreen());
            n5 = (int)((double)(color.getBlue() - color2.getBlue()) * d + (double)color2.getBlue());
            color4 = new Color(n7, n6, n5);
            graphics.setColor(color4);
            if (nArray != null) {
                n9 = nArray[n8 - n13][0] + n2;
                n10 = nArray[n8 - n13][1] + n2;
            }
            graphics.fillRect(n8, n9, 1, n10 - n9);
        }
        for (n8 = n16; n8 < n17 && n8 <= n + n3; ++n8) {
            d = (double)(n8 - n16) / (double)(n17 - n16);
            n7 = (int)((double)(color3.getRed() - color.getRed()) * d + (double)color.getRed());
            n6 = (int)((double)(color3.getGreen() - color.getGreen()) * d + (double)color.getGreen());
            n5 = (int)((double)(color3.getBlue() - color.getBlue()) * d + (double)color.getBlue());
            color4 = new Color(n7, n6, n5);
            graphics.setColor(color4);
            if (nArray != null) {
                n9 = nArray[n8 - n13][0] + n2;
                n10 = nArray[n8 - n13][1] + n2;
            }
            graphics.drawLine(n8, n9, n8, n10);
        }
    }

    static void paintVerticalGradient(Graphics graphics, int n, int n2, int n3, int n4, float f, float f2, Color color, Color color2, Color color3, int[][] nArray) {
        Color color4;
        int n5;
        int n6;
        int n7;
        double d;
        int n8;
        if (graphics instanceof Graphics2D && SystemProperties.getProperty("gnu.javax.swing.noGraphics2D") == null) {
            MetalUtils.paintVerticalGradient2D((Graphics2D)graphics, n, n2, n3, n4, f, f2, color, color2, color3, nArray);
            return;
        }
        int n9 = n;
        int n10 = n + n3;
        int n11 = (int)((float)n4 * f);
        int n12 = (int)((float)n4 * f2);
        int n13 = n2;
        int n14 = n13 + n11;
        int n15 = n14 + n12;
        int n16 = n15 + n11;
        int n17 = n2 + n4;
        for (n8 = n13; n8 < n14 && n8 <= n2 + n4; ++n8) {
            d = (double)(n8 - n13) / (double)n11;
            n7 = (int)((double)(color2.getRed() - color.getRed()) * d + (double)color.getRed());
            n6 = (int)((double)(color2.getGreen() - color.getGreen()) * d + (double)color.getGreen());
            n5 = (int)((double)(color2.getBlue() - color.getBlue()) * d + (double)color.getBlue());
            color4 = new Color(n7, n6, n5);
            graphics.setColor(color4);
            if (nArray != null) {
                n9 = nArray[n8 - n13][0] + n;
                n10 = nArray[n8 - n13][1] + n;
            }
            graphics.fillRect(n9, n8, n10 - n9, 1);
        }
        graphics.setColor(color2);
        if (nArray == null) {
            graphics.fillRect(n, n14, n3, n15 - n14);
        } else {
            for (n8 = n14; n8 < n15; ++n8) {
                n9 = nArray[n8 - n13][0] + n;
                n10 = nArray[n8 - n13][1] + n;
                graphics.fillRect(n9, n8, n10 - n9, 1);
            }
        }
        for (n8 = n15; n8 < n16 && n8 <= n2 + n4; ++n8) {
            d = (double)(n8 - n15) / (double)n11;
            n7 = (int)((double)(color.getRed() - color2.getRed()) * d + (double)color2.getRed());
            n6 = (int)((double)(color.getGreen() - color2.getGreen()) * d + (double)color2.getGreen());
            n5 = (int)((double)(color.getBlue() - color2.getBlue()) * d + (double)color2.getBlue());
            color4 = new Color(n7, n6, n5);
            graphics.setColor(color4);
            if (nArray != null) {
                n9 = nArray[n8 - n13][0] + n;
                n10 = nArray[n8 - n13][1] + n;
            }
            graphics.fillRect(n9, n8, n10 - n9, 1);
        }
        for (n8 = n16; n8 < n17 && n8 <= n2 + n4; ++n8) {
            d = (double)(n8 - n16) / (double)(n17 - n16);
            n7 = (int)((double)(color3.getRed() - color.getRed()) * d + (double)color.getRed());
            n6 = (int)((double)(color3.getGreen() - color.getGreen()) * d + (double)color.getGreen());
            n5 = (int)((double)(color3.getBlue() - color.getBlue()) * d + (double)color.getBlue());
            color4 = new Color(n7, n6, n5);
            graphics.setColor(color4);
            if (nArray != null) {
                n9 = nArray[n8 - n13][0] + n;
                n10 = nArray[n8 - n13][1] + n;
            }
            graphics.fillRect(n9, n8, n10 - n9, 1);
        }
    }

    private static void paintHorizontalGradient2D(Graphics2D graphics2D, int n, int n2, int n3, int n4, float f, float f2, Color color, Color color2, Color color3, int[][] nArray) {
        GradientPaint gradientPaint = new GradientPaint(n, n2, color, (float)n + (float)n3 * f, n2, color2);
        graphics2D.setPaint(gradientPaint);
        graphics2D.fillRect(n, n2, (int)((float)n3 * (f + f2)), n4);
        GradientPaint gradientPaint2 = new GradientPaint((float)n + (float)n3 * (f + f2), n2, color2, n + n3, n2, color3);
        graphics2D.setPaint(gradientPaint2);
        graphics2D.fillRect((int)((float)n + (float)n3 * (f + f2)), n2, (int)((double)n3 * (1.0 - (double)(f + f2))), n4);
    }

    private static void paintVerticalGradient2D(Graphics2D graphics2D, int n, int n2, int n3, int n4, float f, float f2, Color color, Color color2, Color color3, int[][] nArray) {
        GradientPaint gradientPaint = new GradientPaint(n, n2, color, n, (float)n2 + (float)n4 * f, color2);
        graphics2D.setPaint(gradientPaint);
        graphics2D.fillRect(n, n2, n3, (int)((float)n4 * (f + f2)));
        GradientPaint gradientPaint2 = new GradientPaint(n, (float)n2 + (float)n4 * (f + f2), color2, n, n2 + n4, color3);
        graphics2D.setPaint(gradientPaint2);
        graphics2D.fillRect(n, (int)((float)n2 + (float)n4 * (f + f2)), n3, (int)((double)n4 * (1.0 - (double)(f + f2))));
    }

    MetalUtils() {
    }
}

