/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Container;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.ArrayList;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.LayoutQueue;
import javax.swing.text.Position;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public class AsyncBoxView
extends View {
    private int majorAxis;
    private float topInset;
    private float bottomInset;
    private float leftInset;
    private boolean estimatedMajorSpan;
    private float rightInset;
    private ArrayList childStates;
    ChildState changing;
    ChildState minReq;
    ChildState prefReq;
    private boolean majorChanged;
    boolean minorChanged;
    float majorSpan;
    float minorSpan;
    private Runnable flushTask;
    protected ChildLocator locator;

    public AsyncBoxView(Element element, int n) {
        super(element);
        this.majorAxis = n;
        this.childStates = new ArrayList();
        this.flushTask = new FlushTask(this);
        this.locator = new ChildLocator(this);
        this.minorSpan = 32767.0f;
    }

    public int getMajorAxis() {
        return this.majorAxis;
    }

    public int getMinorAxis() {
        if (this.majorAxis == 0) {
            return 1;
        }
        return 0;
    }

    public View getView(int n) {
        ChildState childState;
        Object object = null;
        ArrayList arrayList = this.childStates;
        synchronized (arrayList) {
            block3: {
                try {
                    if (n < 0 || n >= this.childStates.size()) break block3;
                    childState = (ChildState)this.childStates.get(n);
                    object = childState.getChildView();
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    throw throwable;
                }
            }
            childState = null;
        }
        childState = object;
        return childState;
    }

    public int getViewCount() {
        ArrayList arrayList = this.childStates;
        synchronized (arrayList) {
            try {
                int n = this.childStates.size();
                Object var3_3 = null;
                return n;
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                throw throwable;
            }
        }
    }

    public int getViewIndex(int n, Position.Bias bias) {
        int n2;
        int n3 = -1;
        if (bias == Position.Bias.Backward) {
            n = Math.max(0, n - 1);
        }
        if ((n2 = this.childStates.size()) > 0) {
            for (int i = 0; i < n2; ++i) {
                View view = ((ChildState)this.childStates.get(i)).getChildView();
                if (view.getStartOffset() > n || view.getEndOffset() <= n) continue;
                n3 = i;
                break;
            }
        }
        return n3;
    }

    public float getTopInset() {
        return this.topInset;
    }

    public void setTopInset(float f) {
        this.topInset = f;
    }

    public float getBottomInset() {
        return this.bottomInset;
    }

    public void setBottomInset(float f) {
        this.bottomInset = f;
    }

    public float getLeftInset() {
        return this.leftInset;
    }

    public void setLeftInset(float f) {
        this.leftInset = f;
    }

    public float getRightInset() {
        return this.rightInset;
    }

    public void setRightInset(float f) {
        this.rightInset = f;
    }

    protected void loadChildren(ViewFactory viewFactory) {
        Element element = this.getElement();
        int n = element.getElementCount();
        if (n > 0) {
            View[] viewArray = new View[n];
            for (int i = 0; i < n; ++i) {
                viewArray[i] = viewFactory.create(element.getElement(i));
            }
            this.replace(0, 0, viewArray);
        }
    }

    protected float getInsetSpan(int n) {
        float f = n == 0 ? this.leftInset + this.rightInset : this.topInset + this.bottomInset;
        return f;
    }

    protected void setEstimatedMajorSpan(boolean bl) {
        this.estimatedMajorSpan = bl;
    }

    protected boolean getEstimatedMajorSpan() {
        return this.estimatedMajorSpan;
    }

    protected synchronized void minorRequirementChange(ChildState childState) {
        this.minorChanged = true;
    }

    protected void majorRequirementChange(ChildState childState, float f) {
        if (!this.estimatedMajorSpan) {
            this.majorSpan += f;
        }
        this.majorChanged = true;
    }

    public void setParent(View view) {
        super.setParent(view);
        if (view != null && this.getViewCount() == 0) {
            ViewFactory viewFactory = this.getViewFactory();
            this.loadChildren(viewFactory);
        }
    }

    public void setSize(float f, float f2) {
        float f3 = this.majorAxis == 0 ? f2 - this.getTopInset() - this.getBottomInset() : f - this.getLeftInset() - this.getRightInset();
        if (f3 != this.minorSpan) {
            this.minorSpan = f3;
            int n = this.getViewCount();
            LayoutQueue layoutQueue = this.getLayoutQueue();
            for (int i = 0; i < n; ++i) {
                ChildState childState = this.getChildState(i);
                childState.childSizeValid = false;
                layoutQueue.addTask(childState);
            }
            layoutQueue.addTask(this.flushTask);
        }
    }

    public void replace(int n, int n2, View[] viewArray) {
        ArrayList arrayList = this.childStates;
        synchronized (arrayList) {
            LayoutQueue layoutQueue;
            block6: {
                try {
                    int n3;
                    layoutQueue = this.getLayoutQueue();
                    for (n3 = 0; n3 < n2; ++n3) {
                        this.childStates.remove(n);
                    }
                    for (n3 = viewArray.length - 1; n3 >= 0; --n3) {
                        this.childStates.add(n, this.createChildState(viewArray[n3]));
                    }
                    if (viewArray.length == 0) break block6;
                    for (n3 = 0; n3 < viewArray.length; ++n3) {
                        ChildState childState = (ChildState)this.childStates.get(n3 + n);
                        childState.getChildView().setParent(this);
                        layoutQueue.addTask(childState);
                    }
                    layoutQueue.addTask(this.flushTask);
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    throw throwable;
                }
            }
            layoutQueue = null;
        }
    }

    public void paint(Graphics graphics, Shape shape) {
        ChildLocator childLocator = this.locator;
        synchronized (childLocator) {
            try {
                this.locator.setAllocation(shape);
                this.locator.paintChildren(graphics);
            }
            finally {
                Object var4_4 = null;
            }
            return;
        }
    }

    public float getPreferredSpan(int n) {
        float f;
        if (this.majorAxis == n) {
            f = this.majorSpan;
        } else if (this.prefReq != null) {
            View view = this.prefReq.getChildView();
            f = view.getPreferredSpan(n);
        } else {
            f = n == 0 ? this.getLeftInset() + this.getRightInset() + 30.0f : this.getTopInset() + this.getBottomInset() + 30.0f;
        }
        return f;
    }

    public Shape modelToView(int n, Shape shape, Position.Bias bias) throws BadLocationException {
        ChildState childState;
        int n2 = this.getViewIndexAtPosition(n, bias);
        Shape shape2 = this.locator.getChildAllocation(n2, shape);
        ChildState childState2 = childState = this.getChildState(n2);
        synchronized (childState2) {
            try {
                Shape shape3;
                View view = childState.getChildView();
                Shape shape4 = shape3 = view.modelToView(n, shape2, bias);
                Object var11_11 = null;
                return shape4;
            }
            catch (Throwable throwable) {
                Object var11_12 = null;
                throw throwable;
            }
        }
    }

    public int viewToModel(float f, float f2, Shape shape, Position.Bias[] biasArray) {
        ChildLocator childLocator = this.locator;
        synchronized (childLocator) {
            ChildState childState;
            Shape shape2;
            int n;
            try {
                n = this.locator.getViewIndexAtPoint(f, f2, shape);
                shape2 = this.locator.getChildAllocation(n, shape);
            }
            finally {
                childState = null;
            }
            ChildState childState2 = childState = this.getChildState(n);
            synchronized (childState2) {
                int n2;
                View view;
                try {
                    view = childState.getChildView();
                    n2 = view.viewToModel(f, f2, shape2, biasArray);
                }
                finally {
                    view = null;
                }
                int n3 = n2;
                return n3;
            }
        }
    }

    public Shape getChildAllocation(int n, Shape shape) {
        Shape shape2 = this.locator.getChildAllocation(n, shape);
        return shape2;
    }

    public float getMaximumSpan(int n) {
        float f = n == this.majorAxis ? this.getPreferredSpan(n) : 32767.0f;
        return f;
    }

    public float getMinimumSpan(int n) {
        float f;
        if (n == this.majorAxis) {
            f = this.getPreferredSpan(n);
        } else if (this.minReq != null) {
            View view = this.minReq.getChildView();
            f = view.getMinimumSpan(n);
        } else {
            f = n == 0 ? this.getLeftInset() + this.getRightInset() + 5.0f : this.getTopInset() + this.getBottomInset() + 5.0f;
        }
        return f;
    }

    public synchronized void preferenceChanged(View view, boolean bl, boolean bl2) {
        if (view == null) {
            this.getParent().preferenceChanged(this, bl, bl2);
        } else {
            View view2;
            if (this.changing != null && (view2 = this.changing.getChildView()) == view) {
                this.changing.preferenceChanged(bl, bl2);
                return;
            }
            int n = this.getViewIndexAtPosition(view.getStartOffset(), Position.Bias.Forward);
            ChildState childState = this.getChildState(n);
            childState.preferenceChanged(bl, bl2);
            LayoutQueue layoutQueue = this.getLayoutQueue();
            layoutQueue.addTask(childState);
            layoutQueue.addTask(this.flushTask);
        }
    }

    protected void updateLayout(DocumentEvent.ElementChange elementChange, DocumentEvent documentEvent, Shape shape) {
        if (elementChange != null) {
            int n = Math.max(elementChange.getIndex() - 1, 0);
            ChildState childState = this.getChildState(n);
            this.locator.childChanged(childState);
        }
    }

    protected ChildState getChildState(int n) {
        ArrayList arrayList = this.childStates;
        synchronized (arrayList) {
            try {
                ChildState childState = (ChildState)this.childStates.get(n);
                Object var4_4 = null;
                return childState;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                throw throwable;
            }
        }
    }

    protected LayoutQueue getLayoutQueue() {
        return LayoutQueue.getDefaultQueue();
    }

    protected synchronized int getViewIndexAtPosition(int n, Position.Bias bias) {
        if (bias == Position.Bias.Backward) {
            n = Math.max(0, n - 1);
        }
        Element element = this.getElement();
        return element.getElementIndex(n);
    }

    protected ChildState createChildState(View view) {
        return new ChildState(this, view);
    }

    protected synchronized void flushRequirementChanges() {
        View view;
        if ((this.majorChanged || this.minorChanged) && (view = this.getParent()) != null) {
            boolean bl;
            boolean bl2;
            if (this.majorAxis == 0) {
                bl2 = this.majorChanged;
                bl = this.minorChanged;
            } else {
                bl = this.majorChanged;
                bl2 = this.minorChanged;
            }
            view.preferenceChanged(this, bl2, bl);
            this.majorChanged = false;
            this.minorChanged = false;
            Container container = this.getContainer();
            if (container != null) {
                container.repaint();
            }
        }
    }

    private class FlushTask
    implements Runnable {
        private /* synthetic */ AsyncBoxView this$0;

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void run() {
            ChildState childState;
            try {
                Document document = this.this$0.getDocument();
                if (document instanceof AbstractDocument) {
                    AbstractDocument abstractDocument = (AbstractDocument)document;
                    abstractDocument.readLock();
                }
                int n = this.this$0.getViewCount();
                if (this.this$0.minorChanged && n > 0) {
                    LayoutQueue layoutQueue = this.this$0.getLayoutQueue();
                    ChildState childState2 = this.this$0.getChildState(0);
                    ChildState childState3 = this.this$0.getChildState(0);
                    for (int i = 1; i < n; ++i) {
                        childState = this.this$0.getChildState(i);
                        if (childState.minimum > childState2.minimum) {
                            childState2 = childState;
                        }
                        if (!(childState.preferred > childState3.preferred)) continue;
                        childState3 = childState;
                    }
                    AsyncBoxView asyncBoxView = this.this$0;
                    // MONITORENTER : asyncBoxView
                    try {
                        this.this$0.minReq = childState2;
                        this.this$0.prefReq = childState3;
                    }
                    catch (Throwable throwable) {
                        childState = null;
                        // MONITOREXIT : asyncBoxView
                        throw throwable;
                    }
                    childState = null;
                    // MONITOREXIT : asyncBoxView
                }
                this.this$0.flushRequirementChanges();
                return;
            }
            finally {
                childState = null;
                Document document = this.this$0.getDocument();
                if (document instanceof AbstractDocument) {
                    AbstractDocument abstractDocument = (AbstractDocument)document;
                    abstractDocument.readUnlock();
                }
            }
        }

        FlushTask(AsyncBoxView asyncBoxView) {
            this.this$0 = asyncBoxView;
        }
    }

    public class ChildState
    implements Runnable {
        private /* synthetic */ AsyncBoxView this$0;
        private View childView;
        private boolean minorValid;
        private boolean majorValid;
        boolean childSizeValid;
        float minimum;
        float preferred;
        private float majorSpan;
        private float majorOffset;
        private float minorSpan;
        private float minorOffset;
        private float maximum;

        public ChildState(AsyncBoxView asyncBoxView, View view) {
            this.this$0 = asyncBoxView;
            this.childView = view;
        }

        public View getChildView() {
            return this.childView;
        }

        public boolean isLayoutValid() {
            return this.minorValid && this.majorValid && this.childSizeValid;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void run() {
            Object var4_6;
            Document document;
            block9: {
                Object object;
                document = this.this$0.getDocument();
                if (document instanceof AbstractDocument) {
                    object = (AbstractDocument)document;
                    ((AbstractDocument)object).readLock();
                }
                try {
                    if (this.minorValid && this.majorValid && this.childSizeValid || this.childView.getParent() != this.this$0) break block9;
                    object = this.this$0;
                    // MONITORENTER : object
                    try {
                        this.this$0.changing = this;
                    }
                    catch (Throwable throwable) {
                        Object var3_4 = null;
                        // MONITOREXIT : object
                        throw throwable;
                    }
                    AsyncBoxView asyncBoxView = null;
                    // MONITOREXIT : object
                    this.update();
                    asyncBoxView = this.this$0;
                    // MONITORENTER : asyncBoxView
                    try {}
                    catch (Throwable throwable) {
                        Object var4_7 = null;
                        // MONITOREXIT : asyncBoxView
                        throw throwable;
                    }
                    {
                        this.this$0.changing = null;
                    }
                    var4_6 = null;
                    // MONITOREXIT : asyncBoxView
                    this.update();
                }
                catch (Throwable throwable) {
                    Object var4_8 = null;
                    if (!(document instanceof AbstractDocument)) throw throwable;
                    AbstractDocument abstractDocument = (AbstractDocument)document;
                    abstractDocument.readUnlock();
                    throw throwable;
                }
            }
            var4_6 = null;
            if (!(document instanceof AbstractDocument)) return;
            AbstractDocument abstractDocument = (AbstractDocument)document;
            abstractDocument.readUnlock();
        }

        private void update() {
            ChildState childState;
            int n = this.this$0.getMajorAxis();
            boolean bl = false;
            ChildState childState2 = this;
            synchronized (childState2) {
                block13: {
                    try {
                        if (this.minorValid) break block13;
                        int n2 = this.this$0.getMinorAxis();
                        this.minimum = this.childView.getMinimumSpan(n2);
                        this.preferred = this.childView.getPreferredSpan(n2);
                        this.maximum = this.childView.getMaximumSpan(n2);
                        this.minorValid = true;
                        bl = true;
                    }
                    catch (Throwable throwable) {
                        Object var4_6 = null;
                        throw throwable;
                    }
                }
                Object var4_5 = null;
            }
            if (bl) {
                this.this$0.minorRequirementChange(this);
            }
            boolean bl2 = false;
            float f = 0.0f;
            ChildState childState3 = this;
            synchronized (childState3) {
                block14: {
                    try {
                        if (this.majorValid) break block14;
                        float f2 = this.majorSpan;
                        this.majorSpan = this.childView.getPreferredSpan(n);
                        f = this.majorSpan - f2;
                        this.majorValid = true;
                        bl2 = true;
                    }
                    catch (Throwable throwable) {
                        Object var7_13 = null;
                        throw throwable;
                    }
                }
                childState = null;
            }
            if (bl2) {
                this.this$0.majorRequirementChange(this, f);
                this.this$0.locator.childChanged(this);
            }
            childState = this;
            synchronized (childState) {
                block15: {
                    try {
                        float f3;
                        float f4;
                        if (this.childSizeValid) break block15;
                        if (n == 0) {
                            f4 = this.majorSpan;
                            f3 = this.getMinorSpan();
                        } else {
                            f4 = this.getMinorSpan();
                            f3 = this.majorSpan;
                        }
                        this.childSizeValid = true;
                        this.childView.setSize(f4, f3);
                    }
                    catch (Throwable throwable) {
                        Object var8_17 = null;
                        throw throwable;
                    }
                }
                Object var8_16 = null;
            }
        }

        public float getMinorSpan() {
            float f = this.maximum < this.minorSpan ? this.maximum : Math.max(this.minimum, this.minorSpan);
            return f;
        }

        public float getMinorOffset() {
            float f;
            if (this.maximum < this.minorSpan) {
                float f2 = this.childView.getAlignment(this.this$0.getMinorAxis());
                f = (this.minorSpan - this.maximum) * f2;
            } else {
                f = 0.0f;
            }
            return f;
        }

        public float getMajorSpan() {
            return this.majorSpan;
        }

        public float getMajorOffset() {
            return this.majorOffset;
        }

        public void setMajorOffset(float f) {
            this.majorOffset = f;
        }

        public void preferenceChanged(boolean bl, boolean bl2) {
            if (this.this$0.getMajorAxis() == 0) {
                if (bl) {
                    this.majorValid = false;
                }
                if (bl2) {
                    this.minorValid = false;
                }
            } else {
                if (bl) {
                    this.minorValid = false;
                }
                if (bl2) {
                    this.majorValid = false;
                }
            }
            this.childSizeValid = false;
        }
    }

    public class ChildLocator {
        private /* synthetic */ AsyncBoxView this$0;
        protected ChildState lastValidOffset;
        protected Rectangle lastAlloc = new Rectangle();
        protected Rectangle childAlloc = new Rectangle();

        public ChildLocator(AsyncBoxView asyncBoxView) {
            this.this$0 = asyncBoxView;
        }

        public synchronized void childChanged(ChildState childState) {
            if (this.lastValidOffset == null || childState.getChildView().getStartOffset() < this.lastValidOffset.getChildView().getStartOffset()) {
                this.lastValidOffset = childState;
            }
        }

        public int getViewIndexAtPoint(float f, float f2, Shape shape) {
            this.setAllocation(shape);
            float f3 = this.this$0.getMajorAxis() == 0 ? f - (float)this.lastAlloc.x : f2 - (float)this.lastAlloc.y;
            int n = this.getViewIndexAtVisualOffset(f3);
            return n;
        }

        public synchronized Shape getChildAllocation(int n, Shape shape) {
            if (shape == null) {
                return null;
            }
            this.setAllocation(shape);
            ChildState childState = this.this$0.getChildState(n);
            if (childState.getChildView().getStartOffset() > this.lastValidOffset.getChildView().getStartOffset()) {
                this.updateChildOffsetsToIndex(n);
            }
            Shape shape2 = this.getChildAllocation(n);
            return shape2;
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public synchronized void paintChildren(Graphics graphics) {
            View view;
            Rectangle rectangle = graphics.getClipBounds();
            float f = this.this$0.getMajorAxis() == 0 ? (float)(rectangle.x - this.lastAlloc.x) : (float)(rectangle.y - this.lastAlloc.y);
            int n = this.getViewIndexAtVisualOffset(f);
            int n2 = this.this$0.getViewCount();
            float f2 = this.this$0.getChildState(n).getMajorOffset();
            int n3 = n;
            while (n3 < n2) {
                ChildState childState = this.this$0.getChildState(n3);
                childState.setMajorOffset(f2);
                Shape shape = this.getChildAllocation(n3);
                if (!shape.intersects(rectangle)) return;
                ChildState childState2 = childState;
                // MONITORENTER : childState2
                view = childState.getChildView();
                view.paint(graphics, shape);
                view = null;
                // MONITOREXIT : childState2
                f2 += childState.getMajorSpan();
                ++n3;
            }
            return;
            catch (Throwable throwable) {
                view = null;
                // MONITOREXIT : childState2
                throw throwable;
            }
        }

        protected Shape getChildAllocation(int n) {
            ChildState childState = this.this$0.getChildState(n);
            if (!childState.isLayoutValid()) {
                childState.run();
            }
            if (this.this$0.getMajorAxis() == 0) {
                this.childAlloc.x = this.lastAlloc.x + (int)childState.getMajorOffset();
                this.childAlloc.y = this.lastAlloc.y + (int)childState.getMinorOffset();
                this.childAlloc.width = (int)childState.getMajorSpan();
                this.childAlloc.height = (int)childState.getMinorSpan();
            } else {
                this.childAlloc.y = this.lastAlloc.y + (int)childState.getMajorOffset();
                this.childAlloc.x = this.lastAlloc.x + (int)childState.getMinorOffset();
                this.childAlloc.height = (int)childState.getMajorSpan();
                this.childAlloc.width = (int)childState.getMinorSpan();
            }
            return this.childAlloc;
        }

        protected void setAllocation(Shape shape) {
            if (shape instanceof Rectangle) {
                this.lastAlloc.setBounds((Rectangle)shape);
            } else {
                this.lastAlloc.setBounds(shape.getBounds());
            }
            this.this$0.setSize(this.lastAlloc.width, this.lastAlloc.height);
        }

        protected int getViewIndexAtVisualOffset(float f) {
            int n = this.this$0.getViewCount();
            if (n > 0) {
                if (this.lastValidOffset == null) {
                    this.lastValidOffset = this.this$0.getChildState(0);
                }
                if (f > this.this$0.majorSpan) {
                    return 0;
                }
                if (f > this.lastValidOffset.getMajorOffset()) {
                    return this.updateChildOffsets(f);
                }
                float f2 = 0.0f;
                for (int i = 0; i < n; ++i) {
                    ChildState childState = this.this$0.getChildState(i);
                    float f3 = f2 + childState.getMajorSpan();
                    if (f < f3) {
                        return i;
                    }
                    f2 = f3;
                }
            }
            return n - 1;
        }

        private int updateChildOffsets(float f) {
            float f2;
            int n = this.this$0.getViewCount();
            int n2 = n - 1;
            int n3 = this.lastValidOffset.getChildView().getStartOffset();
            int n4 = this.this$0.getViewIndexAtPosition(n3, Position.Bias.Forward);
            float f3 = f2 = this.lastValidOffset.getMajorOffset();
            for (int i = n4; i < n; ++i) {
                ChildState childState = this.this$0.getChildState(i);
                childState.setMajorOffset(f3);
                f3 += childState.getMajorSpan();
                if (!(f < f3)) continue;
                n2 = i;
                this.lastValidOffset = childState;
                break;
            }
            return n2;
        }

        private void updateChildOffsetsToIndex(int n) {
            int n2 = this.lastValidOffset.getChildView().getStartOffset();
            int n3 = this.this$0.getViewIndexAtPosition(n2, Position.Bias.Forward);
            float f = this.lastValidOffset.getMajorOffset();
            for (int i = n3; i <= n; ++i) {
                ChildState childState = this.this$0.getChildState(i);
                childState.setMajorOffset(f);
                f += childState.getMajorSpan();
            }
        }
    }
}

