/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Color;
import java.awt.Container;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.BoxView;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public class WrappedPlainView
extends BoxView
implements TabExpander {
    Color selectedColor;
    Color unselectedColor;
    Color disabledColor;
    FontMetrics metrics;
    boolean wordWrap;
    ViewFactory viewFactory;
    int selectionStart;
    int selectionEnd;
    int lineHeight;
    private transient Segment lineBuffer;

    private /* synthetic */ void finit$() {
        this.viewFactory = new WrappedLineCreator(this);
    }

    public WrappedPlainView(Element element) {
        this(element, false);
    }

    public WrappedPlainView(Element element, boolean bl) {
        super(element, 1);
        this.finit$();
        this.wordWrap = bl;
    }

    protected final Segment getLineBuffer() {
        if (this.lineBuffer == null) {
            this.lineBuffer = new Segment();
        }
        return this.lineBuffer;
    }

    public float nextTabStop(float f, int n) {
        JTextComponent jTextComponent = (JTextComponent)this.getContainer();
        float f2 = this.getTabSize() * jTextComponent.getFontMetrics(jTextComponent.getFont()).charWidth('m');
        return (float)(Math.floor(f / f2) + 1.0) * f2;
    }

    protected int getTabSize() {
        Object object = this.getDocument().getProperty("tabSize");
        if (object == null) {
            return 8;
        }
        return (Integer)object;
    }

    protected void drawLine(int n, int n2, Graphics graphics, int n3, int n4) {
        try {
            if (this.selectionStart == this.selectionEnd || n > this.selectionEnd || n2 < this.selectionStart) {
                this.drawUnselectedText(graphics, n3, n4, n, n2);
            } else if (n >= this.selectionStart && n2 <= this.selectionEnd) {
                this.drawSelectedText(graphics, n3, n4, n, n2);
            } else if (n >= this.selectionStart) {
                n3 = this.drawSelectedText(graphics, n3, n4, n, this.selectionEnd);
                this.drawUnselectedText(graphics, n3, n4, this.selectionEnd, n2);
            } else if (this.selectionStart > n && this.selectionEnd > n2) {
                n3 = this.drawUnselectedText(graphics, n3, n4, n, this.selectionStart);
                this.drawSelectedText(graphics, n3, n4, this.selectionStart, n2);
            } else if (this.selectionStart > n) {
                n3 = this.drawUnselectedText(graphics, n3, n4, n, this.selectionStart);
                n3 = this.drawSelectedText(graphics, n3, n4, this.selectionStart, this.selectionEnd);
                this.drawUnselectedText(graphics, n3, n4, this.selectionEnd, n2);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    protected int drawSelectedText(Graphics graphics, int n, int n2, int n3, int n4) throws BadLocationException {
        graphics.setColor(this.selectedColor);
        Segment segment = this.getLineBuffer();
        this.getDocument().getText(n3, n4 - n3, segment);
        return Utilities.drawTabbedText(segment, n, n2, graphics, this, n3);
    }

    protected int drawUnselectedText(Graphics graphics, int n, int n2, int n3, int n4) throws BadLocationException {
        JTextComponent jTextComponent = (JTextComponent)this.getContainer();
        if (jTextComponent.isEnabled()) {
            graphics.setColor(this.unselectedColor);
        } else {
            graphics.setColor(this.disabledColor);
        }
        Segment segment = this.getLineBuffer();
        this.getDocument().getText(n3, n4 - n3, segment);
        return Utilities.drawTabbedText(segment, n, n2, graphics, this, n3);
    }

    protected void loadChildren(ViewFactory viewFactory) {
        Element element = this.getElement();
        int n = element.getElementCount();
        if (n == 0) {
            return;
        }
        View[] viewArray = new View[n];
        for (int i = 0; i < n; ++i) {
            viewArray[i] = new WrappedLine(this, element.getElement(i));
        }
        this.replace(0, 0, viewArray);
    }

    protected int calculateBreakPosition(int n, int n2) {
        short s;
        Container container = this.getContainer();
        short s2 = this.getLeftInset();
        Rectangle rectangle = new Rectangle(s2, s = this.getTopInset(), this.getWidth() - this.getRightInset() - s2, this.getHeight() - this.getBottomInset() - s);
        if (rectangle.isEmpty()) {
            return 0;
        }
        this.updateMetrics();
        try {
            this.getDocument().getText(n, n2 - n, this.getLineBuffer());
        }
        catch (BadLocationException badLocationException) {
            throw new InternalError("Invalid offsets p0: " + n + " - p1: " + n2);
        }
        if (this.wordWrap) {
            return Utilities.getBreakLocation(this.lineBuffer, this.metrics, rectangle.x, rectangle.x + rectangle.width, this, n);
        }
        return n + Utilities.getTabbedTextOffset(this.lineBuffer, this.metrics, rectangle.x, rectangle.x + rectangle.width, this, 0, true);
    }

    void updateMetrics() {
        Container container = this.getContainer();
        this.metrics = container.getFontMetrics(container.getFont());
    }

    public float getPreferredSpan(int n) {
        this.updateMetrics();
        return super.getPreferredSpan(n);
    }

    public float getMinimumSpan(int n) {
        this.updateMetrics();
        return super.getMinimumSpan(n);
    }

    public float getMaximumSpan(int n) {
        this.updateMetrics();
        return super.getMaximumSpan(n);
    }

    public void insertUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        super.insertUpdate(documentEvent, shape, this.viewFactory);
    }

    public void removeUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        super.removeUpdate(documentEvent, shape, this.viewFactory);
    }

    public void changedUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        super.changedUpdate(documentEvent, shape, this.viewFactory);
    }

    public void paint(Graphics graphics, Shape shape) {
        JTextComponent jTextComponent = (JTextComponent)this.getContainer();
        this.updateMetrics();
        this.selectionStart = jTextComponent.getSelectionStart();
        this.selectionEnd = jTextComponent.getSelectionEnd();
        this.selectedColor = jTextComponent.getSelectedTextColor();
        this.unselectedColor = jTextComponent.getForeground();
        this.disabledColor = jTextComponent.getDisabledTextColor();
        this.selectedColor = jTextComponent.getSelectedTextColor();
        this.lineHeight = this.metrics.getHeight();
        graphics.setFont(jTextComponent.getFont());
        super.paint(graphics, shape);
    }

    public void setSize(float f, float f2) {
        this.updateMetrics();
        if (f != (float)this.getWidth()) {
            this.preferenceChanged(null, true, true);
        }
        super.setSize(f, f2);
    }

    class WrappedLine
    extends View {
        private /* synthetic */ WrappedPlainView this$0;
        int numLines;

        private /* synthetic */ void finit$() {
            this.numLines = 1;
        }

        public WrappedLine(WrappedPlainView wrappedPlainView, Element element) {
            this.this$0 = wrappedPlainView;
            super(element);
            this.finit$();
            this.determineNumLines();
        }

        public void paint(Graphics graphics, Shape shape) {
            Rectangle rectangle = shape.getBounds();
            int n = this.getEndOffset();
            int n2 = this.getStartOffset();
            int n3 = 0;
            while (n2 < n) {
                int n4 = this.this$0.calculateBreakPosition(n2, n);
                this.this$0.drawLine(n2, n4, graphics, rectangle.x, rectangle.y + this.this$0.metrics.getAscent());
                rectangle.y += this.this$0.lineHeight;
                n2 = n4 == n2 ? ++n2 : n4;
                ++n3;
            }
            if (n3 != this.numLines) {
                this.numLines = n3;
                this.preferenceChanged(this, false, true);
            }
        }

        void determineNumLines() {
            this.numLines = 0;
            int n = this.getEndOffset();
            if (n == 0) {
                return;
            }
            int n2 = this.getStartOffset();
            while (n2 < n) {
                ++this.numLines;
                int n3 = this.this$0.calculateBreakPosition(n2, n);
                if (n3 == 0) {
                    return;
                }
                if (n3 == n2) break;
                n2 = n3;
            }
        }

        public float getPreferredSpan(int n) {
            if (n == 0) {
                return this.this$0.getWidth();
            }
            if (n == 1) {
                if (this.this$0.metrics == null) {
                    this.this$0.updateMetrics();
                }
                return this.numLines * this.this$0.metrics.getHeight();
            }
            throw new IllegalArgumentException("Invalid axis for getPreferredSpan: " + n);
        }

        public Shape modelToView(int n, Shape shape, Position.Bias bias) throws BadLocationException {
            int n2;
            Rectangle rectangle = shape.getBounds();
            if (rectangle.isEmpty()) {
                throw new BadLocationException("Unable to calculate view coordinates when allocation area is empty.", 5);
            }
            Segment segment = this.this$0.getLineBuffer();
            rectangle.height = n2 = this.this$0.metrics.getHeight();
            rectangle.width = 1;
            int n3 = this.getStartOffset();
            int n4 = this.getEndOffset();
            if (n < n3 || n >= n4) {
                throw new BadLocationException("invalid offset", n);
            }
            while (true) {
                int n5 = this.this$0.calculateBreakPosition(n3, n4);
                if (n >= n3 && n < n5) {
                    try {
                        this.getDocument().getText(n3, n - n3, segment);
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                    rectangle.x += Utilities.getTabbedTextWidth(segment, this.this$0.metrics, rectangle.x, this.this$0, n3);
                    return rectangle;
                }
                rectangle.y += n2;
                if (n5 == n3) {
                    n3 = n4;
                    continue;
                }
                n3 = n5;
            }
        }

        public int viewToModel(float f, float f2, Shape shape, Position.Bias[] biasArray) {
            Segment segment = this.this$0.getLineBuffer();
            Rectangle rectangle = shape.getBounds();
            int n = this.getStartOffset();
            int n2 = this.getEndOffset();
            int n3 = this.this$0.metrics.getHeight();
            if (f2 < (float)rectangle.y) {
                return n;
            }
            if (f2 > (float)(rectangle.y + rectangle.height)) {
                return n2;
            }
            while (n != n2) {
                int n4 = this.this$0.calculateBreakPosition(n, n2);
                if (f2 >= (float)rectangle.y && f2 < (float)(rectangle.y + n3)) {
                    try {
                        this.getDocument().getText(n, n4 - n, segment);
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                    int n5 = Utilities.getTabbedTextOffset(segment, this.this$0.metrics, rectangle.x, (int)f, this.this$0, n);
                    if (n5 == n4) {
                        return n5 - 1;
                    }
                    return n5;
                }
                rectangle.y += n3;
                n = n4;
            }
            return n2;
        }

        void updateDamage(Rectangle rectangle) {
            if (rectangle == null || rectangle.isEmpty()) {
                this.numLines = 1;
                return;
            }
            int n = this.numLines;
            this.determineNumLines();
            if (this.numLines != n) {
                this.preferenceChanged(this, false, true);
            } else {
                this.getContainer().repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }

        public void insertUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
            this.updateDamage((Rectangle)shape);
        }

        public void removeUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
            this.updateDamage((Rectangle)shape);
        }
    }

    class WrappedLineCreator
    implements ViewFactory {
        private /* synthetic */ WrappedPlainView this$0;

        public View create(Element element) {
            return new WrappedLine(this.this$0, element);
        }

        WrappedLineCreator(WrappedPlainView wrappedPlainView) {
            this.this$0 = wrappedPlainView;
        }
    }
}

