/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.undo;

import java.util.Hashtable;
import java.util.Iterator;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.StateEditable;

public class StateEdit
extends AbstractUndoableEdit {
    protected static final String RCSID = "$Id: StateEdit.java,v 1.6 1997/10/01 20:05:51 sandipc Exp $";
    protected StateEditable object;
    protected Hashtable preState;
    protected Hashtable postState;
    protected String undoRedoName;

    public StateEdit(StateEditable stateEditable) {
        this.init(stateEditable, null);
    }

    public StateEdit(StateEditable stateEditable, String string) {
        this.init(stateEditable, string);
    }

    protected void init(StateEditable stateEditable, String string) {
        this.object = stateEditable;
        this.undoRedoName = string;
        this.preState = new Hashtable();
        this.postState = new Hashtable();
        stateEditable.storeState(this.preState);
    }

    public void end() {
        this.object.storeState(this.postState);
        this.removeRedundantState();
    }

    public void undo() {
        super.undo();
        this.object.restoreState(this.preState);
    }

    public void redo() {
        super.redo();
        this.object.restoreState(this.postState);
    }

    public String getPresentationName() {
        return this.undoRedoName;
    }

    protected void removeRedundantState() {
        Iterator iterator = this.preState.keySet().iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!this.postState.containsKey(object) || !this.preState.get(object).equals(this.postState.get(object))) continue;
            iterator.remove();
            this.postState.remove(object);
        }
    }
}

