/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.xpath;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactoryConfigurationException;
import javax.xml.xpath.XPathFunctionResolver;
import javax.xml.xpath.XPathVariableResolver;

public abstract class XPathFactory {
    public static final String DEFAULT_PROPERTY_NAME = "javax.xml.xpath.XPathFactory";
    public static final String DEFAULT_OBJECT_MODEL_URI = "http://java.sun.com/jaxp/xpath/dom";

    protected XPathFactory() {
    }

    public static final XPathFactory newInstance() {
        try {
            return XPathFactory.newInstance(DEFAULT_OBJECT_MODEL_URI);
        }
        catch (XPathFactoryConfigurationException xPathFactoryConfigurationException) {
            throw new RuntimeException(xPathFactoryConfigurationException.getMessage());
        }
    }

    public static final XPathFactory newInstance(String string) throws XPathFactoryConfigurationException {
        Object object;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = XPathFactory.class$(DEFAULT_PROPERTY_NAME).getClassLoader();
        }
        String string2 = null;
        int n = 0;
        do {
            if ((string2 = XPathFactory.getFactoryClassName(classLoader, n++)) == null) continue;
            try {
                object = classLoader != null ? classLoader.loadClass(string2) : Class.forName(string2);
                XPathFactory xPathFactory = (XPathFactory)((Class)object).newInstance();
                if (xPathFactory.isObjectModelSupported(string)) {
                    return xPathFactory;
                }
                string2 = null;
            }
            catch (ClassNotFoundException classNotFoundException) {
                string2 = null;
            }
            catch (Exception exception) {
                throw new XPathFactoryConfigurationException(exception);
            }
        } while (string2 == null && n < 4);
        object = "no factories with support for " + string;
        throw new XPathFactoryConfigurationException((String)object);
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static String getFactoryClassName(ClassLoader classLoader, int n) {
        String string = DEFAULT_PROPERTY_NAME;
        switch (n) {
            case 0: {
                return System.getProperty(string);
            }
            case 1: {
                try {
                    File file = new File(System.getProperty("java.home"));
                    file = new File(file, "lib");
                    file = new File(file, "jaxp.properties");
                    FileInputStream fileInputStream = new FileInputStream(file);
                    Properties properties = new Properties();
                    properties.load(fileInputStream);
                    ((InputStream)fileInputStream).close();
                    return properties.getProperty(string);
                }
                catch (IOException iOException) {
                    return null;
                }
            }
            case 2: {
                try {
                    InputStream inputStream;
                    String string2 = "/META-INF/services/" + string;
                    InputStream inputStream2 = inputStream = classLoader != null ? classLoader.getResourceAsStream(string2) : XPathFactory.class$(DEFAULT_PROPERTY_NAME).getResourceAsStream(string2);
                    if (inputStream != null) {
                        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                        String string3 = bufferedReader.readLine();
                        bufferedReader.close();
                        return string3;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return null;
            }
            case 3: {
                return "gnu.xml.xpath.XPathFactoryImpl";
            }
        }
        return null;
    }

    public abstract boolean isObjectModelSupported(String var1);

    public abstract void setFeature(String var1, boolean var2) throws XPathFactoryConfigurationException;

    public abstract boolean getFeature(String var1) throws XPathFactoryConfigurationException;

    public abstract void setXPathVariableResolver(XPathVariableResolver var1);

    public abstract void setXPathFunctionResolver(XPathFunctionResolver var1);

    public abstract XPath newXPath();
}

