/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.jarsigner;

import gnu.classpath.Configuration;
import gnu.classpath.SystemProperties;
import gnu.classpath.tools.jarsigner.Main;
import gnu.classpath.tools.jarsigner.Messages;
import gnu.classpath.tools.jarsigner.SFHelper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class JarSigner {
    private static final Logger log = Logger.getLogger(JarSigner.class$("gnu.classpath.tools.jarsigner.JarSigner").getName());
    private Main main;

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    JarSigner(Main main) {
        this.main = main;
    }

    void start() throws Exception {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        if (Configuration.DEBUG) {
            log.entering(this.getClass().getName(), "start");
        }
        JarFile jarFile = new JarFile(this.main.getJarFileName());
        SFHelper sFHelper = new SFHelper(jarFile);
        sFHelper.startSigning();
        Object object7 = jarFile.entries();
        while (object7.hasMoreElements()) {
            object6 = object7.nextElement();
            object5 = ((ZipEntry)object6).getName();
            if (((String)object5).equals("META-INF/MANIFEST.MF") || ((String)object5).endsWith(File.separator)) continue;
            sFHelper.updateEntry((JarEntry)object6);
            if (!this.main.isVerbose()) continue;
            System.out.println(Messages.getString("JarSigner.1") + (String)object5);
        }
        sFHelper.finishSigning(this.main.isSectionsOnly());
        if (this.main.isVerbose()) {
            System.out.println(Messages.getString("JarSigner.2") + "META-INF/MANIFEST.MF");
        }
        object7 = File.createTempFile("gcp-", ".jar");
        object6 = new FileOutputStream((File)object7);
        object5 = new JarOutputStream((OutputStream)object6, sFHelper.getManifest());
        Object object8 = jarFile.entries();
        while (object8.hasMoreElements()) {
            object4 = object8.nextElement();
            object3 = ((ZipEntry)object4).getName();
            if (((String)object3).equals("META-INF/MANIFEST.MF") || ((String)object3).endsWith(File.separator)) continue;
            log.finest("Processing " + (String)object3);
            object2 = new JarEntry((String)object3);
            ((ZipEntry)object2).setTime(((ZipEntry)object4).getTime());
            ((JarOutputStream)object5).putNextEntry((ZipEntry)object2);
            object = jarFile.getInputStream((ZipEntry)object4);
            this.copyFromTo((InputStream)object, (JarOutputStream)object5);
        }
        object8 = this.main.getSigFileName();
        object4 = "META-INF/" + (String)object8 + ".SF";
        if (Configuration.DEBUG) {
            log.fine("Processing " + (String)object4);
        }
        object3 = new JarEntry((String)object4);
        ((ZipEntry)object3).setTime(System.currentTimeMillis());
        ((JarOutputStream)object5).putNextEntry((ZipEntry)object3);
        sFHelper.writeSF((JarOutputStream)object5);
        if (Configuration.DEBUG) {
            log.fine("Created .SF file");
        }
        if (this.main.isVerbose()) {
            System.out.println(Messages.getString("JarSigner.8") + (String)object4);
        }
        object2 = "META-INF/" + (String)object8 + ".DSA";
        if (Configuration.DEBUG) {
            log.fine("Processing " + (String)object2);
        }
        object = new JarEntry((String)object2);
        ((ZipEntry)object).setTime(System.currentTimeMillis());
        ((JarOutputStream)object5).putNextEntry((ZipEntry)object);
        sFHelper.writeDSA((JarOutputStream)object5, this.main.getSignerPrivateKey(), this.main.getSignerCertificateChain(), this.main.isInternalSF());
        if (Configuration.DEBUG) {
            log.fine("Created .DSA file");
        }
        if (this.main.isVerbose()) {
            System.out.println(Messages.getString("JarSigner.8") + (String)object2);
        }
        ((ZipOutputStream)object5).close();
        ((FileOutputStream)object6).close();
        ((File)object7).renameTo(new File(this.main.getSignedJarFileName()));
        if (Configuration.DEBUG) {
            log.fine("Renamed signed JAR file");
        }
        if (this.main.isVerbose()) {
            System.out.println(SystemProperties.getProperty((String)"line.separator") + Messages.getString("JarSigner.14"));
        }
        if (Configuration.DEBUG) {
            log.exiting(this.getClass().getName(), "start");
        }
    }

    private void copyFromTo(InputStream inputStream, JarOutputStream jarOutputStream) throws IOException {
        int n;
        byte[] byArray = new byte[8192];
        while ((n = inputStream.read(byArray)) != -1) {
            if (n <= 0) continue;
            jarOutputStream.write(byArray, 0, n);
        }
    }
}

