/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.keytool;

import gnu.classpath.Configuration;
import gnu.classpath.tools.getopt.ClasspathToolParser;
import gnu.classpath.tools.getopt.Option;
import gnu.classpath.tools.getopt.OptionException;
import gnu.classpath.tools.getopt.OptionGroup;
import gnu.classpath.tools.getopt.Parser;
import gnu.classpath.tools.keytool.Command;
import gnu.classpath.tools.keytool.Messages;
import java.io.IOException;
import java.security.Key;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.logging.Logger;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextOutputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

class KeyCloneCmd
extends Command {
    private static final Logger log = Logger.getLogger(KeyCloneCmd.class$("gnu.classpath.tools.keytool.KeyCloneCmd").getName());
    protected String _alias;
    protected String _destAlias;
    protected String _password;
    protected String _newPassword;
    protected String _ksType;
    protected String _ksURL;
    protected String _ksPassword;
    protected String _providerClassName;
    private String destinationAlias;
    private char[] newKeyPasswordChars;

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void setAlias(String string) {
        this._alias = string;
    }

    public void setDest(String string) {
        this._destAlias = string;
    }

    public void setKeypass(String string) {
        this._password = string;
    }

    public void setNew(String string) {
        this._newPassword = string;
    }

    public void setStoretype(String string) {
        this._ksType = string;
    }

    public void setKeystore(String string) {
        this._ksURL = string;
    }

    public void setStorepass(String string) {
        this._ksPassword = string;
    }

    public void setProvider(String string) {
        this._providerClassName = string;
    }

    void setup() throws Exception {
        this.setKeyStoreParams(this._providerClassName, this._ksType, this._ksPassword, this._ksURL);
        this.setAliasParam(this._alias);
        this.setKeyPasswordNoPrompt(this._password);
        this.setDestinationAlias(this._destAlias);
        if (Configuration.DEBUG) {
            log.fine("-keyclone handler will use the following options:");
            log.fine("  -alias=" + this.alias);
            log.fine("  -dest=" + this.destinationAlias);
            log.fine("  -storetype=" + this.storeType);
            log.fine("  -keystore=" + this.storeURL);
            log.fine("  -provider=" + this.provider);
            log.fine("  -v=" + this.verbose);
        }
    }

    void start() throws KeyStoreException, NoSuchAlgorithmException, IOException, UnsupportedCallbackException, UnrecoverableKeyException, CertificateException {
        if (Configuration.DEBUG) {
            log.entering(this.getClass().getName(), "start");
        }
        if (this.store.containsAlias(this.destinationAlias)) {
            throw new SecurityException(Messages.getString("KeyCloneCmd.23"));
        }
        Key key = this.getAliasPrivateKey();
        this.setNewKeyPassword(this._newPassword);
        Certificate[] certificateArray = this.store.getCertificateChain(this.alias);
        this.store.setKeyEntry(this.destinationAlias, key, this.newKeyPasswordChars, certificateArray);
        this.saveKeyStore();
        if (Configuration.DEBUG) {
            log.exiting(this.getClass().getName(), "start");
        }
    }

    Parser getParser() {
        if (Configuration.DEBUG) {
            log.entering(this.getClass().getName(), "getParser");
        }
        ClasspathToolParser classpathToolParser = new ClasspathToolParser("keyclone", true);
        classpathToolParser.setHeader(Messages.getString("KeyCloneCmd.22"));
        classpathToolParser.setFooter(Messages.getString("KeyCloneCmd.21"));
        OptionGroup optionGroup = new OptionGroup(Messages.getString("KeyCloneCmd.20"));
        optionGroup.add(new Option(this, "alias", Messages.getString("KeyCloneCmd.19"), Messages.getString("KeyCloneCmd.16")){
            private /* synthetic */ KeyCloneCmd this$0;
            {
                this.this$0 = keyCloneCmd;
                super(string, string2, string3);
            }

            public void parsed(String string) throws OptionException {
                this.this$0._alias = string;
            }
        });
        optionGroup.add(new Option(this, "dest", Messages.getString("KeyCloneCmd.17"), Messages.getString("KeyCloneCmd.16")){
            private /* synthetic */ KeyCloneCmd this$0;
            {
                this.this$0 = keyCloneCmd;
                super(string, string2, string3);
            }

            public void parsed(String string) throws OptionException {
                this.this$0._destAlias = string;
            }
        });
        optionGroup.add(new Option(this, "keypass", Messages.getString("KeyCloneCmd.15"), Messages.getString("KeyCloneCmd.6")){
            private /* synthetic */ KeyCloneCmd this$0;
            {
                this.this$0 = keyCloneCmd;
                super(string, string2, string3);
            }

            public void parsed(String string) throws OptionException {
                this.this$0._password = string;
            }
        });
        optionGroup.add(new Option(this, "new", Messages.getString("KeyCloneCmd.13"), Messages.getString("KeyCloneCmd.6")){
            private /* synthetic */ KeyCloneCmd this$0;
            {
                this.this$0 = keyCloneCmd;
                super(string, string2, string3);
            }

            public void parsed(String string) throws OptionException {
                this.this$0._newPassword = string;
            }
        });
        optionGroup.add(new Option(this, "storetype", Messages.getString("KeyCloneCmd.11"), Messages.getString("KeyCloneCmd.10")){
            private /* synthetic */ KeyCloneCmd this$0;
            {
                this.this$0 = keyCloneCmd;
                super(string, string2, string3);
            }

            public void parsed(String string) throws OptionException {
                this.this$0._ksType = string;
            }
        });
        optionGroup.add(new Option(this, "keystore", Messages.getString("KeyCloneCmd.9"), Messages.getString("KeyCloneCmd.8")){
            private /* synthetic */ KeyCloneCmd this$0;
            {
                this.this$0 = keyCloneCmd;
                super(string, string2, string3);
            }

            public void parsed(String string) throws OptionException {
                this.this$0._ksURL = string;
            }
        });
        optionGroup.add(new Option(this, "storepass", Messages.getString("KeyCloneCmd.7"), Messages.getString("KeyCloneCmd.6")){
            private /* synthetic */ KeyCloneCmd this$0;
            {
                this.this$0 = keyCloneCmd;
                super(string, string2, string3);
            }

            public void parsed(String string) throws OptionException {
                this.this$0._ksPassword = string;
            }
        });
        optionGroup.add(new Option(this, "provider", Messages.getString("KeyCloneCmd.5"), Messages.getString("KeyCloneCmd.4")){
            private /* synthetic */ KeyCloneCmd this$0;
            {
                this.this$0 = keyCloneCmd;
                super(string, string2, string3);
            }

            public void parsed(String string) throws OptionException {
                this.this$0._providerClassName = string;
            }
        });
        optionGroup.add(new Option(this, "v", Messages.getString("KeyCloneCmd.3")){
            private /* synthetic */ KeyCloneCmd this$0;
            {
                this.this$0 = keyCloneCmd;
                super(string, string2);
            }

            public void parsed(String string) throws OptionException {
                this.this$0.verbose = true;
            }
        });
        classpathToolParser.add(optionGroup);
        if (Configuration.DEBUG) {
            log.exiting(this.getClass().getName(), "getParser", classpathToolParser);
        }
        return classpathToolParser;
    }

    private void setDestinationAlias(String string) throws IOException, UnsupportedCallbackException {
        if (string == null || string.trim().length() == 0) {
            NameCallback nameCallback = new NameCallback(Messages.getString("KeyCloneCmd.26"));
            this.getCallbackHandler().handle(new Callback[]{nameCallback});
            string = nameCallback.getName();
            if (string == null || string.trim().length() == 0) {
                throw new IllegalArgumentException(Messages.getString("KeyCloneCmd.27"));
            }
        }
        this.destinationAlias = string.trim();
    }

    private void setNewKeyPassword(String string) throws IOException, UnsupportedCallbackException {
        if (string != null) {
            this.newKeyPasswordChars = string.toCharArray();
        } else {
            boolean bl = false;
            Callback[] callbackArray = new Callback[1];
            Callback[] callbackArray2 = new Callback[1];
            for (int i = 0; i < 3; ++i) {
                if (!this.prompt4NewPassword(this.getCallbackHandler(), callbackArray, callbackArray2)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                throw new SecurityException(Messages.getString("StorePasswdCmd.19"));
            }
        }
    }

    private boolean prompt4NewPassword(CallbackHandler callbackHandler, Callback[] callbackArray, Callback[] callbackArray2) throws IOException, UnsupportedCallbackException {
        String string = Messages.getFormattedString("KeyCloneCmd.28", new String[]{this.destinationAlias, String.valueOf(this.keyPasswordChars)});
        PasswordCallback passwordCallback = new PasswordCallback(string, false);
        callbackArray[0] = passwordCallback;
        callbackHandler.handle(callbackArray);
        char[] cArray = passwordCallback.getPassword();
        passwordCallback.clearPassword();
        if (cArray == null || cArray.length == 0) {
            this.newKeyPasswordChars = (char[])this.keyPasswordChars.clone();
            return true;
        }
        if (cArray.length < 6) {
            callbackArray2[0] = new TextOutputCallback(2, Messages.getString("StorePasswdCmd.21"));
            callbackHandler.handle(callbackArray2);
            return false;
        }
        this.newKeyPasswordChars = cArray;
        return true;
    }

    KeyCloneCmd() {
    }
}

