/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.rmi.rmic;

import gnu.classpath.tools.AbstractMethodGenerator;
import gnu.classpath.tools.rmi.rmic.RmicCompiler;
import gnu.classpath.tools.rmi.rmic.WrapUnWrapper;
import gnu.java.rmi.server.RMIHashes;
import java.lang.reflect.Method;
import java.util.Properties;

public class RmiMethodGenerator
implements AbstractMethodGenerator {
    Method method;
    RmicCompiler rmic;

    public RmiMethodGenerator(Method method, RmicCompiler rmicCompiler) {
        this.method = method;
        this.rmic = rmicCompiler;
        if (this.method.getParameterTypes().length == 0) {
            this.rmic.addZeroSizeObjecArray = true;
        }
    }

    public String getArgumentList() {
        StringBuffer stringBuffer = new StringBuffer();
        Class<?>[] classArray = this.method.getParameterTypes();
        for (int i = 0; i < classArray.length; ++i) {
            stringBuffer.append(this.rmic.name(classArray[i]));
            stringBuffer.append(" p" + i);
            if (i >= classArray.length - 1) continue;
            stringBuffer.append(", ");
        }
        return stringBuffer.toString();
    }

    public String getArgumentNames() {
        StringBuffer stringBuffer = new StringBuffer();
        Class<?>[] classArray = this.method.getParameterTypes();
        for (int i = 0; i < classArray.length; ++i) {
            stringBuffer.append(" p" + i);
            if (i >= classArray.length - 1) continue;
            stringBuffer.append(", ");
        }
        return stringBuffer.toString();
    }

    public String getThrows() {
        StringBuffer stringBuffer = new StringBuffer();
        Class<?>[] classArray = this.method.getExceptionTypes();
        for (int i = 0; i < classArray.length; ++i) {
            stringBuffer.append(this.rmic.name(classArray[i]));
            if (i >= classArray.length - 1) continue;
            stringBuffer.append(", ");
        }
        return stringBuffer.toString();
    }

    public String generateStubMethod() {
        String string;
        Properties properties = new Properties(this.rmic.vars);
        properties.put("#return_type", this.rmic.name(this.method.getReturnType()));
        properties.put("#method_name", this.method.getName());
        properties.put("#method_hash", this.getMethodHashCode());
        properties.put("#argument_list", this.getArgumentList());
        properties.put("#object_arg_list", this.getArgListAsObjectArray());
        properties.put("#declaring_class", this.rmic.name(this.method.getDeclaringClass()));
        properties.put("#class_arg_list", this.getArgListAsClassArray());
        String string2 = this.getThrows();
        if (string2.length() > 0) {
            properties.put("#throws", "\n    throws " + string2);
        } else {
            properties.put("#throws", "");
        }
        if (this.method.getReturnType().equals(Void.TYPE)) {
            string = "Stub_12MethodVoid.jav";
        } else {
            string = "Stub_12Method.jav";
            properties.put("#return_statement", this.getReturnStatement());
        }
        String string3 = this.rmic.getResource(string);
        String string4 = this.rmic.replaceAll(string3, properties);
        return string4;
    }

    public String getStaticMethodDeclarations() {
        StringBuffer stringBuffer = new StringBuffer();
        Class<?>[] classArray = this.method.getParameterTypes();
        for (int i = 0; i < classArray.length; ++i) {
            stringBuffer.append("            ");
            stringBuffer.append(this.rmic.name(classArray[i]));
            stringBuffer.append(" ");
            stringBuffer.append("p" + i);
            stringBuffer.append(" = ");
            if (i >= classArray.length - 1) continue;
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public String getArgListAsObjectArray() {
        Class<?>[] classArray = this.method.getParameterTypes();
        if (classArray.length == 0) {
            return "NO_ARGS";
        }
        StringBuffer stringBuffer = new StringBuffer("new Object[] {");
        for (int i = 0; i < classArray.length; ++i) {
            if (!classArray[i].isPrimitive()) {
                stringBuffer.append("p" + i);
            } else {
                stringBuffer.append("new " + this.rmic.name(WrapUnWrapper.getWrappingClass(classArray[i])));
                stringBuffer.append("(p" + i + ")");
            }
            if (i >= classArray.length - 1) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public String getReturnStatement() {
        Class<?> clazz = this.method.getReturnType();
        if (clazz.equals(Void.TYPE)) {
            return "";
        }
        if (clazz.isPrimitive()) {
            String string = this.rmic.name(WrapUnWrapper.getWrappingClass(clazz));
            return "return ((" + string + ") result)." + WrapUnWrapper.getUnwrappingMethod(clazz) + ";";
        }
        return "return (" + this.rmic.name(clazz) + ") result;";
    }

    public String getArgListAsClassArray() {
        StringBuffer stringBuffer = new StringBuffer();
        Class<?>[] classArray = this.method.getParameterTypes();
        for (int i = 0; i < classArray.length; ++i) {
            stringBuffer.append(this.rmic.name(classArray[i]));
            stringBuffer.append(".class");
            if (i >= classArray.length - 1) continue;
            stringBuffer.append(", ");
        }
        return stringBuffer.toString();
    }

    public String generateTieMethod() {
        throw new InternalError();
    }

    public String getMethodHashCode() {
        return RMIHashes.getMethodHash((Method)this.method) + "L";
    }

    public String convertStubName(String string) {
        return string;
    }
}

