<?php
/**
 * This class represents a Kolab user accessing the export system.
 *
 * PHP version 5
 *
 * @category Kolab
 * @package  Kolab_FreeBusy
 * @author   Gunnar Wrobel <wrobel@pardus.de>
 * @license  http://www.fsf.org/copyleft/lgpl.html LGPL
 * @link     http://pear.horde.org/index.php?package=Kolab_FreeBusy
 */

/**
 * This class represents a Kolab accessing the export system.
 *
 * Copyright 2010 The Horde Project (http://www.horde.org/)
 *
 * See the enclosed file COPYING for license information (LGPL). If you did not
 * receive this file, see
 * http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
 *
 * @category Kolab
 * @package  Kolab_FreeBusy
 * @author   Gunnar Wrobel <wrobel@pardus.de>
 * @license  http://www.fsf.org/copyleft/lgpl.html LGPL
 * @link     http://pear.horde.org/index.php?package=Kolab_FreeBusy
 */
class Horde_Kolab_FreeBusy_User_Kolab
extends Horde_Kolab_FreeBusy_UserDb_User_Kolab
implements Horde_Kolab_FreeBusy_User
{
    /**
     * The user details.
     *
     * @var Horde_Kolab_FreeBusy_Params_User
     */
    private $_user;

    /**
     * The connection to the user database.
     *
     * @var Horde_Kolab_FreeBusy_UserDb
     */
    private $_userdb;

    /**
     * Has the user authenticated successfully?
     *
     * @var boolean
     */
    private $_authenticated;

    /**
     * Constructor.
     *
     * @param Horde_Kolab_FreeBusy_Params_User $user   The user parameters.
     * @param Horde_Kolab_FreeBusy_UserDb      $userdb The connection to the user database.
     */
    public function __construct(
        Horde_Kolab_FreeBusy_Params_User $user,
        Horde_Kolab_FreeBusy_UserDb $userdb
    ) {
        $this->_user   = $user;
        $this->_userdb = $userdb;
        parent::__construct($userdb);
    }

    /**
     * Fetch the user data from the user db.
     *
     * @return NULL
     */
    protected function fetchUserDbUser()
    {
        return $this->fetchUser($this->_user->getId());
    }

    /**
     * Finds out if a set of login credentials are valid.
     *
     * @return boolean Whether or not the password was correct.
     */
    public function isAuthenticated()
    {
        if ($this->_authenticated === null) {
            list($user, $pass) = $this->_user->getCredentials();
            try {
                $this->_userdb->connect($this->getGuid(), $pass);
                $this->_authenticated = true;
            } catch (Exception $e) {
                //@todo: Not just Exception. This must be made more specific.
                $this->_authenticated = false;
            }
        }
        return $this->_authenticated;
    }
}