#!/bin/sh
echo 'name: snap-core
version: 0.2.16
id: snap-core-0.2.16-f5298e871485b4ce15cc2f034cb1ab1e

license: BSD3
copyright:
maintainer: snap@snapframework.com
stability:
homepage: http://snapframework.com/
package-url:
description: This is the first developer prerelease of the Snap framework.  Snap is a
             simple and fast web development framework and server written in Haskell. For
             more information or to download the latest version, you can visit the Snap
             project website at <http://snapframework.com/>.
             .
             This library contains the core definitions and types for the Snap framework,
             including:
             .
             1. Primitive types and functions for HTTP (requests, responses, cookies,
             post/query parameters, etc)
             .
             2. Type aliases and helper functions for Iteratee I/O
             .
             3. A monad for programming web handlers called \"Snap\", inspired by
             happstack'\''s (<http://happstack.com/index.html>), which allows:
             .
             * Stateful access to the HTTP request and response objects
             .
             * Monadic failure (i.e. MonadPlus/Alternative instances) for declining
             to handle requests and chaining handlers together
             .
             * Early termination of the computation if you know early what you want
             to return and want to prevent further monadic processing
             .
             /Quick start/: The '\''Snap'\'' monad and HTTP definitions are in "Snap.Types",
             some iteratee utilities are in "Snap.Iteratee".
             .
             Higher-level facilities for building web applications (like user/session
             management, component interfaces, data modeling, etc.) are planned but not
             yet implemented, so this release will mostly be of interest for those who:
             .
             * need a fast and minimal HTTP API at roughly the same level of abstraction
             as Java servlets, or
             .
             * are interested in contributing to the Snap Framework project.
category: Web
author: James Sanders, Shu-yu Guo, Gregory Collins, Doug Beardsley
pkgpath: www/hs-snap-core
exposed: True
exposed-modules: Data.CIByteString Snap.Types Snap.Iteratee
                 Snap.Internal.Debug Snap.Internal.Http.Types
                 Snap.Internal.Iteratee.Debug Snap.Util.FileServe Snap.Util.GZip
hidden-modules: Snap.Internal.Parsing Snap.Internal.Routing
                Snap.Internal.Types
import-dirs: /usr/local/lib/ghc/snap-core-0.2.16
library-dirs: /usr/local/lib/ghc/snap-core-0.2.16
hs-libraries: HSsnap-core-0.2.16
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: ListLike-1.0.1-101912a25d1639b6cbb5278b3a2c5ab6
         MonadCatchIO-transformers-0.2.2.0-2f29616558987a7d7eed29310fd8bf1a
         attoparsec-0.8.1.0-0cb5649a81f86e011cb80bdd81d0cd7d
         base-4.2.0.2-578c91f7479ca9d00c13da2ed514f7ac
         bytestring-0.9.1.7-41dd05a497806d68d10ffae5438a0632
         bytestring-nums-0.3.2-9b8c8eedca7f6c16768c3418a1439e84
         bytestring-show-0.3.3-bdad6ac9ec65d2bb548fc86e9003de40
         cereal-0.3.0.0-780d21095ae79ac3df7682af40a002c1
         containers-0.3.0.0-ee442470d8dcc9e45f31677c400c5379
         deepseq-1.1.0.0-5b7e75cfe2cd44024326a4af10ca9e7b
         directory-1.0.1.1-debc5b242c6cb9e9d9ae96c3aeec5419
         directory-tree-0.2.0-7c85c7fbceccf2b4ca95a0fccca6ad79
         dlist-0.5-d48152d9ee53bf6ba28585ac50da0a6b
         filepath-1.1.0.4-c303c646a99c2a24d2402008d247eb5f
         haskell98-1.0.1.1-4d2891ad99eae334ff8234bcfbddce06
         iteratee-0.3.5-7be6a1424a669bfd6cfa78c9310087cb
         monads-fd-0.1.0.1-4302101a818b1cd4a450f02794f0a403
         old-locale-1.0.0.2-0c1a4b40f2d3b9f6b725f54c00fe0923
         old-time-1.0.0.5-99a656bc4f807d3640e245d60c3d290a
         template-haskell-2.4.0.1-48b6a3b68cc3ef7829c65c5f5384baa3
         text-0.10.0.2-4744e8f39b84612e1c289458d542f90d
         time-1.1.4-d9f7b7932dc3a4863006ed6b1d525856
         transformers-0.2.1.0-83bd04c7d756a68d4480a7c48ea90dcc
         unix-compat-0.1.2.1-d442ecaa9ecebf4138ae5bcd92cce9c7
         zlib-0.5.2.0-7acfb4dd7cb77e3a4b5beb3b9b160b08
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-snap-core-0.2.16/html/snap-core.haddock
haddock-html: /usr/local/share/doc/hs-snap-core-0.2.16/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-conf' "$@"
