/*
 * Decompiled with CFR 0.152.
 */
package java.security.cert;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.security.GeneralSecurityException;
import java.security.cert.CertPath;

public class CertPathValidatorException
extends GeneralSecurityException {
    private static final long serialVersionUID = -3083180014971893139L;
    private int index = -1;
    private CertPath certPath;
    private Reason reason = BasicReason.UNSPECIFIED;

    public CertPathValidatorException() {
        this(null, null);
    }

    public CertPathValidatorException(String string) {
        this(string, null);
    }

    public CertPathValidatorException(Throwable throwable) {
        this(throwable == null ? null : throwable.toString(), throwable);
    }

    public CertPathValidatorException(String string, Throwable throwable) {
        this(string, throwable, null, -1);
    }

    public CertPathValidatorException(String string, Throwable throwable, CertPath certPath, int n) {
        this(string, throwable, certPath, n, BasicReason.UNSPECIFIED);
    }

    public CertPathValidatorException(String string, Throwable throwable, CertPath certPath, int n, Reason reason) {
        super(string, throwable);
        if (certPath == null && n != -1) {
            throw new IllegalArgumentException();
        }
        if (n < -1 || certPath != null && n >= certPath.getCertificates().size()) {
            throw new IndexOutOfBoundsException();
        }
        if (reason == null) {
            throw new NullPointerException("reason can't be null");
        }
        this.certPath = certPath;
        this.index = n;
        this.reason = reason;
    }

    public CertPath getCertPath() {
        return this.certPath;
    }

    public int getIndex() {
        return this.index;
    }

    public Reason getReason() {
        return this.reason;
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        if (this.reason == null) {
            this.reason = BasicReason.UNSPECIFIED;
        }
        if (this.certPath == null && this.index != -1) {
            throw new InvalidObjectException("certpath is null and index != -1");
        }
        if (this.index < -1 || this.certPath != null && this.index >= this.certPath.getCertificates().size()) {
            throw new InvalidObjectException("index out of range");
        }
    }

    public static enum BasicReason implements Reason
    {
        UNSPECIFIED,
        EXPIRED,
        NOT_YET_VALID,
        REVOKED,
        UNDETERMINED_REVOCATION_STATUS,
        INVALID_SIGNATURE;

    }

    public static interface Reason
    extends Serializable {
    }
}

