/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.InternalFrameFocusTraversalPolicy;
import javax.swing.JComponent;
import javax.swing.SwingContainerOrderFocusTraversalPolicy;
import sun.util.logging.PlatformLogger;

public class SortingFocusTraversalPolicy
extends InternalFrameFocusTraversalPolicy {
    private Comparator<? super Component> comparator;
    private boolean implicitDownCycleTraversal = true;
    private PlatformLogger log = PlatformLogger.getLogger("javax.swing.SortingFocusTraversalPolicy");
    private transient Container cachedRoot;
    private transient List<Component> cachedCycle;
    private static final SwingContainerOrderFocusTraversalPolicy fitnessTestPolicy = new SwingContainerOrderFocusTraversalPolicy();
    private final int FORWARD_TRAVERSAL = 0;
    private final int BACKWARD_TRAVERSAL = 1;

    protected SortingFocusTraversalPolicy() {
    }

    public SortingFocusTraversalPolicy(Comparator<? super Component> comparator) {
        this.comparator = comparator;
    }

    private List<Component> getFocusTraversalCycle(Container container) {
        ArrayList<Component> arrayList = new ArrayList<Component>();
        this.enumerateAndSortCycle(container, arrayList);
        return arrayList;
    }

    private int getComponentIndex(List<Component> list, Component component) {
        int n;
        try {
            n = Collections.binarySearch(list, component, this.comparator);
        }
        catch (ClassCastException classCastException) {
            if (this.log.isLoggable(500)) {
                this.log.fine("### During the binary search for " + component + " the exception occured: ", classCastException);
            }
            return -1;
        }
        if (n < 0) {
            n = list.indexOf(component);
        }
        return n;
    }

    private void enumerateAndSortCycle(Container container, List<Component> list) {
        if (container.isShowing()) {
            this.enumerateCycle(container, list);
            Collections.sort(list, this.comparator);
        }
    }

    private void enumerateCycle(Container container, List<Component> list) {
        Component[] componentArray;
        if (!container.isVisible() || !container.isDisplayable()) {
            return;
        }
        list.add(container);
        for (Component component : componentArray = container.getComponents()) {
            Container container2;
            if (!(!(component instanceof Container) || (container2 = (Container)component).isFocusCycleRoot() || container2.isFocusTraversalPolicyProvider() || container2 instanceof JComponent && ((JComponent)container2).isManagingFocus())) {
                this.enumerateCycle(container2, list);
                continue;
            }
            list.add(component);
        }
    }

    Container getTopmostProvider(Container container, Component component) {
        Container container2;
        Container container3 = null;
        for (container2 = component.getParent(); container2 != container && container2 != null; container2 = container2.getParent()) {
            if (!container2.isFocusTraversalPolicyProvider()) continue;
            container3 = container2;
        }
        if (container2 == null) {
            return null;
        }
        return container3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Component getComponentDownCycle(Component component, int n) {
        Component component2 = null;
        if (!(component instanceof Container)) return component2;
        Container container = (Container)component;
        if (container.isFocusCycleRoot()) {
            if (!this.getImplicitDownCycleTraversal()) return null;
            component2 = container.getFocusTraversalPolicy().getDefaultComponent(container);
            if (component2 == null || !this.log.isLoggable(500)) return component2;
            this.log.fine("### Transfered focus down-cycle to " + component2 + " in the focus cycle root " + container);
            return component2;
        } else {
            if (!container.isFocusTraversalPolicyProvider()) return component2;
            Component component3 = component2 = n == 0 ? container.getFocusTraversalPolicy().getDefaultComponent(container) : container.getFocusTraversalPolicy().getLastComponent(container);
            if (component2 == null || !this.log.isLoggable(500)) return component2;
            this.log.fine("### Transfered focus to " + component2 + " in the FTP provider " + container);
        }
        return component2;
    }

    @Override
    public Component getComponentAfter(Container container, Component component) {
        int n;
        Object object;
        if (this.log.isLoggable(500)) {
            this.log.fine("### Searching in " + container + " for component after " + component);
        }
        if (container == null || component == null) {
            throw new IllegalArgumentException("aContainer and aComponent cannot be null");
        }
        if (!container.isFocusTraversalPolicyProvider() && !container.isFocusCycleRoot()) {
            throw new IllegalArgumentException("aContainer should be focus cycle root or focus traversal policy provider");
        }
        if (container.isFocusCycleRoot() && !component.isFocusCycleRoot(container)) {
            throw new IllegalArgumentException("aContainer is not a focus cycle root of aComponent");
        }
        Component component2 = this.getComponentDownCycle(component, 0);
        if (component2 != null) {
            return component2;
        }
        Container container2 = this.getTopmostProvider(container, component);
        if (container2 != null) {
            Component component3;
            if (this.log.isLoggable(500)) {
                this.log.fine("### Asking FTP " + container2 + " for component after " + component);
            }
            if ((component3 = ((FocusTraversalPolicy)(object = container2.getFocusTraversalPolicy())).getComponentAfter(container2, component)) != null) {
                if (this.log.isLoggable(500)) {
                    this.log.fine("### FTP returned " + component3);
                }
                return component3;
            }
            component = container2;
        }
        object = this.getFocusTraversalCycle(container);
        if (this.log.isLoggable(500)) {
            this.log.fine("### Cycle is " + object + ", component is " + component);
        }
        if ((n = this.getComponentIndex((List<Component>)object, component)) < 0) {
            if (this.log.isLoggable(500)) {
                this.log.fine("### Didn't find component " + component + " in a cycle " + container);
            }
            return this.getFirstComponent(container);
        }
        ++n;
        while (n < object.size()) {
            component2 = (Component)object.get(n);
            if (this.accept(component2)) {
                return component2;
            }
            if ((component2 = this.getComponentDownCycle(component2, 0)) != null) {
                return component2;
            }
            ++n;
        }
        if (container.isFocusCycleRoot()) {
            this.cachedRoot = container;
            this.cachedCycle = object;
            component2 = this.getFirstComponent(container);
            this.cachedRoot = null;
            this.cachedCycle = null;
            return component2;
        }
        return null;
    }

    @Override
    public Component getComponentBefore(Container container, Component component) {
        Component component2;
        int n;
        Object object;
        if (container == null || component == null) {
            throw new IllegalArgumentException("aContainer and aComponent cannot be null");
        }
        if (!container.isFocusTraversalPolicyProvider() && !container.isFocusCycleRoot()) {
            throw new IllegalArgumentException("aContainer should be focus cycle root or focus traversal policy provider");
        }
        if (container.isFocusCycleRoot() && !component.isFocusCycleRoot(container)) {
            throw new IllegalArgumentException("aContainer is not a focus cycle root of aComponent");
        }
        Container container2 = this.getTopmostProvider(container, component);
        if (container2 != null) {
            Component component3;
            if (this.log.isLoggable(500)) {
                this.log.fine("### Asking FTP " + container2 + " for component after " + component);
            }
            if ((component3 = ((FocusTraversalPolicy)(object = container2.getFocusTraversalPolicy())).getComponentBefore(container2, component)) != null) {
                if (this.log.isLoggable(500)) {
                    this.log.fine("### FTP returned " + component3);
                }
                return component3;
            }
            component = container2;
            if (this.accept(component)) {
                return component;
            }
        }
        object = this.getFocusTraversalCycle(container);
        if (this.log.isLoggable(500)) {
            this.log.fine("### Cycle is " + object + ", component is " + component);
        }
        if ((n = this.getComponentIndex((List<Component>)object, component)) < 0) {
            if (this.log.isLoggable(500)) {
                this.log.fine("### Didn't find component " + component + " in a cycle " + container);
            }
            return this.getLastComponent(container);
        }
        --n;
        while (n >= 0) {
            Component component4;
            component2 = (Component)object.get(n);
            if (component2 != container && (component4 = this.getComponentDownCycle(component2, 1)) != null) {
                return component4;
            }
            if (this.accept(component2)) {
                return component2;
            }
            --n;
        }
        if (container.isFocusCycleRoot()) {
            this.cachedRoot = container;
            this.cachedCycle = object;
            component2 = this.getLastComponent(container);
            this.cachedRoot = null;
            this.cachedCycle = null;
            return component2;
        }
        return null;
    }

    @Override
    public Component getFirstComponent(Container container) {
        if (this.log.isLoggable(500)) {
            this.log.fine("### Getting first component in " + container);
        }
        if (container == null) {
            throw new IllegalArgumentException("aContainer cannot be null");
        }
        List<Component> list = this.cachedRoot == container ? this.cachedCycle : this.getFocusTraversalCycle(container);
        if (list.size() == 0) {
            if (this.log.isLoggable(500)) {
                this.log.fine("### Cycle is empty");
            }
            return null;
        }
        if (this.log.isLoggable(500)) {
            this.log.fine("### Cycle is " + list);
        }
        for (Component component : list) {
            if (this.accept(component)) {
                return component;
            }
            if (component == container || (component = this.getComponentDownCycle(component, 0)) == null) continue;
            return component;
        }
        return null;
    }

    @Override
    public Component getLastComponent(Container container) {
        if (this.log.isLoggable(500)) {
            this.log.fine("### Getting last component in " + container);
        }
        if (container == null) {
            throw new IllegalArgumentException("aContainer cannot be null");
        }
        List<Component> list = this.cachedRoot == container ? this.cachedCycle : this.getFocusTraversalCycle(container);
        if (list.size() == 0) {
            if (this.log.isLoggable(500)) {
                this.log.fine("### Cycle is empty");
            }
            return null;
        }
        if (this.log.isLoggable(500)) {
            this.log.fine("### Cycle is " + list);
        }
        for (int i = list.size() - 1; i >= 0; --i) {
            Container container2;
            Component component = list.get(i);
            if (this.accept(component)) {
                return component;
            }
            if (!(component instanceof Container) || component == container || !(container2 = (Container)component).isFocusTraversalPolicyProvider()) continue;
            return container2.getFocusTraversalPolicy().getLastComponent(container2);
        }
        return null;
    }

    @Override
    public Component getDefaultComponent(Container container) {
        return this.getFirstComponent(container);
    }

    public void setImplicitDownCycleTraversal(boolean bl) {
        this.implicitDownCycleTraversal = bl;
    }

    public boolean getImplicitDownCycleTraversal() {
        return this.implicitDownCycleTraversal;
    }

    protected void setComparator(Comparator<? super Component> comparator) {
        this.comparator = comparator;
    }

    protected Comparator<? super Component> getComparator() {
        return this.comparator;
    }

    protected boolean accept(Component component) {
        return fitnessTestPolicy.accept(component);
    }
}

