/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.image;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferUShort;
import java.awt.image.Raster;
import java.awt.image.RasterFormatException;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import sun.awt.image.NativeLibLoader;
import sun.awt.image.SunWritableRaster;

public class ShortComponentRaster
extends SunWritableRaster {
    protected int bandOffset;
    protected int[] dataOffsets;
    protected int scanlineStride;
    protected int pixelStride;
    protected short[] data;
    int type;
    private int maxX;
    private int maxY;

    private static native void initIDs();

    public ShortComponentRaster(SampleModel sampleModel, Point point) {
        this(sampleModel, sampleModel.createDataBuffer(), new Rectangle(point.x, point.y, sampleModel.getWidth(), sampleModel.getHeight()), point, null);
    }

    public ShortComponentRaster(SampleModel sampleModel, DataBuffer dataBuffer, Point point) {
        this(sampleModel, dataBuffer, new Rectangle(point.x, point.y, sampleModel.getWidth(), sampleModel.getHeight()), point, null);
    }

    public ShortComponentRaster(SampleModel sampleModel, DataBuffer dataBuffer, Rectangle rectangle, Point point, ShortComponentRaster shortComponentRaster) {
        super(sampleModel, dataBuffer, rectangle, point, shortComponentRaster);
        this.maxX = this.minX + this.width;
        this.maxY = this.minY + this.height;
        if (!(dataBuffer instanceof DataBufferUShort)) {
            throw new RasterFormatException("ShortComponentRasters must have short DataBuffers");
        }
        DataBufferUShort dataBufferUShort = (DataBufferUShort)dataBuffer;
        this.data = ShortComponentRaster.stealData(dataBufferUShort, 0);
        if (dataBufferUShort.getNumBanks() != 1) {
            throw new RasterFormatException("DataBuffer for ShortComponentRasters must only have 1 bank.");
        }
        int n = dataBufferUShort.getOffset();
        if (sampleModel instanceof ComponentSampleModel) {
            ComponentSampleModel componentSampleModel = (ComponentSampleModel)sampleModel;
            this.type = 2;
            this.scanlineStride = componentSampleModel.getScanlineStride();
            this.pixelStride = componentSampleModel.getPixelStride();
            this.dataOffsets = componentSampleModel.getBandOffsets();
            int n2 = rectangle.x - point.x;
            int n3 = rectangle.y - point.y;
            int n4 = 0;
            while (n4 < this.getNumDataElements()) {
                int n5 = n4++;
                this.dataOffsets[n5] = this.dataOffsets[n5] + (n + n2 * this.pixelStride + n3 * this.scanlineStride);
            }
        } else if (sampleModel instanceof SinglePixelPackedSampleModel) {
            SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)sampleModel;
            this.type = 8;
            this.scanlineStride = singlePixelPackedSampleModel.getScanlineStride();
            this.pixelStride = 1;
            this.dataOffsets = new int[1];
            this.dataOffsets[0] = n;
            int n6 = rectangle.x - point.x;
            int n7 = rectangle.y - point.y;
            this.dataOffsets[0] = this.dataOffsets[0] + (n6 + n7 * this.scanlineStride);
        } else {
            throw new RasterFormatException("ShortComponentRasters must haveComponentSampleModel or SinglePixelPackedSampleModel");
        }
        this.bandOffset = this.dataOffsets[0];
        this.verify(false);
    }

    public int[] getDataOffsets() {
        return (int[])this.dataOffsets.clone();
    }

    public int getDataOffset(int n) {
        return this.dataOffsets[n];
    }

    public int getScanlineStride() {
        return this.scanlineStride;
    }

    public int getPixelStride() {
        return this.pixelStride;
    }

    public short[] getDataStorage() {
        return this.data;
    }

    @Override
    public Object getDataElements(int n, int n2, Object object) {
        if (n < this.minX || n2 < this.minY || n >= this.maxX || n2 >= this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        short[] sArray = object == null ? new short[this.numDataElements] : (short[])object;
        int n3 = (n2 - this.minY) * this.scanlineStride + (n - this.minX) * this.pixelStride;
        for (int i = 0; i < this.numDataElements; ++i) {
            sArray[i] = this.data[this.dataOffsets[i] + n3];
        }
        return sArray;
    }

    @Override
    public Object getDataElements(int n, int n2, int n3, int n4, Object object) {
        if (n < this.minX || n2 < this.minY || n + n3 > this.maxX || n2 + n4 > this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        short[] sArray = object == null ? new short[n3 * n4 * this.numDataElements] : (short[])object;
        int n5 = (n2 - this.minY) * this.scanlineStride + (n - this.minX) * this.pixelStride;
        int n6 = 0;
        int n7 = 0;
        while (n7 < n4) {
            int n8 = n5;
            int n9 = 0;
            while (n9 < n3) {
                for (int i = 0; i < this.numDataElements; ++i) {
                    sArray[n6++] = this.data[this.dataOffsets[i] + n8];
                }
                ++n9;
                n8 += this.pixelStride;
            }
            ++n7;
            n5 += this.scanlineStride;
        }
        return sArray;
    }

    public short[] getShortData(int n, int n2, int n3, int n4, int n5, short[] sArray) {
        if (n < this.minX || n2 < this.minY || n + n3 > this.maxX || n2 + n4 > this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        if (sArray == null) {
            sArray = new short[this.numDataElements * n3 * n4];
        }
        int n6 = (n2 - this.minY) * this.scanlineStride + (n - this.minX) * this.pixelStride + this.dataOffsets[n5];
        int n7 = 0;
        if (this.pixelStride == 1) {
            if (this.scanlineStride == n3) {
                System.arraycopy(this.data, n6, sArray, 0, n3 * n4);
            } else {
                int n8 = 0;
                while (n8 < n4) {
                    System.arraycopy(this.data, n6, sArray, n7, n3);
                    n7 += n3;
                    ++n8;
                    n6 += this.scanlineStride;
                }
            }
        } else {
            int n9 = 0;
            while (n9 < n4) {
                int n10 = n6;
                int n11 = 0;
                while (n11 < n3) {
                    sArray[n7++] = this.data[n10];
                    ++n11;
                    n10 += this.pixelStride;
                }
                ++n9;
                n6 += this.scanlineStride;
            }
        }
        return sArray;
    }

    public short[] getShortData(int n, int n2, int n3, int n4, short[] sArray) {
        if (n < this.minX || n2 < this.minY || n + n3 > this.maxX || n2 + n4 > this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        if (sArray == null) {
            sArray = new short[this.numDataElements * n3 * n4];
        }
        int n5 = (n2 - this.minY) * this.scanlineStride + (n - this.minX) * this.pixelStride;
        int n6 = 0;
        int n7 = 0;
        while (n7 < n4) {
            int n8 = n5;
            int n9 = 0;
            while (n9 < n3) {
                for (int i = 0; i < this.numDataElements; ++i) {
                    sArray[n6++] = this.data[this.dataOffsets[i] + n8];
                }
                ++n9;
                n8 += this.pixelStride;
            }
            ++n7;
            n5 += this.scanlineStride;
        }
        return sArray;
    }

    @Override
    public void setDataElements(int n, int n2, Object object) {
        if (n < this.minX || n2 < this.minY || n >= this.maxX || n2 >= this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        short[] sArray = (short[])object;
        int n3 = (n2 - this.minY) * this.scanlineStride + (n - this.minX) * this.pixelStride;
        for (int i = 0; i < this.numDataElements; ++i) {
            this.data[this.dataOffsets[i] + n3] = sArray[i];
        }
        this.markDirty();
    }

    @Override
    public void setDataElements(int n, int n2, Raster raster) {
        int n3 = n + raster.getMinX();
        int n4 = n2 + raster.getMinY();
        int n5 = raster.getWidth();
        int n6 = raster.getHeight();
        if (n3 < this.minX || n4 < this.minY || n3 + n5 > this.maxX || n4 + n6 > this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        this.setDataElements(n3, n4, n5, n6, raster);
    }

    private void setDataElements(int n, int n2, int n3, int n4, Raster raster) {
        if (n3 <= 0 || n4 <= 0) {
            return;
        }
        int n5 = raster.getMinX();
        int n6 = raster.getMinY();
        Object object = null;
        for (int i = 0; i < n4; ++i) {
            object = raster.getDataElements(n5, n6 + i, n3, 1, object);
            this.setDataElements(n, n2 + i, n3, 1, object);
        }
    }

    @Override
    public void setDataElements(int n, int n2, int n3, int n4, Object object) {
        if (n < this.minX || n2 < this.minY || n + n3 > this.maxX || n2 + n4 > this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        short[] sArray = (short[])object;
        int n5 = (n2 - this.minY) * this.scanlineStride + (n - this.minX) * this.pixelStride;
        int n6 = 0;
        int n7 = 0;
        while (n7 < n4) {
            int n8 = n5;
            int n9 = 0;
            while (n9 < n3) {
                for (int i = 0; i < this.numDataElements; ++i) {
                    this.data[this.dataOffsets[i] + n8] = sArray[n6++];
                }
                ++n9;
                n8 += this.pixelStride;
            }
            ++n7;
            n5 += this.scanlineStride;
        }
        this.markDirty();
    }

    public void putShortData(int n, int n2, int n3, int n4, int n5, short[] sArray) {
        if (n < this.minX || n2 < this.minY || n + n3 > this.maxX || n2 + n4 > this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int n6 = (n2 - this.minY) * this.scanlineStride + (n - this.minX) * this.pixelStride + this.dataOffsets[n5];
        int n7 = 0;
        if (this.pixelStride == 1) {
            if (this.scanlineStride == n3) {
                System.arraycopy(sArray, 0, this.data, n6, n3 * n4);
            } else {
                int n8 = 0;
                while (n8 < n4) {
                    System.arraycopy(sArray, n7, this.data, n6, n3);
                    n7 += n3;
                    ++n8;
                    n6 += this.scanlineStride;
                }
            }
        } else {
            int n9 = 0;
            while (n9 < n4) {
                int n10 = n6;
                int n11 = 0;
                while (n11 < n3) {
                    this.data[n10] = sArray[n7++];
                    ++n11;
                    n10 += this.pixelStride;
                }
                ++n9;
                n6 += this.scanlineStride;
            }
        }
        this.markDirty();
    }

    public void putShortData(int n, int n2, int n3, int n4, short[] sArray) {
        if (n < this.minX || n2 < this.minY || n + n3 > this.maxX || n2 + n4 > this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int n5 = (n2 - this.minY) * this.scanlineStride + (n - this.minX) * this.pixelStride;
        int n6 = 0;
        int n7 = 0;
        while (n7 < n4) {
            int n8 = n5;
            int n9 = 0;
            while (n9 < n3) {
                for (int i = 0; i < this.numDataElements; ++i) {
                    this.data[this.dataOffsets[i] + n8] = sArray[n6++];
                }
                ++n9;
                n8 += this.pixelStride;
            }
            ++n7;
            n5 += this.scanlineStride;
        }
        this.markDirty();
    }

    @Override
    public Raster createChild(int n, int n2, int n3, int n4, int n5, int n6, int[] nArray) {
        WritableRaster writableRaster = this.createWritableChild(n, n2, n3, n4, n5, n6, nArray);
        return writableRaster;
    }

    @Override
    public WritableRaster createWritableChild(int n, int n2, int n3, int n4, int n5, int n6, int[] nArray) {
        if (n < this.minX) {
            throw new RasterFormatException("x lies outside the raster");
        }
        if (n2 < this.minY) {
            throw new RasterFormatException("y lies outside the raster");
        }
        if (n + n3 < n || n + n3 > this.minX + this.width) {
            throw new RasterFormatException("(x + width) is outside of Raster");
        }
        if (n2 + n4 < n2 || n2 + n4 > this.minY + this.height) {
            throw new RasterFormatException("(y + height) is outside of Raster");
        }
        SampleModel sampleModel = nArray != null ? this.sampleModel.createSubsetSampleModel(nArray) : this.sampleModel;
        int n7 = n5 - n;
        int n8 = n6 - n2;
        return new ShortComponentRaster(sampleModel, this.dataBuffer, new Rectangle(n5, n6, n3, n4), new Point(this.sampleModelTranslateX + n7, this.sampleModelTranslateY + n8), this);
    }

    @Override
    public WritableRaster createCompatibleWritableRaster(int n, int n2) {
        if (n <= 0 || n2 <= 0) {
            throw new RasterFormatException("negative " + (n <= 0 ? "width" : "height"));
        }
        SampleModel sampleModel = this.sampleModel.createCompatibleSampleModel(n, n2);
        return new ShortComponentRaster(sampleModel, new Point(0, 0));
    }

    @Override
    public WritableRaster createCompatibleWritableRaster() {
        return this.createCompatibleWritableRaster(this.width, this.height);
    }

    private void verify(boolean bl) {
        int n;
        for (n = 0; n < this.dataOffsets.length; ++n) {
            if (this.dataOffsets[n] >= 0) continue;
            throw new RasterFormatException("Data offsets for band " + n + "(" + this.dataOffsets[n] + ") must be >= 0");
        }
        n = 0;
        for (int i = 0; i < this.numDataElements; ++i) {
            int n2 = (this.height - 1) * this.scanlineStride + (this.width - 1) * this.pixelStride + this.dataOffsets[i];
            if (n2 <= n) continue;
            n = n2;
        }
        if (this.data.length < n) {
            throw new RasterFormatException("Data array too small (should be " + n + " )");
        }
    }

    public String toString() {
        return new String("ShortComponentRaster: width = " + this.width + " height = " + this.height + " #numDataElements " + this.numDataElements);
    }

    static {
        NativeLibLoader.loadLibraries();
        ShortComponentRaster.initIDs();
    }
}

