/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.pisces;

import java.util.Arrays;
import java.util.Iterator;
import sun.awt.geom.PathConsumer2D;
import sun.java2d.pisces.Curve;
import sun.java2d.pisces.Helpers;
import sun.java2d.pisces.PiscesCache;

public class Renderer
implements PathConsumer2D {
    private static final int YMIN = 0;
    private static final int YMAX = 1;
    private static final int CURX = 2;
    private static final int CURY = 3;
    private static final int OR = 4;
    private static final int SLOPE = 5;
    private static final int X0 = 5;
    private static final int Y0 = 6;
    private static final int XL = 7;
    private static final int COUNT = 8;
    private static final int CURSLOPE = 9;
    private static final int DX = 10;
    private static final int DY = 11;
    private static final int DDX = 12;
    private static final int DDY = 13;
    private static final int DDDX = 14;
    private static final int DDDY = 15;
    private float edgeMinY = Float.POSITIVE_INFINITY;
    private float edgeMaxY = Float.NEGATIVE_INFINITY;
    private float edgeMinX = Float.POSITIVE_INFINITY;
    private float edgeMaxX = Float.NEGATIVE_INFINITY;
    private static final int SIZEOF_EDGE = 6;
    private float[] edges = null;
    private int numEdges;
    private static final int SIZEOF_QUAD = 14;
    private float[] quads = null;
    private int numQuads;
    private static final int SIZEOF_CURVE = 16;
    private float[] curves = null;
    private int numCurves;
    private static final float DEC_BND = 20.0f;
    private static final float INC_BND = 8.0f;
    public static final int WIND_EVEN_ODD = 0;
    public static final int WIND_NON_ZERO = 1;
    private final int SUBPIXEL_LG_POSITIONS_X;
    private final int SUBPIXEL_LG_POSITIONS_Y;
    private final int SUBPIXEL_POSITIONS_X;
    private final int SUBPIXEL_POSITIONS_Y;
    private final int SUBPIXEL_MASK_X;
    private final int SUBPIXEL_MASK_Y;
    final int MAX_AA_ALPHA;
    PiscesCache cache;
    private final int boundsMinX;
    private final int boundsMinY;
    private final int boundsMaxX;
    private final int boundsMaxY;
    private final int windingRule;
    private float x0;
    private float y0;
    private float pix_sx0;
    private float pix_sy0;
    private final float[][] pts = new float[2][8];
    private final float[] ts = new float[4];
    Curve c = new Curve();

    private static void qsort(float[] fArray, int[] nArray, int n, int n2, int n3) {
        if (n3 > n2) {
            int n4 = Renderer.partition(fArray, nArray, n, n2, n3);
            if (n2 < n4 - 1) {
                Renderer.qsort(fArray, nArray, n, n2, n4 - 1);
            }
            if (n4 < n3) {
                Renderer.qsort(fArray, nArray, n, n4, n3);
            }
        }
    }

    private static int partition(float[] fArray, int[] nArray, int n, int n2, int n3) {
        int n4 = nArray[n2] + n;
        while (n2 <= n3) {
            while (fArray[nArray[n2] + n] < fArray[n4]) {
                ++n2;
            }
            while (fArray[nArray[n3] + n] > fArray[n4]) {
                --n3;
            }
            if (n2 > n3) continue;
            int n5 = nArray[n2];
            nArray[n2] = nArray[n3];
            nArray[n3] = n5;
            ++n2;
            --n3;
        }
        return n2;
    }

    private void edgeSetCurY(int n, int n2) {
        int n3 = n + 2;
        this.edges[n3] = this.edges[n3] + ((float)n2 - this.edges[n + 3]) * this.edges[n + 5];
        this.edges[n + 3] = n2;
    }

    private void edgeGoToNextY(int n) {
        int n2 = n + 3;
        this.edges[n2] = this.edges[n2] + 1.0f;
        int n3 = n + 2;
        this.edges[n3] = this.edges[n3] + this.edges[n + 5];
    }

    private void quadSetCurY(int n, int n2) {
        assert ((float)n2 < this.quads[n + 1]);
        assert (this.quads[n + 3] > (float)n2);
        assert ((double)this.quads[n + 3] == Math.ceil(this.quads[n + 3]));
        while (this.quads[n + 3] < (float)n2) {
            this.quadGoToNextY(n);
        }
    }

    private void quadGoToNextY(int n) {
        int n2 = n + 3;
        this.quads[n2] = this.quads[n2] + 1.0f;
        int n3 = n + 2;
        this.quads[n3] = this.quads[n3] + this.quads[n + 9];
        int n4 = (int)this.quads[n + 8];
        while (this.quads[n + 3] >= this.quads[n + 6] && n4 > 0) {
            float f = this.quads[n + 5];
            float f2 = this.quads[n + 6];
            n4 = this.executeQuadAFDIteration(n);
            float f3 = this.quads[n + 5];
            float f4 = this.quads[n + 6];
            if (f4 == f2) continue;
            this.quads[n + 9] = (f3 - f) / (f4 - f2);
            this.quads[n + 2] = f + (this.quads[n + 3] - f2) * this.quads[n + 9];
        }
    }

    private void curveSetCurY(int n, int n2) {
        assert ((float)n2 < this.curves[n + 1]);
        assert (this.curves[n + 3] > (float)n2);
        assert ((double)this.curves[n + 3] == Math.ceil(this.curves[n + 3]));
        while (this.curves[n + 3] < (float)n2) {
            this.curveGoToNextY(n);
        }
    }

    private void curveGoToNextY(int n) {
        int n2 = n + 3;
        this.curves[n2] = this.curves[n2] + 1.0f;
        int n3 = n + 2;
        this.curves[n3] = this.curves[n3] + this.curves[n + 9];
        int n4 = (int)this.curves[n + 8];
        while (this.curves[n + 3] >= this.curves[n + 6] && n4 > 0) {
            float f = this.curves[n + 5];
            float f2 = this.curves[n + 6];
            n4 = this.executeCurveAFDIteration(n);
            float f3 = this.curves[n + 5];
            float f4 = this.curves[n + 6];
            if (f4 == f2) continue;
            this.curves[n + 9] = (f3 - f) / (f4 - f2);
            this.curves[n + 2] = f + (this.curves[n + 3] - f2) * this.curves[n + 9];
        }
    }

    private int executeQuadAFDIteration(int n) {
        int n2 = (int)this.quads[n + 8];
        float f = this.quads[n + 12];
        float f2 = this.quads[n + 13];
        float f3 = this.quads[n + 10];
        float f4 = this.quads[n + 11];
        while (Math.abs(f) > 20.0f || Math.abs(f2) > 20.0f) {
            f3 = (f3 - (f /= 4.0f)) / 2.0f;
            f4 = (f4 - (f2 /= 4.0f)) / 2.0f;
            n2 <<= 1;
        }
        while (n2 % 2 == 0 && Math.abs(f3) <= 8.0f && Math.abs(f4) <= 8.0f) {
            f3 = 2.0f * f3 + f;
            f4 = 2.0f * f4 + f2;
            f = 4.0f * f;
            f2 = 4.0f * f2;
            n2 >>= 1;
        }
        if (--n2 > 0) {
            int n3 = n + 5;
            this.quads[n3] = this.quads[n3] + f3;
            f3 += f;
            int n4 = n + 6;
            this.quads[n4] = this.quads[n4] + f4;
            f4 += f2;
        } else {
            this.quads[n + 5] = this.quads[n + 7];
            this.quads[n + 6] = this.quads[n + 1];
        }
        this.quads[n + 8] = n2;
        this.quads[n + 12] = f;
        this.quads[n + 13] = f2;
        this.quads[n + 10] = f3;
        this.quads[n + 11] = f4;
        return n2;
    }

    private int executeCurveAFDIteration(int n) {
        int n2 = (int)this.curves[n + 8];
        float f = this.curves[n + 12];
        float f2 = this.curves[n + 13];
        float f3 = this.curves[n + 10];
        float f4 = this.curves[n + 11];
        float f5 = this.curves[n + 14];
        float f6 = this.curves[n + 15];
        while (Math.abs(f) > 20.0f || Math.abs(f2) > 20.0f) {
            f = f / 4.0f - (f5 /= 8.0f);
            f2 = f2 / 4.0f - (f6 /= 8.0f);
            f3 = (f3 - f) / 2.0f;
            f4 = (f4 - f2) / 2.0f;
            n2 <<= 1;
        }
        while (n2 % 2 == 0 && Math.abs(f3) <= 8.0f && Math.abs(f4) <= 8.0f) {
            f3 = 2.0f * f3 + f;
            f4 = 2.0f * f4 + f2;
            f = 4.0f * (f + f5);
            f2 = 4.0f * (f2 + f6);
            f5 = 8.0f * f5;
            f6 = 8.0f * f6;
            n2 >>= 1;
        }
        if (--n2 > 0) {
            int n3 = n + 5;
            this.curves[n3] = this.curves[n3] + f3;
            f3 += f;
            f += f5;
            int n4 = n + 6;
            this.curves[n4] = this.curves[n4] + f4;
            f4 += f2;
            f2 += f6;
        } else {
            this.curves[n + 5] = this.curves[n + 7];
            this.curves[n + 6] = this.curves[n + 1];
        }
        this.curves[n + 8] = n2;
        this.curves[n + 14] = f5;
        this.curves[n + 15] = f6;
        this.curves[n + 12] = f;
        this.curves[n + 13] = f2;
        this.curves[n + 10] = f3;
        this.curves[n + 11] = f4;
        return n2;
    }

    private void initLine(int n, float[] fArray, int n2) {
        this.edges[n + 5] = (fArray[2] - fArray[0]) / (fArray[3] - fArray[1]);
        this.edges[n + 2] = fArray[0] + (this.edges[n + 3] - fArray[1]) * this.edges[n + 5];
    }

    private void initQuad(int n, float[] fArray, int n2) {
        this.c.set(fArray, 6);
        float f = this.c.dbx / 64.0f;
        float f2 = this.c.dby / 64.0f;
        float f3 = this.c.bx / 64.0f + this.c.cx / 8.0f;
        float f4 = this.c.by / 64.0f + this.c.cy / 8.0f;
        this.quads[n + 12] = f;
        this.quads[n + 13] = f2;
        this.quads[n + 10] = f3;
        this.quads[n + 11] = f4;
        this.quads[n + 8] = 8.0f;
        this.quads[n + 7] = fArray[4];
        this.quads[n + 5] = fArray[0];
        this.quads[n + 6] = fArray[1];
        this.executeQuadAFDIteration(n);
        float f5 = this.quads[n + 5];
        float f6 = this.quads[n + 6];
        this.quads[n + 9] = (f5 - fArray[0]) / (f6 - fArray[1]);
        this.quads[n + 2] = fArray[0] + (this.quads[n + 3] - fArray[1]) * this.quads[n + 9];
    }

    private void initCurve(int n, float[] fArray, int n2) {
        this.c.set(fArray, 8);
        float f = 2.0f * this.c.dax / 512.0f;
        float f2 = 2.0f * this.c.day / 512.0f;
        float f3 = f + this.c.dbx / 64.0f;
        float f4 = f2 + this.c.dby / 64.0f;
        float f5 = this.c.ax / 512.0f + this.c.bx / 64.0f + this.c.cx / 8.0f;
        float f6 = this.c.ay / 512.0f + this.c.by / 64.0f + this.c.cy / 8.0f;
        this.curves[n + 14] = f;
        this.curves[n + 15] = f2;
        this.curves[n + 12] = f3;
        this.curves[n + 13] = f4;
        this.curves[n + 10] = f5;
        this.curves[n + 11] = f6;
        this.curves[n + 8] = 8.0f;
        this.curves[n + 7] = fArray[6];
        this.curves[n + 5] = fArray[0];
        this.curves[n + 6] = fArray[1];
        this.executeCurveAFDIteration(n);
        float f7 = this.curves[n + 5];
        float f8 = this.curves[n + 6];
        this.curves[n + 9] = (f7 - fArray[0]) / (f8 - fArray[1]);
        this.curves[n + 2] = fArray[0] + (this.curves[n + 3] - fArray[1]) * this.curves[n + 9];
    }

    private void addPathSegment(float[] fArray, int n, int n2) {
        int n3;
        switch (n) {
            case 4: {
                n3 = this.numEdges * 6;
                this.edges = Helpers.widenArray(this.edges, this.numEdges * 6, 6);
                float[] fArray2 = this.edges;
                ++this.numEdges;
                break;
            }
            case 6: {
                n3 = this.numQuads * 14;
                this.quads = Helpers.widenArray(this.quads, this.numQuads * 14, 14);
                float[] fArray2 = this.quads;
                ++this.numQuads;
                break;
            }
            case 8: {
                n3 = this.numCurves * 16;
                this.curves = Helpers.widenArray(this.curves, this.numCurves * 16, 16);
                float[] fArray2 = this.curves;
                ++this.numCurves;
                break;
            }
            default: {
                throw new InternalError();
            }
        }
        fArray2[n3 + 0] = fArray[1];
        fArray2[n3 + 1] = fArray[n - 1];
        fArray2[n3 + 4] = n2;
        fArray2[n3 + 3] = (float)Math.ceil(fArray[1]);
        switch (n) {
            case 4: {
                this.initLine(n3, fArray, n2);
                break;
            }
            case 6: {
                this.initQuad(n3, fArray, n2);
                break;
            }
            case 8: {
                this.initCurve(n3, fArray, n2);
                break;
            }
            default: {
                throw new InternalError();
            }
        }
    }

    private void somethingTo(float[] fArray, int n, int n2) {
        this.x0 = n2 >= 0 ? fArray[n - 2] : fArray[0];
        this.y0 = n2 >= 0 ? fArray[n - 1] : fArray[1];
        float f = fArray[1];
        float f2 = fArray[n - 1];
        if (Math.ceil(f) >= Math.ceil(f2) || Math.ceil(f) >= (double)this.boundsMaxY || f2 < (float)this.boundsMinY) {
            return;
        }
        if (f < this.edgeMinY) {
            this.edgeMinY = f;
        }
        if (f2 > this.edgeMaxY) {
            this.edgeMaxY = f2;
        }
        int n3 = fArray[0] < fArray[n - 2] ? 0 : n - 2;
        float f3 = fArray[n3];
        float f4 = fArray[n - 2 - n3];
        if (f3 < this.edgeMinX) {
            this.edgeMinX = f3;
        }
        if (f4 > this.edgeMaxX) {
            this.edgeMaxX = f4;
        }
        this.addPathSegment(fArray, n, n2);
    }

    public Renderer(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        this.SUBPIXEL_LG_POSITIONS_X = n;
        this.SUBPIXEL_LG_POSITIONS_Y = n2;
        this.SUBPIXEL_MASK_X = (1 << this.SUBPIXEL_LG_POSITIONS_X) - 1;
        this.SUBPIXEL_MASK_Y = (1 << this.SUBPIXEL_LG_POSITIONS_Y) - 1;
        this.SUBPIXEL_POSITIONS_X = 1 << this.SUBPIXEL_LG_POSITIONS_X;
        this.SUBPIXEL_POSITIONS_Y = 1 << this.SUBPIXEL_LG_POSITIONS_Y;
        this.MAX_AA_ALPHA = this.SUBPIXEL_POSITIONS_X * this.SUBPIXEL_POSITIONS_Y;
        this.windingRule = n7;
        this.boundsMinX = n3 * this.SUBPIXEL_POSITIONS_X;
        this.boundsMinY = n4 * this.SUBPIXEL_POSITIONS_Y;
        this.boundsMaxX = (n3 + n5) * this.SUBPIXEL_POSITIONS_X;
        this.boundsMaxY = (n4 + n6) * this.SUBPIXEL_POSITIONS_Y;
    }

    private float tosubpixx(float f) {
        return f * (float)this.SUBPIXEL_POSITIONS_X;
    }

    private float tosubpixy(float f) {
        return f * (float)this.SUBPIXEL_POSITIONS_Y;
    }

    @Override
    public void moveTo(float f, float f2) {
        this.closePath();
        this.pix_sx0 = f;
        this.pix_sy0 = f2;
        this.y0 = this.tosubpixy(f2);
        this.x0 = this.tosubpixx(f);
    }

    public void lineJoin() {
    }

    private static void invertPolyPoints(float[] fArray, int n, int n2) {
        int n3 = n;
        for (int i = n + n2 - 2; n3 < i; n3 += 2, i -= 2) {
            float f = fArray[n3];
            fArray[n3] = fArray[i];
            fArray[i] = f;
            f = fArray[n3 + 1];
            fArray[n3 + 1] = fArray[i + 1];
            fArray[i + 1] = f;
        }
    }

    private static int makeMonotonicCurveUpright(float[] fArray, int n, int n2) {
        float f = fArray[n + 1];
        float f2 = fArray[n + n2 - 1];
        if (f > f2) {
            Renderer.invertPolyPoints(fArray, n, n2);
            return -1;
        }
        if (f < f2) {
            return 1;
        }
        return 0;
    }

    @Override
    public void lineTo(float f, float f2) {
        this.pts[0][0] = this.x0;
        this.pts[0][1] = this.y0;
        this.pts[0][2] = this.tosubpixx(f);
        this.pts[0][3] = this.tosubpixy(f2);
        int n = Renderer.makeMonotonicCurveUpright(this.pts[0], 0, 4);
        this.somethingTo(this.pts[0], 4, n);
    }

    private void curveOrQuadTo(int n) {
        this.c.set(this.pts[0], n);
        int n2 = this.c.dxRoots(this.ts, 0);
        n2 += this.c.dyRoots(this.ts, n2);
        n2 = Helpers.filterOutNotInAB(this.ts, 0, n2, 0.0f, 1.0f);
        Helpers.isort(this.ts, 0, n2);
        Iterator<float[]> iterator = Curve.breakPtsAtTs(this.pts, n, this.ts, n2);
        while (iterator.hasNext()) {
            float[] fArray = iterator.next();
            int n3 = Renderer.makeMonotonicCurveUpright(fArray, 0, n);
            this.somethingTo(fArray, n, n3);
        }
    }

    @Override
    public void curveTo(float f, float f2, float f3, float f4, float f5, float f6) {
        this.pts[0][0] = this.x0;
        this.pts[0][1] = this.y0;
        this.pts[0][2] = this.tosubpixx(f);
        this.pts[0][3] = this.tosubpixy(f2);
        this.pts[0][4] = this.tosubpixx(f3);
        this.pts[0][5] = this.tosubpixy(f4);
        this.pts[0][6] = this.tosubpixx(f5);
        this.pts[0][7] = this.tosubpixy(f6);
        this.curveOrQuadTo(8);
    }

    @Override
    public void quadTo(float f, float f2, float f3, float f4) {
        this.pts[0][0] = this.x0;
        this.pts[0][1] = this.y0;
        this.pts[0][2] = this.tosubpixx(f);
        this.pts[0][3] = this.tosubpixy(f2);
        this.pts[0][4] = this.tosubpixx(f3);
        this.pts[0][5] = this.tosubpixy(f4);
        this.curveOrQuadTo(6);
    }

    @Override
    public void closePath() {
        this.lineTo(this.pix_sx0, this.pix_sy0);
    }

    @Override
    public void pathDone() {
        this.closePath();
    }

    @Override
    public long getNativeConsumer() {
        throw new InternalError("Renderer does not use a native consumer.");
    }

    private void _endRendering(int n, int n2, int n3, int n4) {
        int n5 = this.windingRule == 0 ? 1 : -1;
        int n6 = n3 - n + 1;
        int[] nArray = new int[n6 + 1];
        int n7 = n << this.SUBPIXEL_LG_POSITIONS_X;
        int n8 = n3 << this.SUBPIXEL_LG_POSITIONS_X;
        int n9 = Integer.MIN_VALUE;
        int n10 = Integer.MAX_VALUE;
        int n11 = this.boundsMinY;
        ScanlineIterator scanlineIterator = new ScanlineIterator();
        while (scanlineIterator.hasNext()) {
            int n12;
            int n13;
            int n14;
            int n15;
            int n16 = scanlineIterator.next();
            int[] nArray2 = scanlineIterator.crossings;
            n11 = scanlineIterator.curY();
            if (n16 > 0) {
                n15 = nArray2[0] >> 1;
                n14 = nArray2[n16 - 1] >> 1;
                n13 = Math.max(n15, n7);
                n12 = Math.min(n14, n8);
                n10 = Math.min(n10, n13 >> this.SUBPIXEL_LG_POSITIONS_X);
                n9 = Math.max(n9, n12 >> this.SUBPIXEL_LG_POSITIONS_X);
            }
            n15 = 0;
            n14 = n7;
            for (n13 = 0; n13 < n16; ++n13) {
                int n17;
                int n18;
                int n19;
                n12 = nArray2[n13];
                int n20 = n12 >> 1;
                int n21 = n19 = (n12 & 1) == 1 ? 1 : -1;
                if ((n15 & n5) != 0 && (n18 = Math.max(n14, n7)) < (n17 = Math.min(n20, n8))) {
                    int n22 = (n18 -= n7) >> this.SUBPIXEL_LG_POSITIONS_X;
                    int n23 = (n17 -= n7) - 1 >> this.SUBPIXEL_LG_POSITIONS_X;
                    if (n22 == n23) {
                        int n24 = n22;
                        nArray[n24] = nArray[n24] + (n17 - n18);
                        int n25 = n22 + 1;
                        nArray[n25] = nArray[n25] - (n17 - n18);
                    } else {
                        int n26 = n17 >> this.SUBPIXEL_LG_POSITIONS_X;
                        int n27 = n22;
                        nArray[n27] = nArray[n27] + (this.SUBPIXEL_POSITIONS_X - (n18 & this.SUBPIXEL_MASK_X));
                        int n28 = n22 + 1;
                        nArray[n28] = nArray[n28] + (n18 & this.SUBPIXEL_MASK_X);
                        int n29 = n26;
                        nArray[n29] = nArray[n29] - (this.SUBPIXEL_POSITIONS_X - (n17 & this.SUBPIXEL_MASK_X));
                        int n30 = n26 + 1;
                        nArray[n30] = nArray[n30] - (n17 & this.SUBPIXEL_MASK_X);
                    }
                }
                n15 += n19;
                n14 = n20;
            }
            if ((n11 & this.SUBPIXEL_MASK_Y) != this.SUBPIXEL_MASK_Y) continue;
            this.emitRow(nArray, n11 >> this.SUBPIXEL_LG_POSITIONS_Y, n10, n9);
            n10 = Integer.MAX_VALUE;
            n9 = Integer.MIN_VALUE;
        }
        if (n9 >= n10) {
            this.emitRow(nArray, n11 >> this.SUBPIXEL_LG_POSITIONS_Y, n10, n9);
        }
    }

    public void endRendering() {
        int n = this.boundsMinX >> this.SUBPIXEL_LG_POSITIONS_X;
        int n2 = this.boundsMaxX >> this.SUBPIXEL_LG_POSITIONS_X;
        int n3 = this.boundsMinY >> this.SUBPIXEL_LG_POSITIONS_Y;
        int n4 = this.boundsMaxY >> this.SUBPIXEL_LG_POSITIONS_Y;
        int n5 = (int)Math.floor(this.edgeMinX) >> this.SUBPIXEL_LG_POSITIONS_X;
        int n6 = (int)Math.ceil(this.edgeMaxX) >> this.SUBPIXEL_LG_POSITIONS_X;
        int n7 = (int)Math.floor(this.edgeMinY) >> this.SUBPIXEL_LG_POSITIONS_Y;
        int n8 = (int)Math.ceil(this.edgeMaxY) >> this.SUBPIXEL_LG_POSITIONS_Y;
        int n9 = Math.max(n, n5);
        int n10 = Math.min(n2, n6);
        int n11 = Math.max(n3, n7);
        int n12 = Math.min(n4, n8);
        if (n9 > n10 || n11 > n12) {
            this.cache = new PiscesCache(n, n3, n2, n4);
            return;
        }
        this.cache = new PiscesCache(n9, n11, n10, n12);
        this._endRendering(n9, n11, n10, n12);
    }

    public PiscesCache getCache() {
        if (this.cache == null) {
            throw new InternalError("cache not yet initialized");
        }
        return this.cache;
    }

    private void emitRow(int[] nArray, int n, int n2, int n3) {
        if (this.cache != null && n3 >= n2) {
            this.cache.startRow(n, n2);
            int n4 = n2 - this.cache.bboxX0;
            int n5 = n3 - this.cache.bboxX0;
            int n6 = 1;
            int n7 = nArray[n4];
            for (int i = n4 + 1; i <= n5; ++i) {
                int n8 = n7 + nArray[i];
                if (n8 == n7) {
                    ++n6;
                    continue;
                }
                this.cache.addRLERun(n7, n6);
                n6 = 1;
                n7 = n8;
            }
            this.cache.addRLERun(n7, n6);
        }
        Arrays.fill(nArray, 0);
    }

    private class ScanlineIterator {
        private int[] crossings = new int[10];
        private int minY;
        private int maxY;
        private int nextY;
        private int elo;
        private int ehi;
        private final int[] edgePtrs;
        private int qlo;
        private int qhi;
        private final int[] quadPtrs;
        private int clo;
        private int chi;
        private final int[] curvePtrs;
        private static final int INIT_CROSSINGS_SIZE = 10;

        private ScanlineIterator() {
            this.edgePtrs = new int[Renderer.this.numEdges];
            Helpers.fillWithIdxes(this.edgePtrs, 6);
            Renderer.qsort(Renderer.this.edges, this.edgePtrs, 0, 0, Renderer.this.numEdges - 1);
            this.quadPtrs = new int[Renderer.this.numQuads];
            Helpers.fillWithIdxes(this.quadPtrs, 14);
            Renderer.qsort(Renderer.this.quads, this.quadPtrs, 0, 0, Renderer.this.numQuads - 1);
            this.curvePtrs = new int[Renderer.this.numCurves];
            Helpers.fillWithIdxes(this.curvePtrs, 16);
            Renderer.qsort(Renderer.this.curves, this.curvePtrs, 0, 0, Renderer.this.numCurves - 1);
            this.nextY = this.minY = Math.max(Renderer.this.boundsMinY, (int)Math.ceil(Renderer.this.edgeMinY));
            this.maxY = Math.min(Renderer.this.boundsMaxY, (int)Math.ceil(Renderer.this.edgeMaxY));
            this.elo = 0;
            while (this.elo < Renderer.this.numEdges && Renderer.this.edges[this.edgePtrs[this.elo] + 1] <= (float)this.minY) {
                ++this.elo;
            }
            this.ehi = this.elo;
            while (this.ehi < Renderer.this.numEdges && Renderer.this.edges[this.edgePtrs[this.ehi] + 0] <= (float)this.minY) {
                Renderer.this.edgeSetCurY(this.edgePtrs[this.ehi], this.minY);
                ++this.ehi;
            }
            this.qlo = 0;
            while (this.qlo < Renderer.this.numQuads && Renderer.this.quads[this.quadPtrs[this.qlo] + 1] <= (float)this.minY) {
                ++this.qlo;
            }
            this.qhi = this.qlo;
            while (this.qhi < Renderer.this.numQuads && Renderer.this.quads[this.quadPtrs[this.qhi] + 0] <= (float)this.minY) {
                Renderer.this.quadSetCurY(this.quadPtrs[this.qhi], this.minY);
                ++this.qhi;
            }
            this.clo = 0;
            while (this.clo < Renderer.this.numCurves && Renderer.this.curves[this.curvePtrs[this.clo] + 1] <= (float)this.minY) {
                ++this.clo;
            }
            this.chi = this.clo;
            while (this.chi < Renderer.this.numCurves && Renderer.this.curves[this.curvePtrs[this.chi] + 0] <= (float)this.minY) {
                Renderer.this.curveSetCurY(this.curvePtrs[this.chi], this.minY);
                ++this.chi;
            }
        }

        private int next() {
            int n;
            int n2;
            int n3 = 0;
            for (n2 = this.elo; n2 < this.ehi; ++n2) {
                if (!(Renderer.this.edges[this.edgePtrs[n2] + 1] <= (float)this.nextY)) continue;
                this.edgePtrs[n2] = this.edgePtrs[this.elo++];
            }
            for (n2 = this.qlo; n2 < this.qhi; ++n2) {
                if (!(Renderer.this.quads[this.quadPtrs[n2] + 1] <= (float)this.nextY)) continue;
                this.quadPtrs[n2] = this.quadPtrs[this.qlo++];
            }
            for (n2 = this.clo; n2 < this.chi; ++n2) {
                if (!(Renderer.this.curves[this.curvePtrs[n2] + 1] <= (float)this.nextY)) continue;
                this.curvePtrs[n2] = this.curvePtrs[this.clo++];
            }
            this.crossings = Helpers.widenArray(this.crossings, 0, this.ehi - this.elo + this.qhi - this.qlo + this.chi - this.clo);
            for (n2 = this.elo; n2 < this.ehi; ++n2) {
                n = this.edgePtrs[n2];
                this.addCrossing(this.nextY, (int)Renderer.this.edges[n + 2], Renderer.this.edges[n + 4], n3);
                Renderer.this.edgeGoToNextY(n);
                ++n3;
            }
            for (n2 = this.qlo; n2 < this.qhi; ++n2) {
                n = this.quadPtrs[n2];
                this.addCrossing(this.nextY, (int)Renderer.this.quads[n + 2], Renderer.this.quads[n + 4], n3);
                Renderer.this.quadGoToNextY(n);
                ++n3;
            }
            for (n2 = this.clo; n2 < this.chi; ++n2) {
                n = this.curvePtrs[n2];
                this.addCrossing(this.nextY, (int)Renderer.this.curves[n + 2], Renderer.this.curves[n + 4], n3);
                Renderer.this.curveGoToNextY(n);
                ++n3;
            }
            ++this.nextY;
            while (this.ehi < Renderer.this.numEdges && Renderer.this.edges[this.edgePtrs[this.ehi] + 0] <= (float)this.nextY) {
                Renderer.this.edgeSetCurY(this.edgePtrs[this.ehi], this.nextY);
                ++this.ehi;
            }
            while (this.qhi < Renderer.this.numQuads && Renderer.this.quads[this.quadPtrs[this.qhi] + 0] <= (float)this.nextY) {
                Renderer.this.quadSetCurY(this.quadPtrs[this.qhi], this.nextY);
                ++this.qhi;
            }
            while (this.chi < Renderer.this.numCurves && Renderer.this.curves[this.curvePtrs[this.chi] + 0] <= (float)this.nextY) {
                Renderer.this.curveSetCurY(this.curvePtrs[this.chi], this.nextY);
                ++this.chi;
            }
            Arrays.sort(this.crossings, 0, n3);
            return n3;
        }

        private boolean hasNext() {
            return this.nextY < this.maxY;
        }

        private int curY() {
            return this.nextY - 1;
        }

        private void addCrossing(int n, int n2, float f, int n3) {
            this.crossings[n3] = f > 0.0f ? n2 | 1 : (n2 <<= 1);
        }
    }
}

