/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.io.IOException;
import java.nio.file.FileRef;
import java.nio.file.spi.FileTypeDetector;
import java.util.Locale;

public abstract class AbstractFileTypeDetector
extends FileTypeDetector {
    private static final String TSPECIALS = "()<>@,;:/[]?=\\\"";

    protected AbstractFileTypeDetector() {
    }

    @Override
    public final String probeContentType(FileRef fileRef) throws IOException {
        if (fileRef == null) {
            throw new NullPointerException("'file' is null");
        }
        String string = this.implProbeContentType(fileRef);
        return string == null ? null : AbstractFileTypeDetector.parse(string);
    }

    protected abstract String implProbeContentType(FileRef var1) throws IOException;

    private static String parse(String string) {
        int n = string.indexOf(47);
        int n2 = string.indexOf(59);
        if (n < 0) {
            return null;
        }
        String string2 = string.substring(0, n).trim().toLowerCase(Locale.ENGLISH);
        if (!AbstractFileTypeDetector.isValidToken(string2)) {
            return null;
        }
        String string3 = n2 < 0 ? string.substring(n + 1) : string.substring(n + 1, n2);
        if (!AbstractFileTypeDetector.isValidToken(string3 = string3.trim().toLowerCase(Locale.ENGLISH))) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(string2.length() + string3.length() + 1);
        stringBuilder.append(string2);
        stringBuilder.append('/');
        stringBuilder.append(string3);
        return stringBuilder.toString();
    }

    private static boolean isTokenChar(char c) {
        return c > ' ' && c < '\u007f' && TSPECIALS.indexOf(c) < 0;
    }

    private static boolean isValidToken(String string) {
        int n = string.length();
        if (n == 0) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (AbstractFileTypeDetector.isTokenChar(string.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

