/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.debugger.cdbg.basic;

import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.cdbg.FieldIdentifier;
import sun.jvm.hotspot.debugger.cdbg.ObjectVisitor;
import sun.jvm.hotspot.debugger.cdbg.Type;
import sun.jvm.hotspot.debugger.cdbg.TypeVisitor;
import sun.jvm.hotspot.debugger.cdbg.basic.BasicCDebugInfoDataBase;
import sun.jvm.hotspot.debugger.cdbg.basic.BasicType;
import sun.jvm.hotspot.debugger.cdbg.basic.ResolveListener;
import sun.jvm.hotspot.utilities.Assert;

public class LazyType
extends BasicType {
    private Object key;
    private int cvAttributes;

    public LazyType(Object key) {
        this(key, 0);
    }

    private LazyType(Object key, int cvAttributes) {
        super(null, 0, cvAttributes);
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(key != null, "key must not be null");
        }
        this.key = key;
        this.cvAttributes = cvAttributes;
    }

    public boolean isLazy() {
        return true;
    }

    public Object getKey() {
        return this.key;
    }

    Type resolveTypes(BasicCDebugInfoDataBase db, ResolveListener listener) {
        BasicType t = (BasicType)db.resolveType(this, (Type)this, listener, "resolving lazy type");
        if (t.isLazy()) {
            return this;
        }
        if (this.cvAttributes != 0) {
            return t.getCVVariant(this.cvAttributes);
        }
        return t;
    }

    public void iterateObject(Address a, ObjectVisitor v, FieldIdentifier f) {
    }

    protected Type createCVVariant(int cvAttributes) {
        return new LazyType(this.key, cvAttributes);
    }

    public void visit(TypeVisitor v) {
    }
}

