/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import sun.jvm.hotspot.code.CodeBlob;
import sun.jvm.hotspot.code.CodeCacheVisitor;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.ui.HistoryComboBox;
import sun.jvm.hotspot.ui.ProgressBarPanel;
import sun.jvm.hotspot.ui.SAEditorPane;
import sun.jvm.hotspot.ui.SAPanel;
import sun.jvm.hotspot.utilities.AddressOps;

public class FindInCodeCachePanel
extends SAPanel {
    private Visitor iterator;
    private long usedSize;
    private long iterated;
    private Address value;
    private ProgressBarPanel progressBar;
    private HistoryComboBox addressField;
    private JButton findButton;
    private SAEditorPane contentEditor;

    public FindInCodeCachePanel() {
        this.setLayout(new BorderLayout());
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BoxLayout(topPanel, 1));
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(new JLabel("Address to search for:"));
        this.addressField = new HistoryComboBox();
        panel.add(this.addressField);
        this.iterator = new Visitor();
        this.findButton = new JButton("Find");
        ActionListener listener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FindInCodeCachePanel.this.iterator.search();
            }
        };
        panel.add(this.findButton);
        this.findButton.addActionListener(listener);
        this.addressField.addActionListener(listener);
        topPanel.add(panel);
        this.progressBar = new ProgressBarPanel(1, "Search progress:");
        topPanel.add(this.progressBar);
        this.add((Component)topPanel, "North");
        this.contentEditor = new SAEditorPane();
        HyperlinkListener hyperListener = new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent e) {
                String item;
                String description;
                int index;
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && (index = (description = e.getDescription()).indexOf(58)) != -1 && (item = description.substring(0, index)).equals("blob")) {
                    Address blob = VM.getVM().getDebugger().parseAddress(description.substring(index + 1));
                    FindInCodeCachePanel.this.showCodeViewer(blob);
                }
            }
        };
        this.contentEditor.addHyperlinkListener(hyperListener);
        JScrollPane scroller = new JScrollPane(this.contentEditor);
        this.add((Component)scroller, "Center");
    }

    private void reportResult(StringBuffer result, CodeBlob blob) {
        result.append("<a href='blob:");
        result.append(blob.contentBegin().toString());
        result.append("'>");
        result.append(blob.getName());
        result.append("@");
        result.append(blob.contentBegin());
        result.append("</a><br>");
    }

    private void clearResultWindow() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                FindInCodeCachePanel.this.contentEditor.setText("");
            }
        });
    }

    private void updateProgressBar(final StringBuffer result) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                FindInCodeCachePanel.this.progressBar.setValue((double)FindInCodeCachePanel.this.iterated / (double)FindInCodeCachePanel.this.usedSize);
                if (result != null) {
                    String s = "<html> <head> </head> <body>\n" + result + " </body> </html>";
                    FindInCodeCachePanel.this.contentEditor.setText(s);
                    FindInCodeCachePanel.this.findButton.setEnabled(true);
                }
            }
        });
    }

    class Visitor
    implements CodeCacheVisitor {
        Address base;
        StringBuffer result;
        boolean searching;

        Visitor() {
        }

        public void prologue(Address start, Address end) {
            this.searching = true;
            this.base = start;
            FindInCodeCachePanel.this.usedSize = end.minus(start);
            FindInCodeCachePanel.this.iterated = 0L;
            this.result = new StringBuffer();
            FindInCodeCachePanel.this.clearResultWindow();
        }

        public void visit(CodeBlob blob) {
            Address begin = blob.headerBegin();
            Address end = begin.addOffsetTo(blob.getSize());
            long addressSize = VM.getVM().getAddressSize();
            boolean found = false;
            while (!found && begin.lessThan(end)) {
                Address val = begin.getAddressAt(0L);
                if (AddressOps.equal(val, FindInCodeCachePanel.this.value)) {
                    FindInCodeCachePanel.this.reportResult(this.result, blob);
                    found = true;
                }
                begin = begin.addOffsetTo(addressSize);
            }
            FindInCodeCachePanel.this.iterated = end.minus(this.base);
            FindInCodeCachePanel.this.updateProgressBar(null);
        }

        public void epilogue() {
        }

        public void cleanup() {
            FindInCodeCachePanel.this.iterated = 0L;
            FindInCodeCachePanel.this.updateProgressBar(this.result);
            this.searching = false;
            this.result = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void search() {
            Address val = null;
            try {
                val = VM.getVM().getDebugger().parseAddress(FindInCodeCachePanel.this.addressField.getText());
            }
            catch (Exception ex) {
                FindInCodeCachePanel.this.contentEditor.setText("<b>Error parsing address</b>");
                return;
            }
            Visitor visitor = FindInCodeCachePanel.this.iterator;
            synchronized (visitor) {
                if (this.searching && ((Object)FindInCodeCachePanel.this.value).equals(val)) {
                    return;
                }
                FindInCodeCachePanel.this.value = val;
                FindInCodeCachePanel.this.contentEditor.setText("");
                FindInCodeCachePanel.this.findButton.setEnabled(false);
                System.out.println("Searching " + FindInCodeCachePanel.this.value);
                Thread t = new Thread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        Visitor visitor = FindInCodeCachePanel.this.iterator;
                        synchronized (visitor) {
                            try {
                                VM.getVM().getCodeCache().iterate(FindInCodeCachePanel.this.iterator);
                            }
                            finally {
                                FindInCodeCachePanel.this.iterator.cleanup();
                            }
                        }
                    }
                });
                t.start();
            }
        }
    }
}

