/*
 * Decompiled with CFR 0.152.
 */
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;

public class JDBCAdapter
extends AbstractTableModel {
    Connection connection;
    Statement statement;
    ResultSet resultSet;
    String[] columnNames = new String[0];
    Vector rows = new Vector();
    ResultSetMetaData metaData;

    public JDBCAdapter(String string, String string2, String string3, String string4) {
        try {
            Class.forName(string2);
            System.out.println("Opening db connection");
            this.connection = DriverManager.getConnection(string, string3, string4);
            this.statement = this.connection.createStatement();
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("Cannot find the database driver classes.");
            System.err.println(classNotFoundException);
        }
        catch (SQLException sQLException) {
            System.err.println("Cannot connect to this database.");
            System.err.println(sQLException);
        }
    }

    public void executeQuery(String string) {
        if (this.connection == null || this.statement == null) {
            System.err.println("There is no database to execute the query.");
            return;
        }
        try {
            this.resultSet = this.statement.executeQuery(string);
            this.metaData = this.resultSet.getMetaData();
            int n = this.metaData.getColumnCount();
            this.columnNames = new String[n];
            for (int i = 0; i < n; ++i) {
                this.columnNames[i] = this.metaData.getColumnLabel(i + 1);
            }
            this.rows = new Vector();
            while (this.resultSet.next()) {
                Vector<Object> vector = new Vector<Object>();
                for (int i = 1; i <= this.getColumnCount(); ++i) {
                    vector.addElement(this.resultSet.getObject(i));
                }
                this.rows.addElement(vector);
            }
            this.fireTableChanged(null);
        }
        catch (SQLException sQLException) {
            System.err.println(sQLException);
        }
    }

    public void close() throws SQLException {
        System.out.println("Closing db connection");
        this.resultSet.close();
        this.statement.close();
        this.connection.close();
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    @Override
    public String getColumnName(int n) {
        if (this.columnNames[n] != null) {
            return this.columnNames[n];
        }
        return "";
    }

    public Class getColumnClass(int n) {
        int n2;
        try {
            n2 = this.metaData.getColumnType(n + 1);
        }
        catch (SQLException sQLException) {
            return super.getColumnClass(n);
        }
        switch (n2) {
            case -1: 
            case 1: 
            case 12: {
                return String.class;
            }
            case -7: {
                return Boolean.class;
            }
            case -6: 
            case 4: 
            case 5: {
                return Integer.class;
            }
            case -5: {
                return Long.class;
            }
            case 6: 
            case 8: {
                return Double.class;
            }
            case 91: {
                return Date.class;
            }
        }
        return Object.class;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        try {
            return this.metaData.isWritable(n2 + 1);
        }
        catch (SQLException sQLException) {
            return false;
        }
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.rows.size();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        Vector vector = (Vector)this.rows.elementAt(n);
        return vector.elementAt(n2);
    }

    public String dbRepresentation(int n, Object object) {
        int n2;
        if (object == null) {
            return "null";
        }
        try {
            n2 = this.metaData.getColumnType(n + 1);
        }
        catch (SQLException sQLException) {
            return object.toString();
        }
        switch (n2) {
            case 4: 
            case 6: 
            case 8: {
                return object.toString();
            }
            case -7: {
                return (Boolean)object != false ? "1" : "0";
            }
            case 91: {
                return object.toString();
            }
        }
        return "\"" + object.toString() + "\"";
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        Object object2;
        try {
            object2 = this.metaData.getTableName(n2 + 1);
            if (object2 == null) {
                System.out.println("Table name returned null.");
            }
            String string = this.getColumnName(n2);
            String string2 = "update " + (String)object2 + " set " + string + " = " + this.dbRepresentation(n2, object) + " where ";
            for (int i = 0; i < this.getColumnCount(); ++i) {
                String string3 = this.getColumnName(i);
                if (string3.equals("")) continue;
                if (i != 0) {
                    string2 = string2 + " and ";
                }
                string2 = string2 + string3 + " = " + this.dbRepresentation(i, this.getValueAt(n, i));
            }
            System.out.println(string2);
            System.out.println("Not sending update to database");
        }
        catch (SQLException sQLException) {
            System.err.println("Update failed");
        }
        object2 = (Vector)this.rows.elementAt(n);
        ((Vector)object2).setElementAt(object, n2);
    }
}

