/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.downloadtasks;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Future;
import java.util.logging.Logger;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.downloadtasks.AbstractDownloadTask;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.DataSource;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.BoundingBoxDownloader;
import org.openstreetmap.josm.io.OsmServerLocationReader;
import org.openstreetmap.josm.io.OsmServerReader;
import org.openstreetmap.josm.io.OsmTransferCancelledException;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DownloadOsmTask
extends AbstractDownloadTask {
    private static final Logger logger = Logger.getLogger(DownloadOsmTask.class.getName());
    private Bounds currentBounds;
    private DataSet downloadedData;
    private DownloadTask downloadTask;

    private void rememberDownloadedData(DataSet ds) {
        this.downloadedData = ds;
    }

    public DataSet getDownloadedData() {
        return this.downloadedData;
    }

    @Override
    public Future<?> download(boolean newLayer, Bounds downloadArea, ProgressMonitor progressMonitor) {
        this.downloadTask = new DownloadTask(newLayer, new BoundingBoxDownloader(downloadArea), progressMonitor);
        this.currentBounds = new Bounds(downloadArea);
        return Main.worker.submit(this.downloadTask);
    }

    @Override
    public Future<?> loadUrl(boolean new_layer, String url, ProgressMonitor progressMonitor) {
        this.downloadTask = new DownloadTask(new_layer, new OsmServerLocationReader(url), progressMonitor);
        this.currentBounds = null;
        return Main.worker.submit(this.downloadTask);
    }

    @Override
    public void cancel() {
        if (this.downloadTask != null) {
            this.downloadTask.cancel();
        }
    }

    private class DownloadTask
    extends PleaseWaitRunnable {
        private OsmServerReader reader;
        private DataSet dataSet;
        private boolean newLayer;

        public DownloadTask(boolean newLayer, OsmServerReader reader, ProgressMonitor progressMonitor) {
            super(I18n.tr("Downloading data"), progressMonitor, false);
            this.reader = reader;
            this.newLayer = newLayer;
        }

        public void realRun() throws IOException, SAXException, OsmTransferException {
            try {
                if (DownloadOsmTask.this.isCanceled()) {
                    return;
                }
                this.dataSet = this.reader.parseOsm(this.progressMonitor.createSubTaskMonitor(-1, false));
            }
            catch (Exception e) {
                if (DownloadOsmTask.this.isCanceled()) {
                    logger.warning(I18n.tr("Ignoring exception because download has been cancelled. Exception was: {0}", e.toString()));
                    return;
                }
                if (e instanceof OsmTransferCancelledException) {
                    DownloadOsmTask.this.setCanceled(true);
                    return;
                }
                if (e instanceof OsmTransferException) {
                    DownloadOsmTask.this.rememberException(e);
                } else {
                    DownloadOsmTask.this.rememberException(new OsmTransferException(e));
                }
                DownloadOsmTask.this.setFailed(true);
            }
        }

        protected OsmDataLayer getEditLayer() {
            if (!Main.isDisplayingMapView()) {
                return null;
            }
            return Main.map.mapView.getEditLayer();
        }

        protected int getNumDataLayers() {
            int count = 0;
            if (!Main.isDisplayingMapView()) {
                return 0;
            }
            Collection<Layer> layers = Main.map.mapView.getAllLayers();
            for (Layer layer : layers) {
                if (!(layer instanceof OsmDataLayer)) continue;
                ++count;
            }
            return count;
        }

        protected OsmDataLayer getFirstDataLayer() {
            if (!Main.isDisplayingMapView()) {
                return null;
            }
            List<Layer> layers = Main.map.mapView.getAllLayersAsList();
            for (Layer layer : layers) {
                if (!(layer instanceof OsmDataLayer)) continue;
                return (OsmDataLayer)layer;
            }
            return null;
        }

        protected void finish() {
            if (DownloadOsmTask.this.isFailed() || DownloadOsmTask.this.isCanceled()) {
                return;
            }
            if (this.dataSet == null) {
                return;
            }
            if (this.dataSet.allPrimitives().isEmpty()) {
                DownloadOsmTask.this.rememberErrorMessage(I18n.tr("No data found in this area."));
                this.dataSet.dataSources.add(new DataSource(DownloadOsmTask.this.currentBounds != null ? DownloadOsmTask.this.currentBounds : new Bounds(new LatLon(0.0, 0.0)), "OpenStreetMap server"));
            }
            DownloadOsmTask.this.rememberDownloadedData(this.dataSet);
            int numDataLayers = this.getNumDataLayers();
            if (this.newLayer || numDataLayers == 0 || numDataLayers > 1 && this.getEditLayer() == null) {
                OsmDataLayer layer = new OsmDataLayer(this.dataSet, OsmDataLayer.createNewName(), null);
                boolean isDisplayingMapView = Main.isDisplayingMapView();
                Main.main.addLayer(layer);
                if (isDisplayingMapView) {
                    BoundingXYVisitor v = new BoundingXYVisitor();
                    if (DownloadOsmTask.this.currentBounds != null) {
                        v.visit(DownloadOsmTask.this.currentBounds);
                    } else {
                        v.computeBoundingBox(this.dataSet.getNodes());
                    }
                    Main.map.mapView.recalculateCenterScale(v);
                }
            } else {
                OsmDataLayer target = this.getEditLayer();
                if (target == null) {
                    target = this.getFirstDataLayer();
                }
                target.mergeFrom(this.dataSet);
                BoundingXYVisitor v = new BoundingXYVisitor();
                if (DownloadOsmTask.this.currentBounds != null) {
                    v.visit(DownloadOsmTask.this.currentBounds);
                } else {
                    v.computeBoundingBox(this.dataSet.getNodes());
                }
                Main.map.mapView.recalculateCenterScale(v);
                target.onPostDownloadFromServer();
            }
        }

        protected void cancel() {
            DownloadOsmTask.this.setCanceled(true);
            if (this.reader != null) {
                this.reader.cancel();
            }
        }
    }
}

