/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.mapmode;

import java.awt.AWTEvent;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.Collections;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.DeleteCommand;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.dialogs.relation.RelationDialogManager;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;

public class DeleteAction
extends MapMode
implements AWTEventListener {
    private boolean drawTargetCursor;
    private MouseEvent oldEvent = null;
    private DeleteMode currentMode = DeleteMode.none;

    public DeleteAction(MapFrame mapFrame) {
        super(I18n.tr("Delete Mode"), "delete", I18n.tr("Delete nodes or ways."), Shortcut.registerShortcut("mapmode:delete", I18n.tr("Mode: {0}", I18n.tr("Delete")), 68, 3), mapFrame, ImageProvider.getCursor("normal", "delete"));
    }

    public void enterMode() {
        super.enterMode();
        if (!this.isEnabled()) {
            return;
        }
        this.drawTargetCursor = Main.pref.getBoolean("draw.target-cursor", true);
        Main.map.mapView.addMouseListener(this);
        Main.map.mapView.addMouseMotionListener(this);
        try {
            Toolkit.getDefaultToolkit().addAWTEventListener(this, 8L);
        }
        catch (SecurityException ex) {
            System.out.println(ex);
        }
        this.currentMode = DeleteMode.none;
    }

    public void exitMode() {
        super.exitMode();
        Main.map.mapView.removeMouseListener(this);
        Main.map.mapView.removeMouseMotionListener(this);
        try {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this);
        }
        catch (SecurityException ex) {
            System.out.println(ex);
        }
    }

    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        if (!Main.map.mapView.isActiveLayerDrawable()) {
            return;
        }
        this.doActionPerformed(e);
    }

    public void doActionPerformed(ActionEvent e) {
        boolean alt;
        if (!Main.map.mapView.isActiveLayerDrawable()) {
            return;
        }
        boolean ctrl = (e.getModifiers() & 2) != 0;
        boolean bl = alt = (e.getModifiers() & 0x28) != 0;
        Command c = ctrl ? DeleteCommand.deleteWithReferences(this.getEditLayer(), this.getCurrentDataSet().getSelected()) : DeleteCommand.delete(this.getEditLayer(), this.getCurrentDataSet().getSelected(), !alt);
        if (c != null) {
            Main.main.undoRedo.add(c);
        }
        this.getCurrentDataSet().setSelected(new PrimitiveId[0]);
        Main.map.repaint();
    }

    public void mouseDragged(MouseEvent e) {
        this.mouseMoved(e);
    }

    public void mouseMoved(MouseEvent e) {
        this.oldEvent = e;
        this.updateCursor(e, e.getModifiers());
    }

    private void updateCursor(MouseEvent e, int modifiers) {
        if (!Main.isDisplayingMapView()) {
            return;
        }
        if (!Main.map.mapView.isActiveLayerVisible() || e == null) {
            return;
        }
        DeleteParameters parameters = this.getDeleteParameters(e, modifiers);
        this.setCursor(parameters.mode);
    }

    public void mouseReleased(MouseEvent e) {
        if (e.getButton() != 1) {
            return;
        }
        if (!Main.map.mapView.isActiveLayerVisible()) {
            return;
        }
        Main.map.mapView.requestFocus();
        Command c = this.buildDeleteCommands(e, e.getModifiers(), false);
        if (c != null) {
            Main.main.undoRedo.add(c);
        }
        this.getCurrentDataSet().setSelected(new PrimitiveId[0]);
        Main.map.mapView.repaint();
    }

    public String getModeHelpText() {
        return I18n.tr("Click to delete. Shift: delete way segment. Alt: do not delete unused nodes when deleting a way. Ctrl: delete referring objects.");
    }

    public boolean layerIsSupported(Layer l) {
        return l instanceof OsmDataLayer;
    }

    protected void updateEnabledState() {
        this.setEnabled(Main.map != null && Main.map.mapView != null && Main.map.mapView.isActiveLayerDrawable());
    }

    public static void deleteRelation(OsmDataLayer layer, Relation toDelete) {
        CheckParameterUtil.ensureParameterNotNull(layer, "layer");
        CheckParameterUtil.ensureParameterNotNull(toDelete, "toDelete");
        Command cmd = DeleteCommand.delete(layer, Collections.singleton(toDelete));
        if (cmd != null) {
            Main.main.undoRedo.add(cmd);
            RelationDialogManager.getRelationDialogManager().close(layer, toDelete);
        }
    }

    private DeleteParameters getDeleteParameters(MouseEvent e, int modifiers) {
        boolean ctrl = (modifiers & 2) != 0;
        boolean shift = (modifiers & 1) != 0;
        boolean alt = (modifiers & 0x28) != 0;
        DeleteParameters result = new DeleteParameters();
        result.nearestNode = Main.map.mapView.getNearestNode(e.getPoint(), OsmPrimitive.isSelectablePredicate);
        if (result.nearestNode == null) {
            result.nearestSegment = Main.map.mapView.getNearestWaySegment(e.getPoint(), OsmPrimitive.isSelectablePredicate);
            result.mode = result.nearestSegment != null ? (shift ? DeleteMode.segment : (ctrl ? DeleteMode.way_with_references : (alt ? DeleteMode.way : DeleteMode.way_with_nodes))) : DeleteMode.none;
        } else {
            result.mode = ctrl ? DeleteMode.node_with_references : DeleteMode.node;
        }
        return result;
    }

    private Command buildDeleteCommands(MouseEvent e, int modifiers, boolean silent) {
        DeleteParameters parameters = this.getDeleteParameters(e, modifiers);
        switch (parameters.mode) {
            case node: {
                return DeleteCommand.delete(this.getEditLayer(), Collections.singleton(parameters.nearestNode), false, silent);
            }
            case node_with_references: {
                return DeleteCommand.deleteWithReferences(this.getEditLayer(), Collections.singleton(parameters.nearestNode));
            }
            case segment: {
                return DeleteCommand.deleteWaySegment(this.getEditLayer(), parameters.nearestSegment);
            }
            case way: {
                return DeleteCommand.delete(this.getEditLayer(), Collections.singleton(parameters.nearestSegment.way), false, silent);
            }
            case way_with_nodes: {
                return DeleteCommand.delete(this.getEditLayer(), Collections.singleton(parameters.nearestSegment.way), true, silent);
            }
            case way_with_references: {
                return DeleteCommand.deleteWithReferences(this.getEditLayer(), Collections.singleton(parameters.nearestSegment.way), true);
            }
        }
        return null;
    }

    private void setCursor(final DeleteMode c) {
        if (this.currentMode.equals((Object)c) || !this.drawTargetCursor && this.currentMode.equals((Object)DeleteMode.none)) {
            return;
        }
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                if (!(Main.map.mapMode instanceof DeleteAction)) {
                    return;
                }
                Main.map.mapView.setCursor(c.cursor());
            }
        });
        this.currentMode = c;
    }

    public void eventDispatched(AWTEvent e) {
        this.updateCursor(this.oldEvent, ((InputEvent)e).getModifiers());
    }

    private static class DeleteParameters {
        DeleteMode mode;
        Node nearestNode;
        WaySegment nearestSegment;

        private DeleteParameters() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum DeleteMode {
        none("delete"),
        segment("delete_segment"),
        node("delete_node"),
        node_with_references("delete_node"),
        way("delete_way_only"),
        way_with_references("delete_way_normal"),
        way_with_nodes("delete_way_node_only");

        private final Cursor c;

        private DeleteMode(String cursorName) {
            this.c = ImageProvider.getCursor("normal", cursorName);
        }

        public Cursor cursor() {
            return this.c;
        }
    }
}

