/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.oauth;

import oauth.signpost.OAuthConsumer;
import org.openstreetmap.josm.tools.CheckParameterUtil;

public class OAuthToken {
    private String key;
    private String secret;

    public static OAuthToken createToken(OAuthConsumer consumer) {
        return new OAuthToken(consumer.getToken(), consumer.getTokenSecret());
    }

    public OAuthToken(String key, String secret) {
        this.key = key;
        this.secret = secret;
    }

    public OAuthToken(OAuthToken other) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull(other, "other");
        this.key = other.key;
        this.secret = other.secret;
    }

    public String getKey() {
        return this.key;
    }

    public String getSecret() {
        return this.secret;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
        result = 31 * result + (this.secret == null ? 0 : this.secret.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OAuthToken other = (OAuthToken)obj;
        if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
            return false;
        }
        return !(this.secret == null ? other.secret != null : !this.secret.equals(other.secret));
    }
}

