/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.text.MessageFormat;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.data.osm.UserInfo;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;

public class JosmUserIdentityManager
implements Preferences.PreferenceChangedListener {
    private static JosmUserIdentityManager instance;
    private String userName;
    private UserInfo userInfo;

    public static JosmUserIdentityManager getInstance() {
        if (instance == null) {
            instance = new JosmUserIdentityManager();
            instance.initFromPreferences();
            Main.pref.addPreferenceChangeListener(instance);
        }
        return instance;
    }

    private JosmUserIdentityManager() {
    }

    public void setAnonymous() {
        this.userName = null;
        this.userInfo = null;
    }

    public void setPartiallyIdentified(String userName) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull(userName, "userName");
        if (userName.trim().equals("")) {
            throw new IllegalArgumentException(MessageFormat.format("Expected non-empty value for parameter ''{0}'', got ''{1}''", "userName", userName));
        }
        this.userName = userName;
        this.userInfo = null;
    }

    public void setFullyIdentified(String username, UserInfo userinfo) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull(username, "username");
        if (username.trim().equals("")) {
            throw new IllegalArgumentException(I18n.tr("Expected non-empty value for parameter ''{0}'', got ''{1}''", "userName", this.userName));
        }
        CheckParameterUtil.ensureParameterNotNull(userinfo, "userinfo");
        this.userName = username;
        this.userInfo = userinfo;
    }

    public boolean isAnonymous() {
        return this.userName == null && this.userInfo == null;
    }

    public boolean isPartiallyIdentified() {
        return this.userName != null && this.userInfo == null;
    }

    public boolean isFullyIdentified() {
        return this.userName != null && this.userInfo != null;
    }

    public String getUserName() {
        return this.userName;
    }

    public int getUserId() {
        if (this.userInfo == null) {
            return 0;
        }
        return this.userInfo.getId();
    }

    public UserInfo getUserInfo() {
        return this.userInfo;
    }

    public void initFromPreferences() {
        String userName = Main.pref.get("osm-server.username");
        if (this.isAnonymous()) {
            if (userName != null && !userName.trim().equals("")) {
                this.setPartiallyIdentified(userName);
            }
        } else if (!userName.equals(this.userName)) {
            this.setPartiallyIdentified(userName);
        }
    }

    public boolean isCurrentUser(String username) {
        if (username == null || this.userName == null) {
            return false;
        }
        return this.userName.equals(username);
    }

    public void preferenceChanged(Preferences.PreferenceChangeEvent evt) {
        if (evt.getKey().equals("osm-server.username")) {
            String newValue = evt.getNewValue();
            if (newValue == null || newValue.trim().length() == 0) {
                this.setAnonymous();
            } else if (!newValue.equals(this.userName)) {
                this.setPartiallyIdentified(newValue);
            }
            return;
        }
        if (evt.getKey().equals("osm-server.url")) {
            String newValue = evt.getNewValue();
            if (newValue == null || newValue.trim().equals("")) {
                this.setAnonymous();
            } else if (this.isFullyIdentified()) {
                this.setPartiallyIdentified(this.getUserName());
            }
        }
    }
}

