/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.LinkedList;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.NavigatableComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectionManager
implements MouseListener,
MouseMotionListener,
PropertyChangeListener {
    private final SelectionEnded selectionEndedListener;
    private Point mousePosStart;
    private Point mousePos;
    private final NavigatableComponent nc;
    private boolean aspectRatio;

    public SelectionManager(SelectionEnded selectionEndedListener, boolean aspectRatio, NavigatableComponent navComp) {
        this.selectionEndedListener = selectionEndedListener;
        this.aspectRatio = aspectRatio;
        this.nc = navComp;
    }

    public void register(NavigatableComponent eventSource) {
        eventSource.addMouseListener(this);
        eventSource.addMouseMotionListener(this);
        this.selectionEndedListener.addPropertyChangeListener(this);
        eventSource.addPropertyChangeListener("scale", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (SelectionManager.this.mousePosStart != null) {
                    SelectionManager.this.paintRect();
                    SelectionManager.this.mousePos = (SelectionManager.this.mousePosStart = null);
                }
            }
        });
    }

    public void unregister(Component eventSource) {
        eventSource.removeMouseListener(this);
        eventSource.removeMouseMotionListener(this);
        this.selectionEndedListener.removePropertyChangeListener(this);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getButton() == 1) {
            this.mousePosStart = this.mousePos = e.getPoint();
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        int buttonPressed = e.getModifiersEx() & 0x1400;
        if (buttonPressed != 0) {
            if (this.mousePosStart == null) {
                this.mousePosStart = this.mousePos = e.getPoint();
            }
            this.paintRect();
        }
        if (buttonPressed == 1024) {
            this.mousePos = e.getPoint();
            this.paintRect();
        } else if (buttonPressed == 5120) {
            this.mousePosStart.x += e.getX() - this.mousePos.x;
            this.mousePosStart.y += e.getY() - this.mousePos.y;
            this.mousePos = e.getPoint();
            this.paintRect();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        boolean ctrl;
        if (e.getButton() != 1) {
            return;
        }
        if (this.mousePos == null || this.mousePosStart == null) {
            return;
        }
        this.paintRect();
        Rectangle r = this.getSelectionRectangle();
        this.mousePosStart = null;
        this.mousePos = null;
        boolean shift = (e.getModifiersEx() & 0x40) != 0;
        boolean alt = (e.getModifiersEx() & 0x2200) != 0;
        boolean bl = ctrl = (e.getModifiersEx() & 0x80) != 0;
        if ((e.getModifiersEx() & 0x1000) == 0) {
            this.selectionEndedListener.selectionEnded(r, alt, shift, ctrl);
        }
    }

    private void paintRect() {
        if (this.mousePos == null || this.mousePosStart == null || this.mousePos == this.mousePosStart) {
            return;
        }
        Graphics g = this.nc.getGraphics();
        g.setColor(Color.BLACK);
        g.setXORMode(Color.WHITE);
        Rectangle r = this.getSelectionRectangle();
        g.drawRect(r.x, r.y, r.width, r.height);
    }

    private Rectangle getSelectionRectangle() {
        int x = this.mousePosStart.x;
        int y = this.mousePosStart.y;
        int w = this.mousePos.x - this.mousePosStart.x;
        int h = this.mousePos.y - this.mousePosStart.y;
        if (w < 0) {
            x += w;
            w = -w;
        }
        if (h < 0) {
            y += h;
            h = -h;
        }
        if (this.aspectRatio) {
            double aspectRatio = (double)this.nc.getWidth() / (double)this.nc.getHeight();
            if ((double)w / (double)h < aspectRatio) {
                int neww = (int)((double)h * aspectRatio);
                if (this.mousePos.x < this.mousePosStart.x) {
                    x += w - neww;
                }
                w = neww;
            } else {
                int newh = (int)((double)w / aspectRatio);
                if (this.mousePos.y < this.mousePosStart.y) {
                    y += h - newh;
                }
                h = newh;
            }
        }
        return new Rectangle(x, y, w, h);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("active") && !((Boolean)evt.getNewValue()).booleanValue() && this.mousePosStart != null) {
            this.paintRect();
            this.mousePosStart = null;
            this.mousePos = null;
        }
    }

    public Collection<OsmPrimitive> getObjectsInRectangle(Rectangle r, boolean alt) {
        LinkedList<OsmPrimitive> selection = new LinkedList<OsmPrimitive>();
        boolean clicked = r.width <= 2 && r.height <= 2;
        Point center = new Point(r.x + r.width / 2, r.y + r.height / 2);
        if (clicked) {
            OsmPrimitive osm = this.nc.getNearest(center, OsmPrimitive.isSelectablePredicate);
            if (osm != null) {
                selection.add(osm);
            }
        } else {
            for (Node n : this.nc.getCurrentDataSet().getNodes()) {
                if (!n.isSelectable() || !r.contains(this.nc.getPoint(n))) continue;
                selection.add(n);
            }
            block1: for (Way w : this.nc.getCurrentDataSet().getWays()) {
                if (!w.isSelectable() || w.getNodesCount() == 0) continue;
                if (alt) {
                    for (Node n : w.getNodes()) {
                        if (n.isIncomplete() || !r.contains(this.nc.getPoint(n))) continue;
                        selection.add(w);
                        continue block1;
                    }
                    continue;
                }
                boolean allIn = true;
                for (Node n : w.getNodes()) {
                    if (n.isIncomplete() || r.contains(this.nc.getPoint(n))) continue;
                    allIn = false;
                    break;
                }
                if (!allIn) continue;
                selection.add(w);
            }
        }
        return selection;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    public static interface SelectionEnded {
        public void selectionEnded(Rectangle var1, boolean var2, boolean var3, boolean var4);

        public void addPropertyChangeListener(PropertyChangeListener var1);

        public void removePropertyChangeListener(PropertyChangeListener var1);
    }
}

