/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.AbstractAction;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.conflict.Conflict;
import org.openstreetmap.josm.data.conflict.ConflictCollection;
import org.openstreetmap.josm.data.conflict.IConflictListener;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.AbstractVisitor;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.gui.OsmPrimitivRenderer;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.dialogs.ConflictResolutionDialog;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConflictDialog
extends ToggleDialog
implements MapView.EditLayerChangeListener,
IConflictListener,
SelectionChangedListener {
    private ConflictCollection conflicts;
    private ConflictListModel model;
    private JList lstConflicts;
    private ResolveAction actResolve;
    private SelectAction actSelect;

    public static Color getColor() {
        return Main.pref.getColor(I18n.marktr("conflict"), Color.gray);
    }

    protected void build() {
        this.model = new ConflictListModel();
        this.lstConflicts = new JList(this.model);
        this.lstConflicts.setSelectionMode(2);
        this.lstConflicts.setCellRenderer(new OsmPrimitivRenderer());
        this.lstConflicts.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() >= 2) {
                    ConflictDialog.this.resolve();
                }
            }
        });
        this.lstConflicts.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                Main.map.mapView.repaint();
            }
        });
        this.add((Component)new JScrollPane(this.lstConflicts), "Center");
        this.actResolve = new ResolveAction();
        SideButton btnResolve = new SideButton(this.actResolve);
        this.lstConflicts.getSelectionModel().addListSelectionListener(this.actResolve);
        this.actSelect = new SelectAction();
        SideButton btnSelect = new SideButton(this.actSelect);
        this.lstConflicts.getSelectionModel().addListSelectionListener(this.actSelect);
        JPanel buttonPanel = this.getButtonPanel(2);
        buttonPanel.add(btnResolve);
        buttonPanel.add(btnSelect);
        this.add((Component)buttonPanel, "South");
    }

    public ConflictDialog() {
        super(I18n.tr("Conflict"), "conflict", I18n.tr("Resolve conflicts."), Shortcut.registerShortcut("subwindow:conflict", I18n.tr("Toggle: {0}", I18n.tr("Conflict")), 67, 4), 100);
        this.build();
        this.refreshView();
    }

    @Override
    public void showNotify() {
        DataSet.addSelectionListener(this);
        MapView.addEditLayerChangeListener(this, true);
        this.refreshView();
    }

    @Override
    public void hideNotify() {
        MapView.removeEditLayerChangeListener(this);
        DataSet.removeSelectionListener(this);
    }

    private final void resolve() {
        if (this.conflicts == null || this.model.getSize() == 0) {
            return;
        }
        int index = this.lstConflicts.getSelectedIndex();
        if (index < 0) {
            index = 0;
        }
        Conflict<?> c = this.conflicts.get(index);
        ConflictResolutionDialog dialog = new ConflictResolutionDialog(Main.parent);
        dialog.getConflictResolver().populate(c);
        dialog.setVisible(true);
        this.lstConflicts.setSelectedIndex(index);
        Main.map.mapView.repaint();
    }

    public final void refreshView() {
        OsmDataLayer editLayer = Main.main.getEditLayer();
        this.conflicts = editLayer == null ? new ConflictCollection() : editLayer.getConflicts();
        this.model.fireContentChanged();
        this.updateTitle(this.conflicts.size());
    }

    private void updateTitle(int conflictsCount) {
        if (conflictsCount > 0) {
            this.setTitle(I18n.tr("Conflicts: {0} unresolved", this.conflicts.size()));
        } else {
            this.setTitle(I18n.tr("Conflict"));
        }
    }

    public void paintConflicts(final Graphics g, final NavigatableComponent nc) {
        Color preferencesColor = ConflictDialog.getColor();
        if (preferencesColor.equals(Main.pref.getColor(I18n.marktr("background"), Color.black))) {
            return;
        }
        g.setColor(preferencesColor);
        AbstractVisitor conflictPainter = new AbstractVisitor(){

            public void visit(Node n) {
                Point p = nc.getPoint(n);
                g.drawRect(p.x - 1, p.y - 1, 2, 2);
            }

            public void visit(Node n1, Node n2) {
                Point p1 = nc.getPoint(n1);
                Point p2 = nc.getPoint(n2);
                g.drawLine(p1.x, p1.y, p2.x, p2.y);
            }

            public void visit(Way w) {
                Node lastN = null;
                for (Node n : w.getNodes()) {
                    if (lastN == null) {
                        lastN = n;
                        continue;
                    }
                    this.visit(lastN, n);
                    lastN = n;
                }
            }

            public void visit(Relation e) {
                for (RelationMember em : e.getMembers()) {
                    em.getMember().visit(this);
                }
            }
        };
        for (Object o : this.lstConflicts.getSelectedValues()) {
            if (this.conflicts == null || !this.conflicts.hasConflictForMy((OsmPrimitive)o)) continue;
            ((OsmPrimitive)this.conflicts.getConflictForMy((OsmPrimitive)o).getTheir()).visit(conflictPainter);
        }
    }

    @Override
    public void editLayerChanged(OsmDataLayer oldLayer, OsmDataLayer newLayer) {
        if (oldLayer != null) {
            oldLayer.getConflicts().removeConflictListener(this);
        }
        if (newLayer != null) {
            newLayer.getConflicts().addConflictListener(this);
        }
        this.refreshView();
    }

    public ConflictCollection getConflicts() {
        return this.conflicts;
    }

    @Override
    public void onConflictsAdded(ConflictCollection conflicts) {
        this.refreshView();
    }

    @Override
    public void onConflictsRemoved(ConflictCollection conflicts) {
        System.err.println("1 conflict has been resolved.");
        this.refreshView();
    }

    @Override
    public void selectionChanged(Collection<? extends OsmPrimitive> newSelection) {
        this.lstConflicts.clearSelection();
        for (OsmPrimitive osmPrimitive : newSelection) {
            int pos;
            if (this.conflicts == null || !this.conflicts.hasConflictForMy(osmPrimitive) || (pos = this.model.indexOf(osmPrimitive)) < 0) continue;
            this.lstConflicts.addSelectionInterval(pos, pos);
        }
    }

    @Override
    public String helpTopic() {
        return "Dialogs/ConflictListDialog";
    }

    class SelectAction
    extends AbstractAction
    implements ListSelectionListener {
        public SelectAction() {
            this.putValue("Name", I18n.tr("Select"));
            this.putValue("ShortDescription", I18n.tr("Set the selected elements on the map to the selected items in the list above."));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "select"));
            this.putValue("help", "Dialogs/ConflictListDialog#SelectAction");
        }

        public void actionPerformed(ActionEvent e) {
            LinkedList<OsmPrimitive> sel = new LinkedList<OsmPrimitive>();
            for (Object o : ConflictDialog.this.lstConflicts.getSelectedValues()) {
                sel.add((OsmPrimitive)o);
            }
            Main.main.getCurrentDataSet().setSelected(sel);
        }

        public void valueChanged(ListSelectionEvent e) {
            ListSelectionModel model = (ListSelectionModel)e.getSource();
            boolean enabled = model.getMinSelectionIndex() >= 0 && model.getMaxSelectionIndex() >= model.getMinSelectionIndex();
            this.setEnabled(enabled);
        }
    }

    class ResolveAction
    extends AbstractAction
    implements ListSelectionListener {
        public ResolveAction() {
            this.putValue("Name", I18n.tr("Resolve"));
            this.putValue("ShortDescription", I18n.tr("Open a merge dialog of all selected items in the list above."));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "conflict"));
            this.putValue("help", "Dialogs/ConflictListDialog#ResolveAction");
        }

        public void actionPerformed(ActionEvent e) {
            ConflictDialog.this.resolve();
        }

        public void valueChanged(ListSelectionEvent e) {
            ListSelectionModel model = (ListSelectionModel)e.getSource();
            boolean enabled = model.getMinSelectionIndex() >= 0 && model.getMaxSelectionIndex() >= model.getMinSelectionIndex();
            this.setEnabled(enabled);
        }
    }

    class ConflictListModel
    implements ListModel {
        private CopyOnWriteArrayList<ListDataListener> listeners = new CopyOnWriteArrayList();

        public void addListDataListener(ListDataListener l) {
            if (l != null) {
                this.listeners.addIfAbsent(l);
            }
        }

        public void removeListDataListener(ListDataListener l) {
            this.listeners.remove(l);
        }

        protected void fireContentChanged() {
            ListDataEvent evt = new ListDataEvent(this, 0, 0, this.getSize());
            Iterator<ListDataListener> it = this.listeners.iterator();
            while (it.hasNext()) {
                it.next().contentsChanged(evt);
            }
        }

        public Object getElementAt(int index) {
            if (index < 0) {
                return null;
            }
            if (index >= this.getSize()) {
                return null;
            }
            return ConflictDialog.this.conflicts.get(index).getMy();
        }

        public int getSize() {
            if (ConflictDialog.this.conflicts == null) {
                return 0;
            }
            return ConflictDialog.this.conflicts.size();
        }

        public int indexOf(OsmPrimitive my) {
            if (ConflictDialog.this.conflicts == null) {
                return -1;
            }
            for (int i = 0; i < ConflictDialog.this.conflicts.size(); ++i) {
                if (!ConflictDialog.this.conflicts.get(i).isMatchingMy(my)) continue;
                return i;
            }
            return -1;
        }

        public OsmPrimitive get(int idx) {
            if (ConflictDialog.this.conflicts == null) {
                return null;
            }
            return ConflictDialog.this.conflicts.get(idx).getMy();
        }
    }
}

