/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.DuplicateLayerAction;
import org.openstreetmap.josm.actions.MergeLayerAction;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.dialogs.LayerListPopup;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.io.SaveLayersDialog;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.widgets.PopupMenuLauncher;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;

public class LayerListDialog
extends ToggleDialog {
    private static LayerListDialog instance;
    private LayerListModel model;
    private DefaultListSelectionModel selectionModel = new DefaultListSelectionModel();
    private LayerList layerList;
    ActivateLayerAction activateLayerAction;

    public static void createInstance(MapFrame mapFrame) {
        if (instance != null) {
            throw new IllegalStateException("Dialog was already created");
        }
        instance = new LayerListDialog(mapFrame);
    }

    public static LayerListDialog getInstance() throws IllegalStateException {
        if (instance == null) {
            throw new IllegalStateException("Dialog not created yet. Invoke createInstance() first");
        }
        return instance;
    }

    protected JPanel createButtonPanel() {
        JPanel buttonPanel = this.getButtonPanel(5);
        MoveUpAction moveUpAction = new MoveUpAction();
        this.adaptTo((IEnabledStateUpdating)moveUpAction, this.model);
        this.adaptTo((IEnabledStateUpdating)moveUpAction, this.selectionModel);
        buttonPanel.add(new SideButton(moveUpAction));
        MoveDownAction moveDownAction = new MoveDownAction();
        this.adaptTo((IEnabledStateUpdating)moveDownAction, this.model);
        this.adaptTo((IEnabledStateUpdating)moveDownAction, this.selectionModel);
        buttonPanel.add(new SideButton(moveDownAction));
        this.activateLayerAction = new ActivateLayerAction();
        this.adaptTo((IEnabledStateUpdating)this.activateLayerAction, this.selectionModel);
        buttonPanel.add(new SideButton(this.activateLayerAction));
        ShowHideLayerAction showHideLayerAction = new ShowHideLayerAction();
        this.adaptTo((IEnabledStateUpdating)showHideLayerAction, this.selectionModel);
        buttonPanel.add(new SideButton(showHideLayerAction));
        MergeAction mergeLayerAction = new MergeAction();
        this.adaptTo((IEnabledStateUpdating)mergeLayerAction, this.model);
        this.adaptTo((IEnabledStateUpdating)mergeLayerAction, this.selectionModel);
        buttonPanel.add(new SideButton(mergeLayerAction));
        DuplicateAction duplicateLayerAction = new DuplicateAction();
        this.adaptTo((IEnabledStateUpdating)duplicateLayerAction, this.model);
        this.adaptTo((IEnabledStateUpdating)duplicateLayerAction, this.selectionModel);
        buttonPanel.add(new SideButton(duplicateLayerAction));
        DeleteLayerAction deleteLayerAction = new DeleteLayerAction();
        this.layerList.getInputMap(0).put(KeyStroke.getKeyStroke(127, 0), "deleteLayer");
        this.layerList.getActionMap().put("deleteLayer", deleteLayerAction);
        this.adaptTo((IEnabledStateUpdating)deleteLayerAction, this.selectionModel);
        buttonPanel.add(new SideButton((Action)deleteLayerAction, false));
        return buttonPanel;
    }

    protected LayerListDialog(MapFrame mapFrame) {
        super(I18n.tr("Layers"), "layerlist", I18n.tr("Open a list of all loaded layers."), Shortcut.registerShortcut("subwindow:layers", I18n.tr("Toggle: {0}", I18n.tr("Layers")), 76, 4), 100, true);
        this.selectionModel.setSelectionMode(2);
        this.model = new LayerListModel(this.selectionModel);
        this.layerList = new LayerList((ListModel)this.model);
        this.layerList.setSelectionModel(this.selectionModel);
        this.layerList.addMouseListener(new DblClickAdapter());
        this.layerList.addMouseListener(new PopupMenuHandler());
        this.layerList.setBackground(UIManager.getColor("Button.background"));
        this.layerList.setCellRenderer(new LayerListCellRenderer());
        this.add((Component)new JScrollPane(this.layerList), "Center");
        MapView mapView = mapFrame.mapView;
        this.model.populate();
        this.model.setSelectedLayer(mapView.getActiveLayer());
        this.model.addLayerListModelListener(new LayerListModelListener(){

            public void makeVisible(int index, Layer layer) {
                LayerListDialog.this.layerList.ensureIndexIsVisible(index);
            }

            public void refresh() {
                LayerListDialog.this.layerList.repaint();
            }
        });
        this.add((Component)this.createButtonPanel(), "South");
    }

    public void showNotify() {
        MapView.addLayerChangeListener(this.activateLayerAction);
        MapView.addLayerChangeListener(this.model);
        this.model.populate();
    }

    public void hideNotify() {
        MapView.removeLayerChangeListener(this.model);
        MapView.removeLayerChangeListener(this.activateLayerAction);
    }

    public LayerListModel getModel() {
        return this.model;
    }

    protected void adaptTo(final IEnabledStateUpdating listener, ListSelectionModel listSelectionModel) {
        listSelectionModel.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                listener.updateEnabledState();
            }
        });
    }

    protected void adaptTo(final IEnabledStateUpdating listener, ListModel listModel) {
        listModel.addListDataListener(new ListDataListener(){

            public void contentsChanged(ListDataEvent e) {
                listener.updateEnabledState();
            }

            public void intervalAdded(ListDataEvent e) {
                listener.updateEnabledState();
            }

            public void intervalRemoved(ListDataEvent e) {
                listener.updateEnabledState();
            }
        });
    }

    public void destroy() {
        super.destroy();
        instance = null;
    }

    public ShowHideLayerAction createShowHideLayerAction() {
        return new ShowHideLayerAction();
    }

    public DeleteLayerAction createDeleteLayerAction() {
        return new DeleteLayerAction();
    }

    public ActivateLayerAction createActivateLayerAction(Layer layer) {
        return new ActivateLayerAction(layer);
    }

    public MergeAction createMergeLayerAction(Layer layer) {
        return new MergeAction(layer);
    }

    static class LayerList
    extends JList {
        public LayerList(ListModel dataModel) {
            super(dataModel);
        }

        protected void processMouseEvent(MouseEvent e) {
            int idx = this.locationToIndex(e.getPoint());
            Rectangle bounds = this.getCellBounds(idx, idx);
            if (bounds != null && bounds.contains(e.getPoint())) {
                super.processMouseEvent(e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LayerListModel
    extends DefaultListModel
    implements MapView.LayerChangeListener,
    PropertyChangeListener {
        private DefaultListSelectionModel selectionModel;
        private CopyOnWriteArrayList<LayerListModelListener> listeners;

        private LayerListModel(DefaultListSelectionModel selectionModel) {
            this.selectionModel = selectionModel;
            this.listeners = new CopyOnWriteArrayList();
        }

        public void addLayerListModelListener(LayerListModelListener listener) {
            if (listener != null) {
                this.listeners.addIfAbsent(listener);
            }
        }

        public void removeLayerListModelListener(LayerListModelListener listener) {
            this.listeners.remove(listener);
        }

        protected void fireMakeVisible(int index, Layer layer) {
            for (LayerListModelListener listener : this.listeners) {
                listener.makeVisible(index, layer);
            }
        }

        protected void fireRefresh() {
            for (LayerListModelListener listener : this.listeners) {
                listener.refresh();
            }
        }

        public void populate() {
            for (Layer layer : this.getLayers()) {
                layer.removePropertyChangeListener(this);
                layer.addPropertyChangeListener(this);
            }
            this.fireContentsChanged(this, 0, this.getSize());
        }

        public void setSelectedLayer(Layer layer) {
            if (layer == null) {
                return;
            }
            int idx = this.getLayers().indexOf(layer);
            if (idx >= 0) {
                this.selectionModel.setSelectionInterval(idx, idx);
            }
            this.fireContentsChanged(this, 0, this.getSize());
            this.ensureSelectedIsVisible();
        }

        public List<Layer> getSelectedLayers() {
            ArrayList<Layer> selected = new ArrayList<Layer>();
            for (int i = 0; i < this.getLayers().size(); ++i) {
                if (!this.selectionModel.isSelectedIndex(i)) continue;
                selected.add(this.getLayers().get(i));
            }
            return selected;
        }

        public List<Integer> getSelectedRows() {
            ArrayList<Integer> selected = new ArrayList<Integer>();
            for (int i = 0; i < this.getLayers().size(); ++i) {
                if (!this.selectionModel.isSelectedIndex(i)) continue;
                selected.add(i);
            }
            return selected;
        }

        protected void onRemoveLayer(Layer layer) {
            if (layer == null) {
                return;
            }
            layer.removePropertyChangeListener(this);
            int size = this.getSize();
            List<Integer> rows = this.getSelectedRows();
            if (rows.isEmpty() && size > 0) {
                this.selectionModel.setSelectionInterval(size - 1, size - 1);
            }
            this.fireRefresh();
            this.ensureActiveSelected();
        }

        protected void onAddLayer(Layer layer) {
            if (layer == null) {
                return;
            }
            layer.addPropertyChangeListener(this);
            this.fireContentsChanged(this, 0, this.getSize());
            int idx = this.getLayers().indexOf(layer);
            this.selectionModel.setSelectionInterval(idx, idx);
            this.ensureSelectedIsVisible();
        }

        public Layer getFirstLayer() {
            if (this.getSize() == 0) {
                return null;
            }
            return this.getLayers().get(0);
        }

        public Layer getLayer(int index) {
            if (index < 0 || index >= this.getSize()) {
                return null;
            }
            return this.getLayers().get(index);
        }

        public boolean canMoveUp() {
            List<Integer> sel = this.getSelectedRows();
            return !sel.isEmpty() && sel.get(0) > 0;
        }

        public void moveUp() {
            if (!this.canMoveUp()) {
                return;
            }
            List<Integer> sel = this.getSelectedRows();
            for (int row : sel) {
                Layer l1 = this.getLayers().get(row);
                Layer l2 = this.getLayers().get(row - 1);
                Main.map.mapView.moveLayer(l2, row);
                Main.map.mapView.moveLayer(l1, row - 1);
            }
            this.fireContentsChanged(this, 0, this.getSize());
            this.selectionModel.clearSelection();
            for (int row : sel) {
                this.selectionModel.addSelectionInterval(row - 1, row - 1);
            }
            this.ensureSelectedIsVisible();
        }

        public boolean canMoveDown() {
            List<Integer> sel = this.getSelectedRows();
            return !sel.isEmpty() && sel.get(sel.size() - 1) < this.getLayers().size() - 1;
        }

        public void moveDown() {
            if (!this.canMoveDown()) {
                return;
            }
            List<Integer> sel = this.getSelectedRows();
            Collections.reverse(sel);
            for (int row : sel) {
                Layer l1 = this.getLayers().get(row);
                Layer l2 = this.getLayers().get(row + 1);
                Main.map.mapView.moveLayer(l1, row + 1);
                Main.map.mapView.moveLayer(l2, row);
            }
            this.fireContentsChanged(this, 0, this.getSize());
            this.selectionModel.clearSelection();
            for (int row : sel) {
                this.selectionModel.addSelectionInterval(row + 1, row + 1);
            }
            this.ensureSelectedIsVisible();
        }

        protected void ensureSelectedIsVisible() {
            int index = this.selectionModel.getMinSelectionIndex();
            if (index < 0) {
                return;
            }
            if (index >= this.getLayers().size()) {
                return;
            }
            Layer layer = this.getLayers().get(index);
            this.fireMakeVisible(index, layer);
        }

        public List<Layer> getPossibleMergeTargets(Layer source) {
            ArrayList<Layer> targets = new ArrayList<Layer>();
            if (source == null) {
                return targets;
            }
            for (Layer target : this.getLayers()) {
                if (source == target || !target.isMergable(source)) continue;
                targets.add(target);
            }
            return targets;
        }

        protected List<Layer> getLayers() {
            if (Main.map == null || Main.map.mapView == null) {
                return Collections.emptyList();
            }
            return Main.map.mapView.getAllLayersAsList();
        }

        protected void ensureActiveSelected() {
            if (this.getLayers().size() == 0) {
                return;
            }
            if (this.getActiveLayer() != null) {
                int idx = this.getLayers().indexOf(this.getActiveLayer());
                this.selectionModel.setSelectionInterval(idx, idx);
                this.ensureSelectedIsVisible();
            } else {
                this.selectionModel.setSelectionInterval(0, 0);
                this.ensureSelectedIsVisible();
            }
        }

        protected Layer getActiveLayer() {
            if (Main.map == null || Main.map.mapView == null) {
                return null;
            }
            return Main.map.mapView.getActiveLayer();
        }

        @Override
        public Object getElementAt(int index) {
            return this.getLayers().get(index);
        }

        @Override
        public int getSize() {
            List<Layer> layers = this.getLayers();
            if (layers == null) {
                return 0;
            }
            return layers.size();
        }

        @Override
        public void activeLayerChange(Layer oldLayer, Layer newLayer) {
            int idx;
            if (oldLayer != null && (idx = this.getLayers().indexOf(oldLayer)) >= 0) {
                this.fireContentsChanged(this, idx, idx);
            }
            if (newLayer != null && (idx = this.getLayers().indexOf(newLayer)) >= 0) {
                this.fireContentsChanged(this, idx, idx);
            }
            this.ensureActiveSelected();
        }

        @Override
        public void layerAdded(Layer newLayer) {
            this.onAddLayer(newLayer);
        }

        @Override
        public void layerRemoved(Layer oldLayer) {
            this.onRemoveLayer(oldLayer);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getSource() instanceof Layer) {
                Layer layer = (Layer)evt.getSource();
                int idx = this.getLayers().indexOf(layer);
                if (idx < 0) {
                    return;
                }
                this.fireRefresh();
            }
        }
    }

    public static interface LayerListModelListener {
        public void makeVisible(int var1, Layer var2);

        public void refresh();
    }

    class MoveDownAction
    extends AbstractAction
    implements IEnabledStateUpdating {
        public MoveDownAction() {
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "down"));
            this.putValue("ShortDescription", I18n.tr("Move the selected layer one row down."));
            this.updateEnabledState();
        }

        public void updateEnabledState() {
            this.setEnabled(LayerListDialog.this.model.canMoveDown());
        }

        public void actionPerformed(ActionEvent e) {
            LayerListDialog.this.model.moveDown();
        }
    }

    class MoveUpAction
    extends AbstractAction
    implements IEnabledStateUpdating {
        public MoveUpAction() {
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "up"));
            this.putValue("ShortDescription", I18n.tr("Move the selected layer one row up."));
            this.updateEnabledState();
        }

        public void updateEnabledState() {
            this.setEnabled(LayerListDialog.this.model.canMoveUp());
        }

        public void actionPerformed(ActionEvent e) {
            LayerListDialog.this.model.moveUp();
        }
    }

    class DblClickAdapter
    extends MouseAdapter {
        DblClickAdapter() {
        }

        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                int index = LayerListDialog.this.layerList.locationToIndex(e.getPoint());
                if (!LayerListDialog.this.layerList.getCellBounds(index, index).contains(e.getPoint())) {
                    return;
                }
                Layer layer = LayerListDialog.this.model.getLayer(index);
                layer.toggleVisible();
            }
        }
    }

    class PopupMenuHandler
    extends PopupMenuLauncher {
        PopupMenuHandler() {
        }

        public void launch(MouseEvent evt) {
            Point p = evt.getPoint();
            int index = LayerListDialog.this.layerList.locationToIndex(p);
            if (index < 0) {
                return;
            }
            if (!LayerListDialog.this.layerList.getCellBounds(index, index).contains(evt.getPoint())) {
                return;
            }
            if (!LayerListDialog.this.layerList.isSelectedIndex(index)) {
                LayerListDialog.this.layerList.setSelectedIndex(index);
            }
            Layer layer = LayerListDialog.this.model.getLayer(index);
            LayerListPopup menu = new LayerListPopup(LayerListDialog.this.getModel().getSelectedLayers(), layer);
            menu.show(LayerListDialog.this, p.x, p.y - 3);
        }
    }

    static class LayerListCellRenderer
    extends DefaultListCellRenderer {
        LayerListCellRenderer() {
        }

        protected boolean isActiveLayer(Layer layer) {
            if (Main.map == null) {
                return false;
            }
            if (Main.map.mapView == null) {
                return false;
            }
            return Main.map.mapView.getActiveLayer() == layer;
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Layer layer = (Layer)value;
            JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, layer.getName(), index, isSelected, cellHasFocus);
            Icon icon = layer.getIcon();
            if (this.isActiveLayer(layer)) {
                icon = ImageProvider.overlay(icon, "overlay/active", ImageProvider.OverlayPosition.SOUTHWEST);
            }
            if (!layer.isVisible()) {
                icon = ImageProvider.overlay(icon, "overlay/invisiblenew", ImageProvider.OverlayPosition.SOUTHEAST);
            }
            label.setIcon(icon);
            label.setToolTipText(layer.getToolTipText());
            return label;
        }
    }

    public final class DuplicateAction
    extends AbstractAction
    implements IEnabledStateUpdating {
        private Layer layer;

        public DuplicateAction(Layer layer) throws IllegalArgumentException {
            this();
            CheckParameterUtil.ensureParameterNotNull(layer, "layer");
            this.layer = layer;
            this.putValue("Name", I18n.tr("Duplicate"));
            this.updateEnabledState();
        }

        public DuplicateAction() {
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "duplicatelayer"));
            this.putValue("ShortDescription", I18n.tr("Duplicate this layer"));
            this.putValue("help", HelpUtil.ht("/Dialog/LayerDialog#DuplicateLayer"));
            this.updateEnabledState();
        }

        public void actionPerformed(ActionEvent e) {
            if (this.layer != null) {
                new DuplicateLayerAction().duplicate(this.layer);
            } else {
                Layer selectedLayer = LayerListDialog.this.getModel().getSelectedLayers().get(0);
                new DuplicateLayerAction().duplicate(selectedLayer);
            }
        }

        protected boolean isActiveLayer(Layer layer) {
            if (Main.map == null) {
                return false;
            }
            if (Main.map.mapView == null) {
                return false;
            }
            return Main.map.mapView.getActiveLayer() == layer;
        }

        public void updateEnabledState() {
            if (this.layer == null) {
                if (LayerListDialog.this.getModel().getSelectedLayers().size() == 1) {
                    this.setEnabled(DuplicateLayerAction.canDuplicate(LayerListDialog.this.getModel().getSelectedLayers().get(0)));
                } else {
                    this.setEnabled(false);
                }
            } else {
                this.setEnabled(DuplicateLayerAction.canDuplicate(this.layer));
            }
        }
    }

    public final class MergeAction
    extends AbstractAction
    implements IEnabledStateUpdating {
        private Layer layer;

        public MergeAction(Layer layer) throws IllegalArgumentException {
            this();
            CheckParameterUtil.ensureParameterNotNull(layer, "layer");
            this.layer = layer;
            this.putValue("Name", I18n.tr("Merge"));
            this.updateEnabledState();
        }

        public MergeAction() {
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "mergedown"));
            this.putValue("ShortDescription", I18n.tr("Merge this layer into another layer"));
            this.putValue("help", HelpUtil.ht("/Dialog/LayerDialog#MergeLayer"));
            this.updateEnabledState();
        }

        public void actionPerformed(ActionEvent e) {
            if (this.layer != null) {
                new MergeLayerAction().merge(this.layer);
            } else {
                Layer selectedLayer = LayerListDialog.this.getModel().getSelectedLayers().get(0);
                new MergeLayerAction().merge(selectedLayer);
            }
        }

        protected boolean isActiveLayer(Layer layer) {
            if (Main.map == null) {
                return false;
            }
            if (Main.map.mapView == null) {
                return false;
            }
            return Main.map.mapView.getActiveLayer() == layer;
        }

        public void updateEnabledState() {
            if (this.layer == null) {
                if (LayerListDialog.this.getModel().getSelectedLayers().size() != 1) {
                    this.setEnabled(false);
                    return;
                }
                Layer selectedLayer = LayerListDialog.this.getModel().getSelectedLayers().get(0);
                List<Layer> targets = LayerListDialog.this.getModel().getPossibleMergeTargets(selectedLayer);
                this.setEnabled(!targets.isEmpty());
            } else {
                List<Layer> targets = LayerListDialog.this.getModel().getPossibleMergeTargets(this.layer);
                this.setEnabled(!targets.isEmpty());
            }
        }
    }

    public final class ActivateLayerAction
    extends AbstractAction
    implements IEnabledStateUpdating,
    MapView.LayerChangeListener {
        private Layer layer;

        public ActivateLayerAction(Layer layer) {
            this();
            CheckParameterUtil.ensureParameterNotNull(layer, "layer");
            this.layer = layer;
            this.putValue("Name", I18n.tr("Activate"));
            this.updateEnabledState();
        }

        public ActivateLayerAction() {
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "activate"));
            this.putValue("ShortDescription", I18n.tr("Activate the selected layer"));
            this.putValue("help", HelpUtil.ht("/Dialog/LayerDialog#ActivateLayer"));
            this.updateEnabledState();
        }

        public void actionPerformed(ActionEvent e) {
            Layer toActivate = this.layer != null ? this.layer : LayerListDialog.this.model.getSelectedLayers().get(0);
            Main.map.mapView.setActiveLayer(toActivate);
            toActivate.setVisible(true);
        }

        protected boolean isActiveLayer(Layer layer) {
            if (Main.map == null) {
                return false;
            }
            if (Main.map.mapView == null) {
                return false;
            }
            return Main.map.mapView.getActiveLayer() == layer;
        }

        public void updateEnabledState() {
            if (this.layer == null) {
                if (LayerListDialog.this.getModel().getSelectedLayers().size() != 1) {
                    this.setEnabled(false);
                    return;
                }
                Layer selectedLayer = LayerListDialog.this.getModel().getSelectedLayers().get(0);
                this.setEnabled(!this.isActiveLayer(selectedLayer));
            } else {
                this.setEnabled(!this.isActiveLayer(this.layer));
            }
        }

        public void activeLayerChange(Layer oldLayer, Layer newLayer) {
            this.updateEnabledState();
        }

        public void layerAdded(Layer newLayer) {
            this.updateEnabledState();
        }

        public void layerRemoved(Layer oldLayer) {
            this.updateEnabledState();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class ShowHideLayerAction
    extends AbstractAction
    implements IEnabledStateUpdating,
    Layer.LayerAction {
        private Layer layer;

        public ShowHideLayerAction(Layer layer) throws IllegalArgumentException {
            this();
            CheckParameterUtil.ensureParameterNotNull(layer, "layer");
            this.layer = layer;
            this.updateEnabledState();
        }

        public ShowHideLayerAction() {
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "showhide"));
            this.putValue("ShortDescription", I18n.tr("Toggle visible state of the selected layer."));
            this.putValue("help", HelpUtil.ht("/Dialog/LayerDialog#ShowHideLayer"));
            this.putValue("Name", I18n.tr("Show/Hide"));
            this.updateEnabledState();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.layer != null) {
                this.layer.toggleVisible();
            } else {
                for (Layer layer : LayerListDialog.this.model.getSelectedLayers()) {
                    layer.toggleVisible();
                }
            }
        }

        @Override
        public void updateEnabledState() {
            if (this.layer == null) {
                this.setEnabled(!LayerListDialog.this.getModel().getSelectedLayers().isEmpty());
            } else {
                this.setEnabled(true);
            }
        }

        @Override
        public Component createMenuComponent() {
            return new JMenuItem(this);
        }

        @Override
        public boolean supportLayers(List<Layer> layers) {
            return true;
        }

        public boolean equals(Object obj) {
            return obj instanceof ShowHideLayerAction;
        }

        public int hashCode() {
            return this.getClass().hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class DeleteLayerAction
    extends AbstractAction
    implements IEnabledStateUpdating,
    Layer.LayerAction {
        public DeleteLayerAction() {
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "delete"));
            this.putValue("ShortDescription", I18n.tr("Delete the selected layers."));
            this.putValue("Name", I18n.tr("Delete"));
            this.putValue("help", HelpUtil.ht("/Dialog/LayerDialog#DeleteLayer"));
            this.updateEnabledState();
        }

        protected boolean enforceUploadOrSaveModifiedData(List<Layer> selectedLayers) {
            SaveLayersDialog dialog = new SaveLayersDialog(Main.parent);
            ArrayList<OsmDataLayer> layersWithUnmodifiedChanges = new ArrayList<OsmDataLayer>();
            for (Layer l : selectedLayers) {
                OsmDataLayer odl;
                if (!(l instanceof OsmDataLayer) || !(odl = (OsmDataLayer)l).requiresSaveToFile() && !odl.requiresUploadToServer() || !odl.data.isModified()) continue;
                layersWithUnmodifiedChanges.add(odl);
            }
            dialog.prepareForSavingAndUpdatingLayersBeforeDelete();
            if (!layersWithUnmodifiedChanges.isEmpty()) {
                dialog.getModel().populate(layersWithUnmodifiedChanges);
                dialog.setVisible(true);
                switch (dialog.getUserAction()) {
                    case CANCEL: {
                        return false;
                    }
                    case PROCEED: {
                        return true;
                    }
                }
                return false;
            }
            return true;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            List<Layer> selectedLayers = LayerListDialog.this.getModel().getSelectedLayers();
            if (selectedLayers.isEmpty()) {
                return;
            }
            if (!this.enforceUploadOrSaveModifiedData(selectedLayers)) {
                return;
            }
            for (Layer l : selectedLayers) {
                Main.main.removeLayer(l);
            }
        }

        @Override
        public void updateEnabledState() {
            this.setEnabled(!LayerListDialog.this.getModel().getSelectedLayers().isEmpty());
        }

        @Override
        public Component createMenuComponent() {
            return new JMenuItem(this);
        }

        @Override
        public boolean supportLayers(List<Layer> layers) {
            return true;
        }

        public boolean equals(Object obj) {
            return obj instanceof DeleteLayerAction;
        }

        public int hashCode() {
            return this.getClass().hashCode();
        }
    }

    private static interface IEnabledStateUpdating {
        public void updateEnabledState();
    }
}

