/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.history;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.AutoScaleAction;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.history.History;
import org.openstreetmap.josm.data.osm.history.HistoryDataSet;
import org.openstreetmap.josm.gui.history.AdjustmentSynchronizer;
import org.openstreetmap.josm.gui.history.HistoryBrowserDialogManager;
import org.openstreetmap.josm.gui.history.HistoryBrowserModel;
import org.openstreetmap.josm.gui.history.HistoryLoadTask;
import org.openstreetmap.josm.gui.history.NodeListTableColumnModel;
import org.openstreetmap.josm.gui.history.PointInTimeType;
import org.openstreetmap.josm.gui.history.SelectionSynchronizer;
import org.openstreetmap.josm.gui.history.VersionInfoPanel;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class NodeListViewer
extends JPanel {
    private HistoryBrowserModel model;
    private VersionInfoPanel referenceInfoPanel;
    private VersionInfoPanel currentInfoPanel;
    private AdjustmentSynchronizer adjustmentSynchronizer;
    private SelectionSynchronizer selectionSynchronizer;
    private NodeListPopupMenu popupMenu;

    protected JScrollPane embeddInScrollPane(JTable table) {
        JScrollPane pane = new JScrollPane(table);
        pane.setHorizontalScrollBarPolicy(30);
        pane.setVerticalScrollBarPolicy(20);
        this.adjustmentSynchronizer.participateInSynchronizedScrolling(pane.getVerticalScrollBar());
        return pane;
    }

    protected JTable buildReferenceNodeListTable() {
        JTable table = new JTable(this.model.getNodeListTableModel(PointInTimeType.REFERENCE_POINT_IN_TIME), new NodeListTableColumnModel());
        table.setName("table.referencenodelisttable");
        table.setSelectionMode(0);
        this.selectionSynchronizer.participateInSynchronizedSelection(table.getSelectionModel());
        table.addMouseListener(new PopupMenuLauncher(table));
        table.addMouseListener(new DoubleClickAdapter(table));
        return table;
    }

    protected JTable buildCurrentNodeListTable() {
        JTable table = new JTable(this.model.getNodeListTableModel(PointInTimeType.CURRENT_POINT_IN_TIME), new NodeListTableColumnModel());
        table.setName("table.currentnodelisttable");
        table.setSelectionMode(0);
        this.selectionSynchronizer.participateInSynchronizedSelection(table.getSelectionModel());
        table.addMouseListener(new PopupMenuLauncher(table));
        table.addMouseListener(new DoubleClickAdapter(table));
        return table;
    }

    protected void build() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridx = 0;
        gc.gridy = 0;
        gc.gridwidth = 1;
        gc.gridheight = 1;
        gc.weightx = 0.5;
        gc.weighty = 0.0;
        gc.insets = new Insets(5, 5, 5, 0);
        gc.fill = 2;
        gc.anchor = 23;
        this.referenceInfoPanel = new VersionInfoPanel(this.model, PointInTimeType.REFERENCE_POINT_IN_TIME);
        this.add((Component)this.referenceInfoPanel, gc);
        gc.gridx = 1;
        gc.gridy = 0;
        gc.gridwidth = 1;
        gc.gridheight = 1;
        gc.fill = 2;
        gc.weightx = 0.5;
        gc.weighty = 0.0;
        gc.anchor = 23;
        this.currentInfoPanel = new VersionInfoPanel(this.model, PointInTimeType.CURRENT_POINT_IN_TIME);
        this.add((Component)this.currentInfoPanel, gc);
        this.adjustmentSynchronizer = new AdjustmentSynchronizer();
        this.selectionSynchronizer = new SelectionSynchronizer();
        gc.gridx = 0;
        gc.gridy = 1;
        gc.gridwidth = 1;
        gc.gridheight = 1;
        gc.weightx = 0.5;
        gc.weighty = 1.0;
        gc.fill = 1;
        gc.anchor = 18;
        this.add((Component)this.embeddInScrollPane(this.buildReferenceNodeListTable()), gc);
        gc.gridx = 1;
        gc.gridy = 1;
        gc.gridwidth = 1;
        gc.gridheight = 1;
        gc.weightx = 0.5;
        gc.weighty = 1.0;
        gc.fill = 1;
        gc.anchor = 18;
        this.add((Component)this.embeddInScrollPane(this.buildCurrentNodeListTable()), gc);
        this.popupMenu = new NodeListPopupMenu();
    }

    public NodeListViewer(HistoryBrowserModel model) {
        this.setModel(model);
        this.build();
    }

    protected void unregisterAsObserver(HistoryBrowserModel model) {
        if (this.currentInfoPanel != null) {
            model.deleteObserver(this.currentInfoPanel);
        }
        if (this.referenceInfoPanel != null) {
            model.deleteObserver(this.referenceInfoPanel);
        }
    }

    protected void registerAsObserver(HistoryBrowserModel model) {
        if (this.currentInfoPanel != null) {
            model.addObserver(this.currentInfoPanel);
        }
        if (this.referenceInfoPanel != null) {
            model.addObserver(this.referenceInfoPanel);
        }
    }

    public void setModel(HistoryBrowserModel model) {
        if (this.model != null) {
            this.unregisterAsObserver(model);
        }
        this.model = model;
        if (this.model != null) {
            this.registerAsObserver(model);
        }
    }

    static class DoubleClickAdapter
    extends MouseAdapter {
        private JTable table;
        private ShowHistoryAction showHistoryAction;

        public DoubleClickAdapter(JTable table) {
            this.table = table;
            this.showHistoryAction = new ShowHistoryAction();
        }

        protected HistoryBrowserModel.NodeListTableModel getModel() {
            return (HistoryBrowserModel.NodeListTableModel)this.table.getModel();
        }

        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() < 2) {
                return;
            }
            int row = this.table.rowAtPoint(e.getPoint());
            PrimitiveId pid = this.getModel().getNodeId(row);
            if (pid == null) {
                return;
            }
            this.showHistoryAction.setPrimitiveId(pid);
            this.showHistoryAction.run();
        }
    }

    class PopupMenuLauncher
    extends MouseAdapter {
        private JTable table;

        public PopupMenuLauncher(JTable table) {
            this.table = table;
        }

        public void mousePressed(MouseEvent e) {
            this.showPopup(e);
        }

        public void mouseReleased(MouseEvent e) {
            this.showPopup(e);
        }

        private void showPopup(MouseEvent e) {
            if (!e.isPopupTrigger()) {
                return;
            }
            Point p = e.getPoint();
            int row = this.table.rowAtPoint(p);
            HistoryBrowserModel.NodeListTableModel model = (HistoryBrowserModel.NodeListTableModel)this.table.getModel();
            PrimitiveId pid = model.getNodeId(row);
            NodeListViewer.this.popupMenu.prepare(pid);
            NodeListViewer.this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    static class ShowHistoryAction
    extends AbstractAction {
        private PrimitiveId primitiveId;

        public ShowHistoryAction() {
            this.putValue("Name", I18n.tr("Show history"));
            this.putValue("ShortDescription", I18n.tr("Open a history browser with the history of this node"));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "history"));
        }

        public void actionPerformed(ActionEvent e) {
            if (!this.isEnabled()) {
                return;
            }
            this.run();
        }

        public void setPrimitiveId(PrimitiveId pid) {
            this.primitiveId = pid;
            this.updateEnabledState();
        }

        public void run() {
            if (HistoryDataSet.getInstance().getHistory(this.primitiveId) == null) {
                Main.worker.submit(new HistoryLoadTask().add(this.primitiveId));
            }
            Runnable r = new Runnable(){

                public void run() {
                    History h = HistoryDataSet.getInstance().getHistory(ShowHistoryAction.this.primitiveId);
                    if (h == null) {
                        return;
                    }
                    HistoryBrowserDialogManager.getInstance().show(h);
                }
            };
            Main.worker.submit(r);
        }

        public void updateEnabledState() {
            this.setEnabled(this.primitiveId != null && this.primitiveId.getUniqueId() > 0L);
        }
    }

    static class ZoomToNodeAction
    extends AbstractAction {
        private PrimitiveId primitiveId;

        public ZoomToNodeAction() {
            this.putValue("Name", I18n.tr("Zoom to node"));
            this.putValue("ShortDescription", I18n.tr("Zoom to this node in the current data layer"));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "zoomin"));
        }

        public void actionPerformed(ActionEvent e) {
            if (!this.isEnabled()) {
                return;
            }
            OsmPrimitive p = this.getPrimitiveToZoom();
            if (p != null) {
                this.getEditLayer().data.setSelected(p.getPrimitiveId());
                AutoScaleAction.autoScale("selection");
            }
        }

        public void setPrimitiveId(PrimitiveId pid) {
            this.primitiveId = pid;
            this.updateEnabledState();
        }

        protected OsmDataLayer getEditLayer() {
            try {
                return Main.map.mapView.getEditLayer();
            }
            catch (NullPointerException e) {
                return null;
            }
        }

        protected OsmPrimitive getPrimitiveToZoom() {
            if (this.primitiveId == null) {
                return null;
            }
            OsmPrimitive p = this.getEditLayer().data.getPrimitiveById(this.primitiveId);
            return p;
        }

        public void updateEnabledState() {
            if (this.getEditLayer() == null) {
                this.setEnabled(false);
                return;
            }
            this.setEnabled(this.getPrimitiveToZoom() != null);
        }
    }

    static class NodeListPopupMenu
    extends JPopupMenu {
        private ZoomToNodeAction zoomToNodeAction = new ZoomToNodeAction();
        private ShowHistoryAction showHistoryAction;

        public NodeListPopupMenu() {
            this.add(this.zoomToNodeAction);
            this.showHistoryAction = new ShowHistoryAction();
            this.add(this.showHistoryAction);
        }

        public void prepare(PrimitiveId pid) {
            this.zoomToNodeAction.setPrimitiveId(pid);
            this.zoomToNodeAction.updateEnabledState();
            this.showHistoryAction.setPrimitiveId(pid);
            this.showHistoryAction.updateEnabledState();
        }
    }
}

