/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.event.ActionEvent;
import java.awt.geom.Area;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.RenameLayerAction;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.conflict.Conflict;
import org.openstreetmap.josm.data.conflict.ConflictCollection;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.gpx.ImmutableGpxTrack;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.DataSetMerger;
import org.openstreetmap.josm.data.osm.DataSource;
import org.openstreetmap.josm.data.osm.DatasetCollection;
import org.openstreetmap.josm.data.osm.DatasetConsistencyTest;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.event.AbstractDatasetChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataSetListenerAdapter;
import org.openstreetmap.josm.data.osm.visitor.AbstractVisitor;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.data.osm.visitor.paint.MapPaintVisitor;
import org.openstreetmap.josm.data.osm.visitor.paint.PaintVisitor;
import org.openstreetmap.josm.data.osm.visitor.paint.SimplePaintVisitor;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.dialogs.LayerListPopup;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.tools.DateUtils;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OsmDataLayer
extends Layer
implements DataSetListenerAdapter.Listener,
SelectionChangedListener {
    public static final String REQUIRES_SAVE_TO_DISK_PROP = OsmDataLayer.class.getName() + ".requiresSaveToDisk";
    public static final String REQUIRES_UPLOAD_TO_SERVER_PROP = OsmDataLayer.class.getName() + ".requiresUploadToServer";
    private boolean requiresSaveToFile = false;
    private boolean requiresUploadToServer = false;
    private boolean isChanged = true;
    private int highlightUpdateCount;
    private static int dataLayerCounter = 0;
    public final DataSet data;
    private ConflictCollection conflicts;
    private static TexturePaint hatched;

    protected void setRequiresSaveToFile(boolean newValue) {
        boolean oldValue = this.requiresSaveToFile;
        this.requiresSaveToFile = newValue;
        if (oldValue != newValue) {
            this.propertyChangeSupport.firePropertyChange(REQUIRES_SAVE_TO_DISK_PROP, oldValue, newValue);
        }
    }

    protected void setRequiresUploadToServer(boolean newValue) {
        boolean oldValue = this.requiresUploadToServer;
        this.requiresUploadToServer = newValue;
        if (oldValue != newValue) {
            this.propertyChangeSupport.firePropertyChange(REQUIRES_UPLOAD_TO_SERVER_PROP, oldValue, newValue);
        }
    }

    public static String createNewName() {
        return I18n.tr("Data Layer {0}", ++dataLayerCounter);
    }

    public static Color getBackgroundColor() {
        return Main.pref.getColor(I18n.marktr("background"), Color.BLACK);
    }

    public static Color getOutsideColor() {
        return Main.pref.getColor(I18n.marktr("outside downloaded area"), Color.YELLOW);
    }

    public static void createHatchTexture() {
        BufferedImage bi = new BufferedImage(15, 15, 2);
        Graphics2D big = bi.createGraphics();
        big.setColor(OsmDataLayer.getBackgroundColor());
        AlphaComposite comp = AlphaComposite.getInstance(3, 0.3f);
        big.setComposite(comp);
        big.fillRect(0, 0, 15, 15);
        big.setColor(OsmDataLayer.getOutsideColor());
        big.drawLine(0, 15, 15, 0);
        Rectangle r = new Rectangle(0, 0, 15, 15);
        hatched = new TexturePaint(bi, r);
    }

    public OsmDataLayer(DataSet data, String name, File associatedFile) {
        super(name);
        this.data = data;
        this.setAssociatedFile(associatedFile);
        this.conflicts = new ConflictCollection();
        data.addDataSetListener(new DataSetListenerAdapter(this));
        DataSet.addSelectionListener(this);
    }

    @Override
    public Icon getIcon() {
        return ImageProvider.get("layer", "osmdata_small");
    }

    @Override
    public void paint(Graphics2D g, MapView mv, Bounds box) {
        boolean virtual;
        this.isChanged = false;
        this.highlightUpdateCount = this.data.getHighlightUpdateCount();
        boolean active = mv.getActiveLayer() == this;
        boolean inactive = !active && Main.pref.getBoolean("draw.data.inactive_color", true);
        boolean bl = virtual = !inactive && mv.isVirtualNodesEnabled();
        if (active && Main.pref.getBoolean("draw.data.downloaded_area", true) && !this.data.dataSources.isEmpty()) {
            Rectangle b = mv.getBounds();
            b.grow(100, 100);
            Area a = new Area(b);
            for (DataSource src : this.data.dataSources) {
                if (src.bounds == null || src.bounds.getMin().equals(src.bounds.getMax())) continue;
                EastNorth en1 = mv.getProjection().latlon2eastNorth(src.bounds.getMin());
                EastNorth en2 = mv.getProjection().latlon2eastNorth(src.bounds.getMax());
                Point p1 = mv.getPoint(en1);
                Point p2 = mv.getPoint(en2);
                Rectangle r = new Rectangle(Math.min(p1.x, p2.x), Math.min(p1.y, p2.y), Math.abs(p2.x - p1.x), Math.abs(p2.y - p1.y));
                a.subtract(new Area(r));
            }
            g.setPaint(hatched);
            g.fill(a);
        }
        PaintVisitor painter = Main.pref.getBoolean("draw.wireframe") ? new SimplePaintVisitor() : new MapPaintVisitor();
        painter.setGraphics(g);
        painter.setNavigatableComponent(mv);
        painter.setInactive(inactive);
        painter.visitAll(this.data, virtual, box);
        Main.map.conflictDialog.paintConflicts(g, mv);
    }

    @Override
    public String getToolTipText() {
        File f;
        int nodes = new DatasetCollection(this.data.getNodes(), OsmPrimitive.nonDeletedPredicate).size();
        int ways = new DatasetCollection(this.data.getWays(), OsmPrimitive.nonDeletedPredicate).size();
        String tool = I18n.trn("{0} node", "{0} nodes", nodes, nodes) + ", ";
        tool = tool + I18n.trn("{0} way", "{0} ways", ways, ways);
        if (this.data.getVersion() != null) {
            tool = tool + ", " + I18n.tr("version {0}", this.data.getVersion());
        }
        if ((f = this.getAssociatedFile()) != null) {
            tool = "<html>" + tool + "<br>" + f.getPath() + "</html>";
        }
        return tool;
    }

    @Override
    public void mergeFrom(Layer from) {
        this.mergeFrom(((OsmDataLayer)from).data);
    }

    public void mergeFrom(DataSet from) {
        DataSetMerger visitor = new DataSetMerger(this.data, from);
        visitor.merge();
        Area a = this.data.getDataSourceArea();
        for (DataSource src : from.dataSources) {
            if (a != null && a.contains(src.bounds.asRect())) continue;
            this.data.dataSources.add(src);
        }
        if (this.data.getVersion() == null) {
            this.data.setVersion(from.getVersion());
        } else if ("0.5".equals(this.data.getVersion()) ^ "0.5".equals(from.getVersion())) {
            System.err.println(I18n.tr("Warning: mixing 0.6 and 0.5 data results in version 0.5"));
            this.data.setVersion("0.5");
        }
        int numNewConflicts = 0;
        for (Conflict<?> c : visitor.getConflicts()) {
            if (this.conflicts.hasConflict(c)) continue;
            ++numNewConflicts;
            this.conflicts.add(c);
        }
        Main.map.mapView.repaint();
        this.warnNumNewConflicts(numNewConflicts);
    }

    protected void warnNumNewConflicts(int numNewConflicts) {
        if (numNewConflicts == 0) {
            return;
        }
        String msg1 = I18n.trn("There was {0} conflict detected.", "There were {0} conflicts detected.", numNewConflicts, numNewConflicts);
        StringBuffer sb = new StringBuffer();
        sb.append("<html>").append(msg1).append("</html>");
        if (numNewConflicts > 0) {
            HelpAwareOptionPane.ButtonSpec[] options = new HelpAwareOptionPane.ButtonSpec[]{new HelpAwareOptionPane.ButtonSpec(I18n.tr("OK"), ImageProvider.get("ok"), I18n.tr("Click to close this dialog and continue editing"), null)};
            HelpAwareOptionPane.showOptionDialog(Main.parent, sb.toString(), I18n.tr("Conflicts detected"), 2, null, options, options[0], HelpUtil.ht("/Concepts/Conflict#WarningAboutDetectedConflicts"));
            Main.map.conflictDialog.unfurlDialog();
            Main.map.repaint();
        }
    }

    @Override
    public boolean isMergable(Layer other) {
        return other instanceof OsmDataLayer;
    }

    @Override
    public void visitBoundingBox(BoundingXYVisitor v) {
        for (Node n : this.data.getNodes()) {
            if (!n.isUsable()) continue;
            v.visit(n);
        }
    }

    public void cleanupAfterUpload(Collection<OsmPrimitive> processed) {
        if (processed == null || processed.isEmpty()) {
            return;
        }
        Main.main.undoRedo.clean(this);
        this.data.cleanupDeletedPrimitives();
        for (OsmPrimitive p : this.data.allPrimitives()) {
            if (!processed.contains(p)) continue;
            p.setModified(false);
        }
    }

    @Override
    public Object getInfoComponent() {
        DataCountVisitor counter = new DataCountVisitor();
        for (OsmPrimitive osm : this.data.allPrimitives()) {
            osm.visit(counter);
        }
        JPanel p = new JPanel(new GridBagLayout());
        String nodeText = I18n.trn("{0} node", "{0} nodes", counter.nodes, counter.nodes);
        if (counter.deletedNodes > 0) {
            nodeText = nodeText + " (" + I18n.trn("{0} deleted", "{0} deleted", counter.deletedNodes, counter.deletedNodes) + ")";
        }
        String wayText = I18n.trn("{0} way", "{0} ways", counter.ways, counter.ways);
        if (counter.deletedWays > 0) {
            wayText = wayText + " (" + I18n.trn("{0} deleted", "{0} deleted", counter.deletedWays, counter.deletedWays) + ")";
        }
        String relationText = I18n.trn("{0} relation", "{0} relations", counter.relations, counter.relations);
        if (counter.deletedRelations > 0) {
            relationText = relationText + " (" + I18n.trn("{0} deleted", "{0} deleted", counter.deletedRelations, counter.deletedRelations) + ")";
        }
        p.add((Component)new JLabel(I18n.tr("{0} consists of:", this.getName())), GBC.eol());
        p.add((Component)new JLabel(nodeText, ImageProvider.get("data", "node"), 0), GBC.eop().insets(15, 0, 0, 0));
        p.add((Component)new JLabel(wayText, ImageProvider.get("data", "way"), 0), GBC.eop().insets(15, 0, 0, 0));
        p.add((Component)new JLabel(relationText, ImageProvider.get("data", "relation"), 0), GBC.eop().insets(15, 0, 0, 0));
        p.add(new JLabel(I18n.tr("API version: {0}", this.data.getVersion() != null ? this.data.getVersion() : I18n.tr("unset"))));
        return p;
    }

    @Override
    public Action[] getMenuEntries() {
        if (Main.applet) {
            return new Action[]{LayerListDialog.getInstance().createActivateLayerAction(this), LayerListDialog.getInstance().createShowHideLayerAction(), LayerListDialog.getInstance().createDeleteLayerAction(), Layer.SeparatorLayerAction.INSTANCE, LayerListDialog.getInstance().createMergeLayerAction(this), Layer.SeparatorLayerAction.INSTANCE, new RenameLayerAction(this.getAssociatedFile(), this), new ConsistencyTestAction(), Layer.SeparatorLayerAction.INSTANCE, new LayerListPopup.InfoAction(this)};
        }
        return new Action[]{LayerListDialog.getInstance().createActivateLayerAction(this), LayerListDialog.getInstance().createShowHideLayerAction(), LayerListDialog.getInstance().createDeleteLayerAction(), Layer.SeparatorLayerAction.INSTANCE, LayerListDialog.getInstance().createMergeLayerAction(this), new Layer.LayerSaveAction(this), new Layer.LayerSaveAsAction(this), new Layer.LayerGpxExportAction(this), new ConvertToGpxLayerAction(), Layer.SeparatorLayerAction.INSTANCE, new RenameLayerAction(this.getAssociatedFile(), this), new ConsistencyTestAction(), Layer.SeparatorLayerAction.INSTANCE, new LayerListPopup.InfoAction(this)};
    }

    public static GpxData toGpxData(DataSet data, File file) {
        GpxData gpxData = new GpxData();
        gpxData.storageFile = file;
        HashSet<Node> doneNodes = new HashSet<Node>();
        for (Way w : data.getWays()) {
            if (!w.isUsable()) continue;
            ArrayList<Collection<WayPoint>> trk = new ArrayList<Collection<WayPoint>>();
            HashMap<String, Object> trkAttr = new HashMap<String, Object>();
            if (w.get("name") != null) {
                trkAttr.put("name", w.get("name"));
            }
            ArrayList<WayPoint> trkseg = null;
            for (Node n : w.getNodes()) {
                if (!n.isUsable()) {
                    trkseg = null;
                    continue;
                }
                if (trkseg == null) {
                    trkseg = new ArrayList<WayPoint>();
                    trk.add(trkseg);
                }
                if (!n.isTagged()) {
                    doneNodes.add(n);
                }
                WayPoint wpt = new WayPoint(n.getCoor());
                if (!n.isTimestampEmpty()) {
                    wpt.attr.put("time", DateUtils.fromDate(n.getTimestamp()));
                    wpt.setTime();
                }
                trkseg.add(wpt);
            }
            gpxData.tracks.add(new ImmutableGpxTrack(trk, trkAttr));
        }
        for (Node n : data.getNodes()) {
            String name;
            if (n.isIncomplete() || n.isDeleted() || doneNodes.contains(n)) continue;
            WayPoint wpt = new WayPoint(n.getCoor());
            if (!n.isTimestampEmpty()) {
                wpt.attr.put("time", DateUtils.fromDate(n.getTimestamp()));
                wpt.setTime();
            }
            if ((name = n.get("name")) == null) continue;
            wpt.attr.put("name", name);
        }
        return gpxData;
    }

    public GpxData toGpxData() {
        return OsmDataLayer.toGpxData(this.data, this.getAssociatedFile());
    }

    public boolean containsPoint(LatLon coor) {
        if (this.data.dataSources.isEmpty()) {
            return true;
        }
        boolean layer_bounds_point = false;
        for (DataSource src : this.data.dataSources) {
            if (!src.bounds.contains(coor)) continue;
            layer_bounds_point = true;
            break;
        }
        return layer_bounds_point;
    }

    public ConflictCollection getConflicts() {
        return this.conflicts;
    }

    public boolean requiresUploadToServer() {
        return this.requiresUploadToServer;
    }

    public boolean requiresSaveToFile() {
        return this.getAssociatedFile() != null && this.requiresSaveToFile;
    }

    public void onPostLoadFromFile() {
        this.setRequiresSaveToFile(false);
        this.setRequiresUploadToServer(this.data.isModified());
    }

    public void onPostDownloadFromServer() {
        this.setRequiresSaveToFile(true);
        this.setRequiresUploadToServer(this.data.isModified());
    }

    @Override
    public boolean isChanged() {
        return this.isChanged || this.highlightUpdateCount != this.data.getHighlightUpdateCount();
    }

    public void onPostSaveToFile() {
        this.setRequiresSaveToFile(false);
        this.setRequiresUploadToServer(this.data.isModified());
    }

    public void onPostUploadToServer() {
        this.setRequiresUploadToServer(this.data.isModified());
    }

    @Override
    public void destroy() {
        DataSet.removeSelectionListener(this);
    }

    @Override
    public void processDatasetEvent(AbstractDatasetChangedEvent event) {
        this.isChanged = true;
        this.setRequiresSaveToFile(true);
        this.setRequiresUploadToServer(true);
    }

    @Override
    public void selectionChanged(Collection<? extends OsmPrimitive> newSelection) {
        this.isChanged = true;
    }

    static {
        OsmDataLayer.createHatchTexture();
    }

    private class ConsistencyTestAction
    extends AbstractAction {
        public ConsistencyTestAction() {
            super(I18n.tr("Dataset consistency test"));
        }

        public void actionPerformed(ActionEvent e) {
            String result = DatasetConsistencyTest.runTests(OsmDataLayer.this.data);
            if (result.length() == 0) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("No problems found"));
            } else {
                JPanel p = new JPanel(new GridBagLayout());
                p.add((Component)new JLabel(I18n.tr("Following problems found:")), GBC.eol());
                JTextArea info = new JTextArea(result, 20, 60);
                info.setCaretPosition(0);
                info.setEditable(false);
                p.add((Component)new JScrollPane(info), GBC.eop());
                JOptionPane.showMessageDialog(Main.parent, p, I18n.tr("Warning"), 2);
            }
        }
    }

    public class ConvertToGpxLayerAction
    extends AbstractAction {
        public ConvertToGpxLayerAction() {
            super(I18n.tr("Convert to GPX layer"), ImageProvider.get("converttogpx"));
        }

        public void actionPerformed(ActionEvent e) {
            Main.main.addLayer(new GpxLayer(OsmDataLayer.this.toGpxData(), I18n.tr("Converted from: {0}", OsmDataLayer.this.getName())));
            Main.main.removeLayer(OsmDataLayer.this);
        }
    }

    public static interface CommandQueueListener {
        public void commandChanged(int var1, int var2);
    }

    public static final class DataCountVisitor
    extends AbstractVisitor {
        public int nodes;
        public int ways;
        public int relations;
        public int deletedNodes;
        public int deletedWays;
        public int deletedRelations;

        public void visit(Node n) {
            ++this.nodes;
            if (n.isDeleted()) {
                ++this.deletedNodes;
            }
        }

        public void visit(Way w) {
            ++this.ways;
            if (w.isDeleted()) {
                ++this.deletedWays;
            }
        }

        public void visit(Relation r) {
            ++this.relations;
            if (r.isDeleted()) {
                ++this.deletedRelations;
            }
        }
    }
}

