/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.util;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableCellEditorSupport {
    private Object editor;
    private LinkedList<CellEditorListener> listeners;

    public TableCellEditorSupport(Object editor) {
        this.editor = editor;
        this.listeners = new LinkedList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<CellEditorListener> getListeners() {
        TableCellEditorSupport tableCellEditorSupport = this;
        synchronized (tableCellEditorSupport) {
            return new ArrayList<CellEditorListener>(this.listeners);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCellEditorListener(CellEditorListener l) {
        TableCellEditorSupport tableCellEditorSupport = this;
        synchronized (tableCellEditorSupport) {
            if (l != null && !this.listeners.contains(l)) {
                this.listeners.add(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCellEditorListener(CellEditorListener l) {
        TableCellEditorSupport tableCellEditorSupport = this;
        synchronized (tableCellEditorSupport) {
            if (l != null && this.listeners.contains(l)) {
                this.listeners.remove(l);
            }
        }
    }

    public void fireEditingCanceled() {
        for (CellEditorListener listener : this.getListeners()) {
            listener.editingCanceled(new ChangeEvent(this.editor));
        }
    }

    public void fireEditingStopped() {
        for (CellEditorListener listener : this.getListeners()) {
            listener.editingStopped(new ChangeEvent(this.editor));
        }
    }
}

