/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.io.Reader;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Stack;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.ValidatorHandler;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.LanguageInfo;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLFilterImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlObjectParser
implements Iterable<Object> {
    public static final String lang = LanguageInfo.getLanguageCodeXML();
    private Map<String, Entry> mapping = new HashMap<String, Entry>();
    private Parser parser;
    private BlockingQueue<Object> queue = new ArrayBlockingQueue<Object>(10);
    private Object lookAhead = null;
    private Object EOS = new Object();

    public XmlObjectParser() {
        this.parser = new Parser();
    }

    private Iterable<Object> start(final Reader in, final ContentHandler contentHandler) {
        new Thread("XML Reader"){

            public void run() {
                try {
                    SAXParserFactory parserFactory = SAXParserFactory.newInstance();
                    parserFactory.setNamespaceAware(true);
                    SAXParser parser = parserFactory.newSAXParser();
                    XMLReader reader = parser.getXMLReader();
                    reader.setContentHandler(contentHandler);
                    reader.parse(new InputSource(in));
                }
                catch (Exception e) {
                    try {
                        XmlObjectParser.this.queue.put(e);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                try {
                    XmlObjectParser.this.queue.put(XmlObjectParser.this.EOS);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }.start();
        return this;
    }

    public Iterable<Object> start(Reader in) {
        return this.start(in, this.parser);
    }

    public Iterable<Object> startWithValidation(Reader in, String namespace, Source schemaSource) throws SAXException {
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = factory.newSchema(schemaSource);
        ValidatorHandler validator = schema.newValidatorHandler();
        validator.setContentHandler(this.parser);
        validator.setErrorHandler(this.parser);
        AddNamespaceFilter filter = new AddNamespaceFilter(namespace);
        filter.setContentHandler(validator);
        return this.start(in, filter);
    }

    public void map(String tagName, Class<?> klass) {
        this.mapping.put(tagName, new Entry(klass, false, false));
    }

    public void mapOnStart(String tagName, Class<?> klass) {
        this.mapping.put(tagName, new Entry(klass, true, false));
    }

    public void mapBoth(String tagName, Class<?> klass) {
        this.mapping.put(tagName, new Entry(klass, false, true));
    }

    public Object next() throws SAXException {
        this.fillLookAhead();
        if (this.lookAhead == this.EOS) {
            throw new NoSuchElementException();
        }
        Object o = this.lookAhead;
        this.lookAhead = null;
        return o;
    }

    private void fillLookAhead() throws SAXException {
        if (this.lookAhead != null) {
            return;
        }
        try {
            this.lookAhead = this.queue.take();
            if (this.lookAhead instanceof SAXException) {
                throw (SAXException)this.lookAhead;
            }
            if (this.lookAhead instanceof RuntimeException) {
                throw (RuntimeException)this.lookAhead;
            }
            if (this.lookAhead instanceof Exception) {
                throw new SAXException((Exception)this.lookAhead);
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException("XmlObjectParser must not be interrupted.", e);
        }
    }

    public boolean hasNext() throws SAXException {
        this.fillLookAhead();
        return this.lookAhead != this.EOS;
    }

    @Override
    public Iterator<Object> iterator() {
        return new Iterator<Object>(){

            @Override
            public boolean hasNext() {
                try {
                    return XmlObjectParser.this.hasNext();
                }
                catch (SAXException e) {
                    e.printStackTrace();
                    throw new RuntimeException(e);
                }
            }

            @Override
            public Object next() {
                try {
                    return XmlObjectParser.this.next();
                }
                catch (SAXException e) {
                    e.printStackTrace();
                    throw new RuntimeException(e);
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Entry {
        Class<?> klass;
        boolean onStart;
        boolean both;

        public Entry(Class<?> klass, boolean onStart, boolean both) {
            this.klass = klass;
            this.onStart = onStart;
            this.both = both;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Parser
    extends DefaultHandler {
        Stack<Object> current = new Stack();
        String characters = "";
        private Locator locator;

        private Parser() {
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }

        protected void throwException(Exception e) throws PresetParsingException {
            throw new PresetParsingException(e).rememberLocation(this.locator);
        }

        @Override
        public void startElement(String ns, String lname, String qname, Attributes a) throws SAXException {
            if (XmlObjectParser.this.mapping.containsKey(qname)) {
                Class<?> klass = ((Entry)((XmlObjectParser)XmlObjectParser.this).mapping.get((Object)qname)).klass;
                try {
                    this.current.push(klass.newInstance());
                }
                catch (Exception e) {
                    this.throwException(e);
                }
                for (int i = 0; i < a.getLength(); ++i) {
                    this.setValue(a.getQName(i), a.getValue(i));
                }
                if (((Entry)((XmlObjectParser)XmlObjectParser.this).mapping.get((Object)qname)).onStart) {
                    this.report();
                }
                if (((Entry)((XmlObjectParser)XmlObjectParser.this).mapping.get((Object)qname)).both) {
                    try {
                        XmlObjectParser.this.queue.put(this.current.peek());
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
            }
        }

        @Override
        public void endElement(String ns, String lname, String qname) throws SAXException {
            if (XmlObjectParser.this.mapping.containsKey(qname) && !((Entry)((XmlObjectParser)XmlObjectParser.this).mapping.get((Object)qname)).onStart) {
                this.report();
            } else if (this.characters != null && !this.current.isEmpty()) {
                this.setValue(qname, this.characters.trim());
                this.characters = "";
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            String s = new String(ch, start, length);
            this.characters = this.characters + s;
        }

        private void report() {
            try {
                XmlObjectParser.this.queue.put(this.current.pop());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.characters = "";
        }

        private Object getValueForClass(Class<?> klass, String value) {
            if (klass == Boolean.TYPE) {
                return this.parseBoolean(value);
            }
            if (klass == Integer.TYPE || klass == Long.TYPE) {
                return Long.parseLong(value);
            }
            if (klass == Float.TYPE || klass == Double.TYPE) {
                return Double.parseDouble(value);
            }
            return value;
        }

        private void setValue(String fieldName, String value) throws SAXException {
            if (fieldName.equals("class") || fieldName.equals("default") || fieldName.equals("throw") || fieldName.equals("new") || fieldName.equals("null")) {
                fieldName = fieldName + "_";
            }
            try {
                Field f;
                Object c;
                block12: {
                    c = this.current.peek();
                    f = null;
                    try {
                        f = c.getClass().getField(fieldName);
                    }
                    catch (NoSuchFieldException e) {
                        if (!fieldName.startsWith(lang)) break block12;
                        String locfieldName = "locale_" + fieldName.substring(lang.length());
                        try {
                            f = c.getClass().getField(locfieldName);
                        }
                        catch (NoSuchFieldException ex) {
                            // empty catch block
                        }
                    }
                }
                if (f != null && Modifier.isPublic(f.getModifiers())) {
                    f.set(c, this.getValueForClass(f.getType(), value));
                } else {
                    Method[] methods;
                    if (fieldName.startsWith(lang)) {
                        int l = lang.length();
                        fieldName = "set" + fieldName.substring(l, l + 1).toUpperCase() + fieldName.substring(l + 1);
                    } else {
                        fieldName = "set" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
                    }
                    for (Method m : methods = c.getClass().getDeclaredMethods()) {
                        if (!m.getName().equals(fieldName) || m.getParameterTypes().length != 1) continue;
                        m.invoke(c, this.getValueForClass(m.getParameterTypes()[0], value));
                        return;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.throwException(e);
            }
        }

        private boolean parseBoolean(String s) {
            return s != null && !s.equals("0") && !s.startsWith("off") && !s.startsWith("false") && !s.startsWith("no");
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
            this.throwException(e);
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            this.throwException(e);
        }
    }

    private static class AddNamespaceFilter
    extends XMLFilterImpl {
        private final String namespace;

        public AddNamespaceFilter(String namespace) {
            this.namespace = namespace;
        }

        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            if ("".equals(uri)) {
                super.startElement(this.namespace, localName, qName, atts);
            } else {
                super.startElement(uri, localName, qName, atts);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Uniform<T>
    implements Iterable<T> {
        private Iterator<Object> iterator;

        public Uniform(Reader input, String tagname, Class<T> klass) {
            XmlObjectParser parser = new XmlObjectParser();
            parser.map(tagname, klass);
            parser.start(input);
            this.iterator = parser.iterator();
        }

        @Override
        public Iterator<T> iterator() {
            return new Iterator<T>(){

                @Override
                public boolean hasNext() {
                    return Uniform.this.iterator.hasNext();
                }

                @Override
                public T next() {
                    return Uniform.this.iterator.next();
                }

                @Override
                public void remove() {
                    Uniform.this.iterator.remove();
                }
            };
        }
    }

    public static class PresetParsingException
    extends SAXException {
        private int columnNumber;
        private int lineNumber;

        public PresetParsingException() {
        }

        public PresetParsingException(Exception e) {
            super(e);
        }

        public PresetParsingException(String message, Exception e) {
            super(message, e);
        }

        public PresetParsingException(String message) {
            super(message);
        }

        public PresetParsingException rememberLocation(Locator locator) {
            if (locator == null) {
                return this;
            }
            this.columnNumber = locator.getColumnNumber();
            this.lineNumber = locator.getLineNumber();
            return this;
        }

        public String getMessage() {
            String msg = super.getMessage();
            if (this.lineNumber == 0 && this.columnNumber == 0) {
                return msg;
            }
            if (msg == null) {
                msg = this.getClass().getName();
            }
            msg = msg + " " + I18n.tr("(at line {0}, column {1})", this.lineNumber, this.columnNumber);
            return msg;
        }

        public int getColumnNumber() {
            return this.columnNumber;
        }

        public int getLineNumber() {
            return this.lineNumber;
        }
    }
}

