/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.dom;

import com.sun.org.apache.xerces.internal.dom.CoreDocumentImpl;
import com.sun.org.apache.xerces.internal.dom.DOMMessageFormatter;
import com.sun.org.apache.xerces.internal.dom.NodeImpl;
import java.io.Serializable;
import java.util.Vector;
import org.w3c.dom.DOMException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class NamedNodeMapImpl
implements NamedNodeMap,
Serializable {
    static final long serialVersionUID = -7039242451046758020L;
    protected short flags;
    protected static final short READONLY = 1;
    protected static final short CHANGED = 2;
    protected static final short HASDEFAULTS = 4;
    protected Vector nodes;
    protected NodeImpl ownerNode;

    protected NamedNodeMapImpl(NodeImpl ownerNode) {
        this.ownerNode = ownerNode;
    }

    @Override
    public int getLength() {
        return this.nodes != null ? this.nodes.size() : 0;
    }

    @Override
    public Node item(int index) {
        return this.nodes != null && index < this.nodes.size() ? (Node)this.nodes.elementAt(index) : null;
    }

    @Override
    public Node getNamedItem(String name) {
        int i = this.findNamePoint(name, 0);
        return i < 0 ? null : (Node)this.nodes.elementAt(i);
    }

    @Override
    public Node getNamedItemNS(String namespaceURI, String localName) {
        int i = this.findNamePoint(namespaceURI, localName);
        return i < 0 ? null : (Node)this.nodes.elementAt(i);
    }

    @Override
    public Node setNamedItem(Node arg) throws DOMException {
        CoreDocumentImpl ownerDocument = this.ownerNode.ownerDocument();
        if (ownerDocument.errorChecking) {
            if (this.isReadOnly()) {
                String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NO_MODIFICATION_ALLOWED_ERR", null);
                throw new DOMException(7, msg);
            }
            if (arg.getOwnerDocument() != ownerDocument) {
                String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "WRONG_DOCUMENT_ERR", null);
                throw new DOMException(4, msg);
            }
        }
        int i = this.findNamePoint(arg.getNodeName(), 0);
        NodeImpl previous = null;
        if (i >= 0) {
            previous = (NodeImpl)this.nodes.elementAt(i);
            this.nodes.setElementAt(arg, i);
        } else {
            i = -1 - i;
            if (null == this.nodes) {
                this.nodes = new Vector(5, 10);
            }
            this.nodes.insertElementAt(arg, i);
        }
        return previous;
    }

    @Override
    public Node setNamedItemNS(Node arg) throws DOMException {
        CoreDocumentImpl ownerDocument = this.ownerNode.ownerDocument();
        if (ownerDocument.errorChecking) {
            if (this.isReadOnly()) {
                String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NO_MODIFICATION_ALLOWED_ERR", null);
                throw new DOMException(7, msg);
            }
            if (arg.getOwnerDocument() != ownerDocument) {
                String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "WRONG_DOCUMENT_ERR", null);
                throw new DOMException(4, msg);
            }
        }
        int i = this.findNamePoint(arg.getNamespaceURI(), arg.getLocalName());
        NodeImpl previous = null;
        if (i >= 0) {
            previous = (NodeImpl)this.nodes.elementAt(i);
            this.nodes.setElementAt(arg, i);
        } else {
            i = this.findNamePoint(arg.getNodeName(), 0);
            if (i >= 0) {
                previous = (NodeImpl)this.nodes.elementAt(i);
                this.nodes.insertElementAt(arg, i);
            } else {
                i = -1 - i;
                if (null == this.nodes) {
                    this.nodes = new Vector(5, 10);
                }
                this.nodes.insertElementAt(arg, i);
            }
        }
        return previous;
    }

    @Override
    public Node removeNamedItem(String name) throws DOMException {
        if (this.isReadOnly()) {
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NO_MODIFICATION_ALLOWED_ERR", null);
            throw new DOMException(7, msg);
        }
        int i = this.findNamePoint(name, 0);
        if (i < 0) {
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NOT_FOUND_ERR", null);
            throw new DOMException(8, msg);
        }
        NodeImpl n = (NodeImpl)this.nodes.elementAt(i);
        this.nodes.removeElementAt(i);
        return n;
    }

    @Override
    public Node removeNamedItemNS(String namespaceURI, String name) throws DOMException {
        if (this.isReadOnly()) {
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NO_MODIFICATION_ALLOWED_ERR", null);
            throw new DOMException(7, msg);
        }
        int i = this.findNamePoint(namespaceURI, name);
        if (i < 0) {
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NOT_FOUND_ERR", null);
            throw new DOMException(8, msg);
        }
        NodeImpl n = (NodeImpl)this.nodes.elementAt(i);
        this.nodes.removeElementAt(i);
        return n;
    }

    public NamedNodeMapImpl cloneMap(NodeImpl ownerNode) {
        NamedNodeMapImpl newmap = new NamedNodeMapImpl(ownerNode);
        newmap.cloneContent(this);
        return newmap;
    }

    protected void cloneContent(NamedNodeMapImpl srcmap) {
        int size;
        Vector srcnodes = srcmap.nodes;
        if (srcnodes != null && (size = srcnodes.size()) != 0) {
            if (this.nodes == null) {
                this.nodes = new Vector(size);
            }
            this.nodes.setSize(size);
            for (int i = 0; i < size; ++i) {
                NodeImpl n = (NodeImpl)srcmap.nodes.elementAt(i);
                NodeImpl clone = (NodeImpl)n.cloneNode(true);
                clone.isSpecified(n.isSpecified());
                this.nodes.setElementAt(clone, i);
            }
        }
    }

    void setReadOnly(boolean readOnly, boolean deep) {
        this.isReadOnly(readOnly);
        if (deep && this.nodes != null) {
            for (int i = this.nodes.size() - 1; i >= 0; --i) {
                ((NodeImpl)this.nodes.elementAt(i)).setReadOnly(readOnly, deep);
            }
        }
    }

    boolean getReadOnly() {
        return this.isReadOnly();
    }

    void setOwnerDocument(CoreDocumentImpl doc) {
        if (this.nodes != null) {
            for (int i = 0; i < this.nodes.size(); ++i) {
                ((NodeImpl)this.item(i)).setOwnerDocument(doc);
            }
        }
    }

    final boolean isReadOnly() {
        return (this.flags & 1) != 0;
    }

    final void isReadOnly(boolean value) {
        this.flags = (short)(value ? this.flags | 1 : this.flags & 0xFFFFFFFE);
    }

    final boolean changed() {
        return (this.flags & 2) != 0;
    }

    final void changed(boolean value) {
        this.flags = (short)(value ? this.flags | 2 : this.flags & 0xFFFFFFFD);
    }

    final boolean hasDefaults() {
        return (this.flags & 4) != 0;
    }

    final void hasDefaults(boolean value) {
        this.flags = (short)(value ? this.flags | 4 : this.flags & 0xFFFFFFFB);
    }

    protected int findNamePoint(String name, int start) {
        int i = 0;
        if (this.nodes != null) {
            int first = start;
            int last = this.nodes.size() - 1;
            while (first <= last) {
                i = (first + last) / 2;
                int test = name.compareTo(((Node)this.nodes.elementAt(i)).getNodeName());
                if (test == 0) {
                    return i;
                }
                if (test < 0) {
                    last = i - 1;
                    continue;
                }
                first = i + 1;
            }
            if (first > i) {
                i = first;
            }
        }
        return -1 - i;
    }

    protected int findNamePoint(String namespaceURI, String name) {
        if (this.nodes == null) {
            return -1;
        }
        if (name == null) {
            return -1;
        }
        if (namespaceURI != null) {
            namespaceURI = namespaceURI.length() == 0 ? null : namespaceURI;
        }
        for (int i = 0; i < this.nodes.size(); ++i) {
            NodeImpl a = (NodeImpl)this.nodes.elementAt(i);
            String aNamespaceURI = a.getNamespaceURI();
            String aLocalName = a.getLocalName();
            if (!(namespaceURI == null ? aNamespaceURI == null && (name.equals(aLocalName) || aLocalName == null && name.equals(a.getNodeName())) : namespaceURI.equals(aNamespaceURI) && name.equals(aLocalName))) continue;
            return i;
        }
        return -1;
    }

    protected boolean precedes(Node a, Node b) {
        if (this.nodes != null) {
            for (int i = 0; i < this.nodes.size(); ++i) {
                Node n = (Node)this.nodes.elementAt(i);
                if (n == a) {
                    return true;
                }
                if (n != b) continue;
                return false;
            }
        }
        return false;
    }

    protected void removeItem(int index) {
        if (this.nodes != null && index < this.nodes.size()) {
            this.nodes.removeElementAt(index);
        }
    }

    protected Object getItem(int index) {
        if (this.nodes != null) {
            return this.nodes.elementAt(index);
        }
        return null;
    }

    protected int addItem(Node arg) {
        int i = this.findNamePoint(arg.getNamespaceURI(), arg.getLocalName());
        if (i >= 0) {
            this.nodes.setElementAt(arg, i);
        } else {
            i = this.findNamePoint(arg.getNodeName(), 0);
            if (i >= 0) {
                this.nodes.insertElementAt(arg, i);
            } else {
                i = -1 - i;
                if (null == this.nodes) {
                    this.nodes = new Vector(5, 10);
                }
                this.nodes.insertElementAt(arg, i);
            }
        }
        return i;
    }

    protected Vector cloneMap(Vector list) {
        if (list == null) {
            list = new Vector(5, 10);
        }
        list.setSize(0);
        if (this.nodes != null) {
            for (int i = 0; i < this.nodes.size(); ++i) {
                list.insertElementAt(this.nodes.elementAt(i), i);
            }
        }
        return list;
    }

    protected int getNamedItemIndex(String namespaceURI, String localName) {
        return this.findNamePoint(namespaceURI, localName);
    }

    public void removeAll() {
        if (this.nodes != null) {
            this.nodes.removeAllElements();
        }
    }
}

