/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.impl;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jruby.Ruby;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyRegexp;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.ast.NodeType;
import org.jruby.ast.executable.AbstractScript;
import org.jruby.ast.executable.RuntimeCache;
import org.jruby.compiler.ASTInspector;
import org.jruby.compiler.CacheCompiler;
import org.jruby.compiler.CompilerCallback;
import org.jruby.compiler.impl.BaseBodyCompiler;
import org.jruby.compiler.impl.SkinnyMethodAdapter;
import org.jruby.compiler.impl.StandardASMCompiler;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.BlockBody;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.CallType;
import org.jruby.runtime.CompiledBlockCallback;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.CodegenUtils;
import org.objectweb.asm.Label;

public class InheritedCacheCompiler
implements CacheCompiler {
    protected StandardASMCompiler scriptCompiler;
    int scopeCount = 0;
    int callSiteCount = 0;
    List<String> callSiteList = new ArrayList<String>();
    List<CallType> callTypeList = new ArrayList<CallType>();
    Map<String, Integer> stringIndices = new HashMap<String, Integer>();
    Map<BigInteger, String> bigIntegers = new HashMap<BigInteger, String>();
    Map<String, Integer> symbolIndices = new HashMap<String, Integer>();
    Map<Long, Integer> fixnumIndices = new HashMap<Long, Integer>();
    int inheritedSymbolCount = 0;
    int inheritedStringCount = 0;
    int inheritedRegexpCount = 0;
    int inheritedBigIntegerCount = 0;
    int inheritedVariableReaderCount = 0;
    int inheritedVariableWriterCount = 0;
    int inheritedFixnumCount = 0;
    int inheritedConstantCount = 0;
    int inheritedBlockBodyCount = 0;
    int inheritedBlockCallbackCount = 0;
    int inheritedMethodCount = 0;
    boolean runtimeCacheInited = false;

    public InheritedCacheCompiler(StandardASMCompiler scriptCompiler) {
        this.scriptCompiler = scriptCompiler;
    }

    public void cacheStaticScope(BaseBodyCompiler method2, StaticScope scope) {
        StringBuffer scopeNames = new StringBuffer();
        for (int i = 0; i < scope.getVariables().length; ++i) {
            if (i != 0) {
                scopeNames.append(';');
            }
            scopeNames.append(scope.getVariables()[i]);
        }
        method2.loadThis();
        method2.loadThreadContext();
        method2.method.ldc(scopeNames.toString());
        if (this.scopeCount < 10) {
            method2.method.invokevirtual(this.scriptCompiler.getClassname(), "getScope" + this.scopeCount, CodegenUtils.sig(StaticScope.class, ThreadContext.class, String.class));
        } else {
            method2.method.pushInt(this.scopeCount);
            method2.method.invokevirtual(this.scriptCompiler.getClassname(), "getScope", CodegenUtils.sig(StaticScope.class, ThreadContext.class, String.class, Integer.TYPE));
        }
        ++this.scopeCount;
    }

    public void cacheCallSite(BaseBodyCompiler method2, String name2, CallType callType) {
        method2.loadThis();
        if (this.callSiteCount < 10) {
            method2.method.invokevirtual(this.scriptCompiler.getClassname(), "getCallSite" + this.callSiteCount, CodegenUtils.sig(CallSite.class, new Class[0]));
        } else {
            method2.method.pushInt(this.callSiteCount);
            method2.method.invokevirtual(this.scriptCompiler.getClassname(), "getCallSite", CodegenUtils.sig(CallSite.class, Integer.TYPE));
        }
        this.callSiteList.add(name2);
        this.callTypeList.add(callType);
        ++this.callSiteCount;
    }

    public void cacheSymbol(BaseBodyCompiler method2, String symbol) {
        Integer index2 = this.symbolIndices.get(symbol);
        if (index2 == null) {
            index2 = this.inheritedSymbolCount++;
            this.symbolIndices.put(symbol, index2);
        }
        method2.loadThis();
        method2.loadRuntime();
        if (index2 < 10) {
            method2.method.ldc(symbol);
            method2.method.invokevirtual(this.scriptCompiler.getClassname(), "getSymbol" + index2, CodegenUtils.sig(RubySymbol.class, Ruby.class, String.class));
        } else {
            method2.method.ldc((int)index2);
            method2.method.ldc(symbol);
            method2.method.invokevirtual(this.scriptCompiler.getClassname(), "getSymbol", CodegenUtils.sig(RubySymbol.class, Ruby.class, Integer.TYPE, String.class));
        }
    }

    public void cacheRegexp(BaseBodyCompiler method2, String pattern, int options2) {
        method2.loadThis();
        method2.loadRuntime();
        int index2 = this.inheritedRegexpCount++;
        if (index2 < 10) {
            method2.method.ldc(pattern);
            method2.method.ldc(options2);
            method2.method.invokevirtual(this.scriptCompiler.getClassname(), "getRegexp" + index2, CodegenUtils.sig(RubyRegexp.class, Ruby.class, String.class, Integer.TYPE));
        } else {
            method2.method.pushInt(index2);
            method2.method.ldc(pattern);
            method2.method.ldc(options2);
            method2.method.invokevirtual(this.scriptCompiler.getClassname(), "getRegexp", CodegenUtils.sig(RubyRegexp.class, Ruby.class, Integer.TYPE, String.class, Integer.TYPE));
        }
    }

    public void cacheDRegexp(BaseBodyCompiler method2, CompilerCallback createStringCallback, int options2) {
        int index2 = this.inheritedRegexpCount++;
        Label alreadyCompiled = new Label();
        method2.loadThis();
        method2.method.getfield(this.scriptCompiler.getClassname(), "runtimeCache", CodegenUtils.ci(RuntimeCache.class));
        method2.method.pushInt(index2);
        method2.method.invokevirtual(CodegenUtils.p(RuntimeCache.class), "getRegexp", CodegenUtils.sig(RubyRegexp.class, Integer.TYPE));
        method2.method.dup();
        method2.ifNotNull(alreadyCompiled);
        method2.method.pop();
        method2.loadThis();
        method2.method.getfield(this.scriptCompiler.getClassname(), "runtimeCache", CodegenUtils.ci(RuntimeCache.class));
        method2.method.pushInt(index2);
        createStringCallback.call(method2);
        method2.method.ldc(options2);
        method2.method.invokevirtual(CodegenUtils.p(RuntimeCache.class), "cacheRegexp", CodegenUtils.sig(RubyRegexp.class, Integer.TYPE, RubyString.class, Integer.TYPE));
        method2.method.label(alreadyCompiled);
    }

    public void cacheFixnum(BaseBodyCompiler method2, long value2) {
        block15: {
            block14: {
                if (value2 > 5L || value2 < -1L) break block14;
                method2.loadRuntime();
                switch ((int)value2) {
                    case -1: {
                        method2.method.invokestatic(CodegenUtils.p(RubyFixnum.class), "minus_one", CodegenUtils.sig(RubyFixnum.class, Ruby.class));
                        break block15;
                    }
                    case 0: {
                        method2.method.invokestatic(CodegenUtils.p(RubyFixnum.class), "zero", CodegenUtils.sig(RubyFixnum.class, Ruby.class));
                        break block15;
                    }
                    case 1: {
                        method2.method.invokestatic(CodegenUtils.p(RubyFixnum.class), "one", CodegenUtils.sig(RubyFixnum.class, Ruby.class));
                        break block15;
                    }
                    case 2: {
                        method2.method.invokestatic(CodegenUtils.p(RubyFixnum.class), "two", CodegenUtils.sig(RubyFixnum.class, Ruby.class));
                        break block15;
                    }
                    case 3: {
                        method2.method.invokestatic(CodegenUtils.p(RubyFixnum.class), "three", CodegenUtils.sig(RubyFixnum.class, Ruby.class));
                        break block15;
                    }
                    case 4: {
                        method2.method.invokestatic(CodegenUtils.p(RubyFixnum.class), "four", CodegenUtils.sig(RubyFixnum.class, Ruby.class));
                        break block15;
                    }
                    case 5: {
                        method2.method.invokestatic(CodegenUtils.p(RubyFixnum.class), "five", CodegenUtils.sig(RubyFixnum.class, Ruby.class));
                        break block15;
                    }
                    default: {
                        throw new RuntimeException("wtf?");
                    }
                }
            }
            Integer index2 = this.fixnumIndices.get(value2);
            if (index2 == null) {
                index2 = this.inheritedFixnumCount++;
                this.fixnumIndices.put(value2, index2);
            }
            method2.loadThis();
            method2.loadRuntime();
            if (value2 <= Integer.MAX_VALUE && value2 >= Integer.MIN_VALUE) {
                if (index2 < 10) {
                    method2.method.pushInt((int)value2);
                    method2.method.invokevirtual(this.scriptCompiler.getClassname(), "getFixnum" + index2, CodegenUtils.sig(RubyFixnum.class, Ruby.class, Integer.TYPE));
                } else {
                    method2.method.pushInt(index2);
                    method2.method.pushInt((int)value2);
                    method2.method.invokevirtual(this.scriptCompiler.getClassname(), "getFixnum", CodegenUtils.sig(RubyFixnum.class, Ruby.class, Integer.TYPE, Integer.TYPE));
                }
            } else {
                method2.method.pushInt(index2);
                method2.method.ldc(value2);
                method2.method.invokevirtual(this.scriptCompiler.getClassname(), "getFixnum", CodegenUtils.sig(RubyFixnum.class, Ruby.class, Integer.TYPE, Long.TYPE));
            }
        }
    }

    public void cacheConstant(BaseBodyCompiler method2, String constantName) {
        method2.loadThis();
        method2.loadThreadContext();
        method2.method.ldc(constantName);
        if (this.inheritedConstantCount < 10) {
            method2.method.invokevirtual(this.scriptCompiler.getClassname(), "getConstant" + this.inheritedConstantCount, CodegenUtils.sig(IRubyObject.class, ThreadContext.class, String.class));
        } else {
            method2.method.pushInt(this.inheritedConstantCount);
            method2.method.invokevirtual(this.scriptCompiler.getClassname(), "getConstant", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, String.class, Integer.TYPE));
        }
        ++this.inheritedConstantCount;
    }

    public void cacheConstantFrom(BaseBodyCompiler method2, String constantName) {
        method2.loadThis();
        method2.method.swap();
        method2.loadThreadContext();
        method2.method.ldc(constantName);
        if (this.inheritedConstantCount < 10) {
            method2.method.invokevirtual(this.scriptCompiler.getClassname(), "getConstantFrom" + this.inheritedConstantCount, CodegenUtils.sig(IRubyObject.class, RubyModule.class, ThreadContext.class, String.class));
        } else {
            method2.method.pushInt(this.inheritedConstantCount);
            method2.method.invokevirtual(this.scriptCompiler.getClassname(), "getConstantFrom", CodegenUtils.sig(IRubyObject.class, RubyModule.class, ThreadContext.class, String.class, Integer.TYPE));
        }
        ++this.inheritedConstantCount;
    }

    public void cacheString(BaseBodyCompiler method2, ByteList contents) {
        String asString = contents.toString();
        Integer index2 = this.stringIndices.get(asString);
        if (index2 == null) {
            index2 = this.inheritedStringCount++;
            this.stringIndices.put(asString, index2);
        }
        method2.loadThis();
        method2.loadRuntime();
        if (index2 < 10) {
            method2.method.invokevirtual(this.scriptCompiler.getClassname(), "getString" + index2, CodegenUtils.sig(RubyString.class, Ruby.class));
        } else {
            method2.method.ldc((int)index2);
            method2.method.invokevirtual(this.scriptCompiler.getClassname(), "getString", CodegenUtils.sig(RubyString.class, Ruby.class, Integer.TYPE));
        }
    }

    public void cacheBigInteger(BaseBodyCompiler method2, BigInteger bigint) {
        method2.loadThis();
        method2.loadRuntime();
        int index2 = this.inheritedBigIntegerCount++;
        if (index2 < 10) {
            method2.method.ldc(bigint.toString(16));
            method2.method.invokevirtual(this.scriptCompiler.getClassname(), "getBigInteger" + index2, CodegenUtils.sig(BigInteger.class, Ruby.class, String.class));
        } else {
            method2.method.pushInt(index2);
            method2.method.ldc(bigint.toString(16));
            method2.method.invokevirtual(this.scriptCompiler.getClassname(), "getBigInteger", CodegenUtils.sig(BigInteger.class, Ruby.class, Integer.TYPE, String.class));
        }
    }

    public void cachedGetVariable(BaseBodyCompiler method2, String name2) {
        method2.loadThis();
        method2.loadRuntime();
        int index2 = this.inheritedVariableReaderCount++;
        if (index2 < 10) {
            method2.method.ldc(name2);
            method2.loadSelf();
            method2.method.invokevirtual(this.scriptCompiler.getClassname(), "getVariable" + index2, CodegenUtils.sig(IRubyObject.class, Ruby.class, String.class, IRubyObject.class));
        } else {
            method2.method.pushInt(index2);
            method2.method.ldc(name2);
            method2.loadSelf();
            method2.method.invokevirtual(this.scriptCompiler.getClassname(), "getVariable", CodegenUtils.sig(IRubyObject.class, Ruby.class, Integer.TYPE, String.class, IRubyObject.class));
        }
    }

    public void cachedSetVariable(BaseBodyCompiler method2, String name2, CompilerCallback valueCallback) {
        method2.loadThis();
        method2.loadRuntime();
        int index2 = this.inheritedVariableWriterCount++;
        if (index2 < 10) {
            method2.method.ldc(name2);
            method2.loadSelf();
            valueCallback.call(method2);
            method2.method.invokevirtual(this.scriptCompiler.getClassname(), "setVariable" + index2, CodegenUtils.sig(IRubyObject.class, Ruby.class, String.class, IRubyObject.class, IRubyObject.class));
        } else {
            method2.method.pushInt(index2);
            method2.method.ldc(name2);
            method2.loadSelf();
            valueCallback.call(method2);
            method2.method.invokevirtual(this.scriptCompiler.getClassname(), "setVariable", CodegenUtils.sig(IRubyObject.class, Ruby.class, Integer.TYPE, String.class, IRubyObject.class, IRubyObject.class));
        }
    }

    public void cacheClosure(BaseBodyCompiler method2, String closureMethod, int arity2, StaticScope scope, boolean hasMultipleArgsHead, NodeType argsNodeId, ASTInspector inspector) {
        StringBuffer scopeNames = new StringBuffer();
        for (int i = 0; i < scope.getVariables().length; ++i) {
            if (i != 0) {
                scopeNames.append(';');
            }
            scopeNames.append(scope.getVariables()[i]);
        }
        String descriptor = closureMethod + ',' + arity2 + ',' + scopeNames + ',' + hasMultipleArgsHead + ',' + BlockBody.asArgumentType(argsNodeId) + ',' + (!inspector.hasClosure() && !inspector.hasScopeAwareMethods());
        method2.loadThis();
        method2.loadThreadContext();
        if (this.inheritedBlockBodyCount < 10) {
            method2.method.ldc(descriptor);
            method2.method.invokevirtual(this.scriptCompiler.getClassname(), "getBlockBody" + this.inheritedBlockBodyCount, CodegenUtils.sig(BlockBody.class, ThreadContext.class, String.class));
        } else {
            method2.method.pushInt(this.inheritedBlockBodyCount);
            method2.method.ldc(descriptor);
            method2.method.invokevirtual(this.scriptCompiler.getClassname(), "getBlockBody", CodegenUtils.sig(BlockBody.class, ThreadContext.class, Integer.TYPE, String.class));
        }
        ++this.inheritedBlockBodyCount;
    }

    public void cacheClosure19(BaseBodyCompiler method2, String closureMethod, int arity2, StaticScope scope, boolean hasMultipleArgsHead, NodeType argsNodeId, ASTInspector inspector) {
        StringBuffer scopeNames = new StringBuffer();
        for (int i = 0; i < scope.getVariables().length; ++i) {
            if (i != 0) {
                scopeNames.append(';');
            }
            scopeNames.append(scope.getVariables()[i]);
        }
        String descriptor = closureMethod + ',' + arity2 + ',' + scopeNames + ',' + hasMultipleArgsHead + ',' + BlockBody.asArgumentType(argsNodeId) + ',' + (!inspector.hasClosure() && !inspector.hasScopeAwareMethods());
        method2.loadThis();
        method2.loadThreadContext();
        if (this.inheritedBlockBodyCount < 10) {
            method2.method.ldc(descriptor);
            method2.method.invokevirtual(this.scriptCompiler.getClassname(), "getBlockBody19" + this.inheritedBlockBodyCount, CodegenUtils.sig(BlockBody.class, ThreadContext.class, String.class));
        } else {
            method2.method.pushInt(this.inheritedBlockBodyCount);
            method2.method.ldc(descriptor);
            method2.method.invokevirtual(this.scriptCompiler.getClassname(), "getBlockBody19", CodegenUtils.sig(BlockBody.class, ThreadContext.class, Integer.TYPE, String.class));
        }
        ++this.inheritedBlockBodyCount;
    }

    public void cacheSpecialClosure(BaseBodyCompiler method2, String closureMethod) {
        method2.loadThis();
        method2.loadRuntime();
        if (this.inheritedBlockCallbackCount < 10) {
            method2.method.ldc(closureMethod);
            method2.method.invokevirtual(this.scriptCompiler.getClassname(), "getBlockCallback" + this.inheritedBlockCallbackCount, CodegenUtils.sig(CompiledBlockCallback.class, Ruby.class, String.class));
        } else {
            method2.method.pushInt(this.inheritedBlockCallbackCount);
            method2.method.ldc(closureMethod);
            method2.method.invokevirtual(this.scriptCompiler.getClassname(), "getBlockCallback", CodegenUtils.sig(CompiledBlockCallback.class, Ruby.class, Integer.TYPE, String.class));
        }
        ++this.inheritedBlockCallbackCount;
    }

    public void cacheMethod(BaseBodyCompiler method2, String methodName) {
        method2.loadThis();
        method2.loadThreadContext();
        method2.loadSelf();
        if (this.inheritedMethodCount < 10) {
            method2.method.ldc(methodName);
            method2.method.invokevirtual(this.scriptCompiler.getClassname(), "getMethod" + this.inheritedMethodCount, CodegenUtils.sig(DynamicMethod.class, ThreadContext.class, IRubyObject.class, String.class));
        } else {
            method2.method.pushInt(this.inheritedMethodCount);
            method2.method.ldc(methodName);
            method2.method.invokevirtual(this.scriptCompiler.getClassname(), "getMethod", CodegenUtils.sig(DynamicMethod.class, ThreadContext.class, IRubyObject.class, Integer.TYPE, String.class));
        }
        ++this.inheritedMethodCount;
    }

    public void cacheMethod(BaseBodyCompiler method2, String methodName, int receiverLocal) {
        method2.loadThis();
        method2.loadThreadContext();
        method2.method.aload(receiverLocal);
        if (this.inheritedMethodCount < 10) {
            method2.method.ldc(methodName);
            method2.method.invokevirtual(this.scriptCompiler.getClassname(), "getMethod" + this.inheritedMethodCount, CodegenUtils.sig(DynamicMethod.class, ThreadContext.class, IRubyObject.class, String.class));
        } else {
            method2.method.pushInt(this.inheritedMethodCount);
            method2.method.ldc(methodName);
            method2.method.invokevirtual(this.scriptCompiler.getClassname(), "getMethod", CodegenUtils.sig(DynamicMethod.class, ThreadContext.class, IRubyObject.class, Integer.TYPE, String.class));
        }
        ++this.inheritedMethodCount;
    }

    public void finish() {
        int otherCount;
        SkinnyMethodAdapter initMethod = this.scriptCompiler.getInitMethod();
        int callSiteCount = this.callSiteList.size();
        if (callSiteCount + (otherCount = this.scopeCount + this.inheritedSymbolCount + this.inheritedFixnumCount + this.inheritedConstantCount + this.inheritedRegexpCount + this.inheritedBigIntegerCount + this.inheritedVariableReaderCount + this.inheritedVariableWriterCount + this.inheritedBlockBodyCount + this.inheritedBlockCallbackCount + this.inheritedMethodCount + this.inheritedStringCount) != 0) {
            this.ensureRuntimeCacheInited(initMethod);
            StringBuffer descriptor = new StringBuffer(callSiteCount * 5 + 12);
            for (int i = 0; i < callSiteCount; ++i) {
                String name2 = this.callSiteList.get(i);
                CallType callType = this.callTypeList.get(i);
                if (i > 0) {
                    descriptor.append('\uffff');
                }
                if (callType.equals((Object)CallType.NORMAL)) {
                    descriptor.append(name2).append("\uffffN");
                    continue;
                }
                if (callType.equals((Object)CallType.FUNCTIONAL)) {
                    descriptor.append(name2).append("\uffffF");
                    continue;
                }
                if (callType.equals((Object)CallType.VARIABLE)) {
                    descriptor.append(name2).append("\uffffV");
                    continue;
                }
                if (!callType.equals((Object)CallType.SUPER)) continue;
                descriptor.append("super").append("\uffffS");
            }
            descriptor.append('\uffff');
            descriptor.append((char)this.scopeCount);
            descriptor.append((char)this.inheritedSymbolCount);
            descriptor.append((char)this.inheritedFixnumCount);
            descriptor.append((char)this.inheritedConstantCount);
            descriptor.append((char)this.inheritedRegexpCount);
            descriptor.append((char)this.inheritedBigIntegerCount);
            descriptor.append((char)this.inheritedVariableReaderCount);
            descriptor.append((char)this.inheritedVariableWriterCount);
            descriptor.append((char)this.inheritedBlockBodyCount);
            descriptor.append((char)this.inheritedBlockCallbackCount);
            descriptor.append((char)this.inheritedMethodCount);
            descriptor.append((char)this.inheritedStringCount);
            initMethod.aload(0);
            initMethod.ldc(descriptor.toString());
            initMethod.invokevirtual(CodegenUtils.p(AbstractScript.class), "initFromDescriptor", CodegenUtils.sig(Void.TYPE, String.class));
            if (this.inheritedStringCount > 0) {
                for (Map.Entry<String, Integer> entry : this.stringIndices.entrySet()) {
                    initMethod.aload(0);
                    initMethod.ldc(entry.getValue());
                    initMethod.ldc(entry.getKey());
                    initMethod.invokevirtual(CodegenUtils.p(AbstractScript.class), "setByteList", CodegenUtils.sig(Void.TYPE, Integer.TYPE, String.class));
                }
            }
        }
    }

    private void ensureRuntimeCacheInited(SkinnyMethodAdapter initMethod) {
        if (!this.runtimeCacheInited) {
            initMethod.aload(0);
            initMethod.newobj(CodegenUtils.p(RuntimeCache.class));
            initMethod.dup();
            initMethod.invokespecial(CodegenUtils.p(RuntimeCache.class), "<init>", CodegenUtils.sig(Void.TYPE, new Class[0]));
            initMethod.putfield(CodegenUtils.p(AbstractScript.class), "runtimeCache", CodegenUtils.ci(RuntimeCache.class));
            this.runtimeCacheInited = true;
        }
    }
}

