/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.util.Arrays;
import java.util.Map;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CodegenUtils {
    public static String c(String p2) {
        return p2.replace('/', '.');
    }

    public static String p(Class n) {
        return n.getName().replace('.', '/');
    }

    public static String ci(Class n) {
        if (n.isArray()) {
            if ((n = n.getComponentType()).isPrimitive()) {
                if (n == Byte.TYPE) {
                    return "[B";
                }
                if (n == Boolean.TYPE) {
                    return "[Z";
                }
                if (n == Short.TYPE) {
                    return "[S";
                }
                if (n == Character.TYPE) {
                    return "[C";
                }
                if (n == Integer.TYPE) {
                    return "[I";
                }
                if (n == Float.TYPE) {
                    return "[F";
                }
                if (n == Double.TYPE) {
                    return "[D";
                }
                if (n == Long.TYPE) {
                    return "[J";
                }
                throw new RuntimeException("Unrecognized type in compiler: " + n.getName());
            }
            return "[" + CodegenUtils.ci(n);
        }
        if (n.isPrimitive()) {
            if (n == Byte.TYPE) {
                return "B";
            }
            if (n == Boolean.TYPE) {
                return "Z";
            }
            if (n == Short.TYPE) {
                return "S";
            }
            if (n == Character.TYPE) {
                return "C";
            }
            if (n == Integer.TYPE) {
                return "I";
            }
            if (n == Float.TYPE) {
                return "F";
            }
            if (n == Double.TYPE) {
                return "D";
            }
            if (n == Long.TYPE) {
                return "J";
            }
            if (n == Void.TYPE) {
                return "V";
            }
            throw new RuntimeException("Unrecognized type in compiler: " + n.getName());
        }
        return "L" + CodegenUtils.p(n) + ";";
    }

    public static String human(Class n) {
        return n.getCanonicalName();
    }

    public static String sig(Class retval, Class ... params2) {
        return CodegenUtils.sigParams(params2) + CodegenUtils.ci(retval);
    }

    public static String sig(Class[] retvalParams) {
        Class[] justParams = new Class[retvalParams.length - 1];
        System.arraycopy(retvalParams, 1, justParams, 0, justParams.length);
        return CodegenUtils.sigParams(justParams) + CodegenUtils.ci(retvalParams[0]);
    }

    public static String sig(Class retval, String descriptor, Class ... params2) {
        return CodegenUtils.sigParams(descriptor, params2) + CodegenUtils.ci(retval);
    }

    public static String sigParams(Class ... params2) {
        StringBuilder signature = new StringBuilder("(");
        for (int i = 0; i < params2.length; ++i) {
            signature.append(CodegenUtils.ci(params2[i]));
        }
        signature.append(")");
        return signature.toString();
    }

    public static String sigParams(String descriptor, Class ... params2) {
        StringBuilder signature = new StringBuilder("(");
        signature.append(descriptor);
        for (int i = 0; i < params2.length; ++i) {
            signature.append(CodegenUtils.ci(params2[i]));
        }
        signature.append(")");
        return signature.toString();
    }

    public static String pretty(Class retval, Class ... params2) {
        return CodegenUtils.prettyParams(params2) + CodegenUtils.human(retval);
    }

    public static String prettyParams(Class ... params2) {
        StringBuilder signature = new StringBuilder("(");
        for (int i = 0; i < params2.length; ++i) {
            signature.append(CodegenUtils.human(params2[i]));
            if (i >= params2.length - 1) continue;
            signature.append(',');
        }
        signature.append(")");
        return signature.toString();
    }

    public static Class[] params(Class ... classes2) {
        return classes2;
    }

    public static Class[] params(Class cls, int times2) {
        Object[] classes2 = new Class[times2];
        Arrays.fill(classes2, cls);
        return classes2;
    }

    public static Class[] params(Class cls1, Class clsFill, int times2) {
        Object[] classes2 = new Class[times2 + 1];
        Arrays.fill(classes2, clsFill);
        classes2[0] = cls1;
        return classes2;
    }

    public static Class[] params(Class cls1, Class cls2, Class clsFill, int times2) {
        Object[] classes2 = new Class[times2 + 2];
        Arrays.fill(classes2, clsFill);
        classes2[0] = cls1;
        classes2[1] = cls2;
        return classes2;
    }

    public static String getAnnotatedBindingClassName(String javaMethodName, String typeName, boolean isStatic, int required, int optional, boolean multi, boolean framed) {
        String marker;
        String string2 = marker = framed ? "$RUBYFRAMEDINVOKER$" : "$RUBYINVOKER$";
        String commonClassSuffix = multi ? (isStatic ? "$s" : "$i") + "_method_multi" + marker + javaMethodName : (isStatic ? "$s" : "$i") + "_method_" + required + "_" + optional + marker + javaMethodName;
        return typeName + commonClassSuffix;
    }

    public static void visitAnnotationFields(AnnotationVisitor visitor, Map<String, Object> fields2) {
        for (Map.Entry<String, Object> fieldEntry : fields2.entrySet()) {
            Object value2 = fieldEntry.getValue();
            if (value2.getClass().isArray()) {
                Object[] values = (Object[])value2;
                AnnotationVisitor arrayV = visitor.visitArray(fieldEntry.getKey());
                for (int i = 0; i < values.length; ++i) {
                    arrayV.visit(null, values[i]);
                }
                arrayV.visitEnd();
                continue;
            }
            if (value2.getClass().isEnum()) {
                visitor.visitEnum(fieldEntry.getKey(), CodegenUtils.ci(value2.getClass()), value2.toString());
                continue;
            }
            if (value2 instanceof Class) {
                visitor.visit(fieldEntry.getKey(), Type.getType((Class)value2));
                continue;
            }
            visitor.visit(fieldEntry.getKey(), value2);
        }
    }

    public static Class getBoxType(Class type2) {
        if (type2 == Integer.TYPE) {
            return Integer.class;
        }
        if (type2 == Byte.TYPE) {
            return Byte.class;
        }
        if (type2 == Short.TYPE) {
            return Short.class;
        }
        if (type2 == Character.TYPE) {
            return Character.class;
        }
        if (type2 == Long.TYPE) {
            return Long.class;
        }
        if (type2 == Float.TYPE) {
            return Float.class;
        }
        if (type2 == Double.TYPE) {
            return Double.class;
        }
        if (type2 == Boolean.TYPE) {
            return Boolean.class;
        }
        throw new RuntimeException("Not a native type: " + type2);
    }
}

