/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util.io;

import java.io.EOFException;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.FileChannel;
import java.nio.channels.IllegalBlockingModeException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.Selector;
import java.nio.channels.spi.SelectorProvider;
import org.jruby.Finalizable;
import org.jruby.Ruby;
import org.jruby.platform.Platform;
import org.jruby.util.ByteList;
import org.jruby.util.JRubyFile;
import org.jruby.util.io.BadDescriptorException;
import org.jruby.util.io.CRLFStreamWrapper;
import org.jruby.util.io.ChannelDescriptor;
import org.jruby.util.io.DirectoryAsFileException;
import org.jruby.util.io.FileExistsException;
import org.jruby.util.io.InvalidValueException;
import org.jruby.util.io.ModeFlags;
import org.jruby.util.io.NullChannel;
import org.jruby.util.io.PipeException;
import org.jruby.util.io.SelectorFactory;
import org.jruby.util.io.Stream;

public class ChannelStream
implements Stream,
Finalizable {
    private static final boolean DEBUG = false;
    static final int BUFSIZE = 4096;
    private static final int BULK_READ_SIZE = 16384;
    private static final ByteBuffer EMPTY_BUFFER = ByteBuffer.allocate(0);
    private volatile Ruby runtime;
    protected ModeFlags modes;
    protected boolean sync = false;
    protected volatile ByteBuffer buffer;
    protected boolean reading;
    private ChannelDescriptor descriptor;
    private boolean blocking = true;
    protected int ungotc = -1;
    private volatile boolean closedExplicitly = false;
    private volatile boolean eof = false;

    private ChannelStream(Ruby runtime2, ChannelDescriptor descriptor) {
        this.runtime = runtime2;
        this.descriptor = descriptor;
        this.modes = descriptor.getOriginalModes();
        this.buffer = ByteBuffer.allocate(4096);
        this.buffer.flip();
        this.reading = true;
        runtime2.addInternalFinalizer(this);
    }

    private ChannelStream(Ruby runtime2, ChannelDescriptor descriptor, ModeFlags modes) throws InvalidValueException {
        this(runtime2, descriptor);
        descriptor.checkNewModes(modes);
        this.modes = modes;
    }

    public Ruby getRuntime() {
        return this.runtime;
    }

    public void checkReadable() throws IOException {
        if (!this.modes.isReadable()) {
            throw new IOException("not opened for reading");
        }
    }

    public void checkWritable() throws IOException {
        if (!this.modes.isWritable()) {
            throw new IOException("not opened for writing");
        }
    }

    public void checkPermissionsSubsetOf(ModeFlags subsetModes) {
        subsetModes.isSubsetOf(this.modes);
    }

    public ModeFlags getModes() {
        return this.modes;
    }

    public boolean isSync() {
        return this.sync;
    }

    public void setSync(boolean sync2) {
        this.sync = sync2;
    }

    public void setBinmode() {
    }

    public void waitUntilReady() throws IOException, InterruptedException {
        while (this.ready() == 0) {
            Thread.sleep(10L);
        }
    }

    public boolean readDataBuffered() {
        return this.reading && this.buffer.hasRemaining();
    }

    public boolean writeDataBuffered() {
        return !this.reading && this.buffer.position() > 0;
    }

    private final int refillBuffer() throws IOException {
        this.buffer.clear();
        int n = ((ReadableByteChannel)this.descriptor.getChannel()).read(this.buffer);
        this.buffer.flip();
        return n;
    }

    public synchronized ByteList fgets(ByteList separatorString) throws IOException, BadDescriptorException {
        this.checkReadable();
        this.ensureRead();
        if (separatorString == null) {
            return this.readall();
        }
        ByteList separator = separatorString == PARAGRAPH_DELIMETER ? PARAGRAPH_SEPARATOR : separatorString;
        this.descriptor.checkOpen();
        if (this.feof()) {
            return null;
        }
        int c = this.read();
        if (c == -1) {
            return null;
        }
        this.buffer.position(this.buffer.position() - 1);
        ByteList buf = new ByteList(40);
        byte first2 = separator.getUnsafeBytes()[separator.getBegin()];
        block0: while (true) {
            block11: {
                byte[] bytes2 = this.buffer.array();
                int offset2 = this.buffer.position();
                int max2 = this.buffer.limit();
                for (int i = offset2; i < max2; ++i) {
                    c = bytes2[i];
                    if (c != first2) continue;
                    buf.append(bytes2, offset2, i - offset2);
                    if (i >= max2) {
                        this.buffer.clear();
                    } else {
                        this.buffer.position(i + 1);
                    }
                    break block11;
                }
                buf.append(bytes2, offset2, this.buffer.remaining());
                int read2 = this.refillBuffer();
                if (read2 != -1) continue;
                break;
            }
            for (int i = 0; i < separator.getRealSize() && c != -1; ++i) {
                if (c != separator.getUnsafeBytes()[separator.getBegin() + i]) {
                    buf.append(c);
                    continue block0;
                }
                buf.append(c);
                if (i >= separator.getRealSize() - 1) continue;
                c = this.read();
            }
            break;
        }
        if (separatorString == PARAGRAPH_DELIMETER) {
            while (c == separator.getUnsafeBytes()[separator.getBegin()]) {
                c = this.read();
            }
            this.ungetc(c);
        }
        return buf;
    }

    public synchronized int getline(ByteList dst, byte terminator) throws IOException, BadDescriptorException {
        this.checkReadable();
        this.ensureRead();
        this.descriptor.checkOpen();
        int totalRead = 0;
        boolean found = false;
        if (this.ungotc != -1) {
            dst.append((byte)this.ungotc);
            found = this.ungotc == terminator;
            this.ungotc = -1;
            ++totalRead;
        }
        while (!found) {
            int n;
            byte[] bytes2 = this.buffer.array();
            int begin2 = this.buffer.arrayOffset() + this.buffer.position();
            int end2 = begin2 + this.buffer.remaining();
            int len = 0;
            for (int i = begin2; i < end2 && !found; ++i) {
                found = bytes2[i] == terminator;
                ++len;
            }
            if (len > 0) {
                dst.append(this.buffer, len);
                totalRead += len;
            }
            if (found || (n = this.refillBuffer()) > 0) continue;
            if (n >= 0 || totalRead >= 1) break;
            return -1;
        }
        return totalRead;
    }

    public synchronized int getline(ByteList dst, byte terminator, long limit2) throws IOException, BadDescriptorException {
        this.checkReadable();
        this.ensureRead();
        this.descriptor.checkOpen();
        int totalRead = 0;
        boolean found = false;
        if (this.ungotc != -1) {
            dst.append((byte)this.ungotc);
            found = this.ungotc == terminator;
            this.ungotc = -1;
            --limit2;
            ++totalRead;
        }
        while (!found) {
            int n;
            byte[] bytes2 = this.buffer.array();
            int begin2 = this.buffer.arrayOffset() + this.buffer.position();
            int end2 = begin2 + this.buffer.remaining();
            int len = 0;
            for (int i = begin2; i < end2 && limit2-- > 0L && !found; ++i) {
                found = bytes2[i] == terminator;
                ++len;
            }
            if (limit2 < 1L) {
                found = true;
            }
            if (len > 0) {
                dst.append(this.buffer, len);
                totalRead += len;
            }
            if (found || (n = this.refillBuffer()) > 0) continue;
            if (n >= 0 || totalRead >= 1) break;
            return -1;
        }
        return totalRead;
    }

    public synchronized ByteList readall() throws IOException, BadDescriptorException {
        long fileSize;
        long l = fileSize = this.descriptor.isSeekable() && this.descriptor.getChannel() instanceof FileChannel ? ((FileChannel)this.descriptor.getChannel()).size() : 0L;
        if (fileSize > 0L) {
            this.ensureRead();
            FileChannel channel = (FileChannel)this.descriptor.getChannel();
            long left = fileSize - channel.position() + (long)this.bufferedInputBytesRemaining();
            if (left <= 0L) {
                this.eof = true;
                return null;
            }
            if (left > Integer.MAX_VALUE) {
                if (this.getRuntime() != null) {
                    throw this.getRuntime().newIOError("File too large");
                }
                throw new IOException("File too large");
            }
            ByteList result = new ByteList((int)left);
            ByteBuffer buf = ByteBuffer.wrap(result.getUnsafeBytes(), result.begin(), (int)left);
            this.copyBufferedBytes(buf);
            while (buf.hasRemaining()) {
                int n;
                int MAX_READ_CHUNK = 0x100000;
                ByteBuffer tmp = buf.duplicate();
                if (tmp.remaining() > 0x100000) {
                    tmp.limit(tmp.position() + 0x100000);
                }
                if ((n = channel.read(tmp)) <= 0) break;
                buf.position(tmp.position());
            }
            this.eof = true;
            result.length(buf.position());
            return result;
        }
        if (this.descriptor.isNull()) {
            return new ByteList(0);
        }
        this.checkReadable();
        ByteList byteList = new ByteList();
        ByteList read2 = this.fread(4096);
        if (read2 == null) {
            this.eof = true;
            return byteList;
        }
        while (read2 != null) {
            byteList.append(read2);
            read2 = this.fread(4096);
        }
        return byteList;
    }

    private final int copyBufferedBytes(ByteBuffer dst) {
        int bytesToCopy = dst.remaining();
        if (this.ungotc != -1 && dst.hasRemaining()) {
            dst.put((byte)this.ungotc);
            this.ungotc = -1;
        }
        if (this.buffer.hasRemaining() && dst.hasRemaining()) {
            if (dst.remaining() >= this.buffer.remaining()) {
                dst.put(this.buffer);
            } else {
                ByteBuffer tmp = this.buffer.duplicate();
                tmp.limit(tmp.position() + dst.remaining());
                dst.put(tmp);
                this.buffer.position(tmp.position());
            }
        }
        return bytesToCopy - dst.remaining();
    }

    private final int copyBufferedBytes(byte[] dst, int off, int len) {
        int bytesCopied = 0;
        if (this.ungotc != -1 && len > 0) {
            dst[off++] = (byte)this.ungotc;
            this.ungotc = -1;
            ++bytesCopied;
        }
        int n = Math.min(len - bytesCopied, this.buffer.remaining());
        this.buffer.get(dst, off, n);
        return bytesCopied += n;
    }

    private final int copyBufferedBytes(ByteList dst, int len) {
        int bytesCopied = 0;
        dst.ensure(Math.min(len, this.bufferedInputBytesRemaining()));
        if (bytesCopied < len && this.ungotc != -1) {
            ++bytesCopied;
            dst.append((byte)this.ungotc);
            this.ungotc = -1;
        }
        if (bytesCopied < len && this.buffer.hasRemaining()) {
            int n = Math.min(this.buffer.remaining(), len - bytesCopied);
            dst.append(this.buffer, n);
            bytesCopied += n;
        }
        return bytesCopied;
    }

    private final int bufferedInputBytesRemaining() {
        return this.reading ? this.buffer.remaining() + (this.ungotc != -1 ? 1 : 0) : 0;
    }

    private final boolean hasBufferedInputBytes() {
        return this.reading && (this.buffer.hasRemaining() || this.ungotc != -1);
    }

    private final int bufferedOutputSpaceRemaining() {
        return !this.reading ? this.buffer.remaining() : 0;
    }

    private final boolean hasBufferedOutputSpace() {
        return !this.reading && this.buffer.hasRemaining();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fclose() throws IOException, BadDescriptorException {
        try {
            ChannelStream channelStream = this;
            synchronized (channelStream) {
                this.closedExplicitly = true;
                this.close();
            }
            Object var4_3 = null;
            Ruby localRuntime = this.getRuntime();
            if (localRuntime != null) {
                localRuntime.removeInternalFinalizer(this);
            }
            this.runtime = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            Ruby localRuntime = this.getRuntime();
            if (localRuntime != null) {
                localRuntime.removeInternalFinalizer(this);
            }
            this.runtime = null;
            throw throwable;
        }
    }

    private void close() throws IOException, BadDescriptorException {
        this.flushWrite();
        this.descriptor.close();
        this.buffer = EMPTY_BUFFER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeForFinalize() {
        block5: {
            try {
                try {
                    this.close();
                }
                catch (BadDescriptorException ex) {
                    Object var3_2 = null;
                    this.runtime = null;
                    break block5;
                }
                catch (IOException iOException) {
                    Object var3_3 = null;
                    this.runtime = null;
                }
                Object var3_1 = null;
                this.runtime = null;
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                this.runtime = null;
                throw throwable;
            }
        }
    }

    public synchronized int fflush() throws IOException, BadDescriptorException {
        this.checkWritable();
        try {
            this.flushWrite();
        }
        catch (EOFException eof2) {
            return -1;
        }
        return 0;
    }

    private void flushWrite() throws IOException, BadDescriptorException {
        if (this.reading || !this.modes.isWritable() || this.buffer.position() == 0) {
            return;
        }
        int len = this.buffer.position();
        this.buffer.flip();
        int n = this.descriptor.write(this.buffer);
        if (n != len) {
            // empty if block
        }
        this.buffer.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean flushWrite(boolean block) throws IOException, BadDescriptorException {
        if (this.reading || !this.modes.isWritable() || this.buffer.position() == 0) {
            return false;
        }
        int len = this.buffer.position();
        int nWritten = 0;
        this.buffer.flip();
        if (this.descriptor.getChannel() instanceof SelectableChannel) {
            SelectableChannel selectableChannel = (SelectableChannel)this.descriptor.getChannel();
            Object object = selectableChannel.blockingLock();
            synchronized (object) {
                block10: {
                    boolean oldBlocking = selectableChannel.isBlocking();
                    try {
                        if (oldBlocking != block) {
                            selectableChannel.configureBlocking(block);
                        }
                        nWritten = this.descriptor.write(this.buffer);
                        Object var8_7 = null;
                        if (oldBlocking == block) break block10;
                    }
                    catch (Throwable throwable) {
                        Object var8_8 = null;
                        if (oldBlocking != block) {
                            selectableChannel.configureBlocking(oldBlocking);
                        }
                        throw throwable;
                    }
                    selectableChannel.configureBlocking(oldBlocking);
                }
            }
        } else {
            nWritten = this.descriptor.write(this.buffer);
        }
        if (nWritten != len) {
            this.buffer.compact();
            return false;
        }
        this.buffer.clear();
        return true;
    }

    public InputStream newInputStream() {
        InputStream in = this.descriptor.getBaseInputStream();
        return in == null ? new InputStreamAdapter(this) : in;
    }

    public OutputStream newOutputStream() {
        return new OutputStreamAdapter(this);
    }

    public void clearerr() {
        this.eof = false;
    }

    public boolean feof() throws IOException, BadDescriptorException {
        this.checkReadable();
        return this.eof;
    }

    public synchronized long fgetpos() throws IOException, PipeException, InvalidValueException, BadDescriptorException {
        if (this.descriptor.isSeekable()) {
            FileChannel fileChannel = (FileChannel)this.descriptor.getChannel();
            long pos2 = fileChannel.position();
            if (this.reading) {
                return pos2 - (long)((pos2 -= (long)this.buffer.remaining()) > 0L && this.ungotc != -1 ? 1 : 0);
            }
            return pos2 + (long)this.buffer.position();
        }
        if (this.descriptor.isNull()) {
            return 0L;
        }
        throw new PipeException();
    }

    public synchronized void lseek(long offset2, int type2) throws IOException, InvalidValueException, PipeException, BadDescriptorException {
        if (this.descriptor.isSeekable()) {
            FileChannel fileChannel = (FileChannel)this.descriptor.getChannel();
            this.ungotc = -1;
            int adj = 0;
            if (this.reading) {
                adj = this.buffer.remaining();
                this.buffer.clear();
                this.buffer.flip();
            } else {
                this.flushWrite();
            }
            try {
                switch (type2) {
                    case 0: {
                        fileChannel.position(offset2);
                        break;
                    }
                    case 1: {
                        fileChannel.position(fileChannel.position() - (long)adj + offset2);
                        break;
                    }
                    case 2: {
                        fileChannel.position(fileChannel.size() + offset2);
                    }
                }
            }
            catch (IllegalArgumentException e) {
                throw new InvalidValueException();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                throw ioe;
            }
        } else if (this.descriptor.getChannel() instanceof SelectableChannel) {
            throw new PipeException();
        }
    }

    public synchronized void sync() throws IOException, BadDescriptorException {
        this.flushWrite();
    }

    private void ensureRead() throws IOException, BadDescriptorException {
        if (this.reading) {
            return;
        }
        this.flushWrite();
        this.buffer.clear();
        this.buffer.flip();
        this.reading = true;
    }

    private void ensureReadNonBuffered() throws IOException, BadDescriptorException {
        if (this.reading) {
            if (this.buffer.hasRemaining()) {
                Ruby localRuntime = this.getRuntime();
                if (localRuntime != null) {
                    throw localRuntime.newIOError("sysread for buffered IO");
                }
                throw new IOException("sysread for buffered IO");
            }
        } else {
            this.flushWrite();
            this.buffer.clear();
            this.buffer.flip();
            this.reading = true;
        }
    }

    private void resetForWrite() throws IOException {
        if (this.descriptor.isSeekable()) {
            FileChannel fileChannel = (FileChannel)this.descriptor.getChannel();
            if (this.buffer.hasRemaining()) {
                fileChannel.position(fileChannel.position() - (long)this.buffer.remaining());
            }
        }
        this.buffer.clear();
        this.reading = false;
    }

    private void ensureWrite() throws IOException {
        if (!this.reading) {
            return;
        }
        this.resetForWrite();
    }

    public synchronized ByteList read(int number) throws IOException, BadDescriptorException {
        this.checkReadable();
        this.ensureReadNonBuffered();
        ByteList byteList = new ByteList(number);
        int bytesRead = this.descriptor.read(number, byteList);
        if (bytesRead == -1) {
            this.eof = true;
        }
        return byteList;
    }

    private ByteList bufferedRead(int number) throws IOException, BadDescriptorException {
        this.checkReadable();
        this.ensureRead();
        int resultSize = 0;
        int BULK_THRESHOLD = 131072;
        if (number >= 131072 && this.descriptor.isSeekable() && this.descriptor.getChannel() instanceof FileChannel) {
            FileChannel fileChannel = (FileChannel)this.descriptor.getChannel();
            resultSize = (int)Math.min(fileChannel.size() - fileChannel.position() + (long)this.bufferedInputBytesRemaining(), (long)number);
        } else {
            resultSize = Math.min(this.bufferedInputBytesRemaining(), number);
        }
        ByteList result = new ByteList(resultSize);
        this.bufferedRead(result, number);
        return result;
    }

    private int bufferedRead(ByteList dst, int number) throws IOException, BadDescriptorException {
        int bytesRead = 0;
        bytesRead += this.copyBufferedBytes(dst, number);
        boolean done = false;
        while (number - bytesRead >= 4096) {
            int bytesToRead = Math.min(16384, number - bytesRead);
            int n = this.descriptor.read(bytesToRead, dst);
            if (n == -1) {
                this.eof = true;
                done = true;
                break;
            }
            if (n == 0) {
                done = true;
                break;
            }
            bytesRead += n;
        }
        while (!done && bytesRead < number) {
            int read2 = this.refillBuffer();
            if (read2 == -1) {
                this.eof = true;
                break;
            }
            if (read2 == 0) break;
            int len = Math.min(this.buffer.remaining(), number - bytesRead);
            dst.append(this.buffer, len);
            bytesRead += len;
        }
        if (bytesRead == 0 && number != 0 && this.eof) {
            throw new EOFException();
        }
        return bytesRead;
    }

    private int bufferedRead(ByteBuffer dst, boolean partial) throws IOException, BadDescriptorException {
        this.checkReadable();
        this.ensureRead();
        boolean done = false;
        int bytesRead = 0;
        bytesRead += this.copyBufferedBytes(dst);
        while (!(bytesRead >= 1 && partial || dst.remaining() < 4096 && !dst.isDirect())) {
            int n;
            int bytesToRead;
            ByteBuffer tmpDst = dst;
            if (!dst.isDirect() && (bytesToRead = Math.min(16384, dst.remaining())) < dst.remaining()) {
                tmpDst = dst.duplicate();
                tmpDst.limit(bytesToRead);
            }
            if ((n = this.descriptor.read(tmpDst)) == -1) {
                this.eof = true;
                done = true;
                break;
            }
            if (n == 0) {
                done = true;
                break;
            }
            bytesRead += n;
        }
        while (!(done || !dst.hasRemaining() || bytesRead >= 1 && partial)) {
            int read2 = this.refillBuffer();
            if (read2 == -1) {
                this.eof = true;
                done = true;
                break;
            }
            if (read2 == 0) {
                done = true;
                break;
            }
            bytesRead += this.copyBufferedBytes(dst);
        }
        if (this.eof && bytesRead == 0 && dst.remaining() != 0) {
            throw new EOFException();
        }
        return bytesRead;
    }

    private int bufferedRead() throws IOException, BadDescriptorException {
        this.ensureRead();
        if (!this.buffer.hasRemaining()) {
            int len = this.refillBuffer();
            if (len == -1) {
                this.eof = true;
                return -1;
            }
            if (len == 0) {
                return -1;
            }
        }
        return this.buffer.get() & 0xFF;
    }

    /*
     * Enabled aggressive block sorting
     */
    private int bufferedWrite(ByteList buf) throws IOException, BadDescriptorException {
        this.checkWritable();
        this.ensureWrite();
        if (buf == null || buf.length() == 0) {
            return 0;
        }
        if (buf.length() > this.buffer.capacity()) {
            this.flushWrite();
            int n = this.descriptor.write(ByteBuffer.wrap(buf.getUnsafeBytes(), buf.begin(), buf.length()));
            if (n == buf.length()) {
                // empty if block
            }
        } else {
            if (buf.length() > this.buffer.remaining()) {
                this.flushWrite();
            }
            this.buffer.put(buf.getUnsafeBytes(), buf.begin(), buf.length());
        }
        if (this.isSync()) {
            this.flushWrite();
        }
        return buf.getRealSize();
    }

    private int bufferedWrite(ByteBuffer buf) throws IOException, BadDescriptorException {
        this.checkWritable();
        this.ensureWrite();
        if (buf == null || !buf.hasRemaining()) {
            return 0;
        }
        int nbytes = buf.remaining();
        if (nbytes >= this.buffer.capacity()) {
            this.flushWrite();
            this.descriptor.write(buf);
        } else {
            if (nbytes > this.buffer.remaining()) {
                this.flushWrite();
            }
            this.buffer.put(buf);
        }
        if (this.isSync()) {
            this.flushWrite();
        }
        return nbytes - buf.remaining();
    }

    private int bufferedWrite(int c) throws IOException, BadDescriptorException {
        this.checkWritable();
        this.ensureWrite();
        if (!this.buffer.hasRemaining()) {
            this.flushWrite();
        }
        this.buffer.put((byte)c);
        if (this.isSync()) {
            this.flushWrite();
        }
        return 1;
    }

    public synchronized void ftruncate(long newLength) throws IOException, BadDescriptorException, InvalidValueException {
        Channel ch = this.descriptor.getChannel();
        if (!(ch instanceof FileChannel)) {
            throw new InvalidValueException();
        }
        this.invalidateBuffer();
        FileChannel fileChannel = (FileChannel)ch;
        if (newLength > fileChannel.size()) {
            long position = fileChannel.position();
            int difference = (int)(newLength - fileChannel.size());
            fileChannel.position(fileChannel.size());
            fileChannel.write(ByteBuffer.allocate(difference));
            fileChannel.position(position);
        } else {
            fileChannel.truncate(newLength);
        }
    }

    private void invalidateBuffer() throws IOException, BadDescriptorException {
        if (!this.reading) {
            this.flushWrite();
        }
        int posOverrun = this.buffer.remaining();
        this.buffer.clear();
        if (this.reading) {
            this.buffer.flip();
            FileChannel fileChannel = (FileChannel)this.descriptor.getChannel();
            if (posOverrun != 0) {
                fileChannel.position(fileChannel.position() - (long)posOverrun);
            }
        }
    }

    public void finalize() {
        if (this.closedExplicitly) {
            return;
        }
        if (this.descriptor != null && this.descriptor.isOpen()) {
            this.closeForFinalize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public int ready() throws IOException {
        if (this.descriptor.getChannel() instanceof SelectableChannel) {
            int ready_stat = 0;
            Selector sel = SelectorFactory.openWithRetryFrom(null, SelectorProvider.provider());
            SelectableChannel selchan = (SelectableChannel)this.descriptor.getChannel();
            Object object = selchan.blockingLock();
            synchronized (object) {
                block15: {
                    boolean is_block;
                    block14: {
                        is_block = selchan.isBlocking();
                        selchan.configureBlocking(false);
                        selchan.register(sel, 1);
                        ready_stat = sel.selectNow();
                        sel.close();
                        Object var8_6 = null;
                        if (sel == null) break block14;
                        try {
                            sel.close();
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    selchan.configureBlocking(is_block);
                    {
                        break block15;
                        catch (Throwable ex) {
                            ex.printStackTrace();
                            Object var8_7 = null;
                            if (sel != null) {
                                try {
                                    sel.close();
                                }
                                catch (Exception e) {
                                    // empty catch block
                                }
                            }
                            selchan.configureBlocking(is_block);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var8_8 = null;
                        if (sel != null) {
                            try {
                                sel.close();
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                        }
                        selchan.configureBlocking(is_block);
                        throw throwable;
                    }
                }
            }
            return ready_stat;
        }
        return this.newInputStream().available();
    }

    public synchronized void fputc(int c) throws IOException, BadDescriptorException {
        this.bufferedWrite(c);
    }

    public int ungetc(int c) {
        if (c == -1) {
            return -1;
        }
        this.eof = false;
        this.ungotc = c;
        return c;
    }

    public synchronized int fgetc() throws IOException, BadDescriptorException {
        if (this.eof) {
            return -1;
        }
        this.checkReadable();
        int c = this.read();
        if (c == -1) {
            this.eof = true;
            return c;
        }
        return c & 0xFF;
    }

    public synchronized int fwrite(ByteList string2) throws IOException, BadDescriptorException {
        return this.bufferedWrite(string2);
    }

    public synchronized int write(ByteBuffer buf) throws IOException, BadDescriptorException {
        return this.bufferedWrite(buf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized int writenonblock(ByteList buf) throws IOException, BadDescriptorException {
        this.checkWritable();
        this.ensureWrite();
        if (buf == null || buf.length() == 0) {
            return 0;
        }
        if (this.buffer.position() != 0 && !this.flushWrite(false)) {
            return 0;
        }
        if (!(this.descriptor.getChannel() instanceof SelectableChannel)) {
            return this.descriptor.write(ByteBuffer.wrap(buf.getUnsafeBytes(), buf.begin(), buf.length()));
        }
        SelectableChannel selectableChannel = (SelectableChannel)this.descriptor.getChannel();
        Object object = selectableChannel.blockingLock();
        synchronized (object) {
            boolean oldBlocking = selectableChannel.isBlocking();
            try {
                if (oldBlocking) {
                    selectableChannel.configureBlocking(false);
                }
                int n = this.descriptor.write(ByteBuffer.wrap(buf.getUnsafeBytes(), buf.begin(), buf.length()));
                Object var7_6 = null;
                if (oldBlocking) {
                    selectableChannel.configureBlocking(oldBlocking);
                }
                return n;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (oldBlocking) {
                    selectableChannel.configureBlocking(oldBlocking);
                }
                throw throwable;
            }
        }
    }

    public synchronized ByteList fread(int number) throws IOException, BadDescriptorException {
        try {
            if (number == 0) {
                if (this.eof) {
                    return null;
                }
                return new ByteList(0);
            }
            return this.bufferedRead(number);
        }
        catch (EOFException e) {
            this.eof = true;
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized ByteList readnonblock(int number) throws IOException, BadDescriptorException, EOFException {
        assert (number >= 0);
        if (number == 0) {
            return null;
        }
        if (this.descriptor.getChannel() instanceof SelectableChannel) {
            SelectableChannel selectableChannel = (SelectableChannel)this.descriptor.getChannel();
            Object object = selectableChannel.blockingLock();
            synchronized (object) {
                ByteList byteList;
                boolean oldBlocking = selectableChannel.isBlocking();
                try {
                    selectableChannel.configureBlocking(false);
                    byteList = this.readpartial(number);
                    Object var7_6 = null;
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    selectableChannel.configureBlocking(oldBlocking);
                    throw throwable;
                }
                selectableChannel.configureBlocking(oldBlocking);
                return byteList;
            }
        }
        if (this.descriptor.getChannel() instanceof FileChannel) {
            return this.fread(number);
        }
        return null;
    }

    public synchronized ByteList readpartial(int number) throws IOException, BadDescriptorException, EOFException {
        assert (number >= 0);
        if (number == 0) {
            return null;
        }
        if (this.descriptor.getChannel() instanceof FileChannel) {
            return this.fread(number);
        }
        if (this.hasBufferedInputBytes()) {
            return this.bufferedRead(Math.min(this.bufferedInputBytesRemaining(), number));
        }
        return this.read(number);
    }

    public synchronized int read(ByteBuffer dst) throws IOException, BadDescriptorException, EOFException {
        return this.read(dst, !(this.descriptor.getChannel() instanceof FileChannel));
    }

    public synchronized int read(ByteBuffer dst, boolean partial) throws IOException, BadDescriptorException, EOFException {
        assert (dst.hasRemaining());
        return this.bufferedRead(dst, partial);
    }

    public synchronized int read() throws IOException, BadDescriptorException {
        try {
            this.descriptor.checkOpen();
            if (this.ungotc >= 0) {
                int c = this.ungotc;
                this.ungotc = -1;
                return c;
            }
            return this.bufferedRead();
        }
        catch (EOFException e) {
            this.eof = true;
            return -1;
        }
    }

    public ChannelDescriptor getDescriptor() {
        return this.descriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBlocking(boolean block) throws IOException {
        if (!(this.descriptor.getChannel() instanceof SelectableChannel)) {
            return;
        }
        Object object = ((SelectableChannel)this.descriptor.getChannel()).blockingLock();
        synchronized (object) {
            this.blocking = block;
            try {
                ((SelectableChannel)this.descriptor.getChannel()).configureBlocking(block);
            }
            catch (IllegalBlockingModeException illegalBlockingModeException) {
                // empty catch block
            }
        }
    }

    public boolean isBlocking() {
        return this.blocking;
    }

    public synchronized void freopen(Ruby runtime2, String path2, ModeFlags modes) throws DirectoryAsFileException, IOException, InvalidValueException, PipeException, BadDescriptorException {
        this.flushWrite();
        this.buffer.clear();
        if (this.reading) {
            this.buffer.flip();
        }
        this.modes = modes;
        if (this.descriptor.isOpen()) {
            this.descriptor.close();
        }
        if (path2.equals("/dev/null") || path2.equalsIgnoreCase("nul:") || path2.equalsIgnoreCase("nul")) {
            this.descriptor = new ChannelDescriptor(new NullChannel(), this.descriptor.getFileno(), modes, new FileDescriptor());
        } else {
            String cwd = runtime2.getCurrentDirectory();
            JRubyFile theFile = JRubyFile.create(cwd, path2);
            if (theFile.isDirectory() && modes.isWritable()) {
                throw new DirectoryAsFileException();
            }
            if (modes.isCreate()) {
                if (theFile.exists() && modes.isExclusive()) {
                    throw runtime2.newErrnoEEXISTError("File exists - " + path2);
                }
                theFile.createNewFile();
            } else if (!theFile.exists()) {
                throw runtime2.newErrnoENOENTError("file not found - " + path2);
            }
            RandomAccessFile file2 = new RandomAccessFile(theFile, modes.toJavaModeString());
            if (modes.isTruncate()) {
                file2.setLength(0L);
            }
            this.descriptor = new ChannelDescriptor(file2.getChannel(), this.descriptor.getFileno(), modes, file2.getFD());
            if (modes.isAppendable()) {
                this.lseek(0L, 2);
            }
        }
    }

    public static final Stream open(Ruby runtime2, ChannelDescriptor descriptor) {
        return ChannelStream.maybeWrapWithLineEndingWrapper(new ChannelStream(runtime2, descriptor), descriptor.getOriginalModes());
    }

    public static Stream fdopen(Ruby runtime2, ChannelDescriptor descriptor, ModeFlags modes) throws InvalidValueException {
        return ChannelStream.maybeWrapWithLineEndingWrapper(new ChannelStream(runtime2, descriptor, modes), modes);
    }

    private static Stream maybeWrapWithLineEndingWrapper(Stream stream, ModeFlags modes) {
        if (Platform.IS_WINDOWS && stream.getDescriptor().getChannel() instanceof FileChannel && !modes.isBinary()) {
            return new CRLFStreamWrapper(stream);
        }
        return stream;
    }

    public static Stream fopen(Ruby runtime2, String path2, ModeFlags modes) throws FileNotFoundException, DirectoryAsFileException, FileExistsException, IOException, InvalidValueException, PipeException, BadDescriptorException {
        ChannelDescriptor descriptor = ChannelDescriptor.open(runtime2.getCurrentDirectory(), path2, modes);
        Stream stream = ChannelStream.fdopen(runtime2, descriptor, modes);
        if (modes.isAppendable()) {
            stream.lseek(0L, 2);
        }
        return stream;
    }

    public Channel getChannel() {
        return this.getDescriptor().getChannel();
    }

    private static final class OutputStreamAdapter
    extends OutputStream {
        private final ChannelStream stream;

        public OutputStreamAdapter(ChannelStream stream) {
            this.stream = stream;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(int i) throws IOException {
            ChannelStream channelStream = this.stream;
            synchronized (channelStream) {
                if (!this.stream.isSync() && this.stream.hasBufferedOutputSpace()) {
                    this.stream.buffer.put((byte)i);
                    return;
                }
            }
            byte[] b = new byte[]{(byte)i};
            this.write(b, 0, 1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void write(byte[] bytes2, int off, int len) throws IOException {
            if (bytes2 == null) {
                throw new NullPointerException("null source buffer");
            }
            if ((len | off | off + len | bytes2.length - (off + len)) < 0) {
                throw new IndexOutOfBoundsException();
            }
            try {
                ChannelStream channelStream = this.stream;
                synchronized (channelStream) {
                    if (!this.stream.isSync() && this.stream.bufferedOutputSpaceRemaining() >= len) {
                        this.stream.buffer.put(bytes2, off, len);
                    } else {
                        if (this.stream.getDescriptor().getChannel() instanceof SelectableChannel) {
                            SelectableChannel ch = (SelectableChannel)this.stream.getDescriptor().getChannel();
                            Object object = ch.blockingLock();
                            synchronized (object) {
                                boolean oldBlocking = ch.isBlocking();
                                try {
                                    if (!oldBlocking) {
                                        ch.configureBlocking(true);
                                    }
                                    this.stream.bufferedWrite(ByteBuffer.wrap(bytes2, off, len));
                                    Object var9_9 = null;
                                    if (oldBlocking) return;
                                }
                                catch (Throwable throwable) {
                                    Object var9_10 = null;
                                    if (oldBlocking) throw throwable;
                                    ch.configureBlocking(oldBlocking);
                                    throw throwable;
                                }
                                ch.configureBlocking(oldBlocking);
                                {
                                }
                            }
                        }
                        this.stream.bufferedWrite(ByteBuffer.wrap(bytes2, off, len));
                    }
                    return;
                }
            }
            catch (BadDescriptorException ex) {
                throw new IOException(ex.getMessage());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            try {
                ChannelStream channelStream = this.stream;
                synchronized (channelStream) {
                    this.stream.fclose();
                }
            }
            catch (BadDescriptorException ex) {
                throw new IOException(ex.getMessage());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void flush() throws IOException {
            try {
                ChannelStream channelStream = this.stream;
                synchronized (channelStream) {
                    this.stream.flushWrite(true);
                }
            }
            catch (BadDescriptorException ex) {
                throw new IOException(ex.getMessage());
            }
        }
    }

    private static final class InputStreamAdapter
    extends InputStream {
        private final ChannelStream stream;

        public InputStreamAdapter(ChannelStream stream) {
            this.stream = stream;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read() throws IOException {
            ChannelStream channelStream = this.stream;
            synchronized (channelStream) {
                if (this.stream.hasBufferedInputBytes()) {
                    try {
                        return this.stream.read();
                    }
                    catch (BadDescriptorException ex) {
                        throw new IOException(ex.getMessage());
                    }
                }
            }
            byte[] b = new byte[1];
            return this.read(b, 0, 1) == 1 ? b[0] & 0xFF : -1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public int read(byte[] bytes2, int off, int len) throws IOException {
            if (bytes2 == null) {
                throw new NullPointerException("null destination buffer");
            }
            if ((len | off | off + len | bytes2.length - (off + len)) < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return 0;
            }
            try {
                ChannelStream channelStream = this.stream;
                synchronized (channelStream) {
                    int available = this.stream.bufferedInputBytesRemaining();
                    if (available >= len) {
                        return this.stream.copyBufferedBytes(bytes2, off, len);
                    }
                    if (!(this.stream.getDescriptor().getChannel() instanceof SelectableChannel)) {
                        return this.stream.bufferedRead(ByteBuffer.wrap(bytes2, off, len), true);
                    }
                    SelectableChannel ch = (SelectableChannel)this.stream.getDescriptor().getChannel();
                    Object object = ch.blockingLock();
                    synchronized (object) {
                        boolean oldBlocking = ch.isBlocking();
                        try {
                            if (!oldBlocking) {
                                ch.configureBlocking(true);
                            }
                            int n = this.stream.bufferedRead(ByteBuffer.wrap(bytes2, off, len), true);
                            Object var11_12 = null;
                            if (!oldBlocking) {
                                ch.configureBlocking(oldBlocking);
                            }
                            return n;
                        }
                        catch (Throwable throwable) {
                            Object var11_13 = null;
                            if (!oldBlocking) {
                                ch.configureBlocking(oldBlocking);
                            }
                            throw throwable;
                        }
                    }
                }
            }
            catch (BadDescriptorException ex) {
                throw new IOException(ex.getMessage());
            }
            catch (EOFException ex) {
                return -1;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int available() throws IOException {
            ChannelStream channelStream = this.stream;
            synchronized (channelStream) {
                return !this.stream.eof ? this.stream.bufferedInputBytesRemaining() : 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            try {
                ChannelStream channelStream = this.stream;
                synchronized (channelStream) {
                    this.stream.fclose();
                }
            }
            catch (BadDescriptorException ex) {
                throw new IOException(ex.getMessage());
            }
        }
    }
}

