/*
 * Decompiled with CFR 0.152.
 */
package org.h2.table;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.expression.FunctionCall;
import org.h2.expression.TableFunction;
import org.h2.index.FunctionIndex;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.message.Message;
import org.h2.result.LocalResult;
import org.h2.result.Row;
import org.h2.schema.Schema;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.Table;
import org.h2.util.ObjectArray;
import org.h2.value.DataType;
import org.h2.value.Value;
import org.h2.value.ValueNull;
import org.h2.value.ValueResultSet;

public class FunctionTable
extends Table {
    private final FunctionCall function;
    private final long rowCount;

    public FunctionTable(Schema schema, Session session, FunctionCall functionCall) throws SQLException {
        super(schema, 0, functionCall.getName(), false);
        this.function = functionCall;
        this.rowCount = functionCall instanceof TableFunction ? ((TableFunction)functionCall).getRowCount() : Long.MAX_VALUE;
        functionCall.optimize(session);
        int n = functionCall.getType();
        if (n != 18) {
            throw Message.getSQLException(90000, functionCall.getName());
        }
        int n2 = functionCall.getParameterCount();
        Expression[] expressionArray = new Expression[n2];
        Expression[] expressionArray2 = functionCall.getArgs();
        for (int i = 0; i < n2; ++i) {
            expressionArray2[i] = expressionArray2[i].optimize(session);
            expressionArray[i] = expressionArray2[i];
        }
        ValueResultSet valueResultSet = functionCall.getValueForColumnList(session, expressionArray);
        if (valueResultSet == null) {
            throw Message.getSQLException(90000, functionCall.getName());
        }
        ResultSet resultSet = valueResultSet.getResultSet();
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n3 = resultSetMetaData.getColumnCount();
        Column[] columnArray = new Column[n3];
        for (int i = 0; i < n3; ++i) {
            columnArray[i] = new Column(resultSetMetaData.getColumnName(i + 1), DataType.convertSQLTypeToValueType(resultSetMetaData.getColumnType(i + 1)), resultSetMetaData.getPrecision(i + 1), resultSetMetaData.getScale(i + 1), resultSetMetaData.getColumnDisplaySize(i + 1));
        }
        this.setColumns(columnArray);
    }

    public void lock(Session session, boolean bl, boolean bl2) {
    }

    public void close(Session session) {
    }

    public void unlock(Session session) {
    }

    public boolean isLockedExclusively() {
        return false;
    }

    public Index addIndex(Session session, String string, int n, IndexColumn[] indexColumnArray, IndexType indexType, int n2, String string2) throws SQLException {
        throw Message.getUnsupportedException();
    }

    public void removeRow(Session session, Row row) throws SQLException {
        throw Message.getUnsupportedException();
    }

    public void truncate(Session session) throws SQLException {
        throw Message.getUnsupportedException();
    }

    public boolean canDrop() {
        throw Message.throwInternalError();
    }

    public void addRow(Session session, Row row) throws SQLException {
        throw Message.getUnsupportedException();
    }

    public void checkSupportAlter() throws SQLException {
        throw Message.getUnsupportedException();
    }

    public String getTableType() {
        return null;
    }

    public Index getScanIndex(Session session) {
        return new FunctionIndex(this, IndexColumn.wrap(this.columns));
    }

    public ObjectArray getIndexes() {
        return null;
    }

    public boolean canGetRowCount() {
        return this.rowCount != Long.MAX_VALUE;
    }

    public long getRowCount(Session session) {
        return this.rowCount;
    }

    public String getCreateSQL() {
        return null;
    }

    public String getDropSQL() {
        return null;
    }

    public void checkRename() throws SQLException {
        throw Message.getUnsupportedException();
    }

    public LocalResult getResult(Session session) throws SQLException {
        this.function.optimize(session);
        Value value = this.function.getValue(session);
        if (value == ValueNull.INSTANCE) {
            return new LocalResult();
        }
        ValueResultSet valueResultSet = (ValueResultSet)value;
        ResultSet resultSet = valueResultSet.getResultSet();
        return LocalResult.read(session, resultSet, 0);
    }

    public long getMaxDataModificationId() {
        return Long.MAX_VALUE;
    }

    public Index getUniqueIndex() {
        return null;
    }

    public String getSQL() {
        return this.function.getSQL();
    }

    public long getRowCountApproximation() {
        return this.rowCount;
    }
}

