/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.security.AccessControlException;
import java.security.AccessController;
import java.security.DomainCombiner;
import java.security.Permission;
import java.security.ProtectionDomain;
import java.security.SecurityPermission;
import java.util.HashSet;

public final class AccessControlContext {
    private final ProtectionDomain[] protectionDomains;
    private final DomainCombiner combiner;

    public final DomainCombiner getDomainCombiner() {
        return this.combiner;
    }

    public final void checkPermission(Permission permission) throws AccessControlException {
        if (this.protectionDomains.length == 0) {
            throw new AccessControlException("permission " + permission + " not granted: no protection domains");
        }
        int n = 0;
        while (n < this.protectionDomains.length) {
            ProtectionDomain protectionDomain = this.protectionDomains[n];
            if (!protectionDomain.implies(permission)) {
                throw new AccessControlException("permission " + permission + " not granted: " + protectionDomain + " does not imply it.");
            }
            ++n;
        }
    }

    public final boolean equals(Object object) {
        if (object instanceof AccessControlContext) {
            AccessControlContext accessControlContext = (AccessControlContext)object;
            if (accessControlContext.protectionDomains.length != this.protectionDomains.length) {
                return false;
            }
            int n = 0;
            while (n < this.protectionDomains.length) {
                int n2 = 0;
                while (n2 < accessControlContext.protectionDomains.length) {
                    if (accessControlContext.protectionDomains[n2].equals(this.protectionDomains[n])) break;
                    ++n2;
                }
                if (n2 == accessControlContext.protectionDomains.length) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        return false;
    }

    public final int hashCode() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.protectionDomains.length) {
            n ^= this.protectionDomains[n2].hashCode();
            ++n2;
        }
        return n;
    }

    final ProtectionDomain[] getProtectionDomains() {
        return this.protectionDomains;
    }

    public AccessControlContext(ProtectionDomain[] protectionDomainArray) {
        HashSet hashSet = new HashSet(protectionDomainArray.length);
        int n = 0;
        while (n < protectionDomainArray.length) {
            hashSet.add(protectionDomainArray[n]);
            ++n;
        }
        this.protectionDomains = (ProtectionDomain[])hashSet.toArray(new ProtectionDomain[hashSet.size()]);
        this.combiner = null;
    }

    public AccessControlContext(AccessControlContext accessControlContext, DomainCombiner domainCombiner) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new SecurityPermission("createAccessControlContext"));
        }
        AccessControlContext accessControlContext2 = AccessController.getContext();
        this.protectionDomains = domainCombiner.combine(accessControlContext2.protectionDomains, accessControlContext.protectionDomains);
        this.combiner = domainCombiner;
    }

    AccessControlContext(ProtectionDomain[] protectionDomainArray, AccessControlContext accessControlContext, DomainCombiner domainCombiner) {
        this.protectionDomains = domainCombiner.combine(protectionDomainArray, accessControlContext.protectionDomains);
        this.combiner = domainCombiner;
    }
}

