// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _LIBGDAMM_SERVEROPERATION_H
#define _LIBGDAMM_SERVEROPERATION_H


#include <glibmm.h>

/* $Id: serveroperation.hg,v 1.2 2006/11/08 00:52:25 murrayc Exp $ */
// -*- C++ -*- //

/* serveroperation.h
 *
 * Copyright 2001      Free Software Foundation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <libgdamm/value.h>
#include <libgda/gda-server-provider.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GdaServerOperation GdaServerOperation;
typedef struct _GdaServerOperationClass GdaServerOperationClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace Gda
{ class ServerOperation_Class; } // namespace Gda

} // namespace Gnome
namespace Gnome
{

namespace Gda
{


class Connection;
class ServerProvider;

//_WRAP_ENUM(ClientSpecsType, GdaClientSpecsType)
/** @addtogroup libgdammEnums libgdamm Enums and Flags */

/**
 * @ingroup libgdammEnums
 */
enum ServerOperationNodeType
{
  SERVER_OPERATION_NODE_PARAMLIST,
  SERVER_OPERATION_NODE_DATA_MODEL,
  SERVER_OPERATION_NODE_PARAM,
  SERVER_OPERATION_NODE_SEQUENCE,
  SERVER_OPERATION_NODE_SEQUENCE_ITEM,
  SERVER_OPERATION_NODE_DATA_MODEL_COLUMN,
  SERVER_OPERATION_NODE_UNKNOWN
};

} // namespace Gda

} // namespace Gnome


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gnome::Gda::ServerOperationNodeType> : public Glib::Value_Enum<Gnome::Gda::ServerOperationNodeType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace Gda
{

/**
 * @ingroup libgdammEnums
 */
enum ServerOperationNodeStatus
{
  SERVER_OPERATION_STATUS_OPTIONAL,
  SERVER_OPERATION_STATUS_REQUIRED,
  SERVER_OPERATION_STATUS_UNKNOWN
};

} // namespace Gda

} // namespace Gnome


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gnome::Gda::ServerOperationNodeStatus> : public Glib::Value_Enum<Gnome::Gda::ServerOperationNodeStatus>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace Gda
{

/**
 * @ingroup libgdammEnums
 */
enum ServerOperationType
{
  SERVER_OPERATION_CREATE_DB,
  SERVER_OPERATION_DROP_DB,
  SERVER_OPERATION_CREATE_TABLE,
  SERVER_OPERATION_DROP_TABLE,
  SERVER_OPERATION_RENAME_TABLE,
  SERVER_OPERATION_ADD_COLUMN,
  SERVER_OPERATION_DROP_COLUMN,
  SERVER_OPERATION_CREATE_INDEX,
  SERVER_OPERATION_DROP_INDEX,
  SERVER_OPERATION_CREATE_VIEW,
  SERVER_OPERATION_DROP_VIEW,
  SERVER_OPERATION_COMMENT_TABLE,
  SERVER_OPERATION_COMMENT_COLUMN,
  SERVER_OPERATION_CREATE_USER,
  SERVER_OPERATION_ALTER_USER,
  SERVER_OPERATION_DROP_USER,
  SERVER_OPERATION_LAST
};

} // namespace Gda

} // namespace Gnome


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gnome::Gda::ServerOperationType> : public Glib::Value_Enum<Gnome::Gda::ServerOperationType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace Gda
{

typedef GdaServerOperationNode ServerOperationNode;

/** @defgroup DDL Data definition (DDL) queries
 */

/** Handles any DDL query in an abstract way.
 *
 * Basically this object is just a named data store: it can store named values, 
 * the values being organized hirarchically. A value can be read from its path
 * (similar to a Unix file path) using the get_value_at() method.
 * 
 * @ingroup DDL
 */

class ServerOperation : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef ServerOperation CppObjectType;
  typedef ServerOperation_Class CppClassType;
  typedef GdaServerOperation BaseObjectType;
  typedef GdaServerOperationClass BaseClassType;

private:  friend class ServerOperation_Class;
  static CppClassType serveroperation_class_;

private:
  // noncopyable
  ServerOperation(const ServerOperation&);
  ServerOperation& operator=(const ServerOperation&);

protected:
  explicit ServerOperation(const Glib::ConstructParams& construct_params);
  explicit ServerOperation(GdaServerOperation* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~ServerOperation();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GdaServerOperation*       gobj()       { return reinterpret_cast<GdaServerOperation*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GdaServerOperation* gobj() const { return reinterpret_cast<GdaServerOperation*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GdaServerOperation* gobj_copy();

private:


public:
  // These are from gda-easy but they fit in here best
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  static Glib::RefPtr<ServerOperation> prepare_create_database(const Glib::ustring& provider,
                                                               const Glib::ustring& db_name);
#else
  static Glib::RefPtr<ServerOperation> prepare_create_database(const Glib::ustring& provider,
                                                               const Glib::ustring& db_name,
                                                               std::auto_ptr<Glib::Error>& error);
#endif    
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  static Glib::RefPtr<ServerOperation> prepare_drop_database(const Glib::ustring& provider,
                                                             const Glib::ustring& db_name);
#else
  static Glib::RefPtr<ServerOperation> prepare_drop_database(const Glib::ustring& provider,
                                                             const Glib::ustring& db_name,
                                                             std::auto_ptr<Glib::Error>& error);
#endif 
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool perform_drop_database(const Glib::ustring& provider);
  bool perform_create_database(const Glib::ustring& provider);
#else
  bool perform_drop_database(const Glib::ustring& provider,
                             std::auto_ptr<Glib::Error>& error);
  bool perform_create_database(const Glib::ustring& provider,
                               std::auto_ptr<Glib::Error>& error);
#endif 

  // The C version of these take varargs for some reason.
  
  /** Get the value for the node at the path formed using @a path_format and ... (the rules are the same as
   * for Glib::strdup_printf())
   * @param path_format A complete path to a node (starting with "/").
   * @param Varargs Arguments to use with @a path_format to make a complete path.
   * @return A constant Value if a value has been defined, or <tt>0</tt> if the value is undefined or
   * if the @a path is not defined or @a path does not hold any value.
   */

  Value get_value_at(const Glib::ustring& path_format) const;

#ifdef GLIBMM_EXCEPTIONS_ENABLED
  template <class ValueType>
  void set_value_at(const Glib::ustring& path_format, const ValueType& value);
#else
  template <class ValueType>
  void set_value_at(const Glib::ustring& path_format, const ValueType& value, std::auto_ptr<Glib::Error>& error);
#endif // GLIBMM_EXCEPTIONS_ENABLED

#ifdef GLIBMM_EXCEPTIONS_ENABLED
  void set_value_at_as_value(const Glib::ustring& path_format, const Glib::ValueBase& value);
#else
  void set_value_at_as_value(const Glib::ustring& path_format, const Glib::ValueBase& value, std::auto_ptr<Glib::Error>& error);
#endif // GLIBMM_EXCEPTIONS_ENABLED

  //TODO: See http://bugzilla.gnome.org/show_bug.cgi?id=574742
  
  /** Convenience function to get the type of a node.
   * @param path A complete path to a node (starting with "/").
   * @param status A place to store the status of the node, or <tt>0</tt>.
   * @return The type of node, or GDA_SERVER_OPERATION_NODE_UNKNOWN if the node was not found.
   */
  ServerOperationNodeType get_node_type(const Glib::ustring& path, ServerOperationNodeStatus& status) const;
  
  /** 
   * @param path A complete path to a sequence node (starting with "/").
   * @return The number of items in the sequence at @a path, or 0 if @a path is not a sequence node.
   */
  guint get_sequence_size(const Glib::ustring& path) const;
  
  /** 
   * @param path A complete path to a sequence node (starting with "/").
   * @return The maximum number of items in the sequence at @a path, or 0 if @a path is not a sequence node.
   */
  guint get_sequence_max_size(const Glib::ustring& path) const;
  
  /** 
   * @param path A complete path to a sequence node (starting with "/").
   * @return The minimum number of items in the sequence at @a path, or 0 if @a path is not a sequence node.
   */
  guint get_sequence_min_size(const Glib::ustring& path) const;
  
  /** Fetch the contents of a sequence. @a path can describe either a sequence (for example "/SEQNAME") or an item in a sequence
   * (for example "/SEQNAME/3")
   * @param path A complete path to a sequence node (starting with "/").
   * @return A array of strings containing the complete paths of the nodes contained at @a path (free with Glib::strfreev()).
   */
  Glib::StringArrayHandle get_sequence_item_names(const Glib::ustring& path) const;
  
  /** 
   * @param path A complete path to a sequence node (starting with "/").
   * @return The name of the sequence at @a path.
   */
  Glib::ustring get_sequence_name(const std::string& path) const;

  //TODO: Is this XML stuff really public API? murrayc.

  //TODO: get_node_info => varargs
  
  /** Tells if all the required values in @a op have been defined.
   * 
   * if @a xml_file is not <tt>0</tt>, the validity of @a op is tested against that specification, 
   * and not against the current @a op's specification.
   * @param xml_file An XML specification file (see new()).
   * @return <tt>true</tt> if @a op is valid.
   */
  bool is_valid(const std::string& xml_file) const;
  
  /** Loads the contents of @a node into @a op. The XML tree passed through the @a node
   * argument must correspond to an XML tree saved using save_data_to_xml().
   * @param node A #xmlNodePtr.
   * @return <tt>true</tt> if no error occurred.
   */
  bool load_data_from_xml(xmlNodePtr node);
  
  xmlNodePtr save_data_to_xml();  
  
  /** Get the last part of @a path
   * @param path A complete path to a node (starting with "/").
   * @return A new string, or <tt>0</tt> if an error occurred.
   */
  Glib::ustring get_node_path_portion(const Glib::ustring& path) const;
  
  /** Get the complete path to the parent of the node defined by @a path
   * @param path A complete path to a node (starting with "/").
   * @return A new string or <tt>0</tt> if the node does not have any parent or does not exist.
   */
  Glib::ustring get_node_parent(const Glib::ustring& path) const;
  
  /** Get the type of operation @a op is for
   * @return A Gda::ServerOperationType enum.
   */
  ServerOperationType get_op_type() const;
  
  
  /** 
   * @param item_path The path to the sequence's item to remove (like "/SEQ_NAME/5" for instance).
   * @return <tt>true</tt> if the specified node has been removed from the sequence.
   */
  bool del_item_from_sequence(const std::string& item_path);
  
  /** 
   * @param seq_path The path to the sequence to which an item must be added (like "/SEQ_NAME" for instance).
   * @return The index of the new entry in the sequence (like 5 for example if a 6th item has
   * been added to the sequence.
   */
  guint add_item_to_sequence(const std::string& item_path);
  
  /** Get an array of strings containing the paths of nodes situated at the root of @a op.
   * @return A new array, which must be freed with Glib::strfreev().
   */
  Glib::StringArrayHandle get_root_nodes() const;

  
  /**
   * @par Prototype:
   * <tt>void on_my_%signal_sequence_item_added(Glib::ustring arg1, int arg2)</tt>
   */

  Glib::SignalProxy2< void,Glib::ustring,int > signal_signal_sequence_item_added();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%signal_sequence_item_remove(Glib::ustring arg1, int arg2)</tt>
   */

  Glib::SignalProxy2< void,Glib::ustring,int > signal_signal_sequence_item_remove();


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Connection to use.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Connection> > property_connection() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Type of operation to be done.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<gint> property_op_type() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


 //TODO: vfuncs.


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

#ifndef DOXYGEN_SHOULD_SKIP_THIS
#ifdef GLIBMM_EXCEPTIONS_ENABLED
template <class ValueType> inline
void ServerOperation::set_value_at(const Glib::ustring& path_format, const ValueType& value)
{
  Gnome::Gda::Value gdavalue(value);
  this->set_value_at_as_value(path_format.c_str(), gdavalue);
}
#else
template <class ValueType> inline
void ServerOperation::set_value_at(const Glib::ustring& path_format, const ValueType& value, std::auto_ptr<Glib::Error>& error)
{
  Gnome::Gda::Value gdavalue(value);
  this->set_value_at_as_value(path_format.c_str(), gdavalue, error);
}
#endif
#endif //DOXYGEN_SHOULD_SKIP_THIS

} // namespace Gda
} // namespace Gnome


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gnome::Gda::ServerOperation
   */
  Glib::RefPtr<Gnome::Gda::ServerOperation> wrap(GdaServerOperation* object, bool take_copy = false);
}


#endif /* _LIBGDAMM_SERVEROPERATION_H */

