#if !defined(__MSP430_HEADERS_ADC12_PLUS_H__)
#define __MSP430_HEADERS_ADC12_PLUS_H__

/* adc12_plus.h
 *
 * mspgcc project: MSP430 device headers
 * High-performance 12-bit analog-to-digital converter
 *
 * NB: The contents of this file are similar to those of
 * <msp430/adc12.h>, but are derived directly from the TI headers.
 * Consequently, the names of several constants have changed
 * (generally, to add a prefix ADC12).  Don't include both.
 *
 * Based on cc430x613x.h version 1.5 by Texas Instruments
 *
 * Peter A. Bigot <pab@peoplepowerco.com>
 *
 */

/* Switches:
__MSP430_HAS_ADC12_PLUS__ - definition to show module available
__MSP430_ADC12_PLUS_BASE__ - base address of ADC_A module
*/

#if defined(__MSP430_ADC12_PLUS_BASE__)

#define ADC12CTL0_ __MSP430_ADC12_PLUS_BASE__ + 0x00  /* ADC12+ Control 0 */
sfrw(ADC12CTL0, ADC12CTL0_);
#define ADC12CTL0_L_ __MSP430_ADC12_PLUS_BASE__ + 0x00  
sfrb(ADC12CTL0_L, ADC12CTL0_L_);
#define ADC12CTL0_H_ __MSP430_ADC12_PLUS_BASE__ + 0x01  
sfrb(ADC12CTL0_H, ADC12CTL0_H_);
#define ADC12CTL1_ __MSP430_ADC12_PLUS_BASE__ + 0x02  /* ADC12+ Control 1 */
sfrw(ADC12CTL1, ADC12CTL1_);
#define ADC12CTL1_L_ __MSP430_ADC12_PLUS_BASE__ + 0x02  
sfrb(ADC12CTL1_L, ADC12CTL1_L_);
#define ADC12CTL1_H_ __MSP430_ADC12_PLUS_BASE__ + 0x03  
sfrb(ADC12CTL1_H, ADC12CTL1_H_);
#define ADC12CTL2_ __MSP430_ADC12_PLUS_BASE__ + 0x04  /* ADC12+ Control 2 */
sfrw(ADC12CTL2, ADC12CTL2_);
#define ADC12CTL2_L_ __MSP430_ADC12_PLUS_BASE__ + 0x04  
sfrb(ADC12CTL2_L, ADC12CTL2_L_);
#define ADC12CTL2_H_ __MSP430_ADC12_PLUS_BASE__ + 0x05  
sfrb(ADC12CTL2_H, ADC12CTL2_H_);
#define ADC12IFG_ __MSP430_ADC12_PLUS_BASE__ + 0x0a  /* ADC12+ Interrupt Flag */
sfrw(ADC12IFG, ADC12IFG_);
#define ADC12IFG_L_ __MSP430_ADC12_PLUS_BASE__ + 0x0a  
sfrb(ADC12IFG_L, ADC12IFG_L_);
#define ADC12IFG_H_ __MSP430_ADC12_PLUS_BASE__ + 0x0b  
sfrb(ADC12IFG_H, ADC12IFG_H_);
#define ADC12IE_ __MSP430_ADC12_PLUS_BASE__ + 0x0c  /* ADC12+ Interrupt Enable */
sfrw(ADC12IE, ADC12IE_);
#define ADC12IE_L_ __MSP430_ADC12_PLUS_BASE__ + 0x0c  
sfrb(ADC12IE_L, ADC12IE_L_);
#define ADC12IE_H_ __MSP430_ADC12_PLUS_BASE__ + 0x0d  
sfrb(ADC12IE_H, ADC12IE_H_);
#define ADC12IV_ __MSP430_ADC12_PLUS_BASE__ + 0x0e  /* ADC12+ Interrupt Vector Word */
sfrw(ADC12IV, ADC12IV_);
#define ADC12IV_L_ __MSP430_ADC12_PLUS_BASE__ + 0x0e  
sfrb(ADC12IV_L, ADC12IV_L_);
#define ADC12IV_H_ __MSP430_ADC12_PLUS_BASE__ + 0x0f  
sfrb(ADC12IV_H, ADC12IV_H_);

#define ADC12MEM0_ __MSP430_ADC12_PLUS_BASE__ + 0x20  /* ADC12 Conversion Memory 0 */
sfrw(ADC12MEM0, ADC12MEM0_);
#define ADC12MEM0_L_ __MSP430_ADC12_PLUS_BASE__ + 0x20  
sfrb(ADC12MEM0_L, ADC12MEM0_L_);
#define ADC12MEM0_H_ __MSP430_ADC12_PLUS_BASE__ + 0x21  
sfrb(ADC12MEM0_H, ADC12MEM0_H_);
#define ADC12MEM1_ __MSP430_ADC12_PLUS_BASE__ + 0x21  /* ADC12 Conversion Memory 1 */
sfrw(ADC12MEM1, ADC12MEM1_);
#define ADC12MEM1_L_ __MSP430_ADC12_PLUS_BASE__ + 0x21  
sfrb(ADC12MEM1_L, ADC12MEM1_L_);
#define ADC12MEM1_H_ __MSP430_ADC12_PLUS_BASE__ + 0x22  
sfrb(ADC12MEM1_H, ADC12MEM1_H_);
#define ADC12MEM2_ __MSP430_ADC12_PLUS_BASE__ + 0x22  /* ADC12 Conversion Memory 2 */
sfrw(ADC12MEM2, ADC12MEM2_);
#define ADC12MEM2_L_ __MSP430_ADC12_PLUS_BASE__ + 0x22  
sfrb(ADC12MEM2_L, ADC12MEM2_L_);
#define ADC12MEM2_H_ __MSP430_ADC12_PLUS_BASE__ + 0x23  
sfrb(ADC12MEM2_H, ADC12MEM2_H_);
#define ADC12MEM3_ __MSP430_ADC12_PLUS_BASE__ + 0x23  /* ADC12 Conversion Memory 3 */
sfrw(ADC12MEM3, ADC12MEM3_);
#define ADC12MEM3_L_ __MSP430_ADC12_PLUS_BASE__ + 0x23  
sfrb(ADC12MEM3_L, ADC12MEM3_L_);
#define ADC12MEM3_H_ __MSP430_ADC12_PLUS_BASE__ + 0x24  
sfrb(ADC12MEM3_H, ADC12MEM3_H_);
#define ADC12MEM4_ __MSP430_ADC12_PLUS_BASE__ + 0x24  /* ADC12 Conversion Memory 4 */
sfrw(ADC12MEM4, ADC12MEM4_);
#define ADC12MEM4_L_ __MSP430_ADC12_PLUS_BASE__ + 0x24  
sfrb(ADC12MEM4_L, ADC12MEM4_L_);
#define ADC12MEM4_H_ __MSP430_ADC12_PLUS_BASE__ + 0x25  
sfrb(ADC12MEM4_H, ADC12MEM4_H_);
#define ADC12MEM5_ __MSP430_ADC12_PLUS_BASE__ + 0x25  /* ADC12 Conversion Memory 5 */
sfrw(ADC12MEM5, ADC12MEM5_);
#define ADC12MEM5_L_ __MSP430_ADC12_PLUS_BASE__ + 0x25  
sfrb(ADC12MEM5_L, ADC12MEM5_L_);
#define ADC12MEM5_H_ __MSP430_ADC12_PLUS_BASE__ + 0x26  
sfrb(ADC12MEM5_H, ADC12MEM5_H_);
#define ADC12MEM6_ __MSP430_ADC12_PLUS_BASE__ + 0x26  /* ADC12 Conversion Memory 6 */
sfrw(ADC12MEM6, ADC12MEM6_);
#define ADC12MEM6_L_ __MSP430_ADC12_PLUS_BASE__ + 0x26  
sfrb(ADC12MEM6_L, ADC12MEM6_L_);
#define ADC12MEM6_H_ __MSP430_ADC12_PLUS_BASE__ + 0x27  
sfrb(ADC12MEM6_H, ADC12MEM6_H_);
#define ADC12MEM7_ __MSP430_ADC12_PLUS_BASE__ + 0x27  /* ADC12 Conversion Memory 7 */
sfrw(ADC12MEM7, ADC12MEM7_);
#define ADC12MEM7_L_ __MSP430_ADC12_PLUS_BASE__ + 0x27  
sfrb(ADC12MEM7_L, ADC12MEM7_L_);
#define ADC12MEM7_H_ __MSP430_ADC12_PLUS_BASE__ + 0x28  
sfrb(ADC12MEM7_H, ADC12MEM7_H_);
#define ADC12MEM8_ __MSP430_ADC12_PLUS_BASE__ + 0x28  /* ADC12 Conversion Memory 8 */
sfrw(ADC12MEM8, ADC12MEM8_);
#define ADC12MEM8_L_ __MSP430_ADC12_PLUS_BASE__ + 0x28  
sfrb(ADC12MEM8_L, ADC12MEM8_L_);
#define ADC12MEM8_H_ __MSP430_ADC12_PLUS_BASE__ + 0x29  
sfrb(ADC12MEM8_H, ADC12MEM8_H_);
#define ADC12MEM9_ __MSP430_ADC12_PLUS_BASE__ + 0x29  /* ADC12 Conversion Memory 9 */
sfrw(ADC12MEM9, ADC12MEM9_);
#define ADC12MEM9_L_ __MSP430_ADC12_PLUS_BASE__ + 0x29  
sfrb(ADC12MEM9_L, ADC12MEM9_L_);
#define ADC12MEM9_H_ __MSP430_ADC12_PLUS_BASE__ + 0x2a  
sfrb(ADC12MEM9_H, ADC12MEM9_H_);
#define ADC12MEM10_ __MSP430_ADC12_PLUS_BASE__ + 0x2a  /* ADC12 Conversion Memory 10 */
sfrw(ADC12MEM10, ADC12MEM10_);
#define ADC12MEM10_L_ __MSP430_ADC12_PLUS_BASE__ + 0x2a  
sfrb(ADC12MEM10_L, ADC12MEM10_L_);
#define ADC12MEM10_H_ __MSP430_ADC12_PLUS_BASE__ + 0x2b  
sfrb(ADC12MEM10_H, ADC12MEM10_H_);
#define ADC12MEM11_ __MSP430_ADC12_PLUS_BASE__ + 0x2b  /* ADC12 Conversion Memory 11 */
sfrw(ADC12MEM11, ADC12MEM11_);
#define ADC12MEM11_L_ __MSP430_ADC12_PLUS_BASE__ + 0x2b  
sfrb(ADC12MEM11_L, ADC12MEM11_L_);
#define ADC12MEM11_H_ __MSP430_ADC12_PLUS_BASE__ + 0x2c  
sfrb(ADC12MEM11_H, ADC12MEM11_H_);
#define ADC12MEM12_ __MSP430_ADC12_PLUS_BASE__ + 0x2c  /* ADC12 Conversion Memory 12 */
sfrw(ADC12MEM12, ADC12MEM12_);
#define ADC12MEM12_L_ __MSP430_ADC12_PLUS_BASE__ + 0x2c  
sfrb(ADC12MEM12_L, ADC12MEM12_L_);
#define ADC12MEM12_H_ __MSP430_ADC12_PLUS_BASE__ + 0x2d  
sfrb(ADC12MEM12_H, ADC12MEM12_H_);
#define ADC12MEM13_ __MSP430_ADC12_PLUS_BASE__ + 0x2d  /* ADC12 Conversion Memory 13 */
sfrw(ADC12MEM13, ADC12MEM13_);
#define ADC12MEM13_L_ __MSP430_ADC12_PLUS_BASE__ + 0x2d  
sfrb(ADC12MEM13_L, ADC12MEM13_L_);
#define ADC12MEM13_H_ __MSP430_ADC12_PLUS_BASE__ + 0x2e  
sfrb(ADC12MEM13_H, ADC12MEM13_H_);
#define ADC12MEM14_ __MSP430_ADC12_PLUS_BASE__ + 0x2e  /* ADC12 Conversion Memory 14 */
sfrw(ADC12MEM14, ADC12MEM14_);
#define ADC12MEM14_L_ __MSP430_ADC12_PLUS_BASE__ + 0x2e  
sfrb(ADC12MEM14_L, ADC12MEM14_L_);
#define ADC12MEM14_H_ __MSP430_ADC12_PLUS_BASE__ + 0x2f  
sfrb(ADC12MEM14_H, ADC12MEM14_H_);
#define ADC12MEM15_ __MSP430_ADC12_PLUS_BASE__ + 0x2f  /* ADC12 Conversion Memory 15 */
sfrw(ADC12MEM15, ADC12MEM15_);
#define ADC12MEM15_L_ __MSP430_ADC12_PLUS_BASE__ + 0x2f  
sfrb(ADC12MEM15_L, ADC12MEM15_L_);
#define ADC12MEM15_H_ __MSP430_ADC12_PLUS_BASE__ + 0x30  
sfrb(ADC12MEM15_H, ADC12MEM15_H_);
#define ADC12MEM_              ADC12MEM       /* ADC12 Conversion Memory */
#ifdef __ASM_HEADER__
#define ADC12MEM               ADC12MEM0      /* ADC12 Conversion Memory (for assembler) */
#else
#define ADC12MEM               ((volatile int*) (ADC12MEM0_)) /* ADC12 Conversion Memory (for C) */
#endif

#define ADC12MCTL0_ __MSP430_ADC12_PLUS_BASE__ + 0x10  /* ADC12 Memory Control 0 */
sfrb(ADC12MCTL0, ADC12MCTL0_);
#define ADC12MCTL1_ __MSP430_ADC12_PLUS_BASE__ + 0x11  /* ADC12 Memory Control 1 */
sfrb(ADC12MCTL1, ADC12MCTL1_);
#define ADC12MCTL2_ __MSP430_ADC12_PLUS_BASE__ + 0x12  /* ADC12 Memory Control 2 */
sfrb(ADC12MCTL2, ADC12MCTL2_);
#define ADC12MCTL3_ __MSP430_ADC12_PLUS_BASE__ + 0x13  /* ADC12 Memory Control 3 */
sfrb(ADC12MCTL3, ADC12MCTL3_);
#define ADC12MCTL4_ __MSP430_ADC12_PLUS_BASE__ + 0x14  /* ADC12 Memory Control 4 */
sfrb(ADC12MCTL4, ADC12MCTL4_);
#define ADC12MCTL5_ __MSP430_ADC12_PLUS_BASE__ + 0x15  /* ADC12 Memory Control 5 */
sfrb(ADC12MCTL5, ADC12MCTL5_);
#define ADC12MCTL6_ __MSP430_ADC12_PLUS_BASE__ + 0x16  /* ADC12 Memory Control 6 */
sfrb(ADC12MCTL6, ADC12MCTL6_);
#define ADC12MCTL7_ __MSP430_ADC12_PLUS_BASE__ + 0x17  /* ADC12 Memory Control 7 */
sfrb(ADC12MCTL7, ADC12MCTL7_);
#define ADC12MCTL8_ __MSP430_ADC12_PLUS_BASE__ + 0x18  /* ADC12 Memory Control 8 */
sfrb(ADC12MCTL8, ADC12MCTL8_);
#define ADC12MCTL9_ __MSP430_ADC12_PLUS_BASE__ + 0x19  /* ADC12 Memory Control 9 */
sfrb(ADC12MCTL9, ADC12MCTL9_);
#define ADC12MCTL10_ __MSP430_ADC12_PLUS_BASE__ + 0x1a  /* ADC12 Memory Control 10 */
sfrb(ADC12MCTL10, ADC12MCTL10_);
#define ADC12MCTL11_ __MSP430_ADC12_PLUS_BASE__ + 0x1b  /* ADC12 Memory Control 11 */
sfrb(ADC12MCTL11, ADC12MCTL11_);
#define ADC12MCTL12_ __MSP430_ADC12_PLUS_BASE__ + 0x1c  /* ADC12 Memory Control 12 */
sfrb(ADC12MCTL12, ADC12MCTL12_);
#define ADC12MCTL13_ __MSP430_ADC12_PLUS_BASE__ + 0x1d  /* ADC12 Memory Control 13 */
sfrb(ADC12MCTL13, ADC12MCTL13_);
#define ADC12MCTL14_ __MSP430_ADC12_PLUS_BASE__ + 0x1e  /* ADC12 Memory Control 14 */
sfrb(ADC12MCTL14, ADC12MCTL14_);
#define ADC12MCTL15_ __MSP430_ADC12_PLUS_BASE__ + 0x1f  /* ADC12 Memory Control 15 */
sfrb(ADC12MCTL15, ADC12MCTL15_);
#define ADC12MCTL_             ADC12MCTL      /* ADC12 Memory Control */
#ifdef __ASM_HEADER__
#define ADC12MCTL              ADC12MCTL0     /* ADC12 Memory Control (for assembler) */
#else
#define ADC12MCTL              ((volatile char*) (ADC12MCTL0_)) /* ADC12 Memory Control (for C) */
#endif

/* ADC12CTL0 Control Bits */
#define ADC12SC                (0x001)        /* ADC12 Start Conversion */
#define ADC12ENC               (0x002)        /* ADC12 Enable Conversion */
#define ADC12TOVIE             (0x004)        /* ADC12 Timer Overflow interrupt enable */
#define ADC12OVIE              (0x008)        /* ADC12 Overflow interrupt enable */
#define ADC12ON                (0x010)        /* ADC12 On/enable */
#define ADC12REFON             (0x020)        /* ADC12 Reference on */
#define ADC12REF2_5V           (0x040)        /* ADC12 Ref 0:1.5V / 1:2.5V */
#define ADC12MSC               (0x080)        /* ADC12 Multiple SampleConversion */
#define ADC12SHT00             (0x0100)       /* ADC12 Sample Hold 0 Select 0 */
#define ADC12SHT01             (0x0200)       /* ADC12 Sample Hold 0 Select 1 */
#define ADC12SHT02             (0x0400)       /* ADC12 Sample Hold 0 Select 2 */
#define ADC12SHT03             (0x0800)       /* ADC12 Sample Hold 0 Select 3 */
#define ADC12SHT10             (0x1000)       /* ADC12 Sample Hold 0 Select 0 */
#define ADC12SHT11             (0x2000)       /* ADC12 Sample Hold 1 Select 1 */
#define ADC12SHT12             (0x4000)       /* ADC12 Sample Hold 2 Select 2 */
#define ADC12SHT13             (0x8000)       /* ADC12 Sample Hold 3 Select 3 */

/* ADC12CTL0 Control Bits */
#define ADC12SC_L              (0x0001)       /* ADC12 Start Conversion */
#define ADC12ENC_L             (0x0002)       /* ADC12 Enable Conversion */
#define ADC12TOVIE_L           (0x0004)       /* ADC12 Timer Overflow interrupt enable */
#define ADC12OVIE_L            (0x0008)       /* ADC12 Overflow interrupt enable */
#define ADC12ON_L              (0x0010)       /* ADC12 On/enable */
#define ADC12REFON_L           (0x0020)       /* ADC12 Reference on */
#define ADC12REF2_5V_L         (0x0040)       /* ADC12 Ref 0:1.5V / 1:2.5V */
#define ADC12MSC_L             (0x0080)       /* ADC12 Multiple SampleConversion */

/* ADC12CTL0 Control Bits */
#define ADC12SHT00_H           (0x0001)       /* ADC12 Sample Hold 0 Select 0 */
#define ADC12SHT01_H           (0x0002)       /* ADC12 Sample Hold 0 Select 1 */
#define ADC12SHT02_H           (0x0004)       /* ADC12 Sample Hold 0 Select 2 */
#define ADC12SHT03_H           (0x0008)       /* ADC12 Sample Hold 0 Select 3 */
#define ADC12SHT10_H           (0x0010)       /* ADC12 Sample Hold 0 Select 0 */
#define ADC12SHT11_H           (0x0020)       /* ADC12 Sample Hold 1 Select 1 */
#define ADC12SHT12_H           (0x0040)       /* ADC12 Sample Hold 2 Select 2 */
#define ADC12SHT13_H           (0x0080)       /* ADC12 Sample Hold 3 Select 3 */

#define ADC12SHT0_0            (0*0x100u)
#define ADC12SHT0_1            (1*0x100u)
#define ADC12SHT0_2            (2*0x100u)
#define ADC12SHT0_3            (3*0x100u)
#define ADC12SHT0_4            (4*0x100u)
#define ADC12SHT0_5            (5*0x100u)
#define ADC12SHT0_6            (6*0x100u)
#define ADC12SHT0_7            (7*0x100u)
#define ADC12SHT0_8            (8*0x100u)
#define ADC12SHT0_9            (9*0x100u)
#define ADC12SHT0_10           (10*0x100u)
#define ADC12SHT0_11           (11*0x100u)
#define ADC12SHT0_12           (12*0x100u)
#define ADC12SHT0_13           (13*0x100u)
#define ADC12SHT0_14           (14*0x100u)
#define ADC12SHT0_15           (15*0x100u)

#define ADC12SHT1_0            (0*0x1000u)
#define ADC12SHT1_1            (1*0x1000u)
#define ADC12SHT1_2            (2*0x1000u)
#define ADC12SHT1_3            (3*0x1000u)
#define ADC12SHT1_4            (4*0x1000u)
#define ADC12SHT1_5            (5*0x1000u)
#define ADC12SHT1_6            (6*0x1000u)
#define ADC12SHT1_7            (7*0x1000u)
#define ADC12SHT1_8            (8*0x1000u)
#define ADC12SHT1_9            (9*0x1000u)
#define ADC12SHT1_10           (10*0x1000u)
#define ADC12SHT1_11           (11*0x1000u)
#define ADC12SHT1_12           (12*0x1000u)
#define ADC12SHT1_13           (13*0x1000u)
#define ADC12SHT1_14           (14*0x1000u)
#define ADC12SHT1_15           (15*0x1000u)

/* ADC12CTL1 Control Bits */
#define ADC12BUSY              (0x0001)       /* ADC12 Busy */
#define ADC12CONSEQ0           (0x0002)       /* ADC12 Conversion Sequence Select 0 */
#define ADC12CONSEQ1           (0x0004)       /* ADC12 Conversion Sequence Select 1 */
#define ADC12SSEL0             (0x0008)       /* ADC12 Clock Source Select 0 */
#define ADC12SSEL1             (0x0010)       /* ADC12 Clock Source Select 1 */
#define ADC12DIV0              (0x0020)       /* ADC12 Clock Divider Select 0 */
#define ADC12DIV1              (0x0040)       /* ADC12 Clock Divider Select 1 */
#define ADC12DIV2              (0x0080)       /* ADC12 Clock Divider Select 2 */
#define ADC12ISSH              (0x0100)       /* ADC12 Invert Sample Hold Signal */
#define ADC12SHP               (0x0200)       /* ADC12 Sample/Hold Pulse Mode */
#define ADC12SHS0              (0x0400)       /* ADC12 Sample/Hold Source 0 */
#define ADC12SHS1              (0x0800)       /* ADC12 Sample/Hold Source 1 */
#define ADC12CSTARTADD0        (0x1000)       /* ADC12 Conversion Start Address 0 */
#define ADC12CSTARTADD1        (0x2000)       /* ADC12 Conversion Start Address 1 */
#define ADC12CSTARTADD2        (0x4000)       /* ADC12 Conversion Start Address 2 */
#define ADC12CSTARTADD3        (0x8000)       /* ADC12 Conversion Start Address 3 */

/* ADC12CTL1 Control Bits */
#define ADC12BUSY_L            (0x0001)       /* ADC12 Busy */
#define ADC12CONSEQ0_L         (0x0002)       /* ADC12 Conversion Sequence Select 0 */
#define ADC12CONSEQ1_L         (0x0004)       /* ADC12 Conversion Sequence Select 1 */
#define ADC12SSEL0_L           (0x0008)       /* ADC12 Clock Source Select 0 */
#define ADC12SSEL1_L           (0x0010)       /* ADC12 Clock Source Select 1 */
#define ADC12DIV0_L            (0x0020)       /* ADC12 Clock Divider Select 0 */
#define ADC12DIV1_L            (0x0040)       /* ADC12 Clock Divider Select 1 */
#define ADC12DIV2_L            (0x0080)       /* ADC12 Clock Divider Select 2 */

/* ADC12CTL1 Control Bits */
#define ADC12ISSH_H            (0x0001)       /* ADC12 Invert Sample Hold Signal */
#define ADC12SHP_H             (0x0002)       /* ADC12 Sample/Hold Pulse Mode */
#define ADC12SHS0_H            (0x0004)       /* ADC12 Sample/Hold Source 0 */
#define ADC12SHS1_H            (0x0008)       /* ADC12 Sample/Hold Source 1 */
#define ADC12CSTARTADD0_H      (0x0010)       /* ADC12 Conversion Start Address 0 */
#define ADC12CSTARTADD1_H      (0x0020)       /* ADC12 Conversion Start Address 1 */
#define ADC12CSTARTADD2_H      (0x0040)       /* ADC12 Conversion Start Address 2 */
#define ADC12CSTARTADD3_H      (0x0080)       /* ADC12 Conversion Start Address 3 */

#define ADC12CONSEQ_0          (0*2u)
#define ADC12CONSEQ_1          (1*2u)
#define ADC12CONSEQ_2          (2*2u)
#define ADC12CONSEQ_3          (3*2u)
#define ADC12SSEL_0            (0*8u)
#define ADC12SSEL_1            (1*8u)
#define ADC12SSEL_2            (2*8u)
#define ADC12SSEL_3            (3*8u)
#define ADC12DIV_0             (0*0x20u)
#define ADC12DIV_1             (1*0x20u)
#define ADC12DIV_2             (2*0x20u)
#define ADC12DIV_3             (3*0x20u)
#define ADC12DIV_4             (4*0x20u)
#define ADC12DIV_5             (5*0x20u)
#define ADC12DIV_6             (6*0x20u)
#define ADC12DIV_7             (7*0x20u)
#define ADC12SHS_0             (0*0x400u)
#define ADC12SHS_1             (1*0x400u)
#define ADC12SHS_2             (2*0x400u)
#define ADC12SHS_3             (3*0x400u)
#define ADC12CSTARTADD_0       (0*0x1000u)
#define ADC12CSTARTADD_1       (1*0x1000u)
#define ADC12CSTARTADD_2       (2*0x1000u)
#define ADC12CSTARTADD_3       (3*0x1000u)
#define ADC12CSTARTADD_4       (4*0x1000u)
#define ADC12CSTARTADD_5       (5*0x1000u)
#define ADC12CSTARTADD_6       (6*0x1000u)
#define ADC12CSTARTADD_7       (7*0x1000u)
#define ADC12CSTARTADD_8       (8*0x1000u)
#define ADC12CSTARTADD_9       (9*0x1000u)
#define ADC12CSTARTADD_10      (10*0x1000u)
#define ADC12CSTARTADD_11      (11*0x1000u)
#define ADC12CSTARTADD_12      (12*0x1000u)
#define ADC12CSTARTADD_13      (13*0x1000u)
#define ADC12CSTARTADD_14      (14*0x1000u)
#define ADC12CSTARTADD_15      (15*0x1000u)

/* ADC12CTL2 Control Bits */
#define ADC12REFBURST          (0x0001)       /* ADC12+ Reference Burst */
#define ADC12REFOUT            (0x0002)       /* ADC12+ Reference Out */
#define ADC12SR                (0x0004)       /* ADC12+ Sampling Rate */
#define ADC12DF                (0x0008)       /* ADC12+ Data Format */
#define ADC12RES0              (0x0010)       /* ADC12+ Resolution Bit: 0 */
#define ADC12RES1              (0x0020)       /* ADC12+ Resolution Bit: 1 */
#define ADC12TCOFF             (0x0080)       /* ADC12+ Temperature Sensor Off */
#define ADC12PDIV              (0x0100)       /* ADC12+ predivider 0:/1   1:/4 */

/* ADC12CTL2 Control Bits */
#define ADC12REFBURST_L        (0x0001)       /* ADC12+ Reference Burst */
#define ADC12REFOUT_L          (0x0002)       /* ADC12+ Reference Out */
#define ADC12SR_L              (0x0004)       /* ADC12+ Sampling Rate */
#define ADC12DF_L              (0x0008)       /* ADC12+ Data Format */
#define ADC12RES0_L            (0x0010)       /* ADC12+ Resolution Bit: 0 */
#define ADC12RES1_L            (0x0020)       /* ADC12+ Resolution Bit: 1 */
#define ADC12TCOFF_L           (0x0080)       /* ADC12+ Temperature Sensor Off */

/* ADC12CTL2 Control Bits */
#define ADC12PDIV_H            (0x0001)       /* ADC12+ predivider 0:/1   1:/4 */

#define ADC12RES_0             (0x0000)       /* ADC12+ Resolution : 8 Bit */
#define ADC12RES_1             (0x0010)       /* ADC12+ Resolution : 10 Bit */
#define ADC12RES_2             (0x0020)       /* ADC12+ Resolution : 12 Bit */
#define ADC12RES_3             (0x0030)       /* ADC12+ Resolution : reserved */

/* ADC12MCTLx Control Bits */
#define ADC12INCH0             (0x0001)       /* ADC12 Input Channel Select Bit 0 */
#define ADC12INCH1             (0x0002)       /* ADC12 Input Channel Select Bit 1 */
#define ADC12INCH2             (0x0004)       /* ADC12 Input Channel Select Bit 2 */
#define ADC12INCH3             (0x0008)       /* ADC12 Input Channel Select Bit 3 */
#define ADC12SREF0             (0x0010)       /* ADC12 Select Reference Bit 0 */
#define ADC12SREF1             (0x0020)       /* ADC12 Select Reference Bit 1 */
#define ADC12SREF2             (0x0040)       /* ADC12 Select Reference Bit 2 */
#define ADC12EOS               (0x0080)       /* ADC12 End of Sequence */

#define ADC12INCH_0            (0)
#define ADC12INCH_1            (1)
#define ADC12INCH_2            (2)
#define ADC12INCH_3            (3)
#define ADC12INCH_4            (4)
#define ADC12INCH_5            (5)
#define ADC12INCH_6            (6)
#define ADC12INCH_7            (7)
#define ADC12INCH_8            (8)
#define ADC12INCH_9            (9)
#define ADC12INCH_10           (10)
#define ADC12INCH_11           (11)
#define ADC12INCH_12           (12)
#define ADC12INCH_13           (13)
#define ADC12INCH_14           (14)
#define ADC12INCH_15           (15)

#define ADC12SREF_0            (0*0x10u)
#define ADC12SREF_1            (1*0x10u)
#define ADC12SREF_2            (2*0x10u)
#define ADC12SREF_3            (3*0x10u)
#define ADC12SREF_4            (4*0x10u)
#define ADC12SREF_5            (5*0x10u)
#define ADC12SREF_6            (6*0x10u)
#define ADC12SREF_7            (7*0x10u)

/* ADC12IV Definitions */
#define ADC12IV_NONE           (0x0000)       /* No Interrupt pending */
#define ADC12IV_ADC12OVIFG     (0x0002)       /* ADC12OVIFG */
#define ADC12IV_ADC12TOVIFG    (0x0004)       /* ADC12TOVIFG */
#define ADC12IV_ADC12IFG0      (0x0006)       /* ADC12IFG0 */
#define ADC12IV_ADC12IFG1      (0x0008)       /* ADC12IFG1 */
#define ADC12IV_ADC12IFG2      (0x000A)       /* ADC12IFG2 */
#define ADC12IV_ADC12IFG3      (0x000C)       /* ADC12IFG3 */
#define ADC12IV_ADC12IFG4      (0x000E)       /* ADC12IFG4 */
#define ADC12IV_ADC12IFG5      (0x0010)       /* ADC12IFG5 */
#define ADC12IV_ADC12IFG6      (0x0012)       /* ADC12IFG6 */
#define ADC12IV_ADC12IFG7      (0x0014)       /* ADC12IFG7 */
#define ADC12IV_ADC12IFG8      (0x0016)       /* ADC12IFG8 */
#define ADC12IV_ADC12IFG9      (0x0018)       /* ADC12IFG9 */
#define ADC12IV_ADC12IFG10     (0x001A)       /* ADC12IFG10 */
#define ADC12IV_ADC12IFG11     (0x001C)       /* ADC12IFG11 */
#define ADC12IV_ADC12IFG12     (0x001E)       /* ADC12IFG12 */
#define ADC12IV_ADC12IFG13     (0x0020)       /* ADC12IFG13 */
#define ADC12IV_ADC12IFG14     (0x0022)       /* ADC12IFG14 */
#define ADC12IV_ADC12IFG15     (0x0024)       /* ADC12IFG15 */

#endif /* __MSP430_ADC12_PLUS_BASE__ */

#endif /* __MSP430_HEADERS_ADC12_PLUS_H__ */

