#ifndef __MSP430_HEADERS_AES_H
#define __MSP430_HEADERS_AES_H

/* aes.h
*
* mspgcc project: MSP430 device headers
* Advanced Enscription Standard module
* Based on cc430x613x.h version 1.5 by Texas Instruments
*
* Peter A. Bigot <pab@peoplepowerco.com>
*/

/* Switches:

__MSP430_AES_BASE__ - base address of the port mapping control module, present if defined

*/

#if defined(__MSP430_AES_BASE__)

/************************************************************
* AES Accelerator
************************************************************/
#define __MSP430_HAS_AES__                    /* Definition to show that Module is available */

#define AESACTL0_                __MSP430_AES_BASE__ + 0x00  /* AES accelerator control register 0 */
sfrw(AESACTL0, AESACTL0_);
#define AESACTL0_L_              __MSP430_AES_BASE__ + 0x00  
sfrb(AESACTL0_L, AESACTL0_L_);
#define AESACTL0_H_              __MSP430_AES_BASE__ + 0x01  
sfrb(AESACTL0_H, AESACTL0_H_);
#define AESASTAT_                __MSP430_AES_BASE__ + 0x04  /* AES accelerator status register */
sfrw(AESASTAT, AESASTAT_);
#define AESASTAT_L_              __MSP430_AES_BASE__ + 0x04  
sfrb(AESASTAT_L, AESASTAT_L_);
#define AESASTAT_H_              __MSP430_AES_BASE__ + 0x05  
sfrb(AESASTAT_H, AESASTAT_H_);
#define AESAKEY_                 __MSP430_AES_BASE__ + 0x06  /* AES accelerator key register */
sfrw(AESAKEY, AESAKEY_);
#define AESAKEY_L_               __MSP430_AES_BASE__ + 0x06  
sfrb(AESAKEY_L, AESAKEY_L_);
#define AESAKEY_H_               __MSP430_AES_BASE__ + 0x07  
sfrb(AESAKEY_H, AESAKEY_H_);
#define AESADIN_                 __MSP430_AES_BASE__ + 0x08  /* AES accelerator data in register */
sfrw(AESADIN, AESADIN_);
#define AESADIN_L_               __MSP430_AES_BASE__ + 0x08  
sfrb(AESADIN_L, AESADIN_L_);
#define AESADIN_H_               __MSP430_AES_BASE__ + 0x09  
sfrb(AESADIN_H, AESADIN_H_);
#define AESADOUT_                __MSP430_AES_BASE__ + 0x0a  /* AES accelerator data out register  */
sfrw(AESADOUT, AESADOUT_);
#define AESADOUT_L_              __MSP430_AES_BASE__ + 0x0a  
sfrb(AESADOUT_L, AESADOUT_L_);
#define AESADOUT_H_              __MSP430_AES_BASE__ + 0x0b  
sfrb(AESADOUT_H, AESADOUT_H_);

/* AESACTL0 Control Bits */
#define AESOP0                 (0x0001)       /* AES Operation Bit: 0 */
#define AESOP1                 (0x0002)       /* AES Operation Bit: 1 */
#define AESSWRST               (0x0080)       /* AES Software Reset */
#define AESRDYIFG              (0x0100)       /* AES ready interrupt flag */
#define AESERRFG               (0x0800)       /* AES Error Flag */
#define AESRDYIE               (0x1000)       /* AES ready interrupt enable*/

/* AESACTL0 Control Bits */
#define AESOP0_L               (0x0001)       /* AES Operation Bit: 0 */
#define AESOP1_L               (0x0002)       /* AES Operation Bit: 1 */
#define AESSWRST_L             (0x0080)       /* AES Software Reset */

/* AESACTL0 Control Bits */
#define AESRDYIFG_H            (0x0001)       /* AES ready interrupt flag */
#define AESERRFG_H             (0x0008)       /* AES Error Flag */
#define AESRDYIE_H             (0x0010)       /* AES ready interrupt enable*/

#define AESOP_0                (0x0000)       /* AES Operation: Encrypt */
#define AESOP_1                (0x0001)       /* AES Operation: Decrypt (same Key) */
#define AESOP_2                (0x0002)       /* AES Operation: Decrypt (frist round Key) */
#define AESOP_3                (0x0003)       /* AES Operation: Generate first round Key */

/* AESASTAT Control Bits */
#define AESBUSY                (0x0001)       /* AES Busy */
#define AESKEYWR               (0x0002)       /* AES All 16 bytes written to AESAKEY */
#define AESDINWR               (0x0004)       /* AES All 16 bytes written to AESADIN */
#define AESDOUTRD              (0x0008)       /* AES All 16 bytes read from AESADOUT */
#define AESKEYCNT0             (0x0010)       /* AES Bytes written via AESAKEY Bit: 0 */
#define AESKEYCNT1             (0x0020)       /* AES Bytes written via AESAKEY Bit: 1 */
#define AESKEYCNT2             (0x0040)       /* AES Bytes written via AESAKEY Bit: 2 */
#define AESKEYCNT3             (0x0080)       /* AES Bytes written via AESAKEY Bit: 3 */
#define AESDINCNT0             (0x0100)       /* AES Bytes written via AESADIN Bit: 0 */
#define AESDINCNT1             (0x0200)       /* AES Bytes written via AESADIN Bit: 1 */
#define AESDINCNT2             (0x0400)       /* AES Bytes written via AESADIN Bit: 2 */
#define AESDINCNT3             (0x0800)       /* AES Bytes written via AESADIN Bit: 3 */
#define AESDOUTCNT0            (0x1000)       /* AES Bytes read via AESADOUT Bit: 0 */
#define AESDOUTCNT1            (0x2000)       /* AES Bytes read via AESADOUT Bit: 1 */
#define AESDOUTCNT2            (0x4000)       /* AES Bytes read via AESADOUT Bit: 2 */
#define AESDOUTCNT3            (0x8000)       /* AES Bytes read via AESADOUT Bit: 3 */

/* AESASTAT Control Bits */
#define AESBUSY_L              (0x0001)       /* AES Busy */
#define AESKEYWR_L             (0x0002)       /* AES All 16 bytes written to AESAKEY */
#define AESDINWR_L             (0x0004)       /* AES All 16 bytes written to AESADIN */
#define AESDOUTRD_L            (0x0008)       /* AES All 16 bytes read from AESADOUT */
#define AESKEYCNT0_L           (0x0010)       /* AES Bytes written via AESAKEY Bit: 0 */
#define AESKEYCNT1_L           (0x0020)       /* AES Bytes written via AESAKEY Bit: 1 */
#define AESKEYCNT2_L           (0x0040)       /* AES Bytes written via AESAKEY Bit: 2 */
#define AESKEYCNT3_L           (0x0080)       /* AES Bytes written via AESAKEY Bit: 3 */

/* AESASTAT Control Bits */
#define AESDINCNT0_H           (0x0001)       /* AES Bytes written via AESADIN Bit: 0 */
#define AESDINCNT1_H           (0x0002)       /* AES Bytes written via AESADIN Bit: 1 */
#define AESDINCNT2_H           (0x0004)       /* AES Bytes written via AESADIN Bit: 2 */
#define AESDINCNT3_H           (0x0008)       /* AES Bytes written via AESADIN Bit: 3 */
#define AESDOUTCNT0_H          (0x0010)       /* AES Bytes read via AESADOUT Bit: 0 */
#define AESDOUTCNT1_H          (0x0020)       /* AES Bytes read via AESADOUT Bit: 1 */
#define AESDOUTCNT2_H          (0x0040)       /* AES Bytes read via AESADOUT Bit: 2 */
#define AESDOUTCNT3_H          (0x0080)       /* AES Bytes read via AESADOUT Bit: 3 */

#endif /* __MSP430_AES_BASE__ */

#endif /* __MSP430_HEADERS_AES_H */
