#if !defined(__MSP430_HEADERS_USCI_5XX_H__)
#define __MSP430_HEADERS_USCI_5XX_H__

/* usci_5xx.h
 *
 * mspgcc project: MSP430 device headers
 * Universal Serial Communication Interface (USCI) module
 * Variant for MSP430-5xx architecture chips
 *
 * Based on msp430x54x.h version 1.10 by Texas Instruments
 *
 * Peter A. Bigot <pab@peoplepowerco.com>
 *
 */

/* Switches:
__MSP430_HAS_USCI_A0__ -- definition indicates availability
__MSP430_HAS_USCI_B0__ -- definition indicates availability
__MSP430_USCI0_BASE__ -- USCI module base address for A0/B0; definition indicates availability
__MSP430_HAS_USCI_A1__ -- definition indicates availability
__MSP430_HAS_USCI_B1__ -- definition indicates availability
__MSP430_USCI1_BASE__ -- USCI module base address for A1/B1; definition indicates availability
__MSP430_HAS_USCI_A2__ -- definition indicates availability
__MSP430_HAS_USCI_B2__ -- definition indicates availability
__MSP430_USCI2_BASE__ -- USCI module base address for A2/B2; definition indicates availability
__MSP430_HAS_USCI_A3__ -- definition indicates availability
__MSP430_HAS_USCI_B3__ -- definition indicates availability
__MSP430_USCI3_BASE__ -- USCI module base address for A3/B3; definition indicates availability
*/

#if defined(__MSP430_USCI0_BASE__)

#if defined(__MSP430_HAS_USCI_A0__)
/************************************************************
* USCI A0
************************************************************/
#define UCA0CTLW0_ __MSP430_USCI0_BASE__ + 0x00  /* USCI A0 Control Word Register 0 */
sfrw(UCA0CTLW0, UCA0CTLW0_);
#define UCA0CTLW0_L_ __MSP430_USCI0_BASE__ + 0x00  
sfrb(UCA0CTLW0_L, UCA0CTLW0_L_);
#define UCA0CTLW0_H_ __MSP430_USCI0_BASE__ + 0x01  
sfrb(UCA0CTLW0_H, UCA0CTLW0_H_);
#define UCA0CTL1               UCA0CTLW0_L    /* USCI A0 Control Register 1 */
#define UCA0CTL0               UCA0CTLW0_H    /* USCI A0 Control Register 0 */
#define UCA0BRW_ __MSP430_USCI0_BASE__ + 0x06  /* USCI A0 Baud Word Rate 0 */
sfrw(UCA0BRW, UCA0BRW_);
#define UCA0BRW_L_ __MSP430_USCI0_BASE__ + 0x06  
sfrb(UCA0BRW_L, UCA0BRW_L_);
#define UCA0BRW_H_ __MSP430_USCI0_BASE__ + 0x07  
sfrb(UCA0BRW_H, UCA0BRW_H_);
#define UCA0BR0                UCA0BRW_L      /* USCI A0 Baud Rate 0 */
#define UCA0BR1                UCA0BRW_H      /* USCI A0 Baud Rate 1 */
#define UCA0MCTL_ __MSP430_USCI0_BASE__ + 0x08  /* USCI A0 Modulation Control */
sfrb(UCA0MCTL, UCA0MCTL_);
#define UCA0STAT_ __MSP430_USCI0_BASE__ + 0x0a  /* USCI A0 Status Register */
sfrb(UCA0STAT, UCA0STAT_);
#define UCA0RXBUF_ __MSP430_USCI0_BASE__ + 0x0c  /* USCI A0 Receive Buffer */
sfrb(UCA0RXBUF, UCA0RXBUF_);
#define UCA0TXBUF_ __MSP430_USCI0_BASE__ + 0x0e  /* USCI A0 Transmit Buffer */
sfrb(UCA0TXBUF, UCA0TXBUF_);
#define UCA0ABCTL_ __MSP430_USCI0_BASE__ + 0x10  /* USCI A0 LIN Control */
sfrb(UCA0ABCTL, UCA0ABCTL_);
#define UCA0IRCTL_ __MSP430_USCI0_BASE__ + 0x12  /* USCI A0 IrDA Transmit Control */
sfrw(UCA0IRCTL, UCA0IRCTL_);
#define UCA0IRCTL_L_ __MSP430_USCI0_BASE__ + 0x12  
sfrb(UCA0IRCTL_L, UCA0IRCTL_L_);
#define UCA0IRCTL_H_ __MSP430_USCI0_BASE__ + 0x13  
sfrb(UCA0IRCTL_H, UCA0IRCTL_H_);
#define UCA0IRTCTL             UCA0IRCTL_L    /* USCI A0 IrDA Transmit Control */
#define UCA0IRRCTL             UCA0IRCTL_H    /* USCI A0 IrDA Receive Control */
#define UCA0ICTL_ __MSP430_USCI0_BASE__ + 0x1c  /* USCI A0 Interrupt Enable Register */
sfrw(UCA0ICTL, UCA0ICTL_);
#define UCA0ICTL_L_ __MSP430_USCI0_BASE__ + 0x1c  
sfrb(UCA0ICTL_L, UCA0ICTL_L_);
#define UCA0ICTL_H_ __MSP430_USCI0_BASE__ + 0x1d  
sfrb(UCA0ICTL_H, UCA0ICTL_H_);
#define UCA0IE                 UCA0ICTL_L     /* USCI A0 Interrupt Enable Register */
#define UCA0IFG                UCA0ICTL_H     /* USCI A0 Interrupt Flags Register */
#define UCA0IV_ __MSP430_USCI0_BASE__ + 0x1e  /* USCI A0 Interrupt Vector Register */
sfrw(UCA0IV, UCA0IV_);
#endif // __MSP430_HAS_USCI_A0__

#if defined(__MSP430_HAS_USCI_B0__)
/************************************************************
* USCI B0
************************************************************/
#define UCB0CTLW0_ __MSP430_USCI0_BASE__ + 0x20  /* USCI B0 Control Word Register 0 */
sfrw(UCB0CTLW0, UCB0CTLW0_);
#define UCB0CTLW0_L_ __MSP430_USCI0_BASE__ + 0x20  
sfrb(UCB0CTLW0_L, UCB0CTLW0_L_);
#define UCB0CTLW0_H_ __MSP430_USCI0_BASE__ + 0x21  
sfrb(UCB0CTLW0_H, UCB0CTLW0_H_);
#define UCB0CTL1               UCB0CTLW0_L    /* USCI B0 Control Register 1 */
#define UCB0CTL0               UCB0CTLW0_H    /* USCI B0 Control Register 0 */
#define UCB0BRW_ __MSP430_USCI0_BASE__ + 0x26  /* USCI B0 Baud Word Rate 0 */
sfrw(UCB0BRW, UCB0BRW_);
#define UCB0BRW_L_ __MSP430_USCI0_BASE__ + 0x26  
sfrb(UCB0BRW_L, UCB0BRW_L_);
#define UCB0BRW_H_ __MSP430_USCI0_BASE__ + 0x27  
sfrb(UCB0BRW_H, UCB0BRW_H_);
#define UCB0BR0                UCB0BRW_L      /* USCI B0 Baud Rate 0 */
#define UCB0BR1                UCB0BRW_H      /* USCI B0 Baud Rate 1 */
#define UCB0STAT_ __MSP430_USCI0_BASE__ + 0x2a  /* USCI B0 Status Register */
sfrb(UCB0STAT, UCB0STAT_);
#define UCB0RXBUF_ __MSP430_USCI0_BASE__ + 0x2c  /* USCI B0 Receive Buffer */
sfrb(UCB0RXBUF, UCB0RXBUF_);
#define UCB0TXBUF_ __MSP430_USCI0_BASE__ + 0x2e  /* USCI B0 Transmit Buffer */
sfrb(UCB0TXBUF, UCB0TXBUF_);
#define UCB0I2COA_ __MSP430_USCI0_BASE__ + 0x30  /* USCI B0 I2C Own Address */
sfrw(UCB0I2COA, UCB0I2COA_);
#define UCB0I2COA_L_ __MSP430_USCI0_BASE__ + 0x30  
sfrb(UCB0I2COA_L, UCB0I2COA_L_);
#define UCB0I2COA_H_ __MSP430_USCI0_BASE__ + 0x31  
sfrb(UCB0I2COA_H, UCB0I2COA_H_);
#define UCB0I2CSA_ __MSP430_USCI0_BASE__ + 0x32  /* USCI B0 I2C Slave Address */
sfrw(UCB0I2CSA, UCB0I2CSA_);
#define UCB0I2CSA_L_ __MSP430_USCI0_BASE__ + 0x32  
sfrb(UCB0I2CSA_L, UCB0I2CSA_L_);
#define UCB0I2CSA_H_ __MSP430_USCI0_BASE__ + 0x33  
sfrb(UCB0I2CSA_H, UCB0I2CSA_H_);
#define UCB0ICTL_ __MSP430_USCI0_BASE__ + 0x3c  /* USCI B0 Interrupt Enable Register */
sfrw(UCB0ICTL, UCB0ICTL_);
#define UCB0ICTL_L_ __MSP430_USCI0_BASE__ + 0x3c  
sfrb(UCB0ICTL_L, UCB0ICTL_L_);
#define UCB0ICTL_H_ __MSP430_USCI0_BASE__ + 0x3d  
sfrb(UCB0ICTL_H, UCB0ICTL_H_);
#define UCB0IE                 UCB0ICTL_L     /* USCI B0 Interrupt Enable Register */
#define UCB0IFG                UCB0ICTL_H     /* USCI B0 Interrupt Flags Register */
#define UCB0IV_ __MSP430_USCI0_BASE__ + 0x3e  /* USCI B0 Interrupt Vector Register */
sfrw(UCB0IV, UCB0IV_);
#endif // __MSP430_HAS_USCI_B0__

#endif // __MSP430_USCI0_BASE__


// UCAxCTL0 UART-Mode Control Bits
#define UCPEN                  (0x80)         /* Async. Mode: Parity enable */
#define UCPAR                  (0x40)         /* Async. Mode: Parity     0:odd / 1:even */
#define UCMSB                  (0x20)         /* Async. Mode: MSB first  0:LSB / 1:MSB */
#define UC7BIT                 (0x10)         /* Async. Mode: Data Bits  0:8-bits / 1:7-bits */
#define UCSPB                  (0x08)         /* Async. Mode: Stop Bits  0:one / 1: two */
#define UCMODE1                (0x04)         /* Async. Mode: USCI Mode 1 */
#define UCMODE0                (0x02)         /* Async. Mode: USCI Mode 0 */
#define UCSYNC                 (0x01)         /* Sync-Mode  0:UART-Mode / 1:SPI-Mode */

// UCxxCTL0 SPI-Mode Control Bits
#define UCCKPH                 (0x80)         /* Sync. Mode: Clock Phase */
#define UCCKPL                 (0x40)         /* Sync. Mode: Clock Polarity */
#define UCMST                  (0x08)         /* Sync. Mode: Master Select */

// UCBxCTL0 I2C-Mode Control Bits
#define UCA10                  (0x80)         /* 10-bit Address Mode */
#define UCSLA10                (0x40)         /* 10-bit Slave Address Mode */
#define UCMM                   (0x20)         /* Multi-Master Environment */
//#define res               (0x10)    /* reserved */
#define UCMODE_0               (0x00)         /* Sync. Mode: USCI Mode: 0 */
#define UCMODE_1               (0x02)         /* Sync. Mode: USCI Mode: 1 */
#define UCMODE_2               (0x04)         /* Sync. Mode: USCI Mode: 2 */
#define UCMODE_3               (0x06)         /* Sync. Mode: USCI Mode: 3 */

// UCAxCTL1 UART-Mode Control Bits
#define UCSSEL1                (0x80)         /* USCI 0 Clock Source Select 1 */
#define UCSSEL0                (0x40)         /* USCI 0 Clock Source Select 0 */
#define UCRXEIE                (0x20)         /* RX Error interrupt enable */
#define UCBRKIE                (0x10)         /* Break interrupt enable */                   
#define UCDORM                 (0x08)         /* Dormant (Sleep) Mode */
#define UCTXADDR               (0x04)         /* Send next Data as Address */
#define UCTXBRK                (0x02)         /* Send next Data as Break */
#define UCSWRST                (0x01)         /* USCI Software Reset */

// UCxxCTL1 SPI-Mode Control Bits
//#define res               (0x20)    /* reserved */
//#define res               (0x10)    /* reserved */
//#define res               (0x08)    /* reserved */
//#define res               (0x04)    /* reserved */
//#define res               (0x02)    /* reserved */

// UCBxCTL1 I2C-Mode Control Bits
//#define res               (0x20)    /* reserved */
#define UCTR                   (0x10)         /* Transmit/Receive Select/Flag */
#define UCTXNACK               (0x08)         /* Transmit NACK */
#define UCTXSTP                (0x04)         /* Transmit STOP */
#define UCTXSTT                (0x02)         /* Transmit START */
#define UCSSEL_0               (0x00)         /* USCI 0 Clock Source: 0 */
#define UCSSEL_1               (0x40)         /* USCI 0 Clock Source: 1 */
#define UCSSEL_2               (0x80)         /* USCI 0 Clock Source: 2 */
#define UCSSEL_3               (0xC0)         /* USCI 0 Clock Source: 3 */
#define UCSSEL__UCLK           (0x00)         /* USCI 0 Clock Source: UCLK */
#define UCSSEL__ACLK           (0x40)         /* USCI 0 Clock Source: ACLK */
#define UCSSEL__SMCLK          (0x80)         /* USCI 0 Clock Source: SMCLK */

/* UCAxMCTL Control Bits */
#define UCBRF3                 (0x80)         /* USCI First Stage Modulation Select 3 */
#define UCBRF2                 (0x40)         /* USCI First Stage Modulation Select 2 */
#define UCBRF1                 (0x20)         /* USCI First Stage Modulation Select 1 */
#define UCBRF0                 (0x10)         /* USCI First Stage Modulation Select 0 */
#define UCBRS2                 (0x08)         /* USCI Second Stage Modulation Select 2 */
#define UCBRS1                 (0x04)         /* USCI Second Stage Modulation Select 1 */
#define UCBRS0                 (0x02)         /* USCI Second Stage Modulation Select 0 */
#define UCOS16                 (0x01)         /* USCI 16-times Oversampling enable */

#define UCBRF_0                (0x00)         /* USCI First Stage Modulation: 0 */
#define UCBRF_1                (0x10)         /* USCI First Stage Modulation: 1 */
#define UCBRF_2                (0x20)         /* USCI First Stage Modulation: 2 */
#define UCBRF_3                (0x30)         /* USCI First Stage Modulation: 3 */
#define UCBRF_4                (0x40)         /* USCI First Stage Modulation: 4 */
#define UCBRF_5                (0x50)         /* USCI First Stage Modulation: 5 */
#define UCBRF_6                (0x60)         /* USCI First Stage Modulation: 6 */
#define UCBRF_7                (0x70)         /* USCI First Stage Modulation: 7 */
#define UCBRF_8                (0x80)         /* USCI First Stage Modulation: 8 */
#define UCBRF_9                (0x90)         /* USCI First Stage Modulation: 9 */
#define UCBRF_10               (0xA0)         /* USCI First Stage Modulation: A */
#define UCBRF_11               (0xB0)         /* USCI First Stage Modulation: B */
#define UCBRF_12               (0xC0)         /* USCI First Stage Modulation: C */
#define UCBRF_13               (0xD0)         /* USCI First Stage Modulation: D */
#define UCBRF_14               (0xE0)         /* USCI First Stage Modulation: E */
#define UCBRF_15               (0xF0)         /* USCI First Stage Modulation: F */

#define UCBRS_0                (0x00)         /* USCI Second Stage Modulation: 0 */
#define UCBRS_1                (0x02)         /* USCI Second Stage Modulation: 1 */
#define UCBRS_2                (0x04)         /* USCI Second Stage Modulation: 2 */
#define UCBRS_3                (0x06)         /* USCI Second Stage Modulation: 3 */
#define UCBRS_4                (0x08)         /* USCI Second Stage Modulation: 4 */
#define UCBRS_5                (0x0A)         /* USCI Second Stage Modulation: 5 */
#define UCBRS_6                (0x0C)         /* USCI Second Stage Modulation: 6 */
#define UCBRS_7                (0x0E)         /* USCI Second Stage Modulation: 7 */

/* UCAxSTAT Control Bits */
#define UCLISTEN               (0x80)         /* USCI Listen mode */
#define UCFE                   (0x40)         /* USCI Frame Error Flag */
#define UCOE                   (0x20)         /* USCI Overrun Error Flag */
#define UCPE                   (0x10)         /* USCI Parity Error Flag */
#define UCBRK                  (0x08)         /* USCI Break received */
#define UCRXERR                (0x04)         /* USCI RX Error Flag */
#define UCADDR                 (0x02)         /* USCI Address received Flag */
#define UCBUSY                 (0x01)         /* USCI Busy Flag */
#define UCIDLE                 (0x02)         /* USCI Idle line detected Flag */

/* UCBxSTAT Control Bits */
#define UCSCLLOW               (0x40)         /* SCL low */
#define UCGC                   (0x20)         /* General Call address received Flag */
#define UCBBUSY                (0x10)         /* Bus Busy Flag */

/* UCAxIRTCTL Control Bits */
#define UCIRTXPL5              (0x80)         /* IRDA Transmit Pulse Length 5 */
#define UCIRTXPL4              (0x40)         /* IRDA Transmit Pulse Length 4 */
#define UCIRTXPL3              (0x20)         /* IRDA Transmit Pulse Length 3 */
#define UCIRTXPL2              (0x10)         /* IRDA Transmit Pulse Length 2 */
#define UCIRTXPL1              (0x08)         /* IRDA Transmit Pulse Length 1 */
#define UCIRTXPL0              (0x04)         /* IRDA Transmit Pulse Length 0 */
#define UCIRTXCLK              (0x02)         /* IRDA Transmit Pulse Clock Select */
#define UCIREN                 (0x01)         /* IRDA Encoder/Decoder enable */

/* UCAxIRRCTL Control Bits */
#define UCIRRXFL5              (0x80)         /* IRDA Receive Filter Length 5 */
#define UCIRRXFL4              (0x40)         /* IRDA Receive Filter Length 4 */
#define UCIRRXFL3              (0x20)         /* IRDA Receive Filter Length 3 */
#define UCIRRXFL2              (0x10)         /* IRDA Receive Filter Length 2 */
#define UCIRRXFL1              (0x08)         /* IRDA Receive Filter Length 1 */
#define UCIRRXFL0              (0x04)         /* IRDA Receive Filter Length 0 */
#define UCIRRXPL               (0x02)         /* IRDA Receive Input Polarity */
#define UCIRRXFE               (0x01)         /* IRDA Receive Filter enable */

/* UCAxABCTL Control Bits */
//#define res               (0x80)    /* reserved */
//#define res               (0x40)    /* reserved */
#define UCDELIM1               (0x20)         /* Break Sync Delimiter 1 */
#define UCDELIM0               (0x10)         /* Break Sync Delimiter 0 */
#define UCSTOE                 (0x08)         /* Sync-Field Timeout error */
#define UCBTOE                 (0x04)         /* Break Timeout error */
//#define res               (0x02)    /* reserved */
#define UCABDEN                (0x01)         /* Auto Baud Rate detect enable */

/* UCBxI2COA Control Bits */
#define UCGCEN                 (0x8000)       /* I2C General Call enable */
#define UCOA9                  (0x0200)       /* I2C Own Address 9 */
#define UCOA8                  (0x0100)       /* I2C Own Address 8 */
#define UCOA7                  (0x0080)       /* I2C Own Address 7 */
#define UCOA6                  (0x0040)       /* I2C Own Address 6 */
#define UCOA5                  (0x0020)       /* I2C Own Address 5 */
#define UCOA4                  (0x0010)       /* I2C Own Address 4 */
#define UCOA3                  (0x0008)       /* I2C Own Address 3 */
#define UCOA2                  (0x0004)       /* I2C Own Address 2 */
#define UCOA1                  (0x0002)       /* I2C Own Address 1 */
#define UCOA0                  (0x0001)       /* I2C Own Address 0 */

/* UCBxI2COA Control Bits */
#define UCOA7_L                (0x0080)       /* I2C Own Address 7 */
#define UCOA6_L                (0x0040)       /* I2C Own Address 6 */
#define UCOA5_L                (0x0020)       /* I2C Own Address 5 */
#define UCOA4_L                (0x0010)       /* I2C Own Address 4 */
#define UCOA3_L                (0x0008)       /* I2C Own Address 3 */
#define UCOA2_L                (0x0004)       /* I2C Own Address 2 */
#define UCOA1_L                (0x0002)       /* I2C Own Address 1 */
#define UCOA0_L                (0x0001)       /* I2C Own Address 0 */

/* UCBxI2COA Control Bits */
#define UCGCEN_H               (0x0080)       /* I2C General Call enable */
#define UCOA9_H                (0x0002)       /* I2C Own Address 9 */
#define UCOA8_H                (0x0001)       /* I2C Own Address 8 */

/* UCBxI2CSA Control Bits */
#define UCSA9                  (0x0200)       /* I2C Slave Address 9 */
#define UCSA8                  (0x0100)       /* I2C Slave Address 8 */
#define UCSA7                  (0x0080)       /* I2C Slave Address 7 */
#define UCSA6                  (0x0040)       /* I2C Slave Address 6 */
#define UCSA5                  (0x0020)       /* I2C Slave Address 5 */
#define UCSA4                  (0x0010)       /* I2C Slave Address 4 */
#define UCSA3                  (0x0008)       /* I2C Slave Address 3 */
#define UCSA2                  (0x0004)       /* I2C Slave Address 2 */
#define UCSA1                  (0x0002)       /* I2C Slave Address 1 */
#define UCSA0                  (0x0001)       /* I2C Slave Address 0 */

/* UCBxI2CSA Control Bits */
#define UCSA7_L                (0x0080)       /* I2C Slave Address 7 */
#define UCSA6_L                (0x0040)       /* I2C Slave Address 6 */
#define UCSA5_L                (0x0020)       /* I2C Slave Address 5 */
#define UCSA4_L                (0x0010)       /* I2C Slave Address 4 */
#define UCSA3_L                (0x0008)       /* I2C Slave Address 3 */
#define UCSA2_L                (0x0004)       /* I2C Slave Address 2 */
#define UCSA1_L                (0x0002)       /* I2C Slave Address 1 */
#define UCSA0_L                (0x0001)       /* I2C Slave Address 0 */

/* UCBxI2CSA Control Bits */
#define UCSA9_H                (0x0002)       /* I2C Slave Address 9 */
#define UCSA8_H                (0x0001)       /* I2C Slave Address 8 */

/* UCAxIE Control Bits */
#define UCTXIE                 (0x0002)       /* USCI Transmit Interrupt Enable */
#define UCRXIE                 (0x0001)       /* USCI Receive Interrupt Enable */

/* UCBxIE Control Bits */
#define UCNACKIE               (0x0020)       /* NACK Condition interrupt enable */
#define UCALIE                 (0x0010)       /* Arbitration Lost interrupt enable */
#define UCSTPIE                (0x0008)       /* STOP Condition interrupt enable */
#define UCSTTIE                (0x0004)       /* START Condition interrupt enable */
#define UCTXIE                 (0x0002)       /* USCI Transmit Interrupt Enable */
#define UCRXIE                 (0x0001)       /* USCI Receive Interrupt Enable */

/* UCAxIFG Control Bits */
#define UCTXIFG                (0x0002)       /* USCI Transmit Interrupt Flag */
#define UCRXIFG                (0x0001)       /* USCI Receive Interrupt Flag */

/* UCBxIFG Control Bits */
#define UCNACKIFG              (0x0020)       /* NAK Condition interrupt Flag */
#define UCALIFG                (0x0010)       /* Arbitration Lost interrupt Flag */
#define UCSTPIFG               (0x0008)       /* STOP Condition interrupt Flag */
#define UCSTTIFG               (0x0004)       /* START Condition interrupt Flag */
#define UCTXIFG                (0x0002)       /* USCI Transmit Interrupt Flag */
#define UCRXIFG                (0x0001)       /* USCI Receive Interrupt Flag */

/* USCI Definitions */
#define USCI_NONE              (0x0000)       /* No Interrupt pending */
#define USCI_UCRXIFG           (0x0002)       /* USCI UCRXIFG */
#define USCI_UCTXIFG           (0x0004)       /* USCI UCTXIFG */
#define USCI_I2C_UCALIFG       (0x0002)       /* USCI I2C Mode: UCALIFG */
#define USCI_I2C_UCNACKIFG     (0x0004)       /* USCI I2C Mode: UCNACKIFG */
#define USCI_I2C_UCSTTIFG      (0x0006)       /* USCI I2C Mode: UCSTTIFG*/
#define USCI_I2C_UCSTPIFG      (0x0008)       /* USCI I2C Mode: UCSTPIFG*/
#define USCI_I2C_UCRXIFG       (0x000A)       /* USCI I2C Mode: UCRXIFG */
#define USCI_I2C_UCTXIFG       (0x000C)       /* USCI I2C Mode: UCTXIFG */

#if defined(__MSP430_USCI1_BASE__)

#if defined(__MSP430_HAS_USCI_A1__)
/************************************************************
* USCI A1
************************************************************/
#define UCA1CTLW0_ __MSP430_USCI1_BASE__ + 0x00  /* USCI A1 Control Word Register 0 */
sfrw(UCA1CTLW0, UCA1CTLW0_);
#define UCA1CTLW0_L_ __MSP430_USCI1_BASE__ + 0x00  
sfrb(UCA1CTLW0_L, UCA1CTLW0_L_);
#define UCA1CTLW0_H_ __MSP430_USCI1_BASE__ + 0x01  
sfrb(UCA1CTLW0_H, UCA1CTLW0_H_);
#define UCA1CTL1               UCA1CTLW0_L    /* USCI A1 Control Register 1 */
#define UCA1CTL0               UCA1CTLW0_H    /* USCI A1 Control Register 0 */
#define UCA1BRW_ __MSP430_USCI1_BASE__ + 0x06  /* USCI A1 Baud Word Rate 0 */
sfrw(UCA1BRW, UCA1BRW_);
#define UCA1BRW_L_ __MSP430_USCI1_BASE__ + 0x06  
sfrb(UCA1BRW_L, UCA1BRW_L_);
#define UCA1BRW_H_ __MSP430_USCI1_BASE__ + 0x07  
sfrb(UCA1BRW_H, UCA1BRW_H_);
#define UCA1BR0                UCA1BRW_L      /* USCI A1 Baud Rate 0 */
#define UCA1BR1                UCA1BRW_H      /* USCI A1 Baud Rate 1 */
#define UCA1MCTL_ __MSP430_USCI1_BASE__ + 0x08  /* USCI A1 Modulation Control */
sfrb(UCA1MCTL, UCA1MCTL_);
#define UCA1STAT_ __MSP430_USCI1_BASE__ + 0x0a  /* USCI A1 Status Register */
sfrb(UCA1STAT, UCA1STAT_);
#define UCA1RXBUF_ __MSP430_USCI1_BASE__ + 0x0c  /* USCI A1 Receive Buffer */
sfrb(UCA1RXBUF, UCA1RXBUF_);
#define UCA1TXBUF_ __MSP430_USCI1_BASE__ + 0x0e  /* USCI A1 Transmit Buffer */
sfrb(UCA1TXBUF, UCA1TXBUF_);
#define UCA1ABCTL_ __MSP430_USCI1_BASE__ + 0x10  /* USCI A1 LIN Control */
sfrb(UCA1ABCTL, UCA1ABCTL_);
#define UCA1IRCTL_ __MSP430_USCI1_BASE__ + 0x12  /* USCI A1 IrDA Transmit Control */
sfrw(UCA1IRCTL, UCA1IRCTL_);
#define UCA1IRCTL_L_ __MSP430_USCI1_BASE__ + 0x12  
sfrb(UCA1IRCTL_L, UCA1IRCTL_L_);
#define UCA1IRCTL_H_ __MSP430_USCI1_BASE__ + 0x13  
sfrb(UCA1IRCTL_H, UCA1IRCTL_H_);
#define UCA1IRTCTL             UCA1IRCTL_L    /* USCI A1 IrDA Transmit Control */
#define UCA1IRRCTL             UCA1IRCTL_H    /* USCI A1 IrDA Receive Control */
#define UCA1ICTL_ __MSP430_USCI1_BASE__ + 0x1c  /* USCI A1 Interrupt Enable Register */
sfrw(UCA1ICTL, UCA1ICTL_);
#define UCA1ICTL_L_ __MSP430_USCI1_BASE__ + 0x1c  
sfrb(UCA1ICTL_L, UCA1ICTL_L_);
#define UCA1ICTL_H_ __MSP430_USCI1_BASE__ + 0x1d  
sfrb(UCA1ICTL_H, UCA1ICTL_H_);
#define UCA1IE                 UCA1ICTL_L     /* USCI A1 Interrupt Enable Register */
#define UCA1IFG                UCA1ICTL_H     /* USCI A1 Interrupt Flags Register */
#define UCA1IV_ __MSP430_USCI1_BASE__ + 0x1e  /* USCI A1 Interrupt Vector Register */
sfrw(UCA1IV, UCA1IV_);
#endif // __MSP430_HAS_USCI_A1__

#if defined(__MSP430_HAS_USCI_B1__)
/************************************************************
* USCI B1
************************************************************/
#define UCB1CTLW0_ __MSP430_USCI1_BASE__ + 0x20  /* USCI B1 Control Word Register 0 */
sfrw(UCB1CTLW0, UCB1CTLW0_);
#define UCB1CTLW0_L_ __MSP430_USCI1_BASE__ + 0x20  
sfrb(UCB1CTLW0_L, UCB1CTLW0_L_);
#define UCB1CTLW0_H_ __MSP430_USCI1_BASE__ + 0x21  
sfrb(UCB1CTLW0_H, UCB1CTLW0_H_);
#define UCB1CTL1               UCB1CTLW0_L    /* USCI B1 Control Register 1 */
#define UCB1CTL0               UCB1CTLW0_H    /* USCI B1 Control Register 0 */
#define UCB1BRW_ __MSP430_USCI1_BASE__ + 0x26  /* USCI B1 Baud Word Rate 0 */
sfrw(UCB1BRW, UCB1BRW_);
#define UCB1BRW_L_ __MSP430_USCI1_BASE__ + 0x26  
sfrb(UCB1BRW_L, UCB1BRW_L_);
#define UCB1BRW_H_ __MSP430_USCI1_BASE__ + 0x27  
sfrb(UCB1BRW_H, UCB1BRW_H_);
#define UCB1BR0                UCB1BRW_L      /* USCI B1 Baud Rate 0 */
#define UCB1BR1                UCB1BRW_H      /* USCI B1 Baud Rate 1 */
#define UCB1STAT_ __MSP430_USCI1_BASE__ + 0x2a  /* USCI B1 Status Register */
sfrb(UCB1STAT, UCB1STAT_);
#define UCB1RXBUF_ __MSP430_USCI1_BASE__ + 0x2c  /* USCI B1 Receive Buffer */
sfrb(UCB1RXBUF, UCB1RXBUF_);
#define UCB1TXBUF_ __MSP430_USCI1_BASE__ + 0x2e  /* USCI B1 Transmit Buffer */
sfrb(UCB1TXBUF, UCB1TXBUF_);
#define UCB1I2COA_ __MSP430_USCI1_BASE__ + 0x30  /* USCI B1 I2C Own Address */
sfrw(UCB1I2COA, UCB1I2COA_);
#define UCB1I2COA_L_ __MSP430_USCI1_BASE__ + 0x30  
sfrb(UCB1I2COA_L, UCB1I2COA_L_);
#define UCB1I2COA_H_ __MSP430_USCI1_BASE__ + 0x31  
sfrb(UCB1I2COA_H, UCB1I2COA_H_);
#define UCB1I2CSA_ __MSP430_USCI1_BASE__ + 0x32  /* USCI B1 I2C Slave Address */
sfrw(UCB1I2CSA, UCB1I2CSA_);
#define UCB1I2CSA_L_ __MSP430_USCI1_BASE__ + 0x32  
sfrb(UCB1I2CSA_L, UCB1I2CSA_L_);
#define UCB1I2CSA_H_ __MSP430_USCI1_BASE__ + 0x33  
sfrb(UCB1I2CSA_H, UCB1I2CSA_H_);
#define UCB1ICTL_ __MSP430_USCI1_BASE__ + 0x3c  /* USCI B1 Interrupt Enable Register */
sfrw(UCB1ICTL, UCB1ICTL_);
#define UCB1ICTL_L_ __MSP430_USCI1_BASE__ + 0x3c  
sfrb(UCB1ICTL_L, UCB1ICTL_L_);
#define UCB1ICTL_H_ __MSP430_USCI1_BASE__ + 0x3d  
sfrb(UCB1ICTL_H, UCB1ICTL_H_);
#define UCB1IE                 UCB1ICTL_L     /* USCI B1 Interrupt Enable Register */
#define UCB1IFG                UCB1ICTL_H     /* USCI B1 Interrupt Flags Register */
#define UCB1IV_ __MSP430_USCI1_BASE__ + 0x3e  /* USCI B1 Interrupt Vector Register */
sfrw(UCB1IV, UCB1IV_);
#endif // __MSP430_HAS_USCI_B1__

#endif // __MSP430_USCI1_BASE__

#if defined(__MSP430_USCI2_BASE__)

#if defined(__MSP430_HAS_USCI_A2__)
/************************************************************
* USCI A2
************************************************************/
#define UCA2CTLW0_ __MSP430_USCI2_BASE__ + 0x00  /* USCI A2 Control Word Register 0 */
sfrw(UCA2CTLW0, UCA2CTLW0_);
#define UCA2CTLW0_L_ __MSP430_USCI2_BASE__ + 0x00  
sfrb(UCA2CTLW0_L, UCA2CTLW0_L_);
#define UCA2CTLW0_H_ __MSP430_USCI2_BASE__ + 0x01  
sfrb(UCA2CTLW0_H, UCA2CTLW0_H_);
#define UCA2CTL1               UCA2CTLW0_L    /* USCI A2 Control Register 1 */
#define UCA2CTL0               UCA2CTLW0_H    /* USCI A2 Control Register 0 */
#define UCA2BRW_ __MSP430_USCI2_BASE__ + 0x06  /* USCI A2 Baud Word Rate 0 */
sfrw(UCA2BRW, UCA2BRW_);
#define UCA2BRW_L_ __MSP430_USCI2_BASE__ + 0x06  
sfrb(UCA2BRW_L, UCA2BRW_L_);
#define UCA2BRW_H_ __MSP430_USCI2_BASE__ + 0x07  
sfrb(UCA2BRW_H, UCA2BRW_H_);
#define UCA2BR0                UCA2BRW_L      /* USCI A2 Baud Rate 0 */
#define UCA2BR1                UCA2BRW_H      /* USCI A2 Baud Rate 1 */
#define UCA2MCTL_ __MSP430_USCI2_BASE__ + 0x08  /* USCI A2 Modulation Control */
sfrb(UCA2MCTL, UCA2MCTL_);
#define UCA2STAT_ __MSP430_USCI2_BASE__ + 0x0a  /* USCI A2 Status Register */
sfrb(UCA2STAT, UCA2STAT_);
#define UCA2RXBUF_ __MSP430_USCI2_BASE__ + 0x0c  /* USCI A2 Receive Buffer */
sfrb(UCA2RXBUF, UCA2RXBUF_);
#define UCA2TXBUF_ __MSP430_USCI2_BASE__ + 0x0e  /* USCI A2 Transmit Buffer */
sfrb(UCA2TXBUF, UCA2TXBUF_);
#define UCA2ABCTL_ __MSP430_USCI2_BASE__ + 0x10  /* USCI A2 LIN Control */
sfrb(UCA2ABCTL, UCA2ABCTL_);
#define UCA2IRCTL_ __MSP430_USCI2_BASE__ + 0x12  /* USCI A2 IrDA Transmit Control */
sfrw(UCA2IRCTL, UCA2IRCTL_);
#define UCA2IRCTL_L_ __MSP430_USCI2_BASE__ + 0x12  
sfrb(UCA2IRCTL_L, UCA2IRCTL_L_);
#define UCA2IRCTL_H_ __MSP430_USCI2_BASE__ + 0x13  
sfrb(UCA2IRCTL_H, UCA2IRCTL_H_);
#define UCA2IRTCTL             UCA2IRCTL_L    /* USCI A2 IrDA Transmit Control */
#define UCA2IRRCTL             UCA2IRCTL_H    /* USCI A2 IrDA Receive Control */
#define UCA2ICTL_ __MSP430_USCI2_BASE__ + 0x1c  /* USCI A2 Interrupt Enable Register */
sfrw(UCA2ICTL, UCA2ICTL_);
#define UCA2ICTL_L_ __MSP430_USCI2_BASE__ + 0x1c  
sfrb(UCA2ICTL_L, UCA2ICTL_L_);
#define UCA2ICTL_H_ __MSP430_USCI2_BASE__ + 0x1d  
sfrb(UCA2ICTL_H, UCA2ICTL_H_);
#define UCA2IE                 UCA2ICTL_L     /* USCI A2 Interrupt Enable Register */
#define UCA2IFG                UCA2ICTL_H     /* USCI A2 Interrupt Flags Register */
#define UCA2IV_ __MSP430_USCI2_BASE__ + 0x1e  /* USCI A2 Interrupt Vector Register */
sfrw(UCA2IV, UCA2IV_);
#endif // __MSP430_HAS_USCI_A2__

#if defined(__MSP430_HAS_USCI_B2__)
/************************************************************
* USCI B2
************************************************************/
#define UCB2CTLW0_ __MSP430_USCI2_BASE__ + 0x20  /* USCI B2 Control Word Register 0 */
sfrw(UCB2CTLW0, UCB2CTLW0_);
#define UCB2CTLW0_L_ __MSP430_USCI2_BASE__ + 0x20  
sfrb(UCB2CTLW0_L, UCB2CTLW0_L_);
#define UCB2CTLW0_H_ __MSP430_USCI2_BASE__ + 0x21  
sfrb(UCB2CTLW0_H, UCB2CTLW0_H_);
#define UCB2CTL1               UCB2CTLW0_L    /* USCI B2 Control Register 1 */
#define UCB2CTL0               UCB2CTLW0_H    /* USCI B2 Control Register 0 */
#define UCB2BRW_ __MSP430_USCI2_BASE__ + 0x26  /* USCI B2 Baud Word Rate 0 */
sfrw(UCB2BRW, UCB2BRW_);
#define UCB2BRW_L_ __MSP430_USCI2_BASE__ + 0x26  
sfrb(UCB2BRW_L, UCB2BRW_L_);
#define UCB2BRW_H_ __MSP430_USCI2_BASE__ + 0x27  
sfrb(UCB2BRW_H, UCB2BRW_H_);
#define UCB2BR0                UCB2BRW_L      /* USCI B2 Baud Rate 0 */
#define UCB2BR1                UCB2BRW_H      /* USCI B2 Baud Rate 1 */
#define UCB2STAT_ __MSP430_USCI2_BASE__ + 0x2a  /* USCI B2 Status Register */
sfrb(UCB2STAT, UCB2STAT_);
#define UCB2RXBUF_ __MSP430_USCI2_BASE__ + 0x2c  /* USCI B2 Receive Buffer */
sfrb(UCB2RXBUF, UCB2RXBUF_);
#define UCB2TXBUF_ __MSP430_USCI2_BASE__ + 0x2e  /* USCI B2 Transmit Buffer */
sfrb(UCB2TXBUF, UCB2TXBUF_);
#define UCB2I2COA_ __MSP430_USCI2_BASE__ + 0x30  /* USCI B2 I2C Own Address */
sfrw(UCB2I2COA, UCB2I2COA_);
#define UCB2I2COA_L_ __MSP430_USCI2_BASE__ + 0x30  
sfrb(UCB2I2COA_L, UCB2I2COA_L_);
#define UCB2I2COA_H_ __MSP430_USCI2_BASE__ + 0x31  
sfrb(UCB2I2COA_H, UCB2I2COA_H_);
#define UCB2I2CSA_ __MSP430_USCI2_BASE__ + 0x32  /* USCI B2 I2C Slave Address */
sfrw(UCB2I2CSA, UCB2I2CSA_);
#define UCB2I2CSA_L_ __MSP430_USCI2_BASE__ + 0x32  
sfrb(UCB2I2CSA_L, UCB2I2CSA_L_);
#define UCB2I2CSA_H_ __MSP430_USCI2_BASE__ + 0x33  
sfrb(UCB2I2CSA_H, UCB2I2CSA_H_);
#define UCB2ICTL_ __MSP430_USCI2_BASE__ + 0x3c  /* USCI B2 Interrupt Enable Register */
sfrw(UCB2ICTL, UCB2ICTL_);
#define UCB2ICTL_L_ __MSP430_USCI2_BASE__ + 0x3c  
sfrb(UCB2ICTL_L, UCB2ICTL_L_);
#define UCB2ICTL_H_ __MSP430_USCI2_BASE__ + 0x3d  
sfrb(UCB2ICTL_H, UCB2ICTL_H_);
#define UCB2IE                 UCB2ICTL_L     /* USCI B2 Interrupt Enable Register */
#define UCB2IFG                UCB2ICTL_H     /* USCI B2 Interrupt Flags Register */
#define UCB2IV_ __MSP430_USCI2_BASE__ + 0x3e  /* USCI B2 Interrupt Vector Register */
sfrw(UCB2IV, UCB2IV_);
#endif // __MSP430_HAS_USCI_B2__

#endif // __MSP430_USCI2_BASE__

#if defined(__MSP430_USCI3_BASE__)

#if defined(__MSP430_HAS_USCI_A3__)
/************************************************************
* USCI A3
************************************************************/
#define UCA3CTLW0_ __MSP430_USCI3_BASE__ + 0x00  /* USCI A3 Control Word Register 0 */
sfrw(UCA3CTLW0, UCA3CTLW0_);
#define UCA3CTLW0_L_ __MSP430_USCI3_BASE__ + 0x00  
sfrb(UCA3CTLW0_L, UCA3CTLW0_L_);
#define UCA3CTLW0_H_ __MSP430_USCI3_BASE__ + 0x01  
sfrb(UCA3CTLW0_H, UCA3CTLW0_H_);
#define UCA3CTL1               UCA3CTLW0_L    /* USCI A3 Control Register 1 */
#define UCA3CTL0               UCA3CTLW0_H    /* USCI A3 Control Register 0 */
#define UCA3BRW_ __MSP430_USCI3_BASE__ + 0x06  /* USCI A3 Baud Word Rate 0 */
sfrw(UCA3BRW, UCA3BRW_);
#define UCA3BRW_L_ __MSP430_USCI3_BASE__ + 0x06  
sfrb(UCA3BRW_L, UCA3BRW_L_);
#define UCA3BRW_H_ __MSP430_USCI3_BASE__ + 0x07  
sfrb(UCA3BRW_H, UCA3BRW_H_);
#define UCA3BR0                UCA3BRW_L      /* USCI A3 Baud Rate 0 */
#define UCA3BR1                UCA3BRW_H      /* USCI A3 Baud Rate 1 */
#define UCA3MCTL_ __MSP430_USCI3_BASE__ + 0x08  /* USCI A3 Modulation Control */
sfrb(UCA3MCTL, UCA3MCTL_);
#define UCA3STAT_ __MSP430_USCI3_BASE__ + 0x0a  /* USCI A3 Status Register */
sfrb(UCA3STAT, UCA3STAT_);
#define UCA3RXBUF_ __MSP430_USCI3_BASE__ + 0x0c  /* USCI A3 Receive Buffer */
sfrb(UCA3RXBUF, UCA3RXBUF_);
#define UCA3TXBUF_ __MSP430_USCI3_BASE__ + 0x0e  /* USCI A3 Transmit Buffer */
sfrb(UCA3TXBUF, UCA3TXBUF_);
#define UCA3ABCTL_ __MSP430_USCI3_BASE__ + 0x10  /* USCI A3 LIN Control */
sfrb(UCA3ABCTL, UCA3ABCTL_);
#define UCA3IRCTL_ __MSP430_USCI3_BASE__ + 0x12  /* USCI A3 IrDA Transmit Control */
sfrw(UCA3IRCTL, UCA3IRCTL_);
#define UCA3IRCTL_L_ __MSP430_USCI3_BASE__ + 0x12  
sfrb(UCA3IRCTL_L, UCA3IRCTL_L_);
#define UCA3IRCTL_H_ __MSP430_USCI3_BASE__ + 0x13  
sfrb(UCA3IRCTL_H, UCA3IRCTL_H_);
#define UCA3IRTCTL             UCA3IRCTL_L    /* USCI A3 IrDA Transmit Control */
#define UCA3IRRCTL             UCA3IRCTL_H    /* USCI A3 IrDA Receive Control */
#define UCA3ICTL_ __MSP430_USCI3_BASE__ + 0x1c  /* USCI A3 Interrupt Enable Register */
sfrw(UCA3ICTL, UCA3ICTL_);
#define UCA3ICTL_L_ __MSP430_USCI3_BASE__ + 0x1c  
sfrb(UCA3ICTL_L, UCA3ICTL_L_);
#define UCA3ICTL_H_ __MSP430_USCI3_BASE__ + 0x1d  
sfrb(UCA3ICTL_H, UCA3ICTL_H_);
#define UCA3IE                 UCA3ICTL_L     /* USCI A3 Interrupt Enable Register */
#define UCA3IFG                UCA3ICTL_H     /* USCI A3 Interrupt Flags Register */
#define UCA3IV_ __MSP430_USCI3_BASE__ + 0x1e  /* USCI A3 Interrupt Vector Register */
sfrw(UCA3IV, UCA3IV_);
#endif // __MSP430_HAS_USCI_A3__

#if defined(__MSP430_HAS_USCI_B3__)
/************************************************************
* USCI B3
************************************************************/
#define UCB3CTLW0_ __MSP430_USCI3_BASE__ + 0x20  /* USCI B3 Control Word Register 0 */
sfrw(UCB3CTLW0, UCB3CTLW0_);
#define UCB3CTLW0_L_ __MSP430_USCI3_BASE__ + 0x20  
sfrb(UCB3CTLW0_L, UCB3CTLW0_L_);
#define UCB3CTLW0_H_ __MSP430_USCI3_BASE__ + 0x21  
sfrb(UCB3CTLW0_H, UCB3CTLW0_H_);
#define UCB3CTL1               UCB3CTLW0_L    /* USCI B3 Control Register 1 */
#define UCB3CTL0               UCB3CTLW0_H    /* USCI B3 Control Register 0 */
#define UCB3BRW_ __MSP430_USCI3_BASE__ + 0x26  /* USCI B3 Baud Word Rate 0 */
sfrw(UCB3BRW, UCB3BRW_);
#define UCB3BRW_L_ __MSP430_USCI3_BASE__ + 0x26  
sfrb(UCB3BRW_L, UCB3BRW_L_);
#define UCB3BRW_H_ __MSP430_USCI3_BASE__ + 0x27  
sfrb(UCB3BRW_H, UCB3BRW_H_);
#define UCB3BR0                UCB3BRW_L      /* USCI B3 Baud Rate 0 */
#define UCB3BR1                UCB3BRW_H      /* USCI B3 Baud Rate 1 */
#define UCB3STAT_ __MSP430_USCI3_BASE__ + 0x2a  /* USCI B3 Status Register */
sfrb(UCB3STAT, UCB3STAT_);
#define UCB3RXBUF_ __MSP430_USCI3_BASE__ + 0x2c  /* USCI B3 Receive Buffer */
sfrb(UCB3RXBUF, UCB3RXBUF_);
#define UCB3TXBUF_ __MSP430_USCI3_BASE__ + 0x2e  /* USCI B3 Transmit Buffer */
sfrb(UCB3TXBUF, UCB3TXBUF_);
#define UCB3I2COA_ __MSP430_USCI3_BASE__ + 0x30  /* USCI B3 I2C Own Address */
sfrw(UCB3I2COA, UCB3I2COA_);
#define UCB3I2COA_L_ __MSP430_USCI3_BASE__ + 0x30  
sfrb(UCB3I2COA_L, UCB3I2COA_L_);
#define UCB3I2COA_H_ __MSP430_USCI3_BASE__ + 0x31  
sfrb(UCB3I2COA_H, UCB3I2COA_H_);
#define UCB3I2CSA_ __MSP430_USCI3_BASE__ + 0x32  /* USCI B3 I2C Slave Address */
sfrw(UCB3I2CSA, UCB3I2CSA_);
#define UCB3I2CSA_L_ __MSP430_USCI3_BASE__ + 0x32  
sfrb(UCB3I2CSA_L, UCB3I2CSA_L_);
#define UCB3I2CSA_H_ __MSP430_USCI3_BASE__ + 0x33  
sfrb(UCB3I2CSA_H, UCB3I2CSA_H_);
#define UCB3ICTL_ __MSP430_USCI3_BASE__ + 0x3c  /* USCI B3 Interrupt Enable Register */
sfrw(UCB3ICTL, UCB3ICTL_);
#define UCB3ICTL_L_ __MSP430_USCI3_BASE__ + 0x3c  
sfrb(UCB3ICTL_L, UCB3ICTL_L_);
#define UCB3ICTL_H_ __MSP430_USCI3_BASE__ + 0x3d  
sfrb(UCB3ICTL_H, UCB3ICTL_H_);
#define UCB3IE                 UCB3ICTL_L     /* USCI B3 Interrupt Enable Register */
#define UCB3IFG                UCB3ICTL_H     /* USCI B3 Interrupt Flags Register */
#define UCB3IV_ __MSP430_USCI3_BASE__ + 0x3e  /* USCI B3 Interrupt Vector Register */
sfrw(UCB3IV, UCB3IV_);
#endif // __MSP430_HAS_USCI_B3__

#endif // __MSP430_USCI3_BASE__

#endif /* __MSP430_HEADERS_USCI_5XX_H__ */

