/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.memory;

import java.text.NumberFormat;
import java.util.Locale;
import org.netbeans.lib.profiler.ProfilerClient;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.results.ExportDataDumper;
import org.netbeans.lib.profiler.results.memory.LivenessMemoryResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.PresoObjAllocCCTNode;
import org.netbeans.lib.profiler.results.memory.RuntimeMemoryCCTNode;
import org.netbeans.lib.profiler.results.memory.RuntimeObjLivenessTermCCTNode;
import org.netbeans.lib.profiler.results.memory.SurvGenSet;

public class PresoObjLivenessCCTNode
extends PresoObjAllocCCTNode {
    static int currentEpoch;
    public static final int SORT_BY_LIVE_OBJ_SIZE = 1;
    public static final int SORT_BY_LIVE_OBJ_NUMBER = 2;
    public static final int SORT_BY_ALLOC_OBJ = 3;
    public static final int SORT_BY_AVG_AGE = 4;
    public static final int SORT_BY_SURV_GEN = 5;
    public static final int SORT_BY_NAME = 6;
    public static final int SORT_BY_TOTAL_ALLOC_OBJ = 7;
    private static boolean dontShowZeroLiveObjNodes;
    public static NumberFormat decimalFormat;
    public float avgObjectAge;
    public int nLiveObjects;
    public int survGen;

    protected PresoObjLivenessCCTNode(RuntimeMemoryCCTNode rtNode) {
        super(rtNode);
    }

    public static PresoObjAllocCCTNode createPresentationCCTFromSnapshot(LivenessMemoryResultsSnapshot snapshot, RuntimeMemoryCCTNode rootRuntimeNode, String classTypeName, int curEpoch, boolean dontShowZeroLiveObjAllocPaths) {
        currentEpoch = curEpoch;
        dontShowZeroLiveObjNodes = dontShowZeroLiveObjAllocPaths;
        SurvGenSet survGens = new SurvGenSet();
        PresoObjAllocCCTNode rootNode = PresoObjLivenessCCTNode.generateMirrorNode(rootRuntimeNode, survGens);
        if (rootNode != null) {
            PresoObjLivenessCCTNode.assignNamesToNodesFromSnapshot(snapshot, rootNode, classTypeName);
        }
        return rootNode;
    }

    public static PresoObjAllocCCTNode createPresentationCCTFromVM(ProfilerClient profilerClient, RuntimeMemoryCCTNode rootRuntimeNode, String classTypeName, int curEpoch, boolean dontShowZeroLiveObjAllocPaths) throws ClientUtils.TargetAppOrVMTerminated {
        currentEpoch = curEpoch;
        dontShowZeroLiveObjNodes = dontShowZeroLiveObjAllocPaths;
        SurvGenSet survGens = new SurvGenSet();
        PresoObjAllocCCTNode rootNode = PresoObjLivenessCCTNode.generateMirrorNode(rootRuntimeNode, survGens);
        if (rootNode != null) {
            PresoObjLivenessCCTNode.assignNamesToNodesFromVM(profilerClient, rootNode, classTypeName);
        }
        return rootNode;
    }

    @Override
    public void sortChildren(int sortBy, boolean sortOrder) {
        int nChildren = this.getNChildren();
        if (nChildren == 0) {
            return;
        }
        for (int i = 0; i < nChildren; ++i) {
            this.children[i].sortChildren(sortBy, sortOrder);
        }
        if (nChildren > 1) {
            switch (sortBy) {
                case 1: {
                    this.sortChildrenByLiveObjSize(sortOrder);
                    break;
                }
                case 2: {
                    this.sortChildrenByLiveObjNumber(sortOrder);
                    break;
                }
                case 3: {
                    this.sortChildrenByAllocObjNumber(sortOrder);
                    break;
                }
                case 4: {
                    this.sortChildrenByAvgAge(sortOrder);
                    break;
                }
                case 5: {
                    this.sortChildrenBySurvGen(sortOrder);
                    break;
                }
                case 6: {
                    this.sortChildrenByName(sortOrder);
                }
            }
        }
    }

    protected static PresoObjAllocCCTNode generateMirrorNode(RuntimeMemoryCCTNode rtNode, SurvGenSet survGens) {
        RuntimeMemoryCCTNode[] ar;
        int nChildren;
        Object nodeChildren;
        PresoObjLivenessCCTNode thisNode = null;
        if (rtNode instanceof RuntimeObjLivenessTermCCTNode) {
            RuntimeObjLivenessTermCCTNode rtTermNode = (RuntimeObjLivenessTermCCTNode)rtNode;
            int nLiveObjects = rtTermNode.calculateTotalNLiveObjects();
            if (dontShowZeroLiveObjNodes && nLiveObjects == 0 && rtNode.children == null) {
                return null;
            }
            thisNode = new PresoObjLivenessCCTNode(rtNode);
            thisNode.nLiveObjects = nLiveObjects;
            RuntimeObjLivenessTermCCTNode.calculateTotalNumberOfSurvGens(rtTermNode, survGens);
            thisNode.survGen = survGens.getTotalNoOfAges();
            thisNode.avgObjectAge = RuntimeObjLivenessTermCCTNode.calculateAvgObjectAgeForAllPaths(rtTermNode, currentEpoch);
            if (rtNode.children != null) {
                int len = rtNode.children instanceof RuntimeMemoryCCTNode ? 1 : ((RuntimeMemoryCCTNode[])rtNode.children).length;
                thisNode.children = new PresoObjAllocCCTNode[len];
            }
        }
        if ((nodeChildren = rtNode.children) != null && (nChildren = (ar = nodeChildren instanceof RuntimeMemoryCCTNode ? new RuntimeMemoryCCTNode[]{(RuntimeMemoryCCTNode)nodeChildren} : (RuntimeMemoryCCTNode[])nodeChildren).length) > 0) {
            double avgAge = 0.0;
            int childIdx = 0;
            for (int i = 0; i < nChildren; ++i) {
                SurvGenSet subNodeSurvGens = nChildren == 1 ? survGens : new SurvGenSet();
                PresoObjLivenessCCTNode child = (PresoObjLivenessCCTNode)PresoObjLivenessCCTNode.generateMirrorNode(ar[i], subNodeSurvGens);
                if (child == null) continue;
                if (thisNode == null) {
                    thisNode = new PresoObjLivenessCCTNode(rtNode);
                    thisNode.children = new PresoObjAllocCCTNode[nChildren];
                }
                thisNode.children[childIdx++] = child;
                child.parent = thisNode;
                thisNode.nCalls += child.nCalls;
                thisNode.totalObjSize += child.totalObjSize;
                thisNode.nLiveObjects += child.nLiveObjects;
                avgAge += (double)(child.avgObjectAge * (float)child.nLiveObjects);
                if (nChildren <= 1) continue;
                survGens.mergeWith(subNodeSurvGens);
            }
            if (dontShowZeroLiveObjNodes && (thisNode == null || thisNode.nLiveObjects == 0)) {
                return null;
            }
            if (childIdx < nChildren) {
                PresoObjAllocCCTNode[] newChildren = new PresoObjAllocCCTNode[childIdx];
                System.arraycopy(thisNode.children, 0, newChildren, 0, childIdx);
                thisNode.children = newChildren;
            }
            thisNode.avgObjectAge = thisNode.nLiveObjects > 0 ? (float)(avgAge / (double)thisNode.nLiveObjects) : 0.0f;
            thisNode.survGen = survGens.getTotalNoOfAges();
        }
        return thisNode;
    }

    protected void sortChildrenByAvgAge(boolean sortOrder) {
        int len = this.children.length;
        float[] values = new float[len];
        for (int i = 0; i < len; ++i) {
            values[i] = ((PresoObjLivenessCCTNode)this.children[i]).avgObjectAge;
        }
        this.sortFloats(values, sortOrder);
    }

    protected void sortChildrenByLiveObjNumber(boolean sortOrder) {
        int len = this.children.length;
        int[] values = new int[len];
        for (int i = 0; i < len; ++i) {
            values[i] = ((PresoObjLivenessCCTNode)this.children[i]).nLiveObjects;
        }
        this.sortInts(values, sortOrder);
    }

    protected void sortChildrenByLiveObjSize(boolean sortOrder) {
        this.sortChildrenByAllocObjSize(sortOrder);
    }

    protected void sortChildrenBySurvGen(boolean sortOrder) {
        int len = this.children.length;
        int[] values = new int[len];
        for (int i = 0; i < len; ++i) {
            values[i] = ((PresoObjLivenessCCTNode)this.children[i]).survGen;
        }
        this.sortInts(values, sortOrder);
    }

    @Override
    public void exportXMLData(ExportDataDumper eDD, String indent) {
        String newline = System.getProperty("line.separator");
        StringBuffer result = new StringBuffer(indent + "<Node>" + newline);
        result.append(indent + " <Name>" + this.replaceHTMLCharacters(this.getNodeName()) + "<Name>" + newline);
        result.append(indent + " <Parent>" + this.replaceHTMLCharacters(this.getParent() == null ? "none" : ((PresoObjAllocCCTNode)this.getParent()).getNodeName()) + "<Parent>" + newline);
        result.append(indent + " <Live_Bytes>" + this.totalObjSize + "</Live_Bytes>" + newline);
        result.append(indent + " <Live_Objects>" + this.nLiveObjects + "</Live_Objects>" + newline);
        result.append(indent + " <Allocated_Objects>" + this.nCalls + "</Allocated_Objects>" + newline);
        result.append(indent + " <Avg_Age>" + this.avgObjectAge + "</Avg_Age>" + newline);
        result.append(indent + " <Generations>" + this.survGen + "</Generations>" + newline);
        eDD.dumpData(result);
        if (this.children != null) {
            for (int i = 0; i < this.getNChildren(); ++i) {
                this.children[i].exportXMLData(eDD, indent + " ");
            }
        }
        result = new StringBuffer(indent + "</Node>");
        eDD.dumpData(result);
    }

    @Override
    public void exportHTMLData(ExportDataDumper eDD, int depth) {
        int i;
        StringBuffer result = new StringBuffer("<tr><td class=\"method\"><pre class=\"method\">");
        for (i = 0; i < depth; ++i) {
            result.append(".");
        }
        result.append(this.replaceHTMLCharacters(this.getNodeName()) + "</pre></td><td class=\"right\">" + this.totalObjSize + "</td><td class=\"right\">" + this.nLiveObjects + "</td><td class=\"right\">" + this.nCalls + "</td><td class=\"right\">" + this.avgObjectAge + "</td><td class=\"right\">" + this.survGen + "</td><td class=\"parent\"><pre class=\"parent\">" + this.replaceHTMLCharacters(this.getParent() == null ? "none" : ((PresoObjAllocCCTNode)this.getParent()).getNodeName()) + "</pre></td></tr>");
        eDD.dumpData(result);
        if (this.children != null) {
            for (i = 0; i < this.children.length; ++i) {
                this.children[i].exportHTMLData(eDD, depth + 1);
            }
        }
    }

    private String replaceHTMLCharacters(String s) {
        StringBuffer sb = new StringBuffer();
        int len = s.length();
        block6: for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '<': {
                    sb.append("&lt;");
                    continue block6;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block6;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block6;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    @Override
    public void exportCSVData(String separator, int depth, ExportDataDumper eDD) {
        int i;
        StringBuffer result = new StringBuffer();
        String newLine = "\r\n";
        String quote = "\"";
        String indent = " ";
        result.append(quote);
        for (i = 0; i < depth; ++i) {
            result.append(indent);
        }
        result.append((this.nodeName == null ? this.className : this.nodeName) + quote + separator);
        result.append(quote + this.totalObjSize + quote + separator);
        result.append(quote + this.nLiveObjects + quote + separator);
        result.append(quote + this.nCalls + quote + separator);
        result.append(quote + decimalFormat.format(this.avgObjectAge) + quote + separator);
        result.append(quote + this.survGen + quote + separator);
        result.append(quote + (this.getParent() == null ? "none" : ((PresoObjAllocCCTNode)this.getParent()).getNodeName()) + newLine);
        eDD.dumpData(result);
        if (this.children != null) {
            for (i = 0; i < this.children.length; ++i) {
                ((PresoObjLivenessCCTNode)this.children[i]).exportCSVData(separator, depth + 1, eDD);
            }
        }
    }

    public void setDecimalFormat() {
        decimalFormat.setMinimumFractionDigits(3);
        decimalFormat.setMaximumFractionDigits(3);
    }

    static {
        decimalFormat = NumberFormat.getInstance(Locale.ENGLISH);
    }
}

