/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.bookmarks;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.lib.editor.bookmarks.api.Bookmark;
import org.netbeans.lib.editor.bookmarks.api.BookmarkList;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.text.NbDocument;
import org.openide.util.Mutex;
import org.openide.util.RequestProcessor;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class BookmarksPersistence {
    private static final String EDITOR_BOOKMARKS_NAMESPACE_URI = "http://www.netbeans.org/ns/editor-bookmarks/1";
    private static final Map<Project, URLToBookmarks> projectToBookmarks = new WeakHashMap<Project, URLToBookmarks>();
    private static ProjectsListener projectsListener;

    public static void init() {
        projectsListener = new ProjectsListener();
    }

    public static void destroy() {
        if (projectsListener != null) {
            projectsListener.destroy();
        }
        ArrayList<Project> projects = new ArrayList<Project>(projectToBookmarks.keySet());
        for (Project project : projects) {
            BookmarksPersistence.saveBookmarks(project);
        }
    }

    public static synchronized void loadBookmarks(BookmarkList bookmarkList) {
        Document document = bookmarkList.getDocument();
        FileObject fo = NbEditorUtilities.getFileObject((Document)document);
        if (fo == null) {
            return;
        }
        Project project = FileOwnerQuery.getOwner((FileObject)fo);
        if (project == null) {
            return;
        }
        URLToBookmarks urlToBookmarks = projectToBookmarks.get(project);
        if (urlToBookmarks == null && (urlToBookmarks = BookmarksPersistence.loadBookmarks(project)) != null) {
            projectToBookmarks.put(project, urlToBookmarks);
        }
        if (urlToBookmarks == null) {
            return;
        }
        try {
            URL url = fo.getURL();
            int[] lines = (int[])urlToBookmarks.get(url);
            if (lines != null) {
                for (int lineNumber : lines) {
                    try {
                        int offset = NbDocument.findLineOffset((StyledDocument)((StyledDocument)document), (int)lineNumber);
                        bookmarkList.addBookmark(offset);
                    }
                    catch (IndexOutOfBoundsException ex) {
                        // empty catch block
                    }
                }
            }
        }
        catch (FileStateInvalidException e) {
            // empty catch block
        }
    }

    private static URLToBookmarks loadBookmarks(final Project project) {
        return (URLToBookmarks)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<URLToBookmarks>(){

            public URLToBookmarks run() {
                AuxiliaryConfiguration ac = ProjectUtils.getAuxiliaryConfiguration((Project)project);
                Element bookmarksElement = ac.getConfigurationFragment("editor-bookmarks", BookmarksPersistence.EDITOR_BOOKMARKS_NAMESPACE_URI, false);
                if (bookmarksElement == null) {
                    return null;
                }
                try {
                    URLToBookmarks urlToBookmarks = new URLToBookmarks();
                    URL projectFolderURL = project.getProjectDirectory().getURL();
                    Node fileElem = BookmarksPersistence.skipNonElementNode(bookmarksElement.getFirstChild());
                    while (fileElem != null) {
                        assert ("file".equals(fileElem.getNodeName()));
                        Node urlElem = BookmarksPersistence.skipNonElementNode(fileElem.getFirstChild());
                        assert ("url".equals(urlElem.getNodeName()));
                        Node lineElem = BookmarksPersistence.skipNonElementNode(urlElem.getNextSibling());
                        int[] lineIndexesArray = new int[1];
                        int lineCount = 0;
                        while (lineElem != null) {
                            assert ("line".equals(lineElem.getNodeName()));
                            if (lineCount == lineIndexesArray.length) {
                                lineIndexesArray = BookmarksPersistence.reallocateIntArray(lineIndexesArray, lineCount, lineCount << 1);
                            }
                            try {
                                Node lineElemText = lineElem.getFirstChild();
                                String lineNumberString = lineElemText.getNodeValue();
                                int lineNumber = Integer.parseInt(lineNumberString);
                                lineIndexesArray[lineCount++] = lineNumber;
                            }
                            catch (DOMException e) {
                                ErrorManager.getDefault().notify((Throwable)e);
                            }
                            catch (NumberFormatException e) {
                                ErrorManager.getDefault().notify((Throwable)e);
                            }
                            lineElem = BookmarksPersistence.skipNonElementNode(lineElem.getNextSibling());
                        }
                        try {
                            URL url;
                            try {
                                Node urlElemText = urlElem.getFirstChild();
                                String relOrAbsURLString = urlElemText.getNodeValue();
                                URI uri = new URI(relOrAbsURLString);
                                url = !uri.isAbsolute() && projectFolderURL != null ? new URL(projectFolderURL, relOrAbsURLString) : new URL(relOrAbsURLString);
                            }
                            catch (URISyntaxException e) {
                                ErrorManager.getDefault().notify((Throwable)e);
                                url = null;
                            }
                            catch (MalformedURLException e) {
                                ErrorManager.getDefault().notify((Throwable)e);
                                url = null;
                            }
                            if (url != null) {
                                if (lineCount != lineIndexesArray.length) {
                                    lineIndexesArray = BookmarksPersistence.reallocateIntArray(lineIndexesArray, lineCount, lineCount);
                                }
                                urlToBookmarks.put(url, lineIndexesArray);
                            }
                        }
                        catch (DOMException e) {
                            ErrorManager.getDefault().notify((Throwable)e);
                        }
                        fileElem = BookmarksPersistence.skipNonElementNode(fileElem.getNextSibling());
                    }
                    return urlToBookmarks;
                }
                catch (FileStateInvalidException e) {
                    return null;
                }
            }
        });
    }

    private static Node skipNonElementNode(Node node) {
        while (node != null && node.getNodeType() != 1) {
            node = node.getNextSibling();
        }
        return node;
    }

    private static int[] reallocateIntArray(int[] intArray, int count, int newLength) {
        int[] newIntArray = new int[newLength];
        System.arraycopy(intArray, 0, newIntArray, 0, count);
        return newIntArray;
    }

    public static synchronized void saveBookmarks(BookmarkList bookmarkList) {
        Document document = bookmarkList.getDocument();
        FileObject fileObject = NbEditorUtilities.getFileObject((Document)document);
        if (fileObject == null) {
            return;
        }
        ArrayList<Bookmark> bookmarks = new ArrayList<Bookmark>(bookmarkList.getBookmarks());
        int[] lineNumbers = new int[bookmarks.size()];
        for (int i = 0; i < bookmarks.size(); ++i) {
            Bookmark bookmark = (Bookmark)bookmarks.get(i);
            lineNumbers[i] = bookmark.getLineNumber();
        }
        try {
            URL url = fileObject.getURL();
            Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
            URLToBookmarks urlToBookmarks = projectToBookmarks.get(project);
            if (urlToBookmarks == null) {
                urlToBookmarks = new URLToBookmarks();
                projectToBookmarks.put(project, urlToBookmarks);
            }
            urlToBookmarks.put(url, lineNumbers);
        }
        catch (FileStateInvalidException e) {
            // empty catch block
        }
    }

    private static void saveBookmarks(Project project) {
        URI baseURI;
        if (!ProjectManager.getDefault().isValid(project)) {
            return;
        }
        AuxiliaryConfiguration auxiliaryConfiguration = ProjectUtils.getAuxiliaryConfiguration((Project)project);
        try {
            baseURI = new URI(project.getProjectDirectory().getURL().toExternalForm());
        }
        catch (FileStateInvalidException e) {
            baseURI = null;
        }
        catch (URISyntaxException e) {
            baseURI = null;
        }
        URLToBookmarks urlToBookmarks = projectToBookmarks.get(project);
        if (urlToBookmarks == null) {
            return;
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            org.w3c.dom.Document document = builder.newDocument();
            Element bookmarksElement = document.createElementNS(EDITOR_BOOKMARKS_NAMESPACE_URI, "editor-bookmarks");
            for (URL url : urlToBookmarks.keySet()) {
                int[] lineNumbers;
                if (((int[])urlToBookmarks.get(url)).length == 0) continue;
                Element fileElement = document.createElementNS(EDITOR_BOOKMARKS_NAMESPACE_URI, "file");
                Element urlElement = document.createElementNS(EDITOR_BOOKMARKS_NAMESPACE_URI, "url");
                String url2 = url.toExternalForm();
                if (baseURI != null) {
                    try {
                        URI absoluteURI = new URI(url2);
                        URI relativeURI = baseURI.relativize(absoluteURI);
                        url2 = relativeURI.toString();
                    }
                    catch (URISyntaxException e) {
                        ErrorManager.getDefault().notify((Throwable)e);
                    }
                }
                urlElement.appendChild(document.createTextNode(url2));
                fileElement.appendChild(urlElement);
                for (int lineNumber : lineNumbers = (int[])urlToBookmarks.get(url)) {
                    Element lineElem = document.createElementNS(EDITOR_BOOKMARKS_NAMESPACE_URI, "line");
                    lineElem.appendChild(document.createTextNode(Integer.toString(lineNumber)));
                    fileElement.appendChild(lineElem);
                }
                bookmarksElement.appendChild(fileElement);
            }
            auxiliaryConfiguration.putConfigurationFragment(bookmarksElement, false);
        }
        catch (ParserConfigurationException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
    }

    private static class ProjectsListener
    implements PropertyChangeListener,
    Runnable {
        private static List<Project> lastOpenProjects;
        private static RequestProcessor RP;

        public ProjectsListener() {
            OpenProjects openProjects = OpenProjects.getDefault();
            lastOpenProjects = new ArrayList<Project>(Arrays.asList(openProjects.getOpenProjects()));
            openProjects.addPropertyChangeListener((PropertyChangeListener)this);
        }

        @Override
        public void run() {
            ProjectManager.mutex().writeAccess(new Runnable(){

                @Override
                public void run() {
                    List<Project> openProjects = Arrays.asList(OpenProjects.getDefault().getOpenProjects());
                    lastOpenProjects.removeAll(openProjects);
                    Iterator it = lastOpenProjects.iterator();
                    while (it.hasNext()) {
                        BookmarksPersistence.saveBookmarks((Project)it.next());
                    }
                    lastOpenProjects = new ArrayList<Project>(openProjects);
                }
            });
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            RP.post((Runnable)this);
        }

        void destroy() {
            OpenProjects.getDefault().removePropertyChangeListener((PropertyChangeListener)this);
        }

        static {
            RP = new RequestProcessor("Bookmarks saver");
        }
    }

    private static class URLToBookmarks
    extends HashMap<URL, int[]> {
        private URLToBookmarks() {
        }
    }
}

