/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.newtable;

import java.awt.Color;
import org.xhtmlrenderer.css.constants.IdentValue;
import org.xhtmlrenderer.css.style.derived.BorderPropertySet;

public class CollapsedBorderValue {
    public static final CollapsedBorderValue NO_BORDER = new CollapsedBorderValue();
    private IdentValue _style;
    private int _width;
    private Color _color;
    private int _precedence;

    public CollapsedBorderValue(IdentValue style, int width, Color color, int precedence) {
        this._style = style;
        this._width = width;
        this._color = color;
        this._precedence = precedence;
    }

    private CollapsedBorderValue() {
        this._style = IdentValue.NONE;
    }

    public Color color() {
        return this._color;
    }

    public void setColor(Color color) {
        this._color = color;
    }

    public IdentValue style() {
        return this._style;
    }

    public void setStyle(IdentValue style) {
        this._style = style;
    }

    public int width() {
        return this._width;
    }

    public void setWidth(int width) {
        this._width = width;
    }

    public int precedence() {
        return this._precedence;
    }

    public void setPrecedence(int precedence) {
        this._precedence = precedence;
    }

    public boolean exists() {
        return this._style != null && this._style != IdentValue.NONE;
    }

    public static CollapsedBorderValue borderLeft(BorderPropertySet border, int precedence) {
        return new CollapsedBorderValue(border.leftStyle(), (int)border.left(), border.leftColor(), precedence);
    }

    public static CollapsedBorderValue borderRight(BorderPropertySet border, int precedence) {
        return new CollapsedBorderValue(border.rightStyle(), (int)border.right(), border.rightColor(), precedence);
    }

    public static CollapsedBorderValue borderTop(BorderPropertySet border, int precedence) {
        return new CollapsedBorderValue(border.topStyle(), (int)border.top(), border.topColor(), precedence);
    }

    public static CollapsedBorderValue borderBottom(BorderPropertySet border, int precedence) {
        return new CollapsedBorderValue(border.bottomStyle(), (int)border.bottom(), border.bottomColor(), precedence);
    }
}

