/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.attach.panels;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import org.netbeans.modules.profiler.attach.panels.AttachSettingsPanel;
import org.netbeans.modules.profiler.attach.panels.components.ButtonGroupEx;
import org.netbeans.modules.profiler.attach.panels.components.ResizableHintPanel;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class AttachSettingsPanelUI
extends JPanel {
    private final String SELECT_GROUP_TITLE = NbBundle.getMessage(this.getClass(), (String)"AttachWizard_SelectTargetTypeForceString");
    private final String SELECT_TARGET_TITLE = NbBundle.getMessage(this.getClass(), (String)"AttachWizard_SelectTargetForceString");
    private JPanel blankPanel;
    private JRadioButton buttonDirect;
    private JRadioButton buttonDynamic16;
    private JRadioButton buttonLocal;
    private JRadioButton buttonRemote;
    private JComboBox comboGroups;
    private JComboBox comboTargets;
    private ButtonGroupEx groupInvocation;
    private ButtonGroupEx groupMethod;
    private ResizableHintPanel hintPanel;
    private JPanel jPanel1;
    private JLabel labelTargetName;
    private JLabel labelTargetType;
    private JPanel panelDetails;
    private JPanel panelInvocation;
    private JPanel panelMethod;
    private JPanel panelType;
    private AttachSettingsPanel.PanelModel model;

    public AttachSettingsPanelUI(AttachSettingsPanel.PanelModel model) {
        this.model = model;
        this.initComponents();
        this.loadModel();
    }

    private void initComponents() {
        this.groupMethod = new ButtonGroupEx();
        this.groupInvocation = new ButtonGroupEx();
        this.panelType = new JPanel();
        this.labelTargetType = new JLabel();
        this.comboGroups = new JComboBox();
        this.labelTargetName = new JLabel();
        this.comboTargets = new JComboBox();
        this.panelDetails = new JPanel();
        this.panelMethod = new JPanel();
        this.buttonLocal = new JRadioButton();
        this.buttonRemote = new JRadioButton();
        this.blankPanel = new JPanel();
        this.panelInvocation = new JPanel();
        this.buttonDirect = new JRadioButton();
        this.buttonDynamic16 = new JRadioButton();
        this.hintPanel = new ResizableHintPanel();
        this.jPanel1 = new JPanel();
        this.setMaximumSize(new Dimension(800, 600));
        this.setMinimumSize(new Dimension(400, 300));
        this.setPreferredSize(new Dimension(500, 400));
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/profiler/attach/panels/Bundle");
        this.panelType.setBorder(BorderFactory.createTitledBorder(null, bundle.getString("TargetTypeWizardPanelUI_SelectAttachTargetString"), 0, 0, UIManager.getFont("TitledBorder.font").deriveFont(1)));
        this.labelTargetType.setLabelFor(this.comboGroups);
        Mnemonics.setLocalizedText((JLabel)this.labelTargetType, (String)bundle.getString("TargetTypeWizardPanelUI_TargetTypeString"));
        this.comboGroups.setModel(this.getGroupsModel());
        this.comboGroups.setMaximumSize(new Dimension(130, 24));
        this.comboGroups.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttachSettingsPanelUI.this.comboGroupsActionPerformed(evt);
            }
        });
        this.labelTargetName.setLabelFor(this.comboTargets);
        Mnemonics.setLocalizedText((JLabel)this.labelTargetName, (String)bundle.getString("TargetTypeWizardPanelUI_TargetNameTypeString"));
        this.comboTargets.setModel(this.getTargetsModel(true));
        this.comboTargets.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttachSettingsPanelUI.this.comboTargetsActionPerformed(evt);
            }
        });
        GroupLayout panelTypeLayout = new GroupLayout(this.panelType);
        this.panelType.setLayout(panelTypeLayout);
        panelTypeLayout.setHorizontalGroup(panelTypeLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelTypeLayout.createSequentialGroup().addContainerGap().addGroup(panelTypeLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelTypeLayout.createSequentialGroup().addComponent(this.labelTargetType).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 362, -2)).addComponent(this.comboGroups, 0, 436, Short.MAX_VALUE).addComponent(this.comboTargets, 0, 436, Short.MAX_VALUE).addComponent(this.labelTargetName)).addContainerGap()));
        panelTypeLayout.setVerticalGroup(panelTypeLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelTypeLayout.createSequentialGroup().addContainerGap().addComponent(this.labelTargetType).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboGroups, -2, -1, -2).addGap(14, 14, 14).addComponent(this.labelTargetName).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboTargets, -2, -1, -2).addContainerGap(20, Short.MAX_VALUE)));
        this.comboGroups.getAccessibleContext().setAccessibleName(NbBundle.getMessage(AttachSettingsPanelUI.class, (String)"AttachSettingsPanelUI.comboGroups.AccessibleContext.accessibleName"));
        this.comboGroups.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AttachSettingsPanelUI.class, (String)"AttachSettingsPanelUI.comboGroups.AccessibleContext.accessibleDescription"));
        this.comboTargets.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AttachSettingsPanelUI.class, (String)"AttachSettingsPanelUI.comboTargets.AccessibleContext.accessibleDescription"));
        this.panelDetails.setLayout(new BoxLayout(this.panelDetails, 2));
        this.panelMethod.setBorder(BorderFactory.createTitledBorder(null, bundle.getString("AttachWizard_AttachMethodString"), 0, 0, UIManager.getFont("TitledBorder.font").deriveFont(1)));
        this.groupMethod.add(this.buttonLocal);
        this.buttonLocal.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.buttonLocal, (String)bundle.getString("TargetSettingsWizardPanelUI_LocalRadioName"));
        this.buttonLocal.setToolTipText(bundle.getString("TargetSettingsWizardPanelUI_LocalRadioAccessDescr"));
        this.buttonLocal.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.buttonLocal.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttachSettingsPanelUI.this.buttonLocalActionPerformed(evt);
            }
        });
        this.groupMethod.add(this.buttonRemote);
        Mnemonics.setLocalizedText((AbstractButton)this.buttonRemote, (String)bundle.getString("TargetSettingsWizardPanelUI_RemoteRadioName"));
        this.buttonRemote.setToolTipText(bundle.getString("TargetSettingsWizardPanelUI_RemoteRadioAccessDescr"));
        this.buttonRemote.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.buttonRemote.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttachSettingsPanelUI.this.buttonRemoteActionPerformed(evt);
            }
        });
        GroupLayout panelMethodLayout = new GroupLayout(this.panelMethod);
        this.panelMethod.setLayout(panelMethodLayout);
        panelMethodLayout.setHorizontalGroup(panelMethodLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelMethodLayout.createSequentialGroup().addContainerGap().addGroup(panelMethodLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.buttonLocal).addComponent(this.buttonRemote)).addContainerGap(62, Short.MAX_VALUE)));
        panelMethodLayout.setVerticalGroup(panelMethodLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelMethodLayout.createSequentialGroup().addContainerGap().addComponent(this.buttonLocal).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonRemote).addGap(0, 9, Short.MAX_VALUE)));
        this.panelDetails.add(this.panelMethod);
        this.blankPanel.setMaximumSize(new Dimension(80, 10));
        this.blankPanel.setMinimumSize(new Dimension(20, 10));
        this.blankPanel.setPreferredSize(new Dimension(20, 10));
        GroupLayout blankPanelLayout = new GroupLayout(this.blankPanel);
        this.blankPanel.setLayout(blankPanelLayout);
        blankPanelLayout.setHorizontalGroup(blankPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 20, Short.MAX_VALUE));
        blankPanelLayout.setVerticalGroup(blankPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 10, Short.MAX_VALUE));
        this.panelDetails.add(this.blankPanel);
        this.panelInvocation.setBorder(BorderFactory.createTitledBorder(null, bundle.getString("AttachWizard_AttachInvocationString"), 0, 0, UIManager.getFont("TitledBorder.font").deriveFont(1)));
        this.groupInvocation.add(this.buttonDirect);
        this.buttonDirect.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.buttonDirect, (String)bundle.getString("TargetSettingsWizardPanelUI_DirectRadioName"));
        this.buttonDirect.setToolTipText(bundle.getString("TargetSettingsWizardPanelUI_DirectRadioAccessDescr"));
        this.buttonDirect.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.buttonDirect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttachSettingsPanelUI.this.buttonDirectActionPerformed(evt);
            }
        });
        this.groupInvocation.add(this.buttonDynamic16);
        Mnemonics.setLocalizedText((AbstractButton)this.buttonDynamic16, (String)NbBundle.getMessage(AttachSettingsPanelUI.class, (String)"TargetSettingsWizardPanelUI_Dynamic16RadioName"));
        this.buttonDynamic16.setToolTipText(NbBundle.getMessage(AttachSettingsPanelUI.class, (String)"AttachSettingsPanelUI.buttonDynamic16.toolTipText"));
        this.buttonDynamic16.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.buttonDynamic16.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttachSettingsPanelUI.this.buttonDynamic16ActionPerformed(evt);
            }
        });
        GroupLayout panelInvocationLayout = new GroupLayout(this.panelInvocation);
        this.panelInvocation.setLayout(panelInvocationLayout);
        panelInvocationLayout.setHorizontalGroup(panelInvocationLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelInvocationLayout.createSequentialGroup().addContainerGap().addGroup(panelInvocationLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.buttonDirect).addComponent(this.buttonDynamic16)).addContainerGap(62, Short.MAX_VALUE)));
        panelInvocationLayout.setVerticalGroup(panelInvocationLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelInvocationLayout.createSequentialGroup().addContainerGap().addComponent(this.buttonDirect).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonDynamic16).addContainerGap(-1, Short.MAX_VALUE)));
        this.panelDetails.add(this.panelInvocation);
        this.hintPanel.setMaximumSize(new Dimension(500, 150));
        this.hintPanel.setMinimumSize(new Dimension(0, 0));
        this.hintPanel.setPreferredSize(new Dimension(500, 80));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 468, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.panelType, -1, -1, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(13, 13, 13).addComponent(this.panelDetails, -1, 475, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE))).addGap(12, 12, 12)).addComponent(this.hintPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.panelType, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.panelDetails, -2, 99, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.hintPanel, -1, 97, Short.MAX_VALUE)));
        this.hintPanel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(AttachSettingsPanelUI.class, (String)"AttachSettingsPanelUI.hintPanel.AccessibleContext.accessibleName"));
    }

    private void buttonDynamic16ActionPerformed(ActionEvent evt) {
        this.model.setDynamicAttach16(this.buttonDynamic16.isEnabled());
        this.loadModel();
    }

    private void buttonDirectActionPerformed(ActionEvent evt) {
        this.model.setDirectAttach(this.buttonDirect.isEnabled());
        this.loadModel();
    }

    private void buttonRemoteActionPerformed(ActionEvent evt) {
        this.model.setRemote(this.buttonRemote.isEnabled());
        this.loadModel();
    }

    private void buttonLocalActionPerformed(ActionEvent evt) {
        this.model.setLocal(this.buttonLocal.isEnabled());
        this.loadModel();
    }

    private void comboTargetsActionPerformed(ActionEvent evt) {
        if (!((ForceSelectionComboBoxModel)this.comboTargets.getModel()).isSelectionMade()) {
            return;
        }
        this.model.setTarget((AttachSettingsPanel.Target)this.comboTargets.getSelectedItem());
        this.loadModel();
    }

    private void comboGroupsActionPerformed(ActionEvent evt) {
        if (!((ForceSelectionComboBoxModel)this.comboGroups.getModel()).isSelectionMade()) {
            return;
        }
        if (this.model.getTargetGroup() != null && this.comboGroups.getSelectedItem() != null && this.model.getTargetGroup().equals(this.comboGroups.getSelectedItem())) {
            return;
        }
        this.model.setTargetGroup((AttachSettingsPanel.TargetGroup)this.comboGroups.getSelectedItem());
        if (this.model.getTargetGroup().isSingular()) {
            this.comboTargets.setModel(this.getTargetsModel(false));
            this.comboTargets.getModel().setSelectedItem(this.model.getTargetGroup().getTargets()[0]);
            this.model.setTarget((AttachSettingsPanel.Target)this.comboTargets.getModel().getSelectedItem());
        } else {
            this.comboTargets.setModel(this.getTargetsModel(true));
            this.comboTargets.getModel().setSelectedItem(null);
            this.model.setTarget(null);
        }
        this.loadModel();
    }

    void init() {
        this.loadModel();
    }

    void applyCombos() {
        AttachSettingsPanel.Target selectedTarget = this.model.getTarget();
        this.comboTargets.setModel(this.getTargetsModel(true));
        this.comboGroups.setSelectedItem(this.model.getTargetGroup());
        this.comboTargets.setSelectedItem(selectedTarget);
    }

    void loadModel() {
        boolean invocationEnabled;
        AttachSettingsPanel.Target target = this.model.getTarget();
        if (this.model.getTargetGroup() != null && !this.model.getTargetGroup().isNull() && !this.model.getTargetGroup().isSingular()) {
            Mnemonics.setLocalizedText((JLabel)this.labelTargetName, (String)MessageFormat.format(NbBundle.getBundle(AttachSettingsPanel.class).getString("TargetTypeWizardPanelUI_TargetNameTypeString"), this.model.getTargetGroup().getName()));
            this.labelTargetName.setVisible(true);
            this.comboTargets.setVisible(true);
        } else {
            this.labelTargetName.setVisible(false);
            this.comboTargets.setVisible(false);
        }
        if (this.model.getTarget() == null) {
            this.panelDetails.setVisible(false);
            this.hintPanel.setVisible(false);
            return;
        }
        this.panelDetails.setVisible(true);
        this.hintPanel.setVisible(true);
        boolean remote = target.supportsRemoteProfiling() && this.model.isRemote();
        boolean local = target.supportsLocalProfiling() && this.model.isLocal() || !target.supportsRemoteProfiling();
        boolean directEnabled = target.supportsDirectAttach();
        boolean dynamicEnabled16 = target.supportsDynamicAttach() && this.model.isLocal() && this.isDynamicAttachSupported();
        boolean direct = directEnabled && this.model.isDirectAttach() || !dynamicEnabled16 && this.model.isDynamicAttach16();
        boolean dynamic16 = dynamicEnabled16 && this.model.isDynamicAttach16() && this.model.isLocal();
        this.buttonRemote.setSelected(remote);
        this.buttonLocal.setSelected(local);
        this.buttonRemote.setEnabled(target.supportsRemoteProfiling());
        this.buttonLocal.setEnabled(target.supportsLocalProfiling());
        this.buttonDynamic16.setEnabled(dynamicEnabled16);
        this.buttonDirect.setEnabled(directEnabled);
        boolean methodEnabled = this.buttonLocal.isEnabled() || this.buttonRemote.isEnabled();
        boolean bl = invocationEnabled = directEnabled || dynamicEnabled16;
        if (!methodEnabled) {
            this.groupMethod.clearSelection();
        }
        if (!invocationEnabled) {
            this.groupInvocation.clearSelection();
        } else {
            this.buttonDynamic16.setSelected(dynamic16);
            this.buttonDirect.setSelected(direct);
        }
        if (direct) {
            this.model.setDirectAttach(direct);
        }
        if (dynamic16) {
            this.model.setDynamicAttach16(dynamic16);
        }
        this.hintPanel.setHint(this.model.getHints());
    }

    public ComboBoxModel getGroupsModel() {
        return new ForceSelectionComboBoxModel(this.SELECT_GROUP_TITLE, this.model.getTargetGroups());
    }

    public ComboBoxModel getTargetsModel(boolean forcedModel) {
        if (forcedModel) {
            return new ForceSelectionComboBoxModel(this.SELECT_TARGET_TITLE, this.model.getTargetGroup() != null ? this.model.getTargetGroup().getTargets() : new Object[]{});
        }
        return new ForceSelectionComboBoxModel(this.model.getTargetGroup().getTargets());
    }

    private boolean isDynamicAttachSupported() {
        try {
            Class.forName("sun.jvmstat.monitor.MonitoredHost");
            Class.forName("com.sun.tools.attach.VirtualMachine");
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
        return true;
    }

    private class ForceSelectionComboBoxModel
    extends DefaultComboBoxModel {
        private String firstLine;
        private boolean internalChange;
        private Object selectedItem;

        public ForceSelectionComboBoxModel(Object[] options) {
            super(options);
            this.firstLine = "";
            this.internalChange = false;
        }

        public ForceSelectionComboBoxModel(String selectionText, Object[] options) {
            super(options);
            this.firstLine = "";
            this.internalChange = false;
            this.insertElementAt(selectionText, 0);
            this.firstLine = selectionText;
            this.selectedItem = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setSelectedItem(Object anObject) {
            if (this.internalChange) {
                return;
            }
            if (anObject == null || anObject.equals(this.firstLine)) {
                this.selectedItem = null;
                return;
            }
            if (this.getElementAt(0).equals(this.firstLine)) {
                try {
                    this.internalChange = true;
                    this.removeElementAt(0);
                }
                finally {
                    this.internalChange = false;
                }
            }
            this.selectedItem = anObject;
            super.setSelectedItem(anObject);
        }

        @Override
        public Object getSelectedItem() {
            if (this.selectedItem == null && this.getSize() > 0 && this.getElementAt(0).equals(this.firstLine)) {
                return this.firstLine;
            }
            return super.getSelectedItem();
        }

        public boolean isSelectionMade() {
            return this.selectedItem != null;
        }
    }
}

