/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.branding;

import javax.swing.JPanel;
import org.netbeans.modules.apisupport.project.ui.branding.BasicBrandingModel;
import org.netbeans.modules.apisupport.project.ui.branding.BrandingEditorPanel;

abstract class AbstractBrandingPanel
extends JPanel {
    private final BasicBrandingModel model;
    private BrandingEditorPanel editor;
    private final String displayName;
    private boolean brandingValid = true;
    private String errMessage = null;

    protected AbstractBrandingPanel(String displayName, BasicBrandingModel model) {
        this.displayName = displayName;
        this.model = model;
    }

    final void init(BrandingEditorPanel editor) {
        this.editor = editor;
    }

    protected final BasicBrandingModel getBranding() {
        return this.model;
    }

    public abstract void store();

    protected final void setErrorMessage(String errMessage) {
        this.errMessage = errMessage;
        this.notifyEditor();
    }

    final String getErrorMessage() {
        return this.errMessage;
    }

    protected final void setValid(boolean valid) {
        this.brandingValid = valid;
        this.notifyEditor();
    }

    final boolean isBrandingValid() {
        return this.brandingValid && null == this.errMessage;
    }

    protected final void setModified() {
        this.editor.setModified();
    }

    public final String getDisplayName() {
        return this.displayName;
    }

    private void notifyEditor() {
        if (null == this.editor) {
            return;
        }
        this.editor.onBrandingValidation();
    }
}

