/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.customizer;

import java.io.File;
import java.util.Set;
import javax.swing.Action;
import org.netbeans.modules.apisupport.project.ManifestManager;
import org.netbeans.modules.apisupport.project.ui.customizer.ClusterizeAction;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public final class ClusterizeInfo
extends FilterNode
implements Comparable<ClusterizeInfo> {
    final String path;
    final ManifestManager mm;
    final File jar;
    private ClusterizeAction state = ClusterizeAction.IGNORE;
    private Sheet sheet;

    private static Node findNode(File f) {
        try {
            FileObject fo;
            if (f != null && (fo = FileUtil.toFileObject((File)f)) != null) {
                return DataObject.find((FileObject)fo).getNodeDelegate();
            }
        }
        catch (DataObjectNotFoundException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return Node.EMPTY;
    }

    ClusterizeInfo(String path, ManifestManager mm, File jar) {
        super(ClusterizeInfo.findNode(jar), (Children)(mm == null ? new Children.Array() : FilterNode.Children.LEAF));
        this.disableDelegation(533);
        this.enableDelegation(1066);
        this.path = path;
        this.mm = mm;
        this.jar = jar;
    }

    public Action[] getActions(boolean context) {
        return null;
    }

    public String getCodeName() {
        return this.mm == null ? "" : this.mm.getCodeNameBase();
    }

    public ClusterizeAction getAction() {
        return this.state;
    }

    public void setAction(ClusterizeAction a) {
        this.state = a;
        this.firePropertyChange("action", null, null);
        for (Node n : this.getChildren().getNodes()) {
            if (!(n instanceof ClusterizeInfo)) continue;
            ClusterizeInfo ci = (ClusterizeInfo)n;
            ci.setAction(a);
        }
        ClusterizeInfo ci = this;
        while (ci.getParentNode() instanceof ClusterizeInfo) {
            ci = (ClusterizeInfo)ci.getParentNode();
        }
        ci.firePropertyChange("selectedFilesCount", null, null);
    }

    public Node.PropertySet[] getPropertySets() {
        if (this.sheet != null) {
            return this.sheet.toArray();
        }
        try {
            this.sheet = Sheet.createDefault();
            Sheet.Set ss = this.sheet.get("properties");
            PropertySupport.Reflection cnb = new PropertySupport.Reflection((Object)this, String.class, "getCodeName", null);
            cnb.setDisplayName(NbBundle.getMessage(ClusterizeInfo.class, (String)"MSG_ClusterizeCodeNameBase"));
            cnb.setName("cnb");
            ss.put((Node.Property)cnb);
            PropertySupport.Reflection act = new PropertySupport.Reflection((Object)this, ClusterizeAction.class, "action");
            act.setDisplayName(NbBundle.getMessage(ClusterizeInfo.class, (String)"MSG_ClusterizeActivateAs"));
            act.setName("action");
            ss.put((Node.Property)act);
            PropertySupport.Reflection count = new PropertySupport.Reflection((Object)this, Integer.class, "getSelectedFilesCount", null);
            count.setDisplayName(NbBundle.getMessage(ClusterizeInfo.class, (String)"MSG_ClusterizeNumberOfModules"));
            count.setName("selectedFilesCount");
            ss.put((Node.Property)act);
            return this.sheet.toArray();
        }
        catch (NoSuchMethodException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    public int compareTo(ClusterizeInfo o) {
        return this.jar.compareTo(o.jar);
    }

    public int getSelectedFilesCount() {
        if (FilterNode.Children.LEAF == this.getChildren()) {
            return this.state == ClusterizeAction.IGNORE ? 0 : 1;
        }
        int cnt = 0;
        for (Node n : this.getChildren().getNodes()) {
            ClusterizeInfo ci = (ClusterizeInfo)n;
            cnt += ci.getSelectedFilesCount();
        }
        return cnt;
    }

    void categorize(Set<String> autoload, Set<String> eager, Set<String> enabled) {
        if (FilterNode.Children.LEAF == this.getChildren()) {
            switch (this.state) {
                case ENABLED: {
                    enabled.add(this.path);
                    return;
                }
                case AUTOLOAD: {
                    autoload.add(this.path);
                    return;
                }
                case EAGER: {
                    eager.add(this.path);
                    return;
                }
            }
        } else {
            for (Node n : this.getChildren().getNodes()) {
                ClusterizeInfo ci = (ClusterizeInfo)n;
                ci.categorize(autoload, eager, enabled);
            }
        }
    }
}

